/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.sipmodel.util;

import com.ibm.siptools.common.sipmodel.And;
import com.ibm.siptools.common.sipmodel.Condition;
import com.ibm.siptools.common.sipmodel.Not;
import com.ibm.siptools.common.sipmodel.Or;
import com.ibm.siptools.common.sipmodel.Pattern;
import com.ibm.siptools.common.sipmodel.SipApplication;
import com.ibm.siptools.common.sipmodel.Siplet;
import com.ibm.siptools.common.sipmodel.SipletMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class SipModelUtils {
    public static List getAllSipletConditions(SipApplication app, Siplet siplet) {
        Condition cond;
        Pattern pattern;
        ArrayList result = new ArrayList();
        SipletMapping mapping = SipModelUtils.getMappingForSiplet(app, siplet);
        if (mapping != null && (pattern = mapping.getPattern()) != null && (cond = pattern.getCondition()) != null) {
            return SipModelUtils.getAllSubCondtions(cond);
        }
        return result;
    }

    public static SipletMapping getMappingForSiplet(SipApplication sipApp, Siplet siplet) {
        if (sipApp == null || siplet == null) {
            return null;
        }
        EList mappings = sipApp.getSipletMapping();
        Iterator iter = mappings.iterator();
        String sipletName = siplet.getServletName();
        while (iter.hasNext()) {
            SipletMapping mapping = (SipletMapping)iter.next();
            if (!sipletName.equals(mapping.getSiplet().getServletName())) continue;
            return mapping;
        }
        return null;
    }

    public static Siplet getSipletForCondition(Condition condition) {
        SipletMapping mapping;
        Pattern pattern;
        EObject container = condition != null ? condition.eContainer() : null;
        while (container != null && container instanceof Condition) {
            condition = (Condition)container;
            container = condition.eContainer();
        }
        if (condition != null && (pattern = condition.getPattern()) != null && (mapping = pattern.getSipletMapping()) != null) {
            return mapping.getSiplet();
        }
        return null;
    }

    public static Siplet getSiplet(Object object) {
        if (object instanceof SipletMapping) {
            return SipModelUtils.getSiplet((SipletMapping)object);
        }
        if (object instanceof Pattern) {
            return SipModelUtils.getSiplet((Pattern)object);
        }
        if (object instanceof Condition) {
            return SipModelUtils.getSiplet((Condition)object);
        }
        return null;
    }

    public static Siplet getSiplet(Condition condition) {
        return SipModelUtils.getSipletForCondition(condition);
    }

    public static Siplet getSiplet(Pattern pattern) {
        SipletMapping mapping;
        if (pattern != null && (mapping = pattern.getSipletMapping()) != null) {
            return mapping.getSiplet();
        }
        return null;
    }

    public static Siplet getSiplet(SipletMapping mapping) {
        return mapping != null ? mapping.getSiplet() : null;
    }

    private static List getAllSubCondtions(Condition cond) {
        Iterator iter;
        ArrayList<Condition> result = new ArrayList<Condition>();
        result.add(cond);
        if (cond instanceof And) {
            iter = ((And)cond).getCondition().iterator();
            while (iter.hasNext()) {
                result.addAll(SipModelUtils.getAllSubCondtions((Condition)iter.next()));
            }
        }
        if (cond instanceof Or) {
            iter = ((Or)cond).getCondition().iterator();
            while (iter.hasNext()) {
                result.addAll(SipModelUtils.getAllSubCondtions((Condition)iter.next()));
            }
        }
        if (cond instanceof Not) {
            result.addAll(SipModelUtils.getAllSubCondtions(((Not)cond).getCondition()));
        }
        return result;
    }
}

