/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.sipmodel.commands;

import com.ibm.siptools.common.sipmodel.And;
import com.ibm.siptools.common.sipmodel.Condition;
import com.ibm.siptools.common.sipmodel.Not;
import com.ibm.siptools.common.sipmodel.Or;
import com.ibm.siptools.common.sipmodel.Pattern;
import com.ibm.siptools.common.sipmodel.SipApplication;
import com.ibm.siptools.common.sipmodel.SipModelFactory;
import com.ibm.siptools.common.sipmodel.SipModelPackage;
import com.ibm.siptools.common.sipmodel.Siplet;
import com.ibm.siptools.common.sipmodel.SipletMapping;
import com.ibm.siptools.common.sipmodel.commands.AbstractSipModelCommand;
import com.ibm.siptools.common.sipmodel.util.SipModelUtils;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AddMappingConditionCommand
extends AbstractSipModelCommand {
    SipApplication _sipApp;
    Siplet _siplet;
    Condition _parentCondition;
    Condition _newCondition;
    boolean _patternExist = true;
    boolean _mappingExist = true;
    boolean _parentExist = true;
    Condition _prevCondition = null;

    public AddMappingConditionCommand(SipApplication sipApp, Siplet siplet, Condition parentCondition, Condition newCondition) {
        this._sipApp = sipApp;
        this._siplet = siplet;
        this._parentCondition = parentCondition;
        this._newCondition = newCondition;
        this._label = "Condition Add";
    }

    public boolean canExecute() {
        boolean result = true;
        try {
            result = result && this._sipApp != null && this._siplet != null && this._newCondition != null;
            boolean bl = result = result && !SipModelUtils.getAllSipletConditions(this._sipApp, this._siplet).contains(this._newCondition);
            if (this._parentCondition != null) {
                result = result && (this._parentCondition instanceof And || this._parentCondition instanceof Or || this._parentCondition instanceof Not);
            }
        }
        catch (Throwable throwable) {
            result = false;
        }
        return result;
    }

    public void execute() {
        if (this._parentCondition != null) {
            if (this._parentCondition instanceof And) {
                ((And)this._parentCondition).getCondition().add((Object)this._newCondition);
            }
            if (this._parentCondition instanceof Or) {
                ((Or)this._parentCondition).getCondition().add((Object)this._newCondition);
            }
            if (this._parentCondition instanceof Not) {
                this._prevCondition = ((Not)this._parentCondition).getCondition();
                ((Not)this._parentCondition).setCondition(this._newCondition);
            }
        } else {
            Pattern pattern;
            this._parentExist = false;
            SipletMapping mapping = SipModelUtils.getMappingForSiplet(this._sipApp, this._siplet);
            if (mapping == null) {
                this._mappingExist = false;
                mapping = SipModelFactory.eINSTANCE.createSipletMapping();
                if (this._sipApp != null) {
                    this._sipApp.getSipletMapping().add((Object)mapping);
                }
                mapping.setSiplet(this._siplet);
            }
            if ((pattern = mapping.getPattern()) == null) {
                this._parentExist = false;
                pattern = SipModelFactory.eINSTANCE.createPattern();
                if (this._sipApp != null) {
                    this._sipApp.getSipletMappingPatern().add((Object)pattern);
                }
                mapping.setPattern(pattern);
            } else {
                this._prevCondition = pattern.getCondition();
                this._sipApp.getCondition().remove((Object)this._prevCondition);
            }
            pattern.setCondition(this._newCondition);
        }
    }

    public boolean canUndo() {
        boolean result;
        block9: {
            Pattern pattern;
            block11: {
                SipletMapping mapping;
                block10: {
                    block8: {
                        result = true;
                        boolean bl = result = result && this._sipApp != null && this._siplet != null && this._newCondition != null;
                        if (this._parentCondition == null) break block8;
                        if (this._parentCondition instanceof And) {
                            result = result && ((And)this._parentCondition).getCondition().contains((Object)this._newCondition);
                            break block9;
                        }
                        if (this._parentCondition instanceof Or) {
                            result = result && ((Or)this._parentCondition).getCondition().contains((Object)this._newCondition);
                            break block9;
                        }
                        if (this._parentCondition instanceof Not) {
                            result = result && ((Not)this._parentCondition).getCondition().equals(this._newCondition);
                            break block9;
                        }
                        return false;
                    }
                    mapping = SipModelUtils.getMappingForSiplet(this._sipApp, this._siplet);
                    if (mapping != null) break block10;
                    return false;
                }
                pattern = mapping.getPattern();
                if (pattern != null) break block11;
                return false;
            }
            try {
                result = result && pattern.getCondition().equals(this._newCondition);
            }
            catch (Throwable throwable) {
                result = false;
            }
        }
        return result;
    }

    public void undo() {
        if (this._parentExist) {
            if (this._parentCondition instanceof And) {
                ((And)this._parentCondition).getCondition().remove((Object)this._newCondition);
            } else if (this._parentCondition instanceof Or) {
                ((Or)this._parentCondition).getCondition().remove((Object)this._newCondition);
            } else if (this._parentCondition instanceof Not) {
                if (this._prevCondition != null) {
                    ((Not)this._parentCondition).setCondition(this._prevCondition);
                } else {
                    ((Not)this._parentCondition).eUnset((EStructuralFeature)SipModelPackage.eINSTANCE.getNot_Condition());
                }
            }
        } else {
            SipletMapping mapping = SipModelUtils.getMappingForSiplet(this._sipApp, this._siplet);
            Pattern pattern = mapping.getPattern();
            this._sipApp.getCondition().remove((Object)this._newCondition);
            if (this._patternExist) {
                pattern.setCondition(this._prevCondition);
            } else {
                pattern.eUnset((EStructuralFeature)SipModelPackage.eINSTANCE.getPattern_Condition());
                mapping.eUnset((EStructuralFeature)SipModelPackage.eINSTANCE.getSipletMapping_Pattern());
                this._sipApp.getSipletMappingPatern().remove((Object)pattern);
            }
            if (!this._mappingExist) {
                this._sipApp.getSipletMapping().remove((Object)mapping);
                mapping.eUnset((EStructuralFeature)SipModelPackage.eINSTANCE.getSipletMapping_Siplet());
            }
        }
    }

    public void redo() {
        this._patternExist = true;
        this._mappingExist = true;
        this._parentExist = true;
        this.execute();
    }

    public Collection getResult() {
        return null;
    }

    public Collection getAffectedObjects() {
        Vector<Object> result = new Vector<Object>();
        result.add(this._sipApp);
        result.add(this._siplet);
        if (this._parentCondition == null) {
            SipletMapping mapping = SipModelUtils.getMappingForSiplet(this._sipApp, this._siplet);
            result.add(mapping);
            if (mapping != null) {
                result.add(mapping.getPattern());
            }
        } else {
            result.add(this._parentCondition);
        }
        result.add(this._newCondition);
        return result;
    }

    public void dispose() {
    }

    public Command chain(Command command) {
        return null;
    }
}

