/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.plugin;

import com.ibm.siptools.common.plugin.Logger;
import com.ibm.siptools.common.plugin.ResourceHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SIPCommonPlugin
extends AbstractUIPlugin
implements ResourceLocator {
    public static final String PLUGIN_ID = "com.ibm.siptools.common";
    public static final String SIP1X_ID = "com.ibm.siptools.common";
    public static final boolean isDebugging = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common/debug"));
    public static final boolean debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common/debug/debug"));
    public static final boolean info = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common/debug/info")) || debug;
    public static final boolean warn = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common/debug/warning")) || info;
    public static final boolean error = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common/debug/error")) || warn;
    private static SIPCommonPlugin plugin;
    private Logger _logger;
    private URL pluginURL = null;
    public static final String[] ICON_DIRS;
    public static final String MERGE = "sartowar";
    public static final String PROMPT_ON_SAVE = "promptonsave";
    public static final boolean MERGE_DEFAULT = true;
    public static final boolean PROMPT_ON_SAVE_DEFAULT = true;

    static {
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/cview16", "icons/full/ctool16", "icons/full/clcl16", "icons/full/ovr16", "icons/full/extra", "icons/full/wizban", "icons", ""};
    }

    public SIPCommonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static SIPCommonPlugin getDefault() {
        return plugin;
    }

    public static Logger getLocalLogger() {
        return SIPCommonPlugin.getDefault().getCreateLogger();
    }

    private Logger getCreateLogger() {
        if (this._logger == null) {
            this._logger = new Logger((Plugin)this);
        }
        return this._logger;
    }

    public String getPluginID() {
        return "com.ibm.siptools.common";
    }

    public URL getBaseURL() {
        if (this.pluginURL == null) {
            try {
                this.pluginURL = Platform.resolve((URL)this.getBundle().getEntry("/"));
            }
            catch (IOException e) {
                SIPCommonPlugin.getLocalLogger().error(ResourceHandler.getString("SIPCommonPlugin.2"), e);
            }
        }
        return this.pluginURL;
    }

    public Object getImage(String key) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (Platform.find((Bundle)this.getBundle(), (IPath)path) != null) {
                try {
                    return new URL(this.getBaseURL(), path.toString());
                }
                catch (MalformedURLException exception) {
                    SIPCommonPlugin.getLocalLogger().error(J2EEPluginResourceHandler.getString((String)"Load_Image_Error_", (Object[])new Object[]{key}), exception);
                }
            }
            ++i;
        }
        return null;
    }

    public String getString(String key) {
        try {
            if (key.startsWith("%")) {
                key = key.substring(1);
            }
            return ResourceHandler.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getString(String key, Object[] substitutions) {
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public String getString(String key, boolean translate) {
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        return ResourceHandler.getString(key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        return this.getString(key, substitutions);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(MERGE, true);
        store.setDefault(PROMPT_ON_SAVE, true);
    }

    public static void ErrorMessage(String msg, Exception e) {
        if (error) {
            System.out.println("(SIP-CM)ERROR: " + msg);
            if (e != null && e.getCause() != null) {
                System.out.println("(SIP-CM)ERROR:... " + e.getCause().getMessage());
            }
        }
        Status status = new Status(4, "com.ibm.siptools.common", 0, "SIP-CM: " + msg, (Throwable)e);
        DebugPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void WarningMessage(String msg, Exception e) {
        if (!isDebugging) {
            return;
        }
        if (warn) {
            System.out.println("(SIP-CM)WARN:  " + msg);
        }
        Status status = new Status(2, "com.ibm.siptools.common", 0, "SIP-CM: " + msg, (Throwable)e);
        DebugPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void InfoMessage(String msg) {
        if (!isDebugging) {
            return;
        }
        if (!info) {
            return;
        }
        System.out.println("(SIP-CM)INFO:  " + msg);
    }

    public static void DebugMessage(String msg) {
        if (!isDebugging) {
            return;
        }
        if (!debug) {
            return;
        }
        System.out.println("(SIP-CM)DEBUG: " + msg);
    }
}

