/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.plugin;

import com.ibm.siptools.common.plugin.SIPCommonPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class Logger {
    public static final String copyright = "(c) Copyright IBM Corporation 2006.";
    private ILog _logFile;
    private String _pluginId;
    private static final String CLASS_NAME = Logger.class.getName();
    private static Properties _configuration = null;
    private static final String CONFIG_FILE_NAME = "logger.cfg";
    private static final String CONSOLE_ENABLED_PROPERTY = "ConsoleEnabled";
    private static final String SEVERITY_PROPERTY = "Severity";
    private static boolean _consoleEnabled = true;
    private static int _severity = 0;

    public Logger(Plugin thePlugin) {
        this._logFile = thePlugin.getLog();
        this._pluginId = thePlugin.getBundle().getSymbolicName();
        if (_configuration == null) {
            _configuration = new Properties();
            try {
                URL url = SIPCommonPlugin.getDefault().getBundle().getEntry("/");
                URL pluginURL = Platform.resolve((URL)url);
                Path toolkitPluginPath = new Path(pluginURL.getPath());
                toolkitPluginPath = toolkitPluginPath.addTrailingSeparator();
                File configFile = new File(String.valueOf(toolkitPluginPath.toOSString()) + CONFIG_FILE_NAME);
                if (configFile.exists()) {
                    BufferedInputStream configFileStream = new BufferedInputStream(new FileInputStream(new File(String.valueOf(toolkitPluginPath.toOSString()) + CONFIG_FILE_NAME)));
                    _configuration.load(configFileStream);
                    String consoleProperty = _configuration.getProperty(CONSOLE_ENABLED_PROPERTY);
                    String severityProperty = _configuration.getProperty(SEVERITY_PROPERTY);
                    _consoleEnabled = new Boolean(consoleProperty);
                    _severity = new Integer(severityProperty);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error initializing Logger configuration");
            }
        }
    }

    public void log(int severity, String msg, Throwable ex) {
        if (!this.isLoggable(severity)) {
            return;
        }
        String formattedMsg = this.formatMsg(this.detectStackTraceElement(), msg);
        Status record = new Status(severity, this._pluginId, severity, formattedMsg, ex);
        this._logFile.log((IStatus)record);
    }

    public void log(int severity, String msg) {
        this.log(severity, msg, null);
    }

    public void error(String msg, Throwable ex) {
        this.log(4, msg, ex);
    }

    public void error(String msg) {
        this.log(4, msg, null);
    }

    public void warning(String msg) {
        this.log(2, msg, null);
    }

    public void info(String msg) {
        this.log(1, msg, null);
    }

    public void log(int severity, String msg, Throwable ex, boolean isLogToConsole) {
        this.log(severity, msg, ex);
        if (isLogToConsole) {
            this.console(msg, ex);
        }
    }

    public void log(int severity, String msg, boolean isLogToConsole) {
        this.log(severity, msg, null, isLogToConsole);
    }

    public void error(String msg, Throwable ex, boolean isLogToConsole) {
        this.log(4, msg, ex, isLogToConsole);
    }

    public void error(String msg, boolean isLogToConsole) {
        this.log(4, msg, null, isLogToConsole);
    }

    public void warning(String msg, boolean isLogToConsole) {
        this.log(2, msg, null, isLogToConsole);
    }

    public void info(String msg, boolean isLogToConsole) {
        this.log(1, msg, null, isLogToConsole);
    }

    public void console(String msg, Throwable ex) {
        if (!this.isConsoleEnabled()) {
            return;
        }
        if (ex != null) {
            ex.printStackTrace(System.out);
        }
    }

    public void console(String msg) {
        this.console(msg, null);
    }

    public void console(Throwable ex) {
        this.console(null, ex);
    }

    public boolean isLoggable(int severity) {
        return severity >= _severity;
    }

    public boolean isConsoleEnabled() {
        return _consoleEnabled;
    }

    private String formatMsg(StackTraceElement trace, String msg) {
        if (trace == null) {
            return msg;
        }
        return new String(String.valueOf(trace.getClassName()) + "." + trace.getMethodName() + ": " + msg);
    }

    private StackTraceElement detectStackTraceElement() {
        Exception dummy = new Exception();
        StackTraceElement[] trace = dummy.getStackTrace();
        int i = 1;
        while (i < trace.length) {
            if (!trace[i].getClassName().equals(CLASS_NAME)) {
                return trace[i];
            }
            ++i;
        }
        return null;
    }
}

