/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.plugin;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;

public class AntBuildLogger
implements BuildLogger {
    private static String prefix = "(SIPANT)";
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private int level = 1;
    private String CRLF = System.getProperty("line.separator");
    private String log = "";

    public String getLog() {
        return this.log;
    }

    private void appendLog(int sev, String s) {
        if (sev > 2) {
            return;
        }
        this.log = String.valueOf(this.log) + this.CRLF + s;
    }

    private void debugMessage(int sev, String msg) {
        int spc;
        if (sev < this.level) {
            this.out.println(String.valueOf(prefix) + "Sev-" + sev + ": " + msg);
        }
        if ((spc = msg.indexOf(32)) >= 0) {
            msg = msg.substring(spc + 1);
        }
        this.appendLog(sev, msg);
        if (sev == 0) {
            Status status = new Status(2, "com.ibm.siptools.common", 0, msg, null);
            DebugPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void errorMessage(int sev, String msg, Throwable e) {
        this.err.println(String.valueOf(prefix) + "ERR:" + sev + ": " + msg);
        this.appendLog(sev, msg);
        if (e instanceof CoreException) {
            msg = ((CoreException)e).getStatus().getMessage();
            this.err.println(String.valueOf(prefix) + "ERR:" + sev + ": ..." + msg);
            this.appendLog(sev, msg);
        }
        if (sev == 0) {
            Status status = new Status(4, "com.ibm.siptools.common", 0, msg, null);
            DebugPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void event(String source, BuildEvent event) {
        String s = "";
        if (event.getTarget() != null) {
            s = event.getTarget().getName();
        }
        s = String.valueOf(s) + ".";
        if (event.getTask() != null) {
            s = String.valueOf(s) + event.getTask().getTaskName();
        }
        if ((s = String.valueOf(s) + " ").equalsIgnoreCase(". ")) {
            s = "";
        }
        int sev = event.getPriority();
        String msg = event.getMessage();
        if (msg == null) {
            msg = "";
        }
        this.debugMessage(sev, String.valueOf(source) + " " + s + msg);
        Throwable t = event.getException();
        if (t != null) {
            msg = t.getMessage();
            this.errorMessage(sev, String.valueOf(source) + " Throwable=" + msg, t);
            t = t.getCause();
            if (t != null && (msg = t.getMessage()) != null) {
                this.errorMessage(sev, String.valueOf(source) + " Throwable CAUSE=" + msg, t);
            }
        }
    }

    public void buildFinished(BuildEvent event) {
        this.event("buildFinished", event);
    }

    public void buildStarted(BuildEvent event) {
        this.event("buildStarted ", event);
    }

    public void messageLogged(BuildEvent event) {
        this.event("messageLogged", event);
    }

    public void targetFinished(BuildEvent event) {
        this.event("targetFinishd", event);
    }

    public void targetStarted(BuildEvent event) {
        this.event("targetStarted", event);
    }

    public void taskFinished(BuildEvent event) {
        this.event("taskFinished ", event);
    }

    public void taskStarted(BuildEvent event) {
        this.event("taskStarted  ", event);
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream errStream) {
        this.err = errStream;
    }

    public void setMessageOutputLevel(int l) {
        this.level = l;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = output;
    }
}

