/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.operations.strategy;

import com.ibm.siptools.common.editmodel.SipArtifactEdit;
import com.ibm.siptools.common.plugin.SIPCommonPlugin;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class SIPComponentLoadStrategyImpl
extends ComponentLoadStrategyImpl {
    public SIPComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public List getFiles() {
        super.getFiles();
        this.addLooseLibJARsToFiles();
        return this.filesHolder.getFiles();
    }

    public IVirtualReference[] getLibModules() {
        SipArtifactEdit sipArtifactEdit = null;
        try {
            sipArtifactEdit = SipArtifactEdit.getSipArtifactEditForRead(this.getComponent());
            if (sipArtifactEdit != null) {
                IVirtualReference[] iVirtualReferenceArray = sipArtifactEdit.getLibModules();
                return iVirtualReferenceArray;
            }
        }
        finally {
            if (sipArtifactEdit != null) {
                sipArtifactEdit.dispose();
            }
        }
        return null;
    }

    public void addLooseLibJARsToFiles() {
        IVirtualReference[] libModules = this.getLibModules();
        int i = 0;
        while (i < libModules.length) {
            IVirtualReference iLibModule = libModules[i];
            IVirtualComponent vComponent = iLibModule.getReferencedComponent();
            if (vComponent.isBinary()) {
                VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)vComponent;
                File diskFile = archiveComp.getUnderlyingDiskFile();
                String uri = String.valueOf(iLibModule.getRuntimePath().makeRelative().toString()) + "/" + diskFile.getName();
                this.addExternalFile(uri, diskFile);
            } else {
                String uri = String.valueOf(iLibModule.getRuntimePath().makeRelative().toString()) + "/" + vComponent.getName() + ".jar";
                try {
                    Archive utilJAR = J2EEProjectUtilities.asArchive((String)uri, (IProject)vComponent.getProject(), (boolean)this.isExportSource());
                    if (utilJAR != null) {
                        this.filesHolder.addFile((org.eclipse.jst.j2ee.commonarchivecore.internal.File)utilJAR);
                    }
                }
                catch (OpenFailureException oe) {
                    String message = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.UNABLE_TO_LOAD_MODULE_ERROR_, (Object[])new Object[]{uri, this.getComponent().getProject().getName(), oe.getConcatenatedMessages()});
                    SIPCommonPlugin.getLocalLogger().error(message, oe);
                }
            }
            ++i;
        }
    }
}

