/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.merge;

import com.ibm.siptools.common.plugin.ResourceHandler;
import java.util.ArrayList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvergedProjectDocumentPreprocessor {
    private Document doc;
    private ArrayList removalList = new ArrayList();

    public ConvergedProjectDocumentPreprocessor(Document doc) {
        this.doc = doc;
        Node child = doc.getFirstChild();
        this.removeComments(child);
    }

    private void removeComments(Node child) {
        NodeList webAppList = this.doc.getElementsByTagName("web-app");
        Node webApp = webAppList.item(0);
        NodeList parents = webApp.getChildNodes();
        NodeList children = null;
        int p = 0;
        while (p < parents.getLength()) {
            children = parents.item(p).getChildNodes();
            int c = 0;
            while (c < children.getLength()) {
                if (children.item(c).getNodeType() == 8 && children.item(c).getTextContent().equals(ResourceHandler.getString("MERGE_COMMENT"))) {
                    this.addForRemoval(parents.item(p));
                }
                ++c;
            }
            ++p;
        }
    }

    public void addForRemoval(Node targetElement) {
        this.removalList.add(targetElement);
    }

    public void process() {
        for (Node child : this.removalList) {
            try {
                this.doc.getDocumentElement().removeChild(child);
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
    }
}

