/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.editmodel;

import com.ibm.siptools.common.plugin.ResourceHandler;
import com.ibm.siptools.common.plugin.SIPCommonConstants;
import com.ibm.siptools.common.plugin.SIPCommonPlugin;
import com.ibm.siptools.common.sipmodel.SipApplication;
import com.ibm.siptools.common.sipmodel.SipApplicationResource;
import com.ibm.siptools.common.sipmodel.SipModelFactory;
import com.ibm.siptools.common.sipmodel.impl.SipAppNameImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class SipArtifactEdit
extends EnterpriseArtifactEdit
implements IArtifactEditFactory {
    public static final Class ADAPTER_TYPE = SipArtifactEdit.class;
    public static IPath SIPLIB = new Path("/WEB-INF/lib");

    protected String getContentTypeDescriber() {
        String contentTypeDescriber = "org.eclipse.jst.j2ee.webDD";
        SIPCommonPlugin.WarningMessage("SipArtifactEdit.getContentTypeDescriber ##WEB## org.eclipse.jst.j2ee.webDD", null);
        return contentTypeDescriber;
    }

    public SipArtifactEdit() {
    }

    public SipArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public SipArtifactEdit(IProject aProject, boolean toAccessAsReadOnly, boolean forCreate) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly, forCreate, "jsr116.siptools");
    }

    public SipArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    public SipArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public int getJ2EEVersion() {
        return ((SipApplicationResource)this.getDeploymentDescriptorResource()).getJ2EEVersionID();
    }

    public Resource getDeploymentDescriptorResource() {
        Resource res = this.getArtifactEditModel().getResource(SIPCommonConstants.SIPAPP_DD_URI_OBJ);
        return res;
    }

    public EObject getDeploymentDescriptorRoot() {
        EList contents = this.getDeploymentDescriptorResource().getContents();
        if (contents.size() > 0) {
            return (EObject)contents.get(0);
        }
        this.addSipAppIfNecessary((XMLResource)((SipApplicationResource)this.getDeploymentDescriptorResource()));
        return (EObject)contents.get(0);
    }

    public EObject createModelRoot() {
        SIPCommonPlugin.WarningMessage("SipArtifactEdit.createModelRoot getJ2EEVersion()=" + this.getJ2EEVersion(), null);
        return this.createModelRoot(this.getJ2EEVersion());
    }

    public EObject createModelRoot(int version) {
        XMLResource res = (XMLResource)this.getDeploymentDescriptorResource();
        SIPCommonPlugin.DebugMessage("SipArtifactEdit.createModelRoot resource=" + res);
        res.setModuleVersionID(version);
        this.addSipAppIfNecessary(res);
        return res.getRootObject();
    }

    public IVirtualReference[] getLibModules() {
        ArrayList<IVirtualReference> result = new ArrayList<IVirtualReference>();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.getProject());
        IVirtualReference[] refComponents = comp.getReferences();
        int i = 0;
        while (i < refComponents.length) {
            comp.getRootFolder().getFolder(SIPLIB);
            if (refComponents[i].getRuntimePath().equals((Object)SIPLIB)) {
                result.add(refComponents[i]);
            }
            ++i;
        }
        return result.toArray(new IVirtualReference[result.size()]);
    }

    public void addLibModules(ReferencedComponent[] libModules) {
    }

    protected void addSipAppIfNecessary(XMLResource aResource) {
        if (aResource != null) {
            SipApplication sipApp;
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                sipApp = SipModelFactory.eINSTANCE.createSipApplication();
                aResource.getContents().add((Object)sipApp);
                aResource.setModified(true);
            }
            sipApp = (SipApplication)aResource.getContents().get(0);
            URI moduleURI = this.getArtifactEditModel().getModuleURI();
            try {
                sipApp.setDisplayName(StructureEdit.getDeployedName((URI)moduleURI));
                int moduleVer = aResource.getModuleVersionID();
                int J2EEVersion = aResource.getJ2EEVersionID();
                if (J2EEVersion >= 50 || moduleVer >= 24) {
                    SIPCommonPlugin.WarningMessage("SipArtifactEdit.addSipAppIfNecessary FORCING SIP11", null);
                    SipAppNameImpl appName = (SipAppNameImpl)sipApp.getSipAppName();
                    if (appName == null || appName.getName() == null) {
                        String sipAppName = ResourceHandler.getString("SIP_APPNAME_DEFAULT");
                        SIPCommonPlugin.InfoMessage("SipArtifactEdit.addSipAppIfNecessary SETTING initial APP-NAME=" + sipAppName);
                        sipApp.setSipAppName(sipAppName);
                    }
                }
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            aResource.setID((EObject)sipApp, "SipApp_ID");
            try {
                aResource.saveIfNecessary();
            }
            catch (Exception e) {
                SIPCommonPlugin.WarningMessage("SipArtifactEdit.addSipAppIfNecessary save exception=" + e.getMessage(), e);
            }
        }
    }

    public ArtifactEdit createArtifactEditForRead(IVirtualComponent aComponent) {
        return SipArtifactEdit.getSipArtifactEditForRead(aComponent);
    }

    public ArtifactEdit createArtifactEditForWrite(IVirtualComponent aComponent) {
        return SipArtifactEdit.getSipArtifactEditForWrite(aComponent);
    }

    public static SipArtifactEdit getSipArtifactEditForRead(IVirtualComponent aModule) {
        try {
            if (SipArtifactEdit.isValidSipModule(aModule)) {
                IProject project = aModule.getProject();
                ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
                return new SipArtifactEdit(nature, aModule, true);
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return null;
    }

    public static SipArtifactEdit getSipArtifactEditForWrite(IVirtualComponent aModule) {
        try {
            if (SipArtifactEdit.isValidSipModule(aModule)) {
                IProject project = aModule.getProject();
                ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
                return new SipArtifactEdit(nature, aModule, false);
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return null;
    }

    public static SipArtifactEdit getSipArtifactEditForRead(IProject aProject) {
        SipArtifactEdit artifactEdit = null;
        try {
            if (SipArtifactEdit.isValidSipModule(ComponentCore.createComponent((IProject)aProject))) {
                artifactEdit = new SipArtifactEdit(aProject, true);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static SipArtifactEdit getSipArtifactEditForWrite(IProject aProject) {
        SipArtifactEdit artifactEdit = null;
        try {
            if (SipArtifactEdit.isValidSipModule(ComponentCore.createComponent((IProject)aProject))) {
                artifactEdit = new SipArtifactEdit(aProject, false, false);
            }
        }
        catch (Exception exception) {
            artifactEdit = null;
        }
        return artifactEdit;
    }

    public static boolean isValidSipModule(IVirtualComponent aModule) throws UnresolveableURIException {
        if (!SipArtifactEdit.isValidEditableModule((IVirtualComponent)aModule)) {
            return false;
        }
        return J2EEProjectUtilities.isProjectOfType((IProject)aModule.getProject(), (String)"jsr116.sip");
    }

    public SipApplication getSipApp() {
        return (SipApplication)this.getDeploymentDescriptorRoot();
    }

    private static void createSip11DeploymentDescriptor(IProject project, IFolder sipInfFolder) throws CoreException {
        IFile sipXmlFile = sipInfFolder.getFile("sip.xml");
        if (!sipXmlFile.exists()) {
            try {
                String sipXmlContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sip-app id=\"SipApp_ID\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.jcp.org/xsd/sip-app-1.1.xsd\">\n<app-name> TODO:REPLACE: " + project.getName() + "</app-name>\n</sip-app>";
                SIPCommonPlugin.WarningMessage("SipArtifactEdit.createSip11DeploymentDescriptor TODO:REPLACE: hack", null);
                sipXmlFile.create((InputStream)new ByteArrayInputStream(sipXmlContents.getBytes("UTF-8")), true, null);
            }
            catch (Exception e) {
                SIPCommonPlugin.ErrorMessage("SipArtifactEdit.createSip11DeploymentDescriptor Exception=" + e.getMessage(), e);
            }
        }
    }

    public static void createDeploymentDescriptor(IProject project, int version) {
        SIPCommonPlugin.DebugMessage("SipArtifactEdit.createDeploymentDescriptor version=" + version);
        SipArtifactEdit sipEdit = new SipArtifactEdit(project, false, true);
        try {
            try {
                if (version >= 11) {
                    IFolder sipInfFolder = project.getFolder("WebContent/WEB-INF");
                    SipArtifactEdit.createSip11DeploymentDescriptor(project, sipInfFolder);
                }
                sipEdit.createModelRoot(version);
                sipEdit.save(null);
            }
            catch (Exception e) {
                SIPCommonPlugin.ErrorMessage("SipArtifactEdit.createDeploymentDescriptor createModelRoot exception=" + e.getMessage(), e);
            }
        }
        finally {
            Resource newRes = sipEdit.getDeploymentDescriptorResource();
            WorkbenchResourceHelperBase.getResourceSet((IProject)project).getResources().remove((Object)newRes);
            newRes.unload();
            sipEdit.dispose();
        }
    }

    public EObject getContentModelRoot() {
        if (this.getDeploymentDescriptorResource().getContents().isEmpty()) {
            return null;
        }
        return this.getSipApp();
    }
}

