/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.ContentType;

import com.ibm.siptools.common.plugin.SIPCommonPlugin;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jst.j2ee.internal.J2EEVersionConstants;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.jst.jee.util.internal.XMLRootHandler;
import org.xml.sax.InputSource;

public class SIP_JavaEEQuickPeek
extends JavaEEQuickPeek
implements J2EEVersionConstants {
    public final String SIPAPP_DOCTYPE = "sip-app";
    public static final int SIP_TYPE = 99;
    public final String SIPAPP_PUBLICID_1_0 = "-//Java Community Process//DTD SIP Application 1.0//EN";
    public final String SIPAPP_PUBLICID_1_1 = "-//Java Community Process//DTD SIP Application 1.1//EN";
    public final String SIPAPP_SYSTEMID_1_0 = "http://www.jcp.org/dtd/sip-app_1_0.dtd";
    public final String SIPAPP_SYSTEMID_1_1 = "http://www.jcp.org/dtd/sip-app-1.1.dtd";
    public final String SIPAPP_SCHEMA_1_0 = "http://www.jcp.org/xsd/sip-app_1_0.xsd";
    public final String SIP_XSD_ID_1_1 = "sip-app-1.1.xsd";
    private XMLRootHandler handler = null;

    public SIP_JavaEEQuickPeek(InputStream in) {
        super(in);
        try {
            try {
                InputSource inputSource = new InputSource(in);
                this.handler = new XMLRootHandler();
                this.handler.parseContents(inputSource);
            }
            catch (Exception ex) {
                SIPCommonPlugin.InfoMessage("SIP_JavaEEQuickPeek Exception=" + ex.getMessage());
                try {
                    if (in != null) {
                        in.reset();
                    }
                }
                catch (IOException ex2) {
                    SIPCommonPlugin.ErrorMessage("SIP_JavaEEQuickPeek IOException=" + ex2.getMessage(), ex2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.reset();
                }
            }
            catch (IOException ex) {
                SIPCommonPlugin.ErrorMessage("SIP_JavaEEQuickPeek IOException=" + ex.getMessage(), ex);
            }
        }
    }

    public int getType() {
        int type = super.getType();
        if (type == -1) {
            String rootName = this.handler.getRootName();
            if (rootName == null) {
                type = -1;
            } else if (rootName.equals("sip-app")) {
                type = 99;
            }
        }
        return type;
    }

    public int getVersion() {
        int version = super.getVersion();
        if (version == -1) {
            String publicID = this.handler.getDtdPublicID();
            String systemID = this.handler.getDtdSystemID();
            String schemaName = null;
            SIPCommonPlugin.DebugMessage("SIP_JavaEEQuickPeek.getVersion publicID=" + publicID);
            if (publicID != null && systemID != null) {
                if (publicID.equals("-//Java Community Process//DTD SIP Application 1.0//EN") && systemID.equals("http://www.jcp.org/dtd/sip-app_1_0.dtd")) {
                    version = 10;
                    return version;
                }
                if (publicID.equals("-//Java Community Process//DTD SIP Application 1.1//EN") && systemID.equals("http://www.jcp.org/dtd/sip-app-1.1.dtd")) {
                    version = 11;
                    return version;
                }
            }
            if (publicID == null || systemID == null) {
                if (this.handler.getRootAttributes() != null) {
                    schemaName = this.handler.getRootAttributes().getValue("xsi:schemaLocation");
                }
                if (schemaName == null) {
                    schemaName = this.handler.getRootAttributes().getValue("xsi:noNamespaceSchemaLocation");
                }
                if (schemaName == null) {
                    schemaName = this.handler.getRootAttributes().getValue("xs:schemaLocation");
                }
                if (schemaName == null) {
                    schemaName = this.handler.getRootAttributes().getValue("xs:noNamespaceSchemaLocation");
                }
                SIPCommonPlugin.DebugMessage("SIP_JavaEEQuickPeek.getVersion schemaName=" + schemaName);
                if (schemaName == null) {
                    version = -1;
                    return version;
                }
            }
            switch (this.getType()) {
                case 99: {
                    if (publicID != null && systemID != null) {
                        if (publicID.equals("-//Java Community Process//DTD SIP Application 1.0//EN") && systemID.equals("http://www.jcp.org/dtd/sip-app_1_0.dtd")) {
                            version = 10;
                            break;
                        }
                        if (!publicID.equals("-//Java Community Process//DTD SIP Application 1.1//EN") || !systemID.equals("http://www.jcp.org/dtd/sip-app-1.1.dtd")) break;
                        version = 11;
                        break;
                    }
                    if (schemaName == null) break;
                    if (schemaName.endsWith("http://www.jcp.org/xsd/sip-app_1_0.xsd")) {
                        version = 10;
                        break;
                    }
                    if (!schemaName.endsWith("sip-app-1.1.xsd")) break;
                    version = 11;
                }
            }
        }
        SIPCommonPlugin.DebugMessage("SIP_JavaEEQuickPeek getVersion version=" + version);
        return version;
    }

    public int getJavaEEVersion() {
        int javaEEVersion = super.getJavaEEVersion();
        if (javaEEVersion == -1) {
            int type = this.getType();
            int version = this.getVersion();
            block0 : switch (type) {
                case 99: {
                    switch (version) {
                        case 10: {
                            javaEEVersion = 14;
                            break block0;
                        }
                        case 11: {
                            SIPCommonPlugin.InfoMessage("SIP_JavaEEQuickPeek getJavaEEVersion 1_4 instead of 5_0");
                            javaEEVersion = 14;
                        }
                    }
                }
            }
        }
        SIPCommonPlugin.DebugMessage("SIP_JavaEEQuickPeek getJavaEEVersion javaEEVersion=" + javaEEVersion);
        return javaEEVersion;
    }
}

