/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rsaz.analysis.architecture.java.collector;

import com.ibm.rsaz.analysis.architecture.core.data.collections.TypesDataMap;
import com.ibm.rsaz.analysis.architecture.java.Messages;
import com.ibm.rsaz.analysis.architecture.java.data.JavaTypeData;
import com.ibm.rsaz.analysis.core.CoreMessages;
import com.ibm.rsaz.analysis.core.data.AbstractDataCollector;
import com.ibm.rsaz.analysis.core.data.AnalysisData;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import com.ibm.rsaz.analysis.core.dataCollectors.AbstractArtifactDataCollector;
import com.ibm.rsaz.analysis.java.core.AnalysisJavaArtifactCollector;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class TypeDataCollector
extends AbstractDataCollector {
    public static final String DEFINED_ID = "com.ibm.rsaz.analysis.architecture.java.collector.TypeDataCollector";
    private static final int PROGRESS_SCALE = 10;

    protected void startCollectingData(IProgressMonitor progressMonitor) {
        try {
            AbstractArtifactDataCollector.ResourcesList resources;
            DataCollector dataCollector = AnalysisDataCollectorsManager.getDataCollector((String)AnalysisJavaArtifactCollector.DEFINED_ID);
            if (dataCollector != null && (resources = (AbstractArtifactDataCollector.ResourcesList)dataCollector.getAnalysisData()) != null) {
                progressMonitor.beginTask(this.getLabel(), resources.size() * 10);
                progressMonitor.subTask("");
                this.populateTypes(resources, (TypesDataMap)this.getAnalysisData(), progressMonitor);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void populateTypes(AbstractArtifactDataCollector.ResourcesList resources, TypesDataMap analysisData, IProgressMonitor progressMonitor) {
        int counter = 0;
        Integer size = new Integer(resources.size());
        for (IResource resource : resources) {
            ++counter;
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            progressMonitor.subTask(CoreMessages.bind((String)CoreMessages.progress_label, (Object)new Integer(counter), (Object)size));
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element.getElementType() == 5) {
                ICompilationUnit cu = (ICompilationUnit)element;
                try {
                    IType[] types = cu.getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        IType type = types[i];
                        analysisData.put((Object)type, (Object)new JavaTypeData(type.getFullyQualifiedName('.'), type));
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            progressMonitor.worked(10);
        }
    }

    public AnalysisData createAnalysisData() {
        TypesDataMap typesMap = new TypesDataMap(10);
        return typesMap;
    }

    public void tearDown() {
        AnalysisData data = this.getAnalysisData();
        if (data instanceof Map) {
            ((Map)data).clear();
        }
        super.tearDown();
    }

    public String getLabel() {
        return Messages.typeDataCollector_label;
    }
}

