/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rsaz.analysis.architecture.java.collector;

import com.ibm.icu.text.UTF16;
import com.ibm.rsaz.analysis.architecture.core.data.AssociationData;
import com.ibm.rsaz.analysis.architecture.core.data.AssociationDataPool;
import com.ibm.rsaz.analysis.architecture.core.data.TypeData;
import com.ibm.rsaz.analysis.architecture.core.data.collections.TypesDataMap;
import com.ibm.rsaz.analysis.architecture.java.Messages;
import com.ibm.rsaz.analysis.core.CoreMessages;
import com.ibm.rsaz.analysis.core.data.AbstractDataCollector;
import com.ibm.rsaz.analysis.core.data.AnalysisData;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import com.ibm.rsaz.analysis.core.logging.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class PatternDataCollector
extends AbstractDataCollector {
    public static final String DEFINED_ID = "com.ibm.rsaz.analysis.architecture.java.collector.PatternDataCollector";
    private static final String ERROR1 = "Could not initialize direct subtypes";
    private static final int PROGRESS_SCALE = 10;

    protected void startCollectingData(IProgressMonitor progressMonitor) {
        try {
            DataCollector dataCollector = AnalysisDataCollectorsManager.getDataCollector((String)"com.ibm.rsaz.analysis.architecture.java.collector.TypeDataCollector");
            if (dataCollector != null) {
                TypesDataMap typesMap = (TypesDataMap)dataCollector.getAnalysisData();
                progressMonitor.beginTask(this.getLabel(), typesMap.size() * 10);
                progressMonitor.subTask("");
                this.polpulatePatternsData(typesMap, progressMonitor);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void polpulatePatternsData(TypesDataMap typesMap, IProgressMonitor progressMonitor) {
        Set entriesSet = typesMap.entrySet();
        int counter = 0;
        Integer size = new Integer(entriesSet.size());
        Iterator iterator = entriesSet.iterator();
        while (iterator.hasNext()) {
            progressMonitor.subTask(CoreMessages.bind((String)CoreMessages.progress_label, (Object)new Integer(++counter), (Object)size));
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                try {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    IType wrappedType = (IType)entry.getKey();
                    TypeData typeData = (TypeData)entry.getValue();
                    if (wrappedType.getSuperclassTypeSignature() != null) {
                        TypeData innerType;
                        TypeData typeData2 = innerType = wrappedType.getDeclaringType() == null ? typesMap.getTypeDataByName(this.getResolvedTypeName(wrappedType.getSuperclassTypeSignature(), wrappedType)) : typesMap.getTypeDataByName(this.getResolvedTypeName(wrappedType.getSuperclassTypeSignature(), wrappedType.getDeclaringType()));
                        if (innerType != null) {
                            IType type = (IType)innerType.getData();
                            TypeData superTypeInfo = typesMap.getTypeData((Object)type);
                            superTypeInfo.addSubtype(typeData);
                            AssociationData association = wrappedType.isClass() ? AssociationDataPool.createGeneralization((TypeData)typeData, (TypeData)superTypeInfo) : AssociationDataPool.createImplements((TypeData)typeData, (TypeData)superTypeInfo);
                            superTypeInfo.addDirectSubtypeAssociationsInScope(association);
                        }
                    }
                    if (wrappedType.getSuperInterfaceTypeSignatures() != null) {
                        String[] elements = wrappedType.getSuperInterfaceTypeSignatures();
                        if (wrappedType.isInterface()) {
                            int i = 0;
                            while (i < elements.length) {
                                TypeData innerType;
                                TypeData typeData3 = innerType = wrappedType.getDeclaringType() == null ? typesMap.getTypeDataByName(this.getResolvedTypeName(elements[i], wrappedType)) : typesMap.getTypeDataByName(this.getResolvedTypeName(elements[i], wrappedType.getDeclaringType()));
                                if (innerType != null) {
                                    IType type = (IType)innerType.getData();
                                    TypeData superTypeInfo = typesMap.getTypeData((Object)type);
                                    superTypeInfo.addSubtype(typeData);
                                    AssociationData association = wrappedType.isClass() ? AssociationDataPool.createGeneralization((TypeData)typeData, (TypeData)superTypeInfo) : AssociationDataPool.createImplements((TypeData)typeData, (TypeData)superTypeInfo);
                                    superTypeInfo.addDirectSubtypeAssociationsInScope(association);
                                }
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < elements.length) {
                                TypeData innerTypeData;
                                TypeData typeData4 = innerTypeData = wrappedType.getDeclaringType() == null ? typesMap.getTypeDataByName(this.getResolvedTypeName(elements[i], wrappedType)) : typesMap.getTypeDataByName(this.getResolvedTypeName(elements[i], wrappedType.getDeclaringType()));
                                if (innerTypeData != null && innerTypeData.isInterface()) {
                                    innerTypeData.addSubtype(typeData);
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (JavaModelException e) {
                    Log.severe((String)ERROR1, (Throwable)e);
                    progressMonitor.worked(10);
                    continue;
                }
            }
            catch (Throwable throwable) {
                progressMonitor.worked(10);
                throw throwable;
            }
            progressMonitor.worked(10);
        }
    }

    public String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException, IllegalArgumentException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        int type = UTF16.charAt((String)refTypeSig, (int)arrayCount);
        if (type == 81) {
            String[][] resolvedNames;
            String name = Signature.getSignatureSimpleName((String)Signature.getTypeErasure((String)Signature.getElementType((String)refTypeSig)));
            String signatureQualifier = Signature.getSignatureQualifier((String)refTypeSig);
            if (!signatureQualifier.equals("")) {
                name = new StringBuffer(signatureQualifier).append('.').append(name).toString();
            }
            if ((resolvedNames = declaringType.resolveType(name)) != null && resolvedNames.length > 0) {
                return this.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    private String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public AnalysisData createAnalysisData() {
        return null;
    }

    public String getLabel() {
        return Messages.patternDataCollector_label;
    }
}

