/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rsaz.analysis.architecture.java.collector;

import com.ibm.rsaz.analysis.architecture.core.data.DomainData;
import com.ibm.rsaz.analysis.architecture.core.data.TypeData;
import com.ibm.rsaz.analysis.architecture.core.data.collections.DomainsDataMap;
import com.ibm.rsaz.analysis.architecture.core.data.collections.TypesDataMap;
import com.ibm.rsaz.analysis.architecture.java.Messages;
import com.ibm.rsaz.analysis.core.CoreMessages;
import com.ibm.rsaz.analysis.core.data.AbstractDataCollector;
import com.ibm.rsaz.analysis.core.data.AnalysisData;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public final class DomainDataCollector
extends AbstractDataCollector {
    public static final String DEFINED_ID = "com.ibm.rsaz.analysis.architecture.java.collector.DomainDataCollector";
    private static final int PROGRESS_SCALE = 10;

    protected void startCollectingData(IProgressMonitor progressMonitor) {
        try {
            TypesDataMap types;
            DataCollector dataCollector = AnalysisDataCollectorsManager.getDataCollector((String)"com.ibm.rsaz.analysis.architecture.java.collector.TypeDataCollector");
            if (dataCollector != null && (types = (TypesDataMap)dataCollector.getAnalysisData()) != null) {
                progressMonitor.beginTask(this.getLabel(), types.size() * 10);
                progressMonitor.subTask("");
                this.populateDomains(types, (DomainsDataMap)this.getAnalysisData(), progressMonitor);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void populateDomains(TypesDataMap types, DomainsDataMap domainsMap, IProgressMonitor progressMonitor) {
        Set entries = types.entrySet();
        int counter = 0;
        Integer size = new Integer(entries.size());
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            ++counter;
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Map.Entry entry = (Map.Entry)iterator.next();
            Object data = entry.getKey();
            TypeData typeData = (TypeData)entry.getValue();
            progressMonitor.subTask(CoreMessages.bind((String)CoreMessages.progress_label, (Object)new Integer(counter), (Object)size));
            if (data instanceof IType) {
                IType type = (IType)data;
                IPackageFragment packageFragment = type.getPackageFragment();
                DomainData domainData = domainsMap.getDomainData((Object)packageFragment);
                if (domainData == null) {
                    domainData = new DomainData(packageFragment.getElementName(), (Object)packageFragment);
                    domainsMap.put((Object)packageFragment, (Object)domainData);
                }
                domainData.addType(typeData);
            }
            progressMonitor.worked(10);
        }
    }

    public AnalysisData createAnalysisData() {
        DomainsDataMap domainsMap = new DomainsDataMap(5);
        return domainsMap;
    }

    public String getLabel() {
        return Messages.domainDataCollector_label;
    }

    public void tearDown() {
        AnalysisData data = this.getAnalysisData();
        if (data instanceof Map) {
            ((Map)data).clear();
        }
        super.tearDown();
    }
}

