/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rsaz.analysis.architecture.java.collector;

import com.ibm.rsaz.analysis.architecture.core.data.TypeData;
import com.ibm.rsaz.analysis.architecture.core.data.collections.TypesDataMap;
import com.ibm.rsaz.analysis.architecture.java.Messages;
import com.ibm.rsaz.analysis.core.CoreMessages;
import com.ibm.rsaz.analysis.core.data.AbstractDataCollector;
import com.ibm.rsaz.analysis.core.data.AnalysisData;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import com.ibm.rsaz.analysis.core.logging.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyDataCollector
extends AbstractDataCollector {
    public static final String DEFINED_ID = "com.ibm.rsaz.analysis.architecture.java.collector.DependencyDataCollector";
    private static final int PROGRESS_SCALE = 10;
    private static SearchEngine engine = new SearchEngine();

    protected void startCollectingData(IProgressMonitor progressMonitor) {
        try {
            DataCollector dataCollector = AnalysisDataCollectorsManager.getDataCollector((String)"com.ibm.rsaz.analysis.architecture.java.collector.TypeDataCollector");
            TypesDataMap typesMap = (TypesDataMap)dataCollector.getAnalysisData();
            progressMonitor.beginTask(this.getLabel(), typesMap.size() * 10);
            progressMonitor.subTask("");
            this.populateDependencyData(typesMap, progressMonitor);
        }
        finally {
            progressMonitor.done();
        }
    }

    private void populateDependencyData(TypesDataMap typesMap, IProgressMonitor progressMonitor) {
        Set entriesSet = typesMap.entrySet();
        int counter = 0;
        Integer size = new Integer(entriesSet.size());
        Iterator iterator = entriesSet.iterator();
        while (iterator.hasNext()) {
            ++counter;
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            progressMonitor.subTask(CoreMessages.bind((String)CoreMessages.progress_label, (Object)new Integer(counter), (Object)size));
            Map.Entry entry = (Map.Entry)iterator.next();
            TypeData typeData = (TypeData)entry.getValue();
            typeData.setDependencies(this.findDependenciesFor(typesMap, typeData));
            progressMonitor.worked(10);
        }
    }

    private Set<TypeData> findDependenciesFor(TypesDataMap typesMap, TypeData typeData) {
        TypeDependencySearchRequestor requestor = new TypeDependencySearchRequestor(typesMap, typeData);
        try {
            engine.searchDeclarationsOfReferencedTypes((IJavaElement)((IType)typeData.getData()), (SearchRequestor)requestor, null);
        }
        catch (JavaModelException javaModelException) {
        }
        catch (ClassCastException e1) {
            Log.severe((String)"", (Throwable)e1);
        }
        return requestor.getFoundTypes();
    }

    public AnalysisData createAnalysisData() {
        return null;
    }

    public String getLabel() {
        return Messages.dependencyDataCollector_label;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeDependencySearchRequestor
    extends SearchRequestor {
        private IType type;
        private Set<IType> foundTypes = new HashSet<IType>(2);
        private TypesDataMap consideredTypes;

        public TypeDependencySearchRequestor(TypesDataMap consideredTypesValue, TypeData typeData) {
            this.type = (IType)typeData.getData();
            this.consideredTypes = consideredTypesValue;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object matchedElement = match.getElement();
            if (this.consideredTypes.containsKey(matchedElement)) {
                this.foundTypes.add((IType)matchedElement);
            }
        }

        public Set<TypeData> getFoundTypes() {
            if (!this.foundTypes.isEmpty()) {
                this.foundTypes.remove(this.type);
                return this.convertToTypeData(this.foundTypes);
            }
            return Collections.emptySet();
        }

        private Set<TypeData> convertToTypeData(Set<IType> foundTypes2) {
            HashSet<TypeData> data = new HashSet<TypeData>(2);
            for (IType typeValue : foundTypes2) {
                data.add(this.consideredTypes.getTypeData((Object)typeValue));
            }
            return data;
        }
    }
}

