/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rdm.ba.document.resource;

import com.ibm.rdm.ba.document.Document;
import com.ibm.rdm.ba.document.resource.DocumentResource;
import com.ibm.rdm.ba.resource.CommonIDGenerator;
import com.ibm.rdm.ba.resource.IAutonameHelper;
import com.ibm.rdm.ba.resource.IIDGenerator;
import com.ibm.rdm.ba.resource.UUIDGenerator;
import com.ibm.rdm.base.BasePackage;
import com.ibm.rdm.emf.base.proxy.ElementProxyUtil;
import com.ibm.rdm.emf.resource.common.CommonResourceImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

public class DocumentResourceImpl
extends CommonResourceImpl
implements DocumentResource {
    protected IIDGenerator idGenerator = null;
    protected IAutonameHelper autonameHelper = null;
    private boolean disableIIDGenerator;
    private String mediaType = "text/xml";

    public boolean isDisableIIDGenerator() {
        return this.disableIIDGenerator;
    }

    public void setDisableIIDGenerator(boolean disableIIDGenerator) {
        this.disableIIDGenerator = disableIIDGenerator;
    }

    public DocumentResourceImpl(URI uri) {
        super(uri);
    }

    protected void attachedHelper(EObject object) {
        EObject proxy = ElementProxyUtil.INSTANCE.getElementProxy(object);
        object = proxy != null ? proxy : object;
        super.attachedHelper(object);
        if (!this.isLoading()) {
            EAttribute idAttribute;
            if (!this.isDisableIIDGenerator() && (idAttribute = object.eClass().getEIDAttribute()) != null && object.eGet((EStructuralFeature)idAttribute) == null) {
                object.eSet((EStructuralFeature)idAttribute, (Object)this.getIdGenerator().generateID(object));
            }
            if (this.getAutonameHelper() != null) {
                this.getAutonameHelper().autoname(object);
            }
        }
        if (object instanceof Document) {
            this.setMediaType(((Document)object).getMediaType());
        }
    }

    protected XMLHelper createXMLHelper() {
        return new XMLHelperImpl((XMLResource)this){

            protected String getURIFragment(Resource containingResource, EObject object) {
                String uriFragment = super.getURIFragment(containingResource, object);
                return uriFragment.length() == 1 && uriFragment.charAt(0) == '/' ? null : uriFragment;
            }

            public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
                if (this.extendedMetaData != null && feature != null && feature.getEContainingClass() == this.extendedMetaData.getDocumentRoot(feature.getEContainingClass().getEPackage()) && this.extendedMetaData.getAffiliation(feature) == BasePackage.Literals.DOCUMENT_ROOT__ANNOTATION) {
                    feature = BasePackage.Literals.DOCUMENT_ROOT__ANNOTATION;
                }
                super.setValue(object, feature, value, position);
            }
        };
    }

    public IIDGenerator getIdGenerator() {
        if (this.idGenerator == null) {
            this.idGenerator = this.useUUIDs() ? UUIDGenerator.INSTANCE : CommonIDGenerator.INSTANCE;
        }
        return this.idGenerator;
    }

    public void setIdGenerator(IIDGenerator idGenerator) {
        assert (idGenerator != null);
        if (this.useUUIDs() && UUIDGenerator.INSTANCE != idGenerator) {
            throw new UnsupportedOperationException("Cannot set ID Generator on Resources using UUIDs");
        }
        this.idGenerator = idGenerator;
    }

    public IAutonameHelper getAutonameHelper() {
        return this.autonameHelper;
    }

    public void setAutonameHelper(IAutonameHelper autonameHelper) {
        this.autonameHelper = autonameHelper;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
        this.getDefaultSaveOptions().put("com.ibm.rdm.base.resource.OPTION_MEDIA_TYPE", mediaType);
        this.setModified(true);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter((ResourceImpl)this){

            public void notifyChanged(Notification notification) {
                if (!DocumentResourceImpl.this.isModified()) {
                    super.notifyChanged(notification);
                }
            }
        };
    }
}

