/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.textanalyzer.internal;

import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.dictionarymanager.DictionaryInfo;
import com.ibm.rcp.textanalyzer.internal.DuplicateWordTableInfo;
import com.ibm.rcp.textanalyzer.internal.SpellCheckerCommon;
import com.ibm.rcp.textanalyzer.internal.TextAnalyzerLogger;
import com.ibm.rcp.textanalyzer.internal.UserDictionaryData;
import com.ibm.rcp.textanalyzer.internal.UserDictionaryManagerImpl;
import com.ibm.rcp.textanalyzer.spellchecker.udm.DataChangedEvent;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionary;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionaryListener;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserWord;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UserDictionaryImpl
implements UserDictionary {
    private final String userWordTag = "userword";
    private final String replaceWordTag = "replaceword";
    private final String userDictionaryFileName = "UserDictionary.xml";
    private final String userWordTypeTag = "userWordType";
    private UserDictionaryData data;
    private boolean disposed = false;

    public boolean addUserWord(String word) throws TextAnalyzerException {
        if (this.disposed) {
            throw new TextAnalyzerException(2, TextAnalyzerLogger.error_UserDictionary_Disposed);
        }
        if (word == null || word.trim().equalsIgnoreCase("")) {
            return false;
        }
        if (this.data != null) {
            word = word.trim();
            if (this.data.words == null) {
                this.data.words = new LinkedList();
            }
            List words = this.data.words;
            Iterator iter = words.iterator();
            while (iter.hasNext()) {
                UserWord userWord = (UserWord)iter.next();
                if (!userWord.getUserWord().equals(word)) continue;
                throw new TextAnalyzerException(2, TextAnalyzerLogger.warning_Duplicated_Word);
            }
            UserWord userWord = new UserWord();
            userWord.setUserWord(word);
            userWord.setType(1);
            boolean retV = false;
            retV = words.add(userWord);
            if (retV) {
                Document doc = this.data.dictionaryNode.getOwnerDocument();
                Element newNode = doc.createElement("userword");
                newNode.setAttribute("userWordType", String.valueOf(userWord.getType()));
                Text txtNode = doc.createTextNode(SpellCheckerCommon.saveConvert(word, false));
                newNode.appendChild(txtNode);
                this.data.dictionaryNode.appendChild(newNode);
                SpellCheckerCommon.writeDocument(doc, "UserDictionary.xml");
                UserDictionaryManagerImpl.recordDataChangedTime(this.data.locale, this.data.dicName, false);
                this.updateDupWordTable(this.data.locale, this.data.dicName, word, true);
                this.createDataChangedEvent(userWord, true);
            }
            return retV;
        }
        return false;
    }

    private void createDataChangedEvent(UserWord word, boolean added) {
        DictionaryInfo[] info = this.getBinaryUserDictioaryInfo();
        if (info.length == 0) {
            DataChangedEvent event = new DataChangedEvent();
            event.setData(new UserWord[]{word});
            event.setLocale(this.data.locale);
            event.setTargetDictionary(this.convertToDictionaryInfo());
            if (added) {
                event.setType(1);
            } else {
                event.setType(2);
            }
            this.fireDataChangedEvent(event);
        } else {
            int i = 0;
            while (i < info.length) {
                DataChangedEvent event = new DataChangedEvent();
                event.setData(new UserWord[]{word});
                event.setLocale(this.data.locale);
                event.setTargetDictionary(info[i]);
                if (added) {
                    event.setType(1);
                } else {
                    event.setType(2);
                }
                this.fireDataChangedEvent(event);
                ++i;
            }
        }
    }

    private void fireDataChangedEvent(DataChangedEvent event) {
        Iterator iter = UserDictionaryManagerImpl.userDictionaryEventListeners.iterator();
        while (iter.hasNext()) {
            UserDictionaryListener lis = (UserDictionaryListener)iter.next();
            lis.dataChanged(event);
        }
    }

    public boolean addUserWord(UserWord userWord) throws TextAnalyzerException {
        if (this.disposed) {
            throw new TextAnalyzerException(2, TextAnalyzerLogger.error_UserDictionary_Disposed);
        }
        if (userWord == null || userWord.getUserWord() == null || userWord.getUserWord().trim().equalsIgnoreCase("")) {
            return false;
        }
        if (userWord.getReplaceWord() != null && "".equals(userWord.getReplaceWord().trim())) {
            userWord.setReplaceWord(null);
        }
        if (this.data != null) {
            if (this.data.words == null) {
                this.data.words = new LinkedList();
            }
            List words = this.data.words;
            Iterator iter = words.iterator();
            while (iter.hasNext()) {
                UserWord word = (UserWord)iter.next();
                if (!word.getUserWord().equals(userWord.getUserWord())) continue;
                throw new TextAnalyzerException(2, TextAnalyzerLogger.warning_Duplicated_Word);
            }
            boolean retV = false;
            UserWord newWord = new UserWord();
            newWord.setReplaceWord(userWord.getReplaceWord());
            newWord.setUserWord(userWord.getUserWord());
            newWord.setType(userWord.getType());
            retV = words.add(newWord);
            if (retV) {
                Document doc = this.data.dictionaryNode.getOwnerDocument();
                Element newNode = doc.createElement("userword");
                if (newWord.getReplaceWord() != null) {
                    newNode.setAttribute("replaceword", SpellCheckerCommon.saveConvert(newWord.getReplaceWord(), false));
                }
                newNode.setAttribute("userWordType", String.valueOf(newWord.getType()));
                Text txtNode = doc.createTextNode(SpellCheckerCommon.saveConvert(newWord.getUserWord(), false));
                newNode.appendChild(txtNode);
                this.data.dictionaryNode.appendChild(newNode);
                SpellCheckerCommon.writeDocument(doc, "UserDictionary.xml");
                UserDictionaryManagerImpl.recordDataChangedTime(this.data.locale, this.data.dicName, false);
                if (userWord.getType() == 1) {
                    this.updateDupWordTable(this.data.locale, this.data.dicName, userWord.getUserWord(), true);
                } else if (userWord.getType() == 2 && userWord.getReplaceWord() != null) {
                    this.updateDupWordTable(this.data.locale, this.data.dicName, userWord.getReplaceWord(), true);
                }
                this.createDataChangedEvent(newWord, true);
            }
            return retV;
        }
        return false;
    }

    public boolean removeUserWord(String word) throws TextAnalyzerException {
        if (this.disposed) {
            throw new TextAnalyzerException(2, TextAnalyzerLogger.error_UserDictionary_Disposed);
        }
        if (word == null || word.trim().equalsIgnoreCase("")) {
            return false;
        }
        if (this.data != null) {
            if (this.data.words == null) {
                return false;
            }
            int size = this.data.words.size();
            int i = 0;
            while (i < size) {
                UserWord userWord = (UserWord)this.data.words.get(i);
                if (userWord.getUserWord().equals(word)) {
                    boolean retV = false;
                    retV = this.data.words.remove(this.data.words.get(i));
                    if (retV) {
                        Node parent = this.data.dictionaryNode;
                        this.removeUserWordNode(parent, userWord);
                        SpellCheckerCommon.writeDocument(parent.getOwnerDocument(), "UserDictionary.xml");
                        UserDictionaryManagerImpl.recordDataChangedTime(this.data.locale, this.data.dicName, false);
                        boolean canDelete = false;
                        String delWord = null;
                        if (userWord.getType() == 1) {
                            canDelete = this.updateDupWordTable(this.data.locale, this.data.dicName, userWord.getUserWord(), false);
                            delWord = userWord.getUserWord();
                        } else if (userWord.getType() == 2 && userWord.getReplaceWord() != null) {
                            canDelete = this.updateDupWordTable(this.data.locale, this.data.dicName, userWord.getReplaceWord(), false);
                            delWord = userWord.getReplaceWord();
                            this.createDataChangedEvent(userWord, false);
                        } else if (userWord.getType() == 2 && userWord.getReplaceWord() == null) {
                            this.createDataChangedEvent(userWord, false);
                        }
                        if (canDelete) {
                            UserWord deleteWord = new UserWord();
                            deleteWord.setUserWord(delWord);
                            deleteWord.setType(1);
                            this.createDataChangedEvent(deleteWord, false);
                        }
                    }
                    return retV;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean removeUserWord(UserWord userWord) throws TextAnalyzerException {
        if (this.disposed) {
            throw new TextAnalyzerException(2, TextAnalyzerLogger.error_UserDictionary_Disposed);
        }
        if (userWord == null || userWord.getUserWord() == null || userWord.getUserWord().trim().equalsIgnoreCase("")) {
            return false;
        }
        if (this.data != null) {
            if (this.data.words == null) {
                return false;
            }
            int size = this.data.words.size();
            int i = 0;
            while (i < size) {
                UserWord word = (UserWord)this.data.words.get(i);
                if (word.getUserWord().equals(userWord.getUserWord())) {
                    boolean retV = false;
                    retV = this.data.words.remove(this.data.words.get(i));
                    if (retV) {
                        Node parent = this.data.dictionaryNode;
                        this.removeUserWordNode(parent, userWord);
                        SpellCheckerCommon.writeDocument(parent.getOwnerDocument(), "UserDictionary.xml");
                        UserDictionaryManagerImpl.recordDataChangedTime(this.data.locale, this.data.dicName, false);
                        boolean canDelete = false;
                        String delWord = null;
                        if (word.getType() == 1) {
                            canDelete = this.updateDupWordTable(this.data.locale, this.data.dicName, word.getUserWord(), false);
                            delWord = word.getUserWord();
                        } else if (word.getType() == 2 && word.getReplaceWord() != null) {
                            canDelete = this.updateDupWordTable(this.data.locale, this.data.dicName, word.getReplaceWord(), false);
                            delWord = word.getReplaceWord();
                            this.createDataChangedEvent(word, false);
                        } else if (word.getType() == 2 && word.getReplaceWord() == null) {
                            this.createDataChangedEvent(word, false);
                        }
                        if (canDelete) {
                            UserWord deleteWord = new UserWord();
                            deleteWord.setUserWord(delWord);
                            deleteWord.setType(1);
                            this.createDataChangedEvent(deleteWord, false);
                        }
                    }
                    return retV;
                }
                ++i;
            }
        }
        return false;
    }

    private void removeUserWordNode(Node parent, UserWord word) {
        NodeList children = parent.getChildNodes();
        int k = children.getLength() - 1;
        while (k >= 0) {
            Node child = children.item(k);
            if ("userword".equals(child.getNodeName().trim()) && SpellCheckerCommon.loadConvert(child.getFirstChild().getNodeValue().trim()).equals(word.getUserWord())) {
                parent.removeChild(child);
            }
            --k;
        }
    }

    public String getName() throws TextAnalyzerException {
        if (this.disposed) {
            return null;
        }
        if (this.data != null) {
            return this.data.dicName;
        }
        return null;
    }

    public String getLocale() throws TextAnalyzerException {
        if (this.disposed) {
            throw new TextAnalyzerException(2, TextAnalyzerLogger.error_UserDictionary_Disposed);
        }
        if (this.data != null) {
            return this.data.locale;
        }
        return null;
    }

    public UserWord[] getUserWords() throws TextAnalyzerException {
        if (this.disposed) {
            throw new TextAnalyzerException(2, TextAnalyzerLogger.error_UserDictionary_Disposed);
        }
        List words = null;
        if (this.data != null) {
            words = this.data.words;
            if (words == null) {
                return new UserWord[0];
            }
            return words.toArray(new UserWord[words.size()]);
        }
        return new UserWord[0];
    }

    public DictionaryInfo[] getBinaryUserDictioaryInfo() {
        if (this.disposed) {
            return new DictionaryInfo[0];
        }
        if (this.data != null) {
            return UserDictionaryManagerImpl.getBinaryUserDictioaryInfo(this.data.locale, this.data.dicName);
        }
        return new DictionaryInfo[0];
    }

    public DictionaryInfo getBinaryUserDictioaryInfo(String engine) {
        if (this.disposed) {
            return null;
        }
        if (this.data != null) {
            return UserDictionaryManagerImpl.getBinaryUserDictioaryInfo(this.data.locale, this.data.dicName, engine);
        }
        return null;
    }

    public void setData(UserDictionaryData data) {
        if (this.disposed) {
            return;
        }
        this.data = data;
    }

    public UserDictionaryData getData() {
        if (this.disposed) {
            return null;
        }
        return this.data;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
    }

    private DictionaryInfo convertToDictionaryInfo() {
        DictionaryInfo info = new DictionaryInfo();
        info.setLocale(this.data.locale);
        info.setDictionaryName(this.data.dicName);
        info.setDictType(2);
        info.setLanguage(SpellCheckerCommon.getLanguageDescription(this.data.locale));
        return info;
    }

    private boolean updateDupWordTable(String locale, String dictName, String word, boolean added) {
        int num;
        boolean retV = false;
        List table = UserDictionaryManagerImpl.getDupWordList();
        int len = table.size();
        DuplicateWordTableInfo exactDic = null;
        int i = 0;
        while (i < len) {
            DuplicateWordTableInfo tmp = (DuplicateWordTableInfo)table.get(i);
            if (tmp.locale.equalsIgnoreCase(locale) && tmp.dictionaryName.equalsIgnoreCase(dictName)) {
                exactDic = tmp;
                break;
            }
            ++i;
        }
        if (exactDic == null) {
            return false;
        }
        if (added) {
            if (exactDic.duplicateWordMap.containsKey(word)) {
                num = (Integer)exactDic.duplicateWordMap.get(word);
                exactDic.duplicateWordMap.put(word, new Integer(num + 1));
            } else if (exactDic.compareWords.contains(word)) {
                exactDic.duplicateWordMap.put(word, new Integer(1));
            }
            exactDic.compareWords.add(word);
        } else {
            if (exactDic.duplicateWordMap.containsKey(word)) {
                num = (Integer)exactDic.duplicateWordMap.get(word);
                if (--num == 0) {
                    exactDic.duplicateWordMap.remove(word);
                } else {
                    exactDic.duplicateWordMap.put(word, new Integer(num));
                }
            } else {
                retV = true;
            }
            exactDic.compareWords.remove(word);
        }
        return retV;
    }
}

