/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.textanalyzer.internal;

import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.internal.EngineExtensionInfo;
import com.ibm.rcp.textanalyzer.internal.RuntimeEngineTable;
import com.ibm.rcp.textanalyzer.internal.TextAnalyzerLogger;
import com.ibm.rcp.textanalyzer.spellchecker.SpellCheckerEngine;
import com.ibm.rcp.textanalyzer.spellchecker.SpellCheckerPreference;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.service.prefs.Preferences;

public class SpellCheckerPrefenceImpl
implements SpellCheckerPreference {
    private static final String IGNORE_WITH_NUMBER = "IGNORE_WITH_NUMBER";
    private static final String IGNORE_WITH_UPPERCASE = "IGNORE_WITH_UPPERCASE";
    private static final String IGNORE_WITH_FILE = "IGNORE_WITH_FILE";
    private static final String IGNORE_WITH_URL = "IGNORE_WITH_URL";
    private Preferences pPref;
    static /* synthetic */ Class class$0;

    public SpellCheckerPrefenceImpl() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.SpellCheckerPrefenceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String pluginID = clazz.getPackage().getName();
        pluginID = pluginID.substring(0, pluginID.lastIndexOf(46));
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences root = service.getRootNode();
        this.pPref = root.node("instance").node(pluginID);
    }

    public boolean getBooleanPreference(int PrefType) throws TextAnalyzerException {
        boolean bRetV = false;
        try {
            switch (PrefType) {
                case 1: {
                    bRetV = this.pPref.getBoolean(IGNORE_WITH_NUMBER, true);
                    break;
                }
                case 2: {
                    bRetV = this.pPref.getBoolean(IGNORE_WITH_UPPERCASE, true);
                    break;
                }
                case 4: {
                    bRetV = this.pPref.getBoolean(IGNORE_WITH_FILE, true);
                    break;
                }
                case 8: {
                    bRetV = this.pPref.getBoolean(IGNORE_WITH_URL, true);
                }
            }
        }
        catch (Exception exception) {
            bRetV = false;
            throw new TextAnalyzerException(7, TextAnalyzerLogger.error_Spell_Preference);
        }
        return bRetV;
    }

    public void setBooleanPreference(int PrefType, boolean bValue) throws TextAnalyzerException {
        try {
            switch (PrefType) {
                case 1: {
                    if (this.pPref.getBoolean(IGNORE_WITH_NUMBER, true) == bValue) break;
                    this.pPref.putBoolean(IGNORE_WITH_NUMBER, bValue);
                    this.pPref.flush();
                    break;
                }
                case 2: {
                    if (this.pPref.getBoolean(IGNORE_WITH_UPPERCASE, true) == bValue) break;
                    this.pPref.putBoolean(IGNORE_WITH_UPPERCASE, bValue);
                    this.pPref.flush();
                    break;
                }
                case 4: {
                    if (this.pPref.getBoolean(IGNORE_WITH_FILE, true) == bValue) break;
                    this.pPref.putBoolean(IGNORE_WITH_FILE, bValue);
                    this.pPref.flush();
                    break;
                }
                case 8: {
                    if (this.pPref.getBoolean(IGNORE_WITH_URL, true) == bValue) break;
                    this.pPref.putBoolean(IGNORE_WITH_URL, bValue);
                    this.pPref.flush();
                }
            }
            this.fireAllLoadedEngineObjects(PrefType, bValue);
            return;
        }
        catch (Exception exception) {
            throw new TextAnalyzerException(7, TextAnalyzerLogger.error_Spell_Preference);
        }
    }

    void fireAllLoadedEngineObjects(int PrefType, boolean bValue) {
        EngineExtensionInfo[] retA = RuntimeEngineTable.getEngineExtensionList();
        if (retA == null || retA.length == 0) {
            return;
        }
        int j = 0;
        while (j < retA.length) {
            SpellCheckerEngine[] allEngObject;
            if (retA[j] != null && (allEngObject = retA[j].getSpellEngineObjects()) != null && allEngObject.length != 0) {
                int cntObj = 0;
                while (cntObj < allEngObject.length) {
                    allEngObject[cntObj].setBooleanPreference(PrefType, bValue);
                    ++cntObj;
                }
            }
            ++j;
        }
    }
}

