/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.textanalyzer.internal;

import com.ibm.rcp.textanalyzer.dictionarymanager.DictionaryInfo;
import com.ibm.rcp.textanalyzer.internal.EngineExtensionInfo;
import com.ibm.rcp.textanalyzer.internal.SpellCheckerCommon;
import com.ibm.rcp.textanalyzer.internal.SpellEngineInfo;
import com.ibm.rcp.textanalyzer.internal.TextAnalyzerLogger;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class RuntimeEngineTable {
    public static final int TYPE_SPELL_ENGINE = 1;
    private static List spellEngineList = null;
    private static List localeList = null;
    private static List spellEngineExtensionList = null;
    private static List allDictionaryList = null;
    private static List allEngineExtensionList = null;
    private static final String ENGINE_EXTENSION = "com.ibm.rcp.textanalyzer.Engines";
    private static final String DICTIONARY_EXTENSION = "com.ibm.rcp.textanalyzer.Dictionaries";
    private static final String ENGINE_ATTRIBUTE = "engine";
    private static final String LOCALE_ATTRIBUTE_TOKEN = ",";
    private static final String DICTIONARY_ATTRIBUTE = "dictionary";
    private static final String DICTIONARY_TYPE_SPELL = "spell";
    private static String clazzName;
    private static String pkgName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.RuntimeEngineTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazzName = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.RuntimeEngineTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        pkgName = clazz2.getPackage().getName();
    }

    public static List getRuntimeEngineTable(int engineType) {
        switch (engineType) {
            case 1: {
                if (spellEngineList == null) {
                    RuntimeEngineTable.constructRuntimeEngineTable();
                }
                return spellEngineList;
            }
        }
        return null;
    }

    public static List getSpellingSupportedLocales() {
        if (localeList != null) {
            return localeList;
        }
        List tempList = RuntimeEngineTable.getRuntimeEngineTable(1);
        if (tempList == null) {
            return null;
        }
        localeList = new LinkedList();
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            SpellEngineInfo specEngine = (SpellEngineInfo)iter.next();
            localeList.add(specEngine.locale);
        }
        return localeList;
    }

    public static EngineExtensionInfo[] getEngineExtensionList() {
        if (spellEngineExtensionList == null) {
            RuntimeEngineTable.constructRuntimeEngineTable();
        }
        if (spellEngineExtensionList != null) {
            return spellEngineExtensionList.toArray(new EngineExtensionInfo[spellEngineExtensionList.size()]);
        }
        return new EngineExtensionInfo[0];
    }

    public static DictionaryInfo[] getDictionariesByEngine(String engineName) {
        if (engineName == null || engineName.length() <= 0) {
            return new DictionaryInfo[0];
        }
        if (allDictionaryList == null) {
            RuntimeEngineTable.constructRuntimeEngineTable();
        }
        if (allDictionaryList == null) {
            return new DictionaryInfo[0];
        }
        DictionaryInfo tempDic = null;
        LinkedList<DictionaryInfo> newList = new LinkedList<DictionaryInfo>();
        Iterator iter = allDictionaryList.iterator();
        while (iter.hasNext()) {
            tempDic = (DictionaryInfo)iter.next();
            if (!engineName.equalsIgnoreCase(tempDic.getEngineName())) continue;
            newList.add(tempDic);
        }
        return newList.toArray(new DictionaryInfo[newList.size()]);
    }

    public static DictionaryInfo[] getDictionariesByLocale(String locale) {
        if (locale == null || locale.length() <= 0) {
            return new DictionaryInfo[0];
        }
        if (allDictionaryList == null) {
            RuntimeEngineTable.constructRuntimeEngineTable();
        }
        if (allDictionaryList == null) {
            return new DictionaryInfo[0];
        }
        DictionaryInfo tempDic = null;
        LinkedList<DictionaryInfo> newList = new LinkedList<DictionaryInfo>();
        Iterator iter = allDictionaryList.iterator();
        while (iter.hasNext()) {
            tempDic = (DictionaryInfo)iter.next();
            if (!locale.equalsIgnoreCase(tempDic.getLocale())) continue;
            newList.add(tempDic);
        }
        return newList.toArray(new DictionaryInfo[newList.size()]);
    }

    public static DictionaryInfo getDictionaryByName(String dicName) {
        if (dicName == null || dicName.length() <= 0) {
            return null;
        }
        if (allDictionaryList == null) {
            RuntimeEngineTable.constructRuntimeEngineTable();
        }
        if (allDictionaryList == null) {
            return null;
        }
        DictionaryInfo dicInfo = null;
        Iterator itr = allDictionaryList.iterator();
        while (itr.hasNext()) {
            DictionaryInfo tempDic = (DictionaryInfo)itr.next();
            if (!tempDic.getDictionaryName().equalsIgnoreCase(dicName)) continue;
            dicInfo = tempDic;
            break;
        }
        return dicInfo;
    }

    public static DictionaryInfo[] getSpellDictionaries(String locale) {
        List tempList = RuntimeEngineTable.getRuntimeEngineTable(1);
        if (tempList == null) {
            return new DictionaryInfo[0];
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            SpellEngineInfo specEngine = (SpellEngineInfo)iter.next();
            if (!locale.equalsIgnoreCase(specEngine.locale)) continue;
            List resList = specEngine.dictionaryInfoList;
            if (resList == null) {
                return new DictionaryInfo[0];
            }
            return resList.toArray(new DictionaryInfo[resList.size()]);
        }
        return new DictionaryInfo[0];
    }

    public static SpellEngineInfo getSpellEngineInfo(String locale) {
        List tempList = RuntimeEngineTable.getRuntimeEngineTable(1);
        if (tempList == null) {
            return null;
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            SpellEngineInfo specEngine = (SpellEngineInfo)iter.next();
            if (!locale.equalsIgnoreCase(specEngine.locale)) continue;
            return specEngine;
        }
        return null;
    }

    private static void constructRuntimeEngineTable() {
        String methodName = "constructRuntimeEngineTable";
        try {
            spellEngineList = new LinkedList();
            RuntimeEngineTable.getSupportedEngines();
            RuntimeEngineTable.getDictionaryMap();
            RuntimeEngineTable.cleanRuntimeSpellTable();
        }
        catch (Exception e) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Construct_RuntimeEngineTable, e);
        }
    }

    private static void getSupportedEngines() {
        IExtensionPoint SCEngine = Platform.getExtensionRegistry().getExtensionPoint(ENGINE_EXTENSION);
        if (SCEngine != null) {
            IExtension[] extension = SCEngine.getExtensions();
            int i = extension.length;
            int j = 0;
            while (j < i) {
                IConfigurationElement[] configurationelement = extension[j].getConfigurationElements();
                int ii = configurationelement.length;
                EngineExtensionInfo newInfo = null;
                int jj = 0;
                while (jj < ii) {
                    if (ENGINE_ATTRIBUTE.equalsIgnoreCase(configurationelement[jj].getName())) {
                        newInfo = new EngineExtensionInfo();
                        newInfo.engineName = configurationelement[jj].getAttribute("name");
                        newInfo.platform = configurationelement[jj].getAttribute("platform");
                        newInfo.provider = configurationelement[jj].getAttribute("provider");
                        Boolean thirdParty = Boolean.valueOf(configurationelement[jj].getAttribute("thirdParty"));
                        newInfo.thirdParty = thirdParty;
                        newInfo.runClass = configurationelement[jj].getAttribute("class");
                        newInfo.interfaceImpl = configurationelement[jj].getAttribute("interface");
                        newInfo.localeString = configurationelement[jj].getAttribute("locales");
                        newInfo.constructElement = configurationelement[jj];
                    }
                    ++jj;
                }
                if (allEngineExtensionList == null) {
                    allEngineExtensionList = new LinkedList();
                }
                allEngineExtensionList.add(newInfo);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.ibm.rcp.textanalyzer.spellchecker.SpellCheckerEngine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.getName().equalsIgnoreCase(newInfo.interfaceImpl)) {
                    if (spellEngineExtensionList == null) {
                        spellEngineExtensionList = new LinkedList();
                    }
                    spellEngineExtensionList.add(newInfo);
                    if (newInfo != null && newInfo.localeString != null) {
                        String[] aSt = RuntimeEngineTable.split(newInfo.localeString, LOCALE_ATTRIBUTE_TOKEN);
                        int iCount = 0;
                        while (iCount < aSt.length) {
                            SpellEngineInfo nInfo = new SpellEngineInfo();
                            nInfo.engineName = newInfo.engineName;
                            nInfo.engineExtensionInfo = newInfo;
                            nInfo.locale = aSt[iCount].trim();
                            spellEngineList.add(nInfo);
                            ++iCount;
                        }
                    }
                }
                ++j;
            }
        }
    }

    private static void getDictionaryMap() {
        String methodName = "getDictionaryMap";
        IExtensionPoint dictionary = Platform.getExtensionRegistry().getExtensionPoint(DICTIONARY_EXTENSION);
        if (dictionary != null) {
            IExtension[] extension = dictionary.getExtensions();
            int j = 0;
            while (j < extension.length) {
                IConfigurationElement[] configurationelement = extension[j].getConfigurationElements();
                String sSpace = extension[j].getContributor().getName();
                DictionaryInfo dictionaryInfo = new DictionaryInfo();
                int ii = configurationelement.length;
                int jj = 0;
                while (jj < ii) {
                    if (DICTIONARY_ATTRIBUTE.equalsIgnoreCase(configurationelement[jj].getName())) {
                        dictionaryInfo.setDescription(configurationelement[jj].getAttribute("description"));
                        dictionaryInfo.setDictionaryName(configurationelement[jj].getAttribute("dict_name"));
                        dictionaryInfo.setEngineName(configurationelement[jj].getAttribute(ENGINE_ATTRIBUTE));
                        dictionaryInfo.setLanguage(SpellCheckerCommon.getLanguageDescription(configurationelement[jj].getAttribute("language")));
                        String dicLocale = configurationelement[jj].getAttribute("locale");
                        dictionaryInfo.setLocale(dicLocale);
                        dictionaryInfo.setProvider(configurationelement[jj].getAttribute("provider"));
                        dictionaryInfo.setVersionInfo(configurationelement[jj].getAttribute("version_info"));
                        String dictType = configurationelement[jj].getAttribute("type");
                        if (dictType == null || dictType.equalsIgnoreCase("")) {
                            dictionaryInfo.setDictType(1);
                        } else if (DICTIONARY_TYPE_SPELL.equalsIgnoreCase(dictType)) {
                            dictionaryInfo.setDictType(1);
                        } else {
                            dictionaryInfo.setDictType(0);
                        }
                        String relativeFilePath = configurationelement[jj].getAttribute("filePath");
                        Bundle bdl = Platform.getBundle((String)sSpace);
                        URL dictionaryURL = FileLocator.find((Bundle)bdl, (IPath)new Path(relativeFilePath), null);
                        try {
                            if (dictionaryURL == null) {
                                TextAnalyzerLogger.log(Level.WARNING, pkgName, clazzName, methodName, TextAnalyzerLogger.warning_Can_Not_Find_Dictionary, new String[]{dictionaryInfo.getDictionaryName()});
                            } else {
                                dictionaryURL = FileLocator.toFileURL((URL)dictionaryURL);
                                URI fileURI = new URI(dictionaryURL.getProtocol(), dictionaryURL.getPath(), null);
                                File tempFile = new File(fileURI);
                                String sDictionaryPath = tempFile.getAbsolutePath();
                                dictionaryInfo.setFilePath(sDictionaryPath);
                            }
                        }
                        catch (Exception e) {
                            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Find_Dictionary_Path, e);
                        }
                    }
                    ++jj;
                }
                RuntimeEngineTable.putDicIntoTable(dictionaryInfo);
                RuntimeEngineTable.putDicIntoSpellTable(dictionaryInfo);
                ++j;
            }
        }
    }

    private static void putDicIntoSpellTable(DictionaryInfo newSpellDic) {
        List tempList = RuntimeEngineTable.getRuntimeEngineTable(1);
        if (tempList == null) {
            return;
        }
        if (newSpellDic == null) {
            return;
        }
        SpellEngineInfo specEngine = null;
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            SpellEngineInfo tmpEngine = (SpellEngineInfo)iter.next();
            if (!tmpEngine.locale.equalsIgnoreCase(newSpellDic.getLocale()) || !tmpEngine.engineName.equalsIgnoreCase(newSpellDic.getEngineName())) continue;
            specEngine = tmpEngine;
            break;
        }
        if (specEngine == null) {
            return;
        }
        if (specEngine.dictionaryInfoList == null) {
            specEngine.dictionaryInfoList = new LinkedList();
            specEngine.dictionaryInfoList.add(newSpellDic);
        } else {
            specEngine.dictionaryInfoList.add(newSpellDic);
        }
    }

    private static void putDicIntoTable(DictionaryInfo newDic) {
        if (allDictionaryList == null) {
            allDictionaryList = new LinkedList();
        }
        allDictionaryList.add(newDic);
    }

    private static void cleanRuntimeSpellTable() {
        HashMap<String, SpellEngineInfo> localeMap = new HashMap<String, SpellEngineInfo>();
        List tempList = RuntimeEngineTable.getRuntimeEngineTable(1);
        if (tempList == null) {
            return;
        }
        SpellEngineInfo specEngine = null;
        Iterator engineIter = tempList.iterator();
        while (engineIter.hasNext()) {
            specEngine = (SpellEngineInfo)engineIter.next();
            if (specEngine.dictionaryInfoList == null) {
                engineIter.remove();
                continue;
            }
            if (!specEngine.engineExtensionInfo.thirdParty && localeMap.containsKey(specEngine.locale)) continue;
            localeMap.put(specEngine.locale, specEngine);
        }
        tempList.retainAll(localeMap.values());
    }

    private static String[] split(String target, String regex) {
        if (target == null || regex == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(target, regex);
        Vector<String> strVector = new Vector<String>();
        int i = 0;
        while (st.hasMoreTokens()) {
            strVector.add(i, st.nextToken());
            ++i;
        }
        String[] returnStrs = new String[i];
        int j = 0;
        while (j < i) {
            returnStrs[j] = (String)strVector.get(j);
            ++j;
        }
        return returnStrs;
    }
}

