/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CQTask;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTBranch;
import com.ibm.rational.wvcm.ct.CTBranchBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTFolderVersion;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTSymbolicLink;
import com.ibm.rational.wvcm.ct.CTSymbolicLinkVersion;
import com.ibm.rational.wvcm.ct.CTTask;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTProvider
extends SrvcProvider {
    public static final String EMPTY_STRING = new String();
    public static final String TRUE = Boolean.toString(true);
    public static final String FALSE = Boolean.toString(false);
    public static final String DEFAULT_COMPONENT_VOB = EMPTY_STRING;
    public static final PropertyNameList.PropertyName<String> FULLY_QUALIFIED_DISPLAY_NAME = new PropertyNameList.PropertyName("com.ibm.rational.wvcm", "fully-qualified-display-name");
    public static final PropertyNameList.PropertyName<String> STREAM_TREE_NODE_NAME = new PropertyNameList.PropertyName("com.ibm.rational.wvcm", "stream-tree-node-name");
    private static final String BASECC_CHAR = String.valueOf('|');
    private static final String UNRECOGNIZED_OPTION = "Unrecognized option";
    private static final String INIT_COMPLETE = "CTProvider initialization complete";
    private static final String DEFAULT_CQ_DBSET_NAME = "sample_schema_repo";
    private static final String DEFAULT_CQ_USERDB_NAME = "SAMPL";
    private static final String DEFAULT_CQ_LOGIN_NAME = "admin";
    private static final int DEFAULT_FEEDBACK_CMD_MIN_DURATION_MILLISECONDS = 60000;
    public static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = FALSE;
    Log _log = null;
    private CCaseLib _cc;
    static boolean IS_CACHING_ENABLED = true;
    private Map<String, CTResource> persistentObjectCache = null;

    public CTProvider() {
        super(null);
    }

    public CTProvider(ProviderFactory.Callback callback, Map<String, String> args) throws WvcmException {
        this.initialize(args, callback);
    }

    public void initialize(Map<String, String> argsArg, ProviderFactory.Callback callback) throws WvcmException {
        String streamPath;
        String pvobTag;
        SrvcFeedback feedback;
        int feedbackDelayMilliseconds;
        CommandProvider p;
        CommandResult r;
        String viewStgPath;
        HashMap<String, String> args = argsArg == null ? new HashMap<String, String>() : argsArg;
        super.initialize(args, callback);
        this._initArgs.put("com.ibm.rational.wvcm.DISPLAYNAME", "ClearCase");
        if (CTInitArgUtils.getCompVobTag(args) == null) {
            CTInitArgUtils.setCompVobTag(args, DEFAULT_COMPONENT_VOB);
        }
        CTLocation viewLoc = null;
        if (this._initArgs.containsKey(InteropStream.IA_WORKSPACE_PATH)) {
            String viewLocString = (String)this._initArgs.get(InteropStream.IA_WORKSPACE_PATH);
            viewLoc = (CTLocation)this.location(viewLocString);
            String viewTag = viewLoc.getViewTag();
            CTInitArgUtils.setViewTag(this._initArgs, viewTag);
        }
        if (CTInitArgUtils.getCQDbsetName(args) == null) {
            CTInitArgUtils.setCQDbsetName(args, DEFAULT_CQ_DBSET_NAME);
        }
        if (CTInitArgUtils.getCQUserdbName(args) == null) {
            CTInitArgUtils.setCQUserdbName(args, DEFAULT_CQ_USERDB_NAME);
        }
        if (CTInitArgUtils.getCQLoginName(args) == null) {
            CTInitArgUtils.setCQLoginName(args, DEFAULT_CQ_LOGIN_NAME);
        }
        if (CTInitArgUtils.getCQUCMRecordAction(args) == null) {
            CTInitArgUtils.setCQUCMRecordAction(args, "");
        }
        String locale = Locale.getDefault().toString();
        String storedLocale = CTInitArgUtils.getLocale(args);
        if (storedLocale == null) {
            CTInitArgUtils.setLocale(args, locale);
        } else if (!locale.equals(storedLocale)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_WARN_LOCALE_MISMATCH, (Object)locale, (Object)storedLocale));
        }
        String charset = Charset.defaultCharset().name();
        String storedCharset = CTInitArgUtils.getCharset(args);
        if (storedCharset == null) {
            CTInitArgUtils.setCharset(args, charset);
        } else if (!charset.equals(storedCharset)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_WARN_CHARSET_MISMATCH, (Object)charset, (Object)storedCharset));
        }
        if (args.get(InteropStream.IA_LINE_SEPARATOR) == null) {
            args.put(InteropStream.IA_LINE_SEPARATOR, InteropStream.LINE_SEPARATOR_DEFAULT.name());
        }
        if ((viewStgPath = CTInitArgUtils.getStgLoc(this._initArgs)) != null && !ObjSelUtils.isViewStgValid(viewStgPath)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_STORAGE_ERROR, (Object)viewStgPath));
        }
        CTInitArgUtils.setDumpEnv(args, CTInitArgUtils.getDumpEnv(args));
        CTInitArgUtils.setUseTripleSet(args, CTInitArgUtils.useTripleSet(args));
        if (CTInitArgUtils.getHost(args) == null) {
            CTInitArgUtils.setHost(args, CCaseLib.HOSTNAME);
        }
        if (CTInitArgUtils.getHpath(args) == null) {
            CTInitArgUtils.setHpath(args, viewStgPath);
        }
        if (CTInitArgUtils.getGpath(args) == null) {
            CTInitArgUtils.setGpath(args, viewStgPath);
        }
        if (!args.containsKey("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION")) {
            args.put("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION", String.valueOf(300000));
        }
        if (!args.containsKey(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE)) {
            args.put(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE, DEFAULT_IGNORE_TASK_CREATION_FAILURE);
        }
        if (CTInitArgUtils.getFeedbackCmdMinDurationValue(args) == null) {
            CTInitArgUtils.setFeedbackCmdMinDurationValue(args, 60000);
        }
        if ((r = (p = new CommandProvider(feedbackDelayMilliseconds = Integer.valueOf(CTInitArgUtils.getFeedbackCmdMinDurationValue(args)).intValue(), this._initArgs)).executeGetResult(feedback = new SrvcFeedback(null), "pwv", "-mvfsroot")).getStat() == 1 && r.getStdErr().contains(UNRECOGNIZED_OPTION)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_CC_VER_ERROR, WvcmException.ReasonCode.FORBIDDEN);
        }
        this._cc = new CCaseLib(p, this._initArgs, this.isCachingEnabled());
        String viewTag = CTInitArgUtils.getViewTag(this._initArgs);
        if (viewTag != null && !this._cc.isViewValid(viewTag, feedback)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_VIEW_ERROR, (Object)viewTag));
        }
        if (!((pvobTag = CTInitArgUtils.getPvobTag(this._initArgs)) != null && pvobTag.length() != 0 || viewLoc == null || viewLoc.getKind().equals((Object)CTLocation.Kind.BASE_CC_VIEW) || (streamPath = (String)this._initArgs.get(InteropStream.IA_OTHER_STREAM_LOCATION)) == null || streamPath.length() == 0)) {
            CTLocation streamLoc = (CTLocation)this.location(streamPath);
            pvobTag = ObjSelUtils.getObjSelVobSel(streamLoc.getDisplayName());
            CTInitArgUtils.setPvobTag(this._initArgs, pvobTag);
        }
        if (pvobTag != null && !this._cc.isVobValid(pvobTag, true, feedback)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_PVOB_ERROR, (Object)pvobTag));
        }
        this.logDebug(INIT_COMPLETE);
    }

    public static void printWarning(String message) {
        System.err.println(message);
    }

    private synchronized Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        }
        return this._log;
    }

    public void logCreation(String objectName, CTLocation objectLocation) {
        this.logDebug("create `" + objectName + "' with location: " + objectLocation.string());
    }

    public void logInfo(String msg) {
        this.getLog().info((Object)msg);
    }

    public void logDebug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public CCaseLib getCCaseLib() {
        return this._cc;
    }

    public void setCCaseLib(CCaseLib cc) {
        this._cc = cc;
    }

    public Location location(String string) throws WvcmException {
        return CTLocation.valueOf(string);
    }

    public SrvcResource lookup(Location genericLocation, SrvcFeedback feedback) {
        if (genericLocation == null) {
            return null;
        }
        CTLocation loc = (CTLocation)genericLocation;
        CTLocation.Kind locKind = loc.getKind();
        CTResource result = null;
        if (this.isCachingEnabled()) {
            if (feedback != null && (result = (CTResource)feedback.lookupCacheEntry((Location)loc)) != null) {
                this.logDebug("Cache hit on kind: " + (Object)((Object)locKind));
                return result;
            }
            result = this.lookupLocationInPersistentProxyCache(loc);
            if (result != null) {
                if (feedback != null) {
                    feedback.setCacheEntry((Location)loc, (SrvcResource)result);
                }
                return result;
            }
        }
        CCaseObjInfo info = null;
        String locationPathname = loc.getDisplayName();
        try {
            if (locKind != null) {
                switch (locKind) {
                    case WORKSPACE: {
                        result = new CTUcmView(loc, this);
                        break;
                    }
                    case CONFIGURATION: {
                        result = new CTWvcmConfiguration(loc, this);
                        break;
                    }
                    case FOLDER: {
                        result = new CTFolder(loc, this);
                        break;
                    }
                    case BRANCH: {
                        result = new CTBranch(loc, this);
                        break;
                    }
                    case BASE_CC_VIEW: {
                        result = new CTBaseCCView(loc, this);
                        break;
                    }
                    case BASE_CC_BASELINE: {
                        result = new CTBranchBaseline(loc, this);
                    }
                }
                if (result != null) {
                    feedback.setCacheEntry((Location)loc, (SrvcResource)result);
                    return result;
                }
            }
            info = CCaseObjInfo.lookupObjInfo(this._cc, locationPathname, feedback);
        }
        catch (WvcmException e) {
            this.getCCaseLib().logIgnoredException("look up location; returning null", (Exception)((Object)e));
            return null;
        }
        return this.createAndCacheCTResource(loc, info, feedback);
    }

    public CTResource createAndCacheCTResource(CTLocation loc, CCaseObjInfo info, SrvcFeedback feedback) {
        if (info == null) {
            return null;
        }
        CTResource result = this.createProxyForLocation(loc, info.getMtype());
        if (result == null) {
            return null;
        }
        result.setObjInfo(info);
        if (feedback != null) {
            feedback.setCacheEntry((Location)loc, (SrvcResource)result);
        }
        this.persistProxyIfImmutable(result, feedback);
        return result;
    }

    private CTResource createProxyForLocation(CTLocation loc, String mtype) {
        CTResource result = null;
        if (mtype.equals("activity")) {
            result = loc.hasKind(CTLocation.Kind.TASK) ? new CTTask(loc, this) : (loc.hasKind(CTLocation.Kind.CQTASK) ? new CQTask(loc, this) : new CTActivity(loc, this));
        } else if (mtype.equals("baseline")) {
            result = new CTBaseline(loc, this);
        } else if (mtype.equals("component")) {
            result = new CTComponent(loc, this);
        } else if (mtype.equals("directory version")) {
            result = this.isVersionSelector(loc) ? new CTFolderVersion(loc, this) : new CTControllableFolder(loc, this);
        } else if (loc.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE)) {
            String pathName;
            File folder;
            result = mtype.equals("directory element") ? new CTControllableFolder(loc, this) : (mtype.equals("symbolic link") ? new CTSymbolicLink(loc, this) : (mtype.equals("**null meta type**") ? ((folder = new File(pathName = (pathName = loc.getDisplayName()).startsWith("vob:") ? pathName.substring("vob:".length()) : pathName)).isDirectory() ? new CTControllableFolder(loc, this) : new CTControllableResource(loc, this)) : new CTControllableResource(loc, this)));
        } else if (mtype.equals("stream")) {
            result = new CTStream(loc, this);
        } else if (mtype.equals("version")) {
            result = this.isVersionSelector(loc) ? new CTVersion(loc, this) : new CTControllableResource(loc, this);
        } else if (mtype.endsWith("element")) {
            result = new CTElement(loc, this);
        } else if (mtype.equals("symbolic link")) {
            result = loc.hasKind(CTLocation.Kind.SYMBOLIC_LINK_VERSION) ? new CTSymbolicLinkVersion(loc, this) : new CTElement(loc, this);
        }
        if (mtype.equals("versioned object base")) {
            result = new CTView(loc, this);
        }
        return result;
    }

    private boolean isVersionSelector(CTLocation loc) {
        return ObjSelUtils.isUniversalSelector(loc.getDisplayName()) || !loc.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE) && loc.getDisplayName().contains("@@");
    }

    public Location rootLocation() {
        return CTLocation._rootLoc;
    }

    public Location relativeRootLocation() {
        return CTLocation._relativeRootLoc;
    }

    public SrvcResource doCreateGeneratedActivity(Location locationHint, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        if (isStream) {
            return CTStream.doCreateGeneratedResource(this, (CTLocation)locationHint, updates, updated, feedback);
        }
        return CTActivity.doCreateGeneratedActivity(false, this, (CTLocation)locationHint, updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return CTTask.doCreateGeneratedActivity(true, this, (CTLocation)location, updates, updated, feedback);
    }

    public SrvcResource doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableFolder.doCreate(this, location, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTSymbolicLink result = CTSymbolicLink.doCreateSymbolicLink(this, location, updates, updated, feedback);
        return result;
    }

    public CTControllableResource doCreateControllableResource(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableResource.doCreate(this, location, updates, updated, feedback);
        return result;
    }

    public List<Object> doFind(Resource query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        if (query instanceof Component) {
            return this.doFindUCMComponent((Component)query, propertyRequest, all, feedback);
        }
        if (query instanceof Version) {
            return this.doFindVersionInWorkspace((Version)query, propertyRequest, all, feedback);
        }
        if (query instanceof Stream) {
            return this.doFindStream((Stream)query, propertyRequest, all, feedback);
        }
        if (query instanceof Configuration) {
            return this.doFindConfigurationInView((Configuration)query, propertyRequest, all, feedback);
        }
        if (query instanceof ControllableResource) {
            return this.doFindCRInView((ControllableResource)query, propertyRequest, all, feedback);
        }
        return this.doFindResource(query, propertyRequest, all, feedback);
    }

    private List<Object> doFindVersionInWorkspace(Version query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<Object> results = new ArrayList<Object>();
        ResourceList queryWorkspaceList = query.getInWorkspaceList();
        Workspace workspaceQuery = (Workspace)queryWorkspaceList.get(0);
        CTLocation viewLoc = (CTLocation)workspaceQuery.getPathnameLocation();
        CTView view = new CTView(viewLoc, this);
        VersionHistory vh = query.getVersionHistory();
        Location elemLoc = vh.getPathnameLocation();
        CTElement element = (CTElement)this.lookup(elemLoc, feedback);
        if (element != null) {
            CTLocation myCRLoc = element.lookupMyControllableResourceLoc(view, feedback);
            CTControllableResource myCR = (CTControllableResource)this.lookup(myCRLoc, feedback);
            CTLocation verLoc = null;
            if (myCR != null) {
                CTVersion version = (CTVersion)myCR.lookupCurrentVersion(feedback);
                if (version != null) {
                    verLoc = version.getLocation();
                    CTVersion ctResult = (CTVersion)this.createAndCacheCTResource(verLoc, myCR.getObjInfo(feedback), feedback);
                    ctResult.setElemUSel(element.getUniversalSelector(feedback));
                }
            } else if (element.getObjInfo(feedback).getMtype().equals("symbolic link")) {
                verLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, element.getLocation().getDisplayName());
            }
            if (verLoc != null) {
                Version vers = (Version)this.buildProxy(verLoc, propertyRequest, feedback);
                results.add(vers);
            }
        }
        return results;
    }

    private List<Object> doFindResource(Resource query, PropertyRequestItem.PropertyRequest propRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<Object> result = new ArrayList<Object>();
        Object streamTreeNodeNameVal = query.lookupProperty(STREAM_TREE_NODE_NAME);
        if (!(streamTreeNodeNameVal instanceof String)) {
            throw new IllegalArgumentException(STREAM_TREE_NODE_NAME + " specified in query is not a string");
        }
        String streamTreeNodeName = (String)streamTreeNodeNameVal;
        if (streamTreeNodeName.length() == 0) {
            List<String> pvobNames = this._cc.getPvobSelectors(all, feedback);
            for (String pvobName : pvobNames) {
                CTLocation folderLoc = CTLocation.valueOf(CTLocation.Kind.FOLDER, pvobName);
                Resource fldr = this.buildProxy(folderLoc, propRequest, feedback);
                result.add(fldr);
            }
        } else {
            CTLocation folderLoc = CTLocation.valueOf(CTLocation.Kind.FOLDER, streamTreeNodeName);
            Resource fldr = this.buildProxy(folderLoc, propRequest, feedback);
            result.add(fldr);
        }
        return result;
    }

    private List<Object> doFindStream(Stream query, PropertyRequestItem.PropertyRequest propRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<Object> result = new ArrayList<Object>();
        String querySel = null;
        try {
            querySel = query.getDisplayName();
        }
        catch (WvcmException wvcmException) {}
        if (querySel != null) {
            if (querySel.contains(BASECC_CHAR)) {
                int index = querySel.indexOf(BASECC_CHAR);
                String brtype = null;
                String lbtype = null;
                if (index != -1) {
                    brtype = querySel.substring(0, index);
                    lbtype = querySel.substring(index + 1, querySel.length());
                    if (lbtype.equals("")) {
                        lbtype = null;
                    }
                }
                if (brtype != null) {
                    String brtypeSel = this._cc.validateAndLockBranchType(brtype, false, feedback);
                    if (brtypeSel == null) {
                        return result;
                    }
                    CTLocation lbtypeLocation = null;
                    if (lbtype != null) {
                        String lbtypeSel = this._cc.validateAndLockLabelType(lbtype, true, feedback);
                        if (lbtypeSel == null) {
                            return result;
                        }
                        lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, lbtypeSel);
                    }
                    CTLocation brtypeLocation = CTLocation.valueOf(CTLocation.Kind.BRTYPE, brtypeSel);
                    CTLocation branchLocation = CTLocation.createBranchLocation(brtypeLocation, lbtypeLocation);
                    Resource branch = this.buildProxy(branchLocation, propRequest, feedback);
                    result.add(branch);
                    return result;
                }
                throw new WvcmException(Messages.CTProvider_INVALID_BASECC_STREAM_FMT_ERROR, WvcmException.ReasonCode.FORBIDDEN);
            }
            String streamSel = this._cc.queryStream(querySel, feedback);
            if (streamSel == null) {
                return result;
            }
            CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamSel);
            Resource stream = this.buildProxy(streamLoc, propRequest, feedback);
            result.add(stream);
            return result;
        }
        String pVobTag = this.getDefaultPvobTag();
        String streamFilter = this.getDefaultStreamFilter();
        if (pVobTag == null || streamFilter == null) {
            throw new IllegalStateException("A filtered stream query requires a pvob tag and a stream filter is required");
        }
        List<String> streamNames = this._cc.findStreams(pVobTag, streamFilter, all, feedback);
        for (String streamUsel : streamNames) {
            CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamUsel);
            Resource stream = this.buildProxy(streamLoc, propRequest, feedback);
            result.add(stream);
            if (!all) break;
        }
        return result;
    }

    private List<Object> doFindCRInView(ControllableResource query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        Resource result;
        block4: {
            if (!query.location().equals(CTLocation._rootLoc)) {
                throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
            }
            Workspace queryWs = query.getWorkspace();
            Location viewLoc = queryWs.getPathnameLocation();
            CTView view = new CTView(viewLoc, this);
            VersionHistory vh = query.getVersionHistory();
            Location elemLoc = vh.getPathnameLocation();
            CTElement element = new CTElement(elemLoc, this);
            CTLocation myCRLoc = element.lookupMyControllableResourceLoc(view, feedback);
            result = null;
            if (myCRLoc != null) {
                try {
                    result = this.buildProxy(myCRLoc, propertyRequest, feedback);
                }
                catch (WvcmException e) {
                    if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) break block4;
                    throw e;
                }
            }
        }
        return Collections.singletonList(result);
    }

    private List<Object> doFindConfigurationInView(Configuration query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        if (!query.location().equals(CTLocation._rootLoc)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        Workspace queryWs = query.getWorkspace();
        CTLocation viewLoc = (CTLocation)queryWs.getPathnameLocation();
        VersionHistory queryComp = query.getVersionHistory();
        CTLocation compLoc = (CTLocation)queryComp.getPathnameLocation();
        CTLocation configLoc = null;
        if (viewLoc.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, compLoc.getDisplayName());
            configLoc = CTLocation.createBaseConfigurationLoc(viewLoc, compLoc);
        } else {
            compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compLoc.getDisplayName());
            configLoc = CTLocation.createConfigurationLoc(viewLoc, compLoc);
        }
        Configuration result = null;
        if (configLoc != null) {
            result = (Configuration)this.buildProxy(configLoc, propertyRequest, feedback);
        }
        return Collections.singletonList(result);
    }

    private List<Object> doFindUCMComponent(Component query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        Object compNameVal = query.lookupProperty(Component.DISPLAY_NAME);
        if (!(compNameVal instanceof String)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        String pVobTag = this.getDefaultPvobTag();
        if (pVobTag == null) {
            return null;
        }
        String compName = (String)compNameVal;
        String compSel = ObjSelUtils.formatSelector("component", compName, pVobTag);
        CCaseObjInfo info = CCaseObjInfo.lookupObjInfo(this._cc, compSel, feedback);
        if (info == null) {
            return null;
        }
        CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, info.getUniversalSelector());
        Resource result = this.buildProxy(compLoc, propertyRequest, feedback);
        return Collections.singletonList(result);
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableResource.doCreateVersionControlledResource(this, (CTLocation)location, (CTLocation)versionLoc, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue streamValue = updates != null ? updates.get(Workspace.TARGET) : null;
        CTLocation streamLoc = streamValue != null ? (CTLocation)streamValue.get_value() : null;
        CTView result = null;
        result = streamLoc != null && streamLoc.hasKind(CTLocation.Kind.BRANCH) ? CTBaseCCView.doCreateGeneratedResource(this, location, updates, updated, feedback) : CTUcmView.doCreateGeneratedResource(this, location, updates, updated, feedback);
        return result;
    }

    public SrvcResource doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTLocation lastLocation = (CTLocation)location;
        if (lastLocation.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE)) {
            CTLocation parentLocation = lastLocation.parent();
            while (parentLocation != null && !parentLocation.equals(CTLocation._rootLoc)) {
                lastLocation = parentLocation;
                parentLocation = parentLocation.parent();
            }
            if (lastLocation.hasKind(CTLocation.Kind.WORKSPACE)) {
                String viewTag = lastLocation.getDisplayName();
                if (this._cc.isBaseCCView(viewTag, feedback)) {
                    throw new WvcmException(Messages.CTProvider_UNSUPPORTED_MKCOMP_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
                }
                return CTControllableFolder.doCreateComponentAndRoot(this, location, updates, updated, feedback);
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.CTProvider_UNSUPPORTED_FOR_LOCATION, (Object)location));
    }

    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource srvcResource = this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = this.doCreateControllableResource(location, (Map)new HashMap(), (List)updated, feedback);
        }
        srvcResource.doWriteContent(content, contentIdentifier, updates, updated, feedback);
        return srvcResource;
    }

    public String getDefaultPvobTag() {
        String pVobTag = CTInitArgUtils.getPvobTag(this._initArgs);
        return pVobTag;
    }

    public String getDefaultCompVobTag(SrvcFeedback feedback) throws WvcmException {
        String compVobTag = CTInitArgUtils.getCompVobTag(this._initArgs).trim();
        if (compVobTag == null) {
            throw new IllegalStateException("CTProvider's compVob tag initial argument is null");
        }
        if (compVobTag.length() == 0) {
            String msg = feedback.format(Messages.CTProvider_MUST_DEFINE_COMPVOBTAG, new Object[]{"COMPONENT_VOB_TAG"});
            throw new WvcmException(msg, WvcmException.ReasonCode.CONFLICT);
        }
        return compVobTag;
    }

    private String getDefaultStreamFilter() {
        String streamFilter = CTInitArgUtils.getStreamFilter(this._initArgs);
        return streamFilter;
    }

    private boolean isCachingEnabled() {
        return IS_CACHING_ENABLED;
    }

    public List<CTResource> getResources(List<CTLocation> locations, SrvcFeedback feedback) {
        ArrayList<CTResource> result = new ArrayList<CTResource>();
        for (CTLocation loc : locations) {
            CTResource r = (CTResource)this.lookup(loc, feedback);
            result.add(r);
        }
        return result;
    }

    public InteropStream.LineSeparator getDefaultLineSeparator() {
        String value = (String)this._initArgs.get(InteropStream.IA_LINE_SEPARATOR);
        return value == null ? InteropStream.LINE_SEPARATOR_DEFAULT : InteropStream.LineSeparator.valueOf((String)value);
    }

    private synchronized void persistProxyIfImmutable(CTResource resource, SrvcFeedback feedback) {
        try {
            if (this.isCachingEnabled() && resource.isImmutable()) {
                if (this.persistentObjectCache == null) {
                    this.persistentObjectCache = new HashMap<String, CTResource>();
                }
                this.persistentObjectCache.put(resource.getUniversalSelector(feedback), resource);
            }
        }
        catch (WvcmException e) {
            this.getCCaseLib().logIgnoredException("persistProxyIfImmutable", (Exception)((Object)e));
        }
    }

    private synchronized CTResource lookupLocationInPersistentProxyCache(CTLocation loc) {
        CTResource result = null;
        String dn = loc.getDisplayName();
        if (dn != null && ObjSelUtils.isUniversalSelector(dn) && this.persistentObjectCache != null) {
            result = this.persistentObjectCache.get(dn);
        }
        return result;
    }

    public void flushPathnameCacheEntries(SrvcFeedback feedback) {
        this.persistentObjectCache = null;
        feedback.flushCache();
    }

    public void validate(Feedback feedback) {
        feedback.notifyActive(Messages.CTProvider_REPORT_MVFS_CASE_CHECK);
        SrvcFeedback f = new SrvcFeedback(feedback);
        try {
            boolean casePreservingNature = this._cc.isCasePreservingNature(f);
            if (!casePreservingNature) {
                feedback.notifyWarning(Messages.CTProvider_WARN_MUST_PRESERVE_CASE);
            }
        }
        catch (WvcmException e) {
            throw new RuntimeException(e);
        }
    }
}

