/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import org.eclipse.core.runtime.CoreException;

public class SerializationUtility {
    public static final String PG_OPENING_TAG = "<";
    public static final String PG_CLOSING_TAG = ">";
    public static final String PD_ENDING_TAG = "/";
    public static final String PROPERTY_NAME_VALUE_SEPARATOR = "\u21c2";
    public static final String PD_CHILDREN_SEPARATOR = "\u21c3";
    public static final String MVP_PROPERTY_VALUES_SEPARATOR = "\u21d5";
    public static final String PG_VERSION_ATTRIBUTE = " V_";

    public static String getPropertyGroupAsString(IPropertyGroup grp, String version) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(SerializationUtility.getPGOpeningTag(grp.getName(), version));
        IPropertyDescriptor[] children = grp.getProperties();
        int i = 0;
        while (i < children.length) {
            block13: {
                block12: {
                    if (!(children[i] instanceof ISingleTypedProperty)) break block12;
                    ISingleTypedProperty prop = (ISingleTypedProperty)children[i];
                    if (prop.getPropertyType().isSensitive() || !prop.isSet()) break block13;
                    if (prop instanceof ISingleValuedProperty) {
                        pgstring.append(prop.getName());
                        pgstring.append(PROPERTY_NAME_VALUE_SEPARATOR);
                        pgstring.append(((ISingleValuedProperty)prop).getValueAsString());
                        pgstring.append(PD_CHILDREN_SEPARATOR);
                    } else if (prop instanceof IMultiValuedProperty) {
                        pgstring.append(prop.getName());
                        pgstring.append(PROPERTY_NAME_VALUE_SEPARATOR);
                        pgstring.append(SerializationUtility.getMultiValues(prop));
                        pgstring.append(PD_CHILDREN_SEPARATOR);
                    }
                }
                if (PropertyHelper.isPropertyGroup(children[i])) {
                    String pgContents = ((IPropertyGroup)children[i]).convertToString();
                    if (pgContents != null && pgContents.length() > 0) {
                        StringBuffer defaultTag = SerializationUtility.getPGOpeningTag(children[i].getName(), version);
                        if (!pgContents.contains(defaultTag)) {
                            pgstring.append(defaultTag);
                        }
                        pgstring.append(pgContents);
                        StringBuffer endingTag = SerializationUtility.getPGClosingTag(children[i].getName());
                        if (!pgContents.contains(endingTag)) {
                            pgstring.append(endingTag);
                        }
                        pgstring.append(PD_CHILDREN_SEPARATOR);
                    } else {
                        pgstring.append(SerializationUtility.getPropertyGroupAsString((IPropertyGroup)children[i], version));
                    }
                }
            }
            ++i;
        }
        pgstring.append(SerializationUtility.getPGClosingTag(grp.getName()));
        return pgstring.toString();
    }

    private static StringBuffer getMultiValues(IPropertyDescriptor propertyDescriptor) {
        String[] values = ((IMultiValuedProperty)propertyDescriptor).getValuesAsStrings();
        StringBuffer pgstring = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            pgstring.append(values[i]);
            if (i < values.length - 1) {
                pgstring.append(MVP_PROPERTY_VALUES_SEPARATOR);
            }
            ++i;
        }
        return pgstring;
    }

    public static StringBuffer getPGOpeningTag(String name, String version) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(PG_OPENING_TAG);
        pgstring.append(name);
        if (version != null) {
            pgstring.append(PG_VERSION_ATTRIBUTE + version);
        }
        pgstring.append(PG_CLOSING_TAG);
        return pgstring;
    }

    public static StringBuffer getPGClosingTag(String name) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(PG_OPENING_TAG);
        pgstring.append(PD_ENDING_TAG);
        pgstring.append(name);
        pgstring.append(PG_CLOSING_TAG);
        return pgstring;
    }

    public static void populatePropertyGroupFromString(String grpString, IPropertyGroup grp) throws CoreException {
        if (grpString == null || "".equals(grpString)) {
            return;
        }
        IPropertyDescriptor[] children = grp.getProperties();
        int i = 0;
        while (i < children.length) {
            block13: {
                block14: {
                    boolean isEnabled;
                    block10: {
                        String value;
                        block15: {
                            block12: {
                                if (!(children[i] instanceof IPropertyGroup)) break block12;
                                ((IPropertyGroup)children[i]).populateFromString(SerializationUtility.extractGroupString(children[i].getName(), grpString));
                                break block13;
                            }
                            if (!(children[i] instanceof ISingleValuedProperty)) break block14;
                            isEnabled = children[i].isEnabled();
                            if (isEnabled) break block15;
                            if (!(children[i] instanceof BaseSingleValuedProperty)) break block13;
                            ((BaseSingleValuedProperty)children[i]).setEnabled(true);
                        }
                        if ((value = SerializationUtility.extractSingleValuePropertyValue(children[i].getName(), grpString)) != null) {
                            try {
                                ((ISingleValuedProperty)children[i]).setValueAsString(value);
                            }
                            catch (CoreException exc) {
                                if (exc.getStatus().getCode() != 4) break block10;
                                throw exc;
                            }
                        }
                    }
                    if (isEnabled) break block13;
                    ((BaseSingleValuedProperty)children[i]).setEnabled(false);
                    break block13;
                }
                if (children[i] instanceof IMultiValuedProperty && children[i].isEnabled()) {
                    String[] values = SerializationUtility.extractMultiValuePropertyValue(children[i].getName(), grpString);
                    ((IMultiValuedProperty)children[i]).unSet();
                    int j = 0;
                    while (j < values.length) {
                        block11: {
                            if (values[j] != null && !values[j].equalsIgnoreCase("null")) {
                                try {
                                    ((IMultiValuedProperty)children[i]).addValue(values[j]);
                                }
                                catch (CoreException exc) {
                                    if (exc.getStatus().getCode() != 4) break block11;
                                    throw exc;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private static String[] extractMultiValuePropertyValue(String propName, String grpString) {
        String extractedPropValue = SerializationUtility.extractSingleValuePropertyValue(propName, grpString);
        return extractedPropValue.split(MVP_PROPERTY_VALUES_SEPARATOR);
    }

    private static String extractSingleValuePropertyValue(String propName, String grpString) {
        int indexOfName = grpString.indexOf(propName);
        if (indexOfName == -1) {
            return null;
        }
        int indexOfSeparator = grpString.indexOf(PD_CHILDREN_SEPARATOR, indexOfName);
        String truncatedPropString = grpString.substring(indexOfName + propName.length() + 1, indexOfSeparator);
        if (truncatedPropString.equalsIgnoreCase("null")) {
            return null;
        }
        return truncatedPropString;
    }

    public static String extractGroupString(String name, String grpString) {
        StringBuffer searchText1 = new StringBuffer();
        searchText1.append(PG_OPENING_TAG);
        searchText1.append(name);
        String truncatedString = grpString;
        if (grpString.indexOf(searchText1.toString()) != -1) {
            truncatedString = truncatedString.substring(truncatedString.indexOf(searchText1.toString()) + searchText1.length());
            truncatedString = truncatedString.substring(truncatedString.indexOf(PG_CLOSING_TAG) + 1);
        }
        String searchText2 = SerializationUtility.getPGClosingTag(name).toString();
        String pgString = truncatedString;
        if (truncatedString.indexOf(searchText2) != -1) {
            pgString = truncatedString.substring(0, truncatedString.indexOf(searchText2));
        }
        return pgString;
    }

    public static String getPropertyGroupVersion(String pgName, String pgContents) {
        StringBuffer pgstring = new StringBuffer();
        pgstring.append(PG_OPENING_TAG);
        pgstring.append(pgName);
        int nameTagIndex = pgContents.indexOf(pgName);
        if (nameTagIndex == -1) {
            return null;
        }
        int nextVersionTagIndex = pgContents.indexOf(PG_VERSION_ATTRIBUTE, nameTagIndex);
        int nextClosingTagIndex = pgContents.indexOf(PG_CLOSING_TAG, nameTagIndex);
        String version = pgContents.substring(nextVersionTagIndex + PG_VERSION_ATTRIBUTE.length(), nextClosingTagIndex);
        return version.trim();
    }
}

