/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class FolderProperty
extends BaseSingleValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = "/\\:.";
    protected int customPropertyFlag = 18;
    protected boolean mustExist = true;

    public FolderProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    public FolderProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, boolean mustExist) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.mustExist = mustExist;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FolderProperty property = (FolderProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    @Override
    public void setValueAsString(String newValue) throws CoreException {
        try {
            if (newValue == null || "".equals(newValue.trim())) {
                this.setValue(null);
                return;
            }
            this.setValue(URI.createFileURI((String)newValue));
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setValue(Object newValue) throws CoreException {
        block12: {
            block11: {
                if (newValue == null) {
                    super.setValue(null);
                    return;
                }
                if (!(newValue instanceof URI)) break block11;
                fileURI = (URI)newValue;
                if (!"platform".equals(fileURI.scheme())) ** GOTO lbl30
                if (fileURI.segmentCount() > 1 && "resource".equals(fileURI.segment(0))) {
                    platformResourcePath = new StringBuffer();
                    i = 1;
                    size = fileURI.segmentCount();
                    while (i < size) {
                        platformResourcePath.append('/');
                        platformResourcePath.append(URI.decode((String)fileURI.segment(i)));
                        ++i;
                    }
                    status = ResourcesPlugin.getWorkspace().validatePath(platformResourcePath.toString(), 2);
                    if (status.getSeverity() == 4 || status.getSeverity() == 2) {
                        throw new CoreException(status);
                    }
                    if (this.mustExist) {
                        folderPath = new Path(platformResourcePath.toString());
                        folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)folderPath);
                        if (!folder.exists()) {
                            status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.bind((String)MessageResource.ERR_DIR_NOT_FOUND, (Object)folderPath.toOSString()), null);
                            throw new CoreException(status);
                        }
                    }
                } else {
                    status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_URI_NOT_FOLDER, null);
                    throw new CoreException((IStatus)status);
lbl30:
                    // 1 sources

                    if ("file".equals(fileURI.scheme())) {
                        directoryPath = fileURI.toFileString();
                        directory = new File(directoryPath);
                        if (directory == null || this.mustExist && !directory.isDirectory()) {
                            status = new Status(2, "com.ibm.propertygroup", 2, MessageResource.bind((String)MessageResource.ERR_DIR_NOT_FOUND, (Object)directoryPath), null);
                            throw new CoreException((IStatus)status);
                        }
                    } else if (this.isMustExist()) {
                        status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_URI_NOT_FOLDER, null);
                        throw new CoreException((IStatus)status);
                    }
                }
                break block12;
            }
            status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_INVALID_OBJECT_TYPE, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        super.setValue(fileURI);
    }

    @Override
    public String getValueAsString() {
        if (this.value != null) {
            if (((URI)this.value).isFile()) {
                return ((URI)this.value).toFileString();
            }
            if ("platform".equals(((URI)this.value).scheme())) {
                URI uri = (URI)this.value;
                String decodedURI = URI.decode((String)uri.toString());
                String path = "platform:/resource";
                int index = decodedURI.indexOf(path);
                String wsPath = decodedURI.substring(index += path.length());
                String wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                String value = String.valueOf(wsRoot) + wsPath;
                return value;
            }
        }
        return "";
    }

    public boolean isMustExist() {
        return this.mustExist;
    }
}

