/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class FileProperty
extends BaseSingleValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = "/\\:.";
    protected int customPropertyFlag = 17;
    protected boolean mustExist = true;
    String[] fileExtensions;

    public FileProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validFileExtensions) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.fileExtensions = validFileExtensions;
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    public FileProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validFileExtensions, boolean mustExist) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.fileExtensions = validFileExtensions;
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.mustExist = mustExist;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FileProperty property = (FileProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        try {
            int size;
            StringBuffer platformResourcePath;
            if (evt.getSource() != this) return;
            if (evt.getNewValue() == null) {
                if (!this.getPropertyType().isRequired()) return;
                throw new PropertyVetoException(MessageResource.ERR_URI_NOT_NULL, evt);
            }
            URI uri = (URI)evt.getNewValue();
            String workspaceFile = null;
            if ("platform".equals(uri.scheme())) {
                if (uri.segmentCount() <= 1 || !"resource".equals(uri.segment(0))) throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
                platformResourcePath = new StringBuffer();
                int i = 1;
                size = uri.segmentCount();
                while (i < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(URI.decode((String)uri.segment(i)));
                    ++i;
                }
                IStatus status = ResourcesPlugin.getWorkspace().validateName(platformResourcePath.toString(), 1);
                if (status.getCode() == 4) {
                    throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
                }
                workspaceFile = platformResourcePath.toString();
            } else if (!uri.isFile()) {
                throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
            }
            if (this.mustExist) {
                File file;
                if ("platform".equals(uri.scheme())) {
                    if (uri.segmentCount() <= 1 || !"resource".equals(uri.segment(0))) throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
                    if (workspaceFile == null) {
                        platformResourcePath = new StringBuffer();
                        int i = 1;
                        size = uri.segmentCount();
                        while (i < size) {
                            platformResourcePath.append('/');
                            platformResourcePath.append(URI.decode((String)uri.segment(i)));
                            ++i;
                        }
                        workspaceFile = platformResourcePath.toString();
                    }
                    if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspaceFile))) == null || !file.exists()) {
                        throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
                    }
                } else {
                    if (!"file".equals(uri.scheme())) throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
                    file = new File(uri.toFileString());
                    if (!file.exists()) {
                        throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
                    }
                }
            }
            if (this.fileExtensions == null || this.fileExtensions.length <= 0) return;
            String fileExt = uri.fileExtension();
            if (fileExt == null) throw new PropertyVetoException(MessageResource.ERR_NO_FILE_EXT, evt);
            int i = this.fileExtensions.length;
            while (--i >= 0) {
                if (!this.fileExtensions[i].equalsIgnoreCase(fileExt)) continue;
                return;
            }
            throw new PropertyVetoException(MessageResource.ERR_INVALID_FILE_EXT, evt);
        }
        catch (Throwable e) {
            throw new PropertyVetoException(e.getLocalizedMessage(), evt);
        }
    }

    public String getFileLocation() {
        try {
            URI uri = (URI)this.getValue();
            if (uri != null) {
                return this.getValueAsString();
            }
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public void setValueAsString(String newValue) throws CoreException {
        if (newValue == null || "".equals(newValue.trim())) {
            this.setValue(null);
            return;
        }
        try {
            if (newValue.startsWith("file:") || newValue.startsWith("platform:")) {
                this.setValue(URI.createURI((String)newValue));
            } else {
                this.setValue(URI.createFileURI((String)newValue));
            }
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public String getValueAsString() {
        if (this.value != null) {
            if (((URI)this.value).isFile()) {
                return ((URI)this.value).toFileString();
            }
            if ("platform".equals(((URI)this.value).scheme())) {
                URI uri = (URI)this.value;
                String decodedURI = URI.decode((String)uri.toString());
                if (this.mustExist) {
                    try {
                        URL javaNetURL = new URL(decodedURI);
                        javaNetURL = FileLocator.resolve((URL)javaNetURL);
                        return javaNetURL.getFile();
                    }
                    catch (Exception exception) {}
                } else {
                    String path = "platform:/resource";
                    int index = decodedURI.indexOf(path);
                    String wsPath = decodedURI.substring(index += path.length());
                    String wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                    String value = String.valueOf(wsRoot) + wsPath;
                    return value;
                }
            }
        }
        return "";
    }

    public boolean isMustExist() {
        return this.mustExist;
    }
}

