/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ITableCellProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.Vector;

public class PropertyChangeSupport {
    private final Vector propertyChangeListeners = new Vector();
    private final IPropertyDescriptor source;
    private final Vector vetoableChangeListeners = new Vector();

    public PropertyChangeSupport(IPropertyDescriptor sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void addVetoableChangeListener(IVetoableChangeListener listener) {
        this.vetoableChangeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent event) {
        Vector targets = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.propertyChangeListeners != null) {
                targets = (Vector)this.propertyChangeListeners.clone();
            }
        }
        if (targets != null) {
            int i = targets.size();
            while (--i >= 0) {
                IPropertyChangeListener target = (IPropertyChangeListener)targets.elementAt(i);
                target.propertyChange(event);
            }
        }
    }

    public void firePropertyEnabledChange(boolean enabled) {
        if (enabled) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 1));
        } else {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 2));
        }
    }

    public void firePropertyGroupAddChild(IPropertyDescriptor child) {
        if (this.source instanceof IPropertyGroup) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)child, 6));
        }
    }

    public void firePropertyGroupRemoveAll(IPropertyDescriptor[] oldChildren) {
        if (this.source instanceof IPropertyGroup) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, oldChildren, null, 9));
        }
    }

    public void firePropertyGroupRemoveChild(IPropertyDescriptor child) {
        if (this.source instanceof IPropertyGroup) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, child, null, 7));
        }
    }

    public void firePropertyGroupReplaceAll(IPropertyDescriptor[] oldChildren, IPropertyDescriptor[] newChildren) {
        if (this.source instanceof IPropertyGroup) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, oldChildren, (Object)newChildren, 8));
        }
    }

    public void firePropertyInValid() {
        if (this.source instanceof IProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 5));
        }
    }

    public void firePropertyValid() {
        if (this.source instanceof IProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 4));
        }
    }

    public void firePropertyValidValuesChanged() {
        if (this.source instanceof ISingleTypedProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 3));
        }
    }

    public void firePropertyValueChange(Object oldValue, Object newValue) {
        if (this.source instanceof ISingleTypedProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, oldValue, newValue, 0));
        }
    }

    public void fireVetoableChange(Object oldValue, Object newValue) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, oldValue, newValue, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        Vector targets = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.vetoableChangeListeners != null) {
                targets = (Vector)this.vetoableChangeListeners.clone();
            }
        }
        if (targets != null) {
            PropertyVetoException warningException = null;
            int i = targets.size();
            while (--i >= 0) {
                IVetoableChangeListener target = (IVetoableChangeListener)targets.elementAt(i);
                try {
                    target.vetoableChange(event);
                }
                catch (PropertyVetoException e) {
                    if (e.getErrorCode() == 0) {
                        throw e;
                    }
                    if (e.getErrorCode() != 1) continue;
                    warningException = e;
                }
            }
            if (warningException != null) {
                throw warningException;
            }
        }
    }

    public void fireTreePropertySelected() {
        if (this.source instanceof INodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, Boolean.TRUE, (Object)Boolean.FALSE, 10));
        }
    }

    public void fireTreePropertyDeselected() {
        if (this.source instanceof INodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, Boolean.FALSE, (Object)Boolean.TRUE, 11));
        }
    }

    public void fireTableRowAdd(ITableCellProperty[] row) {
        if (this.source instanceof ITableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, row, null, 12));
        }
    }

    public void fireTableRowRemove(ITableCellProperty[] row) {
        if (this.source instanceof ITableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)row, 13));
        }
    }

    public void fireTableRowMove(int to, int from) {
        if (this.source instanceof ITableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, new Integer(to), (Object)new Integer(from), 14));
        }
    }

    public void fireTableCleared() {
        if (this.source instanceof ITableProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 15));
        }
    }

    public void fireMultiValuePropertySelection(int[] oldSelection, int[] newSelection) {
        if (this.source instanceof IMultiValuedProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, oldSelection, (Object)newSelection, 16));
        }
    }

    public void fireTreeNodeHighlighted() {
        if (this.source instanceof INodeProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, (Object)null, (Object)null, 17));
        }
    }

    public synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public synchronized void removeVetoableChangeListener(IVetoableChangeListener listener) {
        this.vetoableChangeListeners.remove(listener);
    }
}

