/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.spi.BasePropertyDescriptor;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.SerializationUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BasePropertyGroup
extends BasePropertyDescriptor
implements IPropertyGroup {
    private ArrayList properties = new ArrayList();
    private Map propertyNames = new HashMap();
    protected Object[] context = null;

    public BasePropertyGroup(String groupName, String displayName, String groupDescription) throws CoreException {
        super(groupName, displayName, groupDescription);
        this.propertyFlag |= 0x4000;
    }

    public void addProperty(IPropertyDescriptor property) {
        if (!this.properties.contains(property) && !this.propertyNames.keySet().contains(property.getName())) {
            this.properties.add(property);
            this.propertyNames.put(property.getName(), property);
            property.setParent(this);
            this.propertyChanges.firePropertyGroupAddChild(property);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BasePropertyGroup clone = (BasePropertyGroup)super.clone();
        clone.properties = new ArrayList();
        clone.propertyNames = new HashMap();
        for (IPropertyDescriptor property : this.properties) {
            IPropertyDescriptor aProp = (IPropertyDescriptor)property.clone();
            aProp.setParent(clone);
            clone.addProperty(aProp);
        }
        return clone;
    }

    @Override
    public IPropertyDescriptor[] getProperties() {
        try {
            return Collections.unmodifiableList(this.properties).toArray(new IPropertyDescriptor[0]);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            return new IPropertyDescriptor[0];
        }
    }

    @Override
    public IPropertyDescriptor getProperty(IPath path) {
        String firstSegment = path.segment(0);
        IPropertyDescriptor descriptor = (IPropertyDescriptor)this.propertyNames.get(firstSegment);
        if (descriptor != null) {
            if (descriptor instanceof IPropertyGroup) {
                if (path.segmentCount() > 1) {
                    return ((IPropertyGroup)descriptor).getProperty(path.removeFirstSegments(1));
                }
                return descriptor;
            }
            return descriptor;
        }
        return null;
    }

    @Override
    public IPropertyDescriptor getProperty(String propertyName) {
        IPropertyDescriptor descriptor = (IPropertyDescriptor)this.propertyNames.get(propertyName);
        return descriptor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void remove(IPropertyDescriptor property) {
        if (property != null) {
            this.properties.remove(property);
            this.propertyNames.remove(property.getName());
            property.setParent(null);
            this.propertyChanges.firePropertyGroupRemoveChild(property);
        }
    }

    public void removeAll() {
        IPropertyDescriptor[] oldProperties = this.properties.toArray(new IPropertyDescriptor[0]);
        this.properties.clear();
        this.propertyNames.clear();
        int i = 0;
        while (i < oldProperties.length) {
            oldProperties[i].setParent(null);
            ++i;
        }
        this.propertyChanges.firePropertyGroupRemoveAll(oldProperties);
    }

    public void replaceAll(IPropertyDescriptor[] newProperties) {
        IPropertyDescriptor[] oldProperties = this.properties.toArray(new IPropertyDescriptor[0]);
        int i = 0;
        while (i < oldProperties.length) {
            oldProperties[i].setParent(null);
            ++i;
        }
        this.properties.clear();
        this.propertyNames.clear();
        int size = newProperties.length;
        int i2 = 0;
        while (i2 < size) {
            this.properties.add(newProperties[i2]);
            this.propertyNames.put(newProperties[i2].getName(), newProperties[i2]);
            newProperties[i2].setParent(this);
            ++i2;
        }
        this.propertyChanges.firePropertyGroupReplaceAll(oldProperties, newProperties);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (IPropertyDescriptor property : this.properties) {
            if (!(property instanceof BasePropertyDescriptor)) continue;
            ((BasePropertyDescriptor)property).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public String convertToString() {
        return SerializationUtility.getPropertyGroupAsString(this, null);
    }

    @Override
    public void populateFromString(String value) throws CoreException {
        SerializationUtility.populatePropertyGroupFromString(value, this);
    }

    @Override
    public Object[] getPropertyGroupContext() {
        return this.context;
    }

    @Override
    public void setPropertyGroupContext(Object[] context) {
        this.context = context;
    }
}

