/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.utilities;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.ui.api.IPropertyGroupUIExtension;
import com.ibm.propertygroup.ui.api.IPropertyUIExtension;
import com.ibm.propertygroup.ui.api.PropertyUIWidgetLabelAdapter;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyInputExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIExtensionRegistry;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIFactoryInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIFlatWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUINormalWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetCheckBox;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetComboBox;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetLabel;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetList;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetRadioButton;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTable;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetText;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetText_BrowseType;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetText_Select;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTree;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIHelpRegistry;
import com.ibm.propertygroup.ui.utilities.PropertyUINestedLayoutInfoWrapper;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Section;

public class PropertyUIFactory {
    private static PropertyUIFactory factory_;
    protected PropertyUIExtensionRegistry registry_;
    protected PropertyUINormalWidgetFactory normalUIFactory_;
    protected PropertyUIFlatWidgetFactory flatUIFactory_;
    public static final int NORMAL_STYLE = 0;
    public static final int FLAT_STYLE = 1;
    public static final int NESTEDGROUPSTYLE_GROUP = 0;
    public static final int NESTEDGROUPSTYLE_INDENT = 1;
    public static final int MAINCOMPOSITETYPE_COMPOSITE = 0;
    public static final int MAINCOMPOSITETYPE_GROUP = 1;
    public static final int MODIFICATIONTYPE_TIMER = 0;
    public static final int MODIFICATIONTYPE_FOCUS = 1;
    public static final String PROPERTYGROUP_SEPARATOR_WIDGET = "PropertyGroupSeparatorWidget";
    public static final String PROPERTYUI_NESTED_LAYOUT_WIDGET = "PropertyUINestedLayoutWidget";
    public static final int SHOWINGADVANCEDSTYLE_BUTTON = 0;
    public static final int SHOWINGADVANCEDSTYLE_EXPANDABLECOMPOSITE = 1;
    public static final int ROOTGROUPINGSTYLE_NONE = 0;
    public static final int ROOTGROUPINGSTYLE_ADVANCED_SECTION = 1;
    public static final int ROOTGROUPINGSTYLE_ALL_SECTION = 2;
    public static final int HELPCONTEXTTYPE_INDIVIDUAL = 0;
    public static final int HELPCONTEXTTYPE_SHARE = 1;
    public static final int BASECOLUMNNUMBER = 2;
    public static final int MAX_NO_OF_VALID_VALUE = 20;
    public static final int UI_WIDGET_TYPE_HIDDEN = -1;
    public static final int UI_WIDGET_TYPE_UNKNOWN = 0;
    public static final int UI_WIDGET_TYPE_TEXT = 1;
    public static final int UI_WIDGET_TYPE_COMBOBOX = 2;
    public static final int UI_WIDGET_TYPE_CHECKBOX = 3;
    public static final int UI_WIDGET_TYPE_LIST = 4;
    public static final int UI_WIDGET_TYPE_RADIOBUTTON = 5;
    public static final int UI_WIDGET_TYPE_LABEL = 6;
    public static final int UI_WIDGET_TYPE_TREE = 7;
    public static final int UI_WIDGET_TYPE_TABLE = 8;
    public static final int UI_WIDGET_TYPE_TEXT_CUSTOM = 9;
    public static final int UI_WIDGET_TYPE_TEXT_PROJECT = 10;
    public static final int UI_WIDGET_TYPE_TEXT_PACKAGE = 11;
    public static final int UI_WIDGET_TYPE_TEXT_FILE = 12;
    public static final int UI_WIDGET_TYPE_TEXT_FOLDER = 13;
    public static final int UI_WIDGET_TYPE_TEXT_SELECT = 14;
    public static final int UI_WIDGET_TYPE_TEXT_TYPEBROWSE = 15;
    public static final int UI_WIDGET_TYPE_TEXT_CUSTOM_MULTI = 16;
    protected PropertyUIFactoryInfo uiInfo_;
    protected int mainCompositeType_;
    protected int level_;
    protected PropertyUIComposite uiComposite_;

    public static PropertyUIFactory instance() {
        return PropertyUIFactory.instance(true);
    }

    public static PropertyUIFactory instance(boolean needInit) {
        if (factory_ == null) {
            factory_ = new PropertyUIFactory();
            factory_.doInit();
        }
        if (needInit) {
            factory_.initialize();
        }
        return factory_;
    }

    public static PropertyUIFactory newInstance(boolean needInit) {
        PropertyUIFactory factory = new PropertyUIFactory();
        factory.doInit();
        if (needInit || factory_ == null) {
            factory.initialize();
        } else {
            factory.setPropertyUIFactoryInfo(PropertyUIFactory.factory_.uiInfo_);
        }
        return factory;
    }

    public void doInit() {
        this.uiInfo_ = new PropertyUIFactoryInfo();
        this.registry_ = PropertyUIExtensionRegistry.instance();
    }

    public void initialize() {
        this.uiInfo_.showAll_ = false;
        this.uiInfo_.style_ = 0;
        this.uiInfo_.nestedGroupStyle_ = 1;
        this.uiInfo_.indent_ = 20;
        this.uiInfo_.modificationType_ = 0;
        this.uiInfo_.helpContextIdPrefix_ = null;
        this.uiInfo_.needSeparatorForProperty_ = true;
        this.uiInfo_.generateRadioButton_ = false;
        this.uiInfo_.shell_ = null;
        this.uiInfo_.showingAdvancedStyle_ = 0;
        this.uiInfo_.helpContextType_ = 0;
        this.uiInfo_.isOrderSensitiveTable = false;
        this.uiInfo_.genSeparatorForNoDNamePG_ = true;
        this.uiInfo_.rootGroupingStyle_ = 0;
        if (this.uiInfo_.nestedLayoutInfo_ == null) {
            this.uiInfo_.nestedLayoutInfo_ = new ArrayList();
        }
        this.uiInfo_.nestedLayoutInfo_.clear();
        this.mainCompositeType_ = 0;
        this.level_ = 0;
    }

    public IPropertyUIWidgetFactory getUIFactory() {
        if (this.uiInfo_.style_ == 1) {
            if (this.flatUIFactory_ == null) {
                this.flatUIFactory_ = new PropertyUIFlatWidgetFactory();
            }
            return this.flatUIFactory_;
        }
        if (this.normalUIFactory_ == null) {
            this.normalUIFactory_ = new PropertyUINormalWidgetFactory();
        }
        return this.normalUIFactory_;
    }

    public void dispose() {
        if (this.flatUIFactory_ != null) {
            this.flatUIFactory_.dispose();
            this.flatUIFactory_ = null;
        }
    }

    public void setStyle(int newStyle) {
        this.uiInfo_.style_ = newStyle;
    }

    public void setShowingAdvancedStyle(int newStyle) {
        this.uiInfo_.showingAdvancedStyle_ = newStyle;
    }

    public void setRootGroupingStyle(int newStyle) {
        this.uiInfo_.rootGroupingStyle_ = newStyle;
    }

    public void setNestedGroupStyle(int newStyle) {
        this.uiInfo_.nestedGroupStyle_ = newStyle;
    }

    public int getNestedGroupStyle() {
        return this.uiInfo_.nestedGroupStyle_;
    }

    public void setIndent(int newValue) {
        this.uiInfo_.indent_ = newValue;
    }

    public int getIndent() {
        return this.uiInfo_.indent_;
    }

    public void setMainCompositeType(int newType) {
        this.mainCompositeType_ = newType;
    }

    public void setModificationType(int newType) {
        this.uiInfo_.modificationType_ = newType;
    }

    public int getModificationType() {
        return this.uiInfo_.modificationType_;
    }

    public void isShowAll(boolean showAll) {
        this.uiInfo_.showAll_ = showAll;
    }

    public void setHelpContextIdPrefix(String newPrefix) {
        this.uiInfo_.helpContextIdPrefix_ = newPrefix;
    }

    public String getHelpContextIdPrefix() {
        return this.uiInfo_.helpContextIdPrefix_;
    }

    public void setHelpContextType(int newType) {
        this.uiInfo_.helpContextType_ = newType;
    }

    public int getHelpContextType() {
        return this.uiInfo_.helpContextType_;
    }

    public void setShell(Shell shell) {
        this.uiInfo_.shell_ = shell;
    }

    public Shell getShell() {
        return this.uiInfo_.shell_;
    }

    public int getNestedLevel() {
        return this.level_;
    }

    public void setNestedLevel(int newValue) {
        this.level_ = newValue;
    }

    public void needSeparatorForProperty(boolean need) {
        this.uiInfo_.needSeparatorForProperty_ = need;
    }

    public boolean needSeparatorForProperty() {
        return this.uiInfo_.needSeparatorForProperty_;
    }

    public void generateRadioButton(boolean gen) {
        this.uiInfo_.generateRadioButton_ = gen;
    }

    public boolean isOrderSensitiveTable() {
        return this.uiInfo_.isOrderSensitiveTable;
    }

    public void isOrderSensitiveTable(boolean sensitive) {
        this.uiInfo_.isOrderSensitiveTable = sensitive;
    }

    public boolean needSeparatorForNoDisplayNameProprtyGroup() {
        return this.uiInfo_.genSeparatorForNoDNamePG_;
    }

    public void needSeparatorForNoDisplayNameProprtyGroup(boolean sensitive) {
        this.uiInfo_.genSeparatorForNoDNamePG_ = sensitive;
    }

    void setPropertyUIFactoryInfo(PropertyUIFactoryInfo newInfo) {
        this.uiInfo_.copyData(newInfo);
    }

    public PropertyUIExtensionRegistry getExtensionRegistry() {
        return this.registry_;
    }

    public PropertyUIWidgetInfo getPropertyUIWidgetInfo() {
        return this.uiInfo_.widgetInfo_;
    }

    public void setPropertyUIWidgetLabelAdapter(PropertyUIWidgetLabelAdapter newAdapter) {
        this.uiInfo_.widgetInfo_.labelAdapter_ = newAdapter;
    }

    public void setPropertyUIWidgetDelayedTimer(int milliseconds) {
        this.uiInfo_.widgetInfo_.delayedTimer_ = milliseconds;
    }

    public void addNestedLayoutInfo(PropertyUINestedLayoutInfoWrapper wrapper) {
        if (this.uiInfo_.nestedLayoutInfo_ == null) {
            this.uiInfo_.nestedLayoutInfo_ = new ArrayList();
        }
        if (this.uiInfo_.nestedLayoutInfo_.indexOf(wrapper) == -1) {
            this.uiInfo_.nestedLayoutInfo_.add(wrapper);
        }
        if (this.uiComposite_ != null) {
            this.uiComposite_.addNestedLayoutInfo(wrapper);
        }
    }

    public ArrayList<PropertyUINestedLayoutInfoWrapper> getNestedLayoutInfo() {
        return this.uiInfo_.nestedLayoutInfo_;
    }

    public PropertyUIComposite generatePropertyUI(Composite parent, IPropertyGroup properties) {
        Group primary;
        PropertyUIComposite uiInfo;
        this.uiComposite_ = uiInfo = new PropertyUIComposite(properties);
        IPropertyUIWidgetFactory factory = this.getUIFactory();
        ArrayList<PropertyUIWidget> widgets = null;
        PropertyUIHelper helper = PropertyUIHelper.instance();
        int parentColumnNumber = 1;
        boolean isShowAll = this.uiInfo_.showAll_;
        Layout layout = parent.getLayout();
        if (layout != null && layout instanceof GridLayout) {
            parentColumnNumber = ((GridLayout)parent.getLayout()).numColumns;
        }
        Object main = this.mainCompositeType_ == 1 ? factory.createGroup(parent, 0) : factory.createComposite(parent, 0);
        boolean[] status = helper.checkExpertInPropertyGroup(properties, false);
        if (!status[0]) {
            isShowAll = true;
        }
        if (this.uiInfo_.showAll_) {
            primary = main;
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = this.calculateMaxRowLength(properties, 6, true, false);
            primary.setLayout((Layout)gridLayout);
            this.inheritLayoutData(null, (Composite)primary);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = parentColumnNumber;
            primary.setLayoutData((Object)gd);
        } else {
            main.setLayout((Layout)new GridLayout());
            this.inheritLayoutData(null, (Composite)main);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = parentColumnNumber;
            main.setLayoutData((Object)gd);
            primary = factory.createComposite((Composite)main, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 3;
            gridLayout.marginWidth = 3;
            gridLayout.numColumns = this.calculateMaxRowLength(properties, 2, true, false);
            primary.setLayout((Layout)gridLayout);
            this.inheritLayoutData(null, (Composite)primary);
            gd = isShowAll || PropertyUIHelper.instance().containsExpandableProperties(properties, this.uiInfo_.rootGroupingStyle_ != 2) ? new GridData(1808) : new GridData(768);
            primary.setLayoutData((Object)gd);
        }
        if (isShowAll) {
            widgets = this.generateWidgets((Composite)primary, null, properties, 6);
        } else {
            widgets = this.generateWidgets((Composite)primary, null, properties, 2);
            Control[] handlers = this.createShowingAdvancedPropertiesHandler(factory, (Composite)main);
            if (this.uiInfo_.showingAdvancedStyle_ == 0) {
                uiInfo.setAdvancedButton((Button)handlers[0]);
                uiInfo.setAdvancedButtonLabel((Label)handlers[1]);
            } else {
                uiInfo.setExpandableComposite((ExpandableComposite)handlers[0]);
            }
        }
        if (!this.uiInfo_.showAll_) {
            uiInfo.setPrimaryComposite((Composite)primary);
        }
        uiInfo.setPropertyUIFactory(this);
        uiInfo.setPropertyFactoryUIInfo(this.uiInfo_);
        uiInfo.needToUpdatePrimaryComposite(status[1]);
        uiInfo.setComposite((Composite)main);
        uiInfo.setUIWidgets(widgets);
        return uiInfo;
    }

    protected Composite createWidgetContainer(IPropertyGroup properties, Composite parent, boolean isSubGroup) {
        IPropertyUIWidgetFactory factory = this.getUIFactory();
        int maxRowLength = this.calculateMaxRowLength(properties, 6);
        Object composite = isSubGroup && this.uiInfo_.nestedGroupStyle_ == 0 ? factory.createGroup(parent, 0) : factory.createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = maxRowLength;
        composite.setLayout((Layout)gridLayout);
        this.inheritLayoutData(null, (Composite)composite);
        return composite;
    }

    public ArrayList<PropertyUIWidget> generateWidgets(Composite parent, IPropertyGroup properties, boolean isSubGroup, int style) {
        ArrayList<PropertyUIWidget> aList = new ArrayList<PropertyUIWidget>();
        IPropertyDescriptor[] propList = properties.getProperties();
        int colNo = ((GridLayout)parent.getLayout()).numColumns;
        boolean isPropertyGroup = false;
        int i = 0;
        while (i < propList.length) {
            block13: {
                String id;
                IPropertyDescriptor ipd;
                block12: {
                    ArrayList<PropertyUIWidget> subList;
                    int type;
                    IPropertyGroup bpg;
                    block15: {
                        block16: {
                            int no;
                            block14: {
                                ipd = propList[i];
                                id = ipd.getID();
                                if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) break block12;
                                bpg = (IPropertyGroup)ipd;
                                if (bpg.getProperties() == null || bpg.getProperties().length < 1 || PropertyUIHelper.instance().getNumberOfProperties(bpg, true, 0) < 1) break block13;
                                no = 0;
                                if ((style & 4) != 0) break block14;
                                if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) < 1) break block13;
                                type = 2;
                                break block15;
                            }
                            if ((style & 2) != 0) break block16;
                            if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) > 0) break block13;
                            type = 4;
                            break block15;
                        }
                        type = 6;
                    }
                    IPropertyGroupUIExtension ext = null;
                    if (id != null) {
                        ext = this.registry_.getPropertyGroupUIExtension(id);
                    }
                    ++this.level_;
                    if (ext == null) {
                        Composite subComp = this.createSubGroupContainer(bpg, parent);
                        GridLayout layout = (GridLayout)subComp.getLayout();
                        if (this.uiInfo_.nestedGroupStyle_ != 1) {
                            layout.numColumns = this.calculateMaxRowLength(bpg, type);
                        }
                        subList = this.generateWidgets(subComp, bpg, true, style);
                    } else {
                        subList = ext.generateWidgets(this, parent, bpg, true, style);
                    }
                    --this.level_;
                    int j = 0;
                    while (j < subList.size()) {
                        aList.add(subList.get(j));
                        ++j;
                    }
                    isPropertyGroup = true;
                    break block13;
                }
                if (this.isUISupportedProperty(ipd)) {
                    boolean isExpert = PropertyUtil.isExpert(ipd);
                    if (!((style & 2) == 0 && !isExpert || (style & 4) == 0 && isExpert)) {
                        PropertyUIWidget widget;
                        IPropertyUIExtension ext = null;
                        if (id != null) {
                            ext = this.registry_.getPropertyUIExtension(id);
                        }
                        if (isPropertyGroup && this.uiInfo_.needSeparatorForProperty_ && this.uiInfo_.nestedGroupStyle_ == 1) {
                            this.generatePropertyGroupSeparator(parent, colNo);
                        }
                        if ((widget = ext == null ? this.baseProperty2Widget(parent, ipd, colNo, isSubGroup) : ext.property2Widget(this, parent, ipd, colNo, isSubGroup)) != null) {
                            aList.add(widget);
                        }
                        isPropertyGroup = false;
                    }
                } else {
                    isPropertyGroup = false;
                }
            }
            ++i;
        }
        return aList;
    }

    ArrayList<PropertyUIWidget> generateWidgets(Composite primary, Composite advanced, IPropertyGroup properties, int style) {
        ArrayList<PropertyUIWidget> aList = new ArrayList<PropertyUIWidget>();
        IPropertyDescriptor[] propList = properties.getProperties();
        boolean isPropertyGroup = false;
        boolean peelPropertyGroup = this.needToPeelPropertyGroup(properties);
        Composite propertyGroupComposite = null;
        ExpandableComposite rootPropertiesContainer = null;
        ExpandableComposite expandArea = null;
        int numOfAdvancedPG = 0;
        int i = 0;
        while (i < propList.length) {
            block33: {
                String id;
                int colNo;
                Composite main;
                IPropertyDescriptor ipd;
                block35: {
                    ArrayList<PropertyUIWidget> subList;
                    int type;
                    IPropertyGroup bpg;
                    block37: {
                        int no;
                        block38: {
                            block36: {
                                block31: {
                                    PropertyUIWidget widget;
                                    block34: {
                                        block32: {
                                            ipd = propList[i];
                                            main = primary;
                                            if (main == null) {
                                                main = advanced;
                                            }
                                            colNo = ((GridLayout)main.getLayout()).numColumns;
                                            id = ipd.getID();
                                            if (!PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) break block31;
                                            if (!((ISingleTypedProperty)ipd).getPropertyType().isExpert()) break block32;
                                            if ((style & 4) == 0) break block33;
                                            if (advanced != null) {
                                                if (this.uiInfo_.rootGroupingStyle_ == 0) {
                                                    main = advanced;
                                                } else {
                                                    if (rootPropertiesContainer == null) {
                                                        expandArea = rootPropertiesContainer = this.createPropertyGroupSection(advanced, PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_ADVANCED_PROPERTIES, null, this.calculateMaxRowLength(properties, 4, true, true), false);
                                                        ++numOfAdvancedPG;
                                                    }
                                                    main = (Composite)rootPropertiesContainer.getClient();
                                                }
                                                colNo = ((GridLayout)main.getLayout()).numColumns;
                                            }
                                            break block34;
                                        }
                                        if ((style & 2) == 0 || primary == null) break block33;
                                    }
                                    IPropertyUIExtension ext = null;
                                    if (id != null) {
                                        ext = this.registry_.getPropertyUIExtension(id);
                                    }
                                    if (isPropertyGroup && this.uiInfo_.needSeparatorForProperty_ && this.uiInfo_.nestedGroupStyle_ == 1 && this.uiInfo_.rootGroupingStyle_ == 0) {
                                        if (main == propertyGroupComposite) {
                                            this.generatePropertyGroupSeparator(main, colNo);
                                            isPropertyGroup = false;
                                        }
                                    } else {
                                        isPropertyGroup = false;
                                    }
                                    if ((widget = ext == null ? this.baseProperty2Widget(main, ipd, colNo, false) : ext.property2Widget(this, main, ipd, colNo, false)) != null) {
                                        aList.add(widget);
                                    }
                                    break block33;
                                }
                                if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) break block35;
                                bpg = (IPropertyGroup)ipd;
                                if (bpg.getProperties() == null || bpg.getProperties().length < 1 || PropertyUIHelper.instance().getNumberOfProperties(bpg, true, 0) < 1) break block33;
                                no = 0;
                                if ((style & 4) != 0) break block36;
                                if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) < 1) break block33;
                                type = 2;
                                break block37;
                            }
                            if ((style & 2) != 0) break block38;
                            if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) > 0) break block33;
                            if (advanced != null) {
                                main = advanced;
                            }
                            type = 4;
                            break block37;
                        }
                        if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) < 1 && advanced != null) {
                            main = advanced;
                        }
                        type = 6;
                    }
                    ExpandableComposite eC = null;
                    if (main.equals(advanced) && this.uiInfo_.rootGroupingStyle_ != 0) {
                        eC = this.createPropertyGroupSection(main, bpg.getDisplayName(), bpg.getName(), this.calculateMaxRowLength(bpg, type), false);
                        main = (Composite)eC.getClient();
                        expandArea = eC;
                        ++numOfAdvancedPG;
                    } else if (main.equals(primary) && this.uiInfo_.rootGroupingStyle_ == 2) {
                        eC = this.createPropertyGroupSection(main, bpg.getDisplayName(), bpg.getName(), this.calculateMaxRowLength(bpg, type), true);
                        main = (Composite)eC.getClient();
                        expandArea = eC;
                    }
                    IPropertyGroupUIExtension ext = null;
                    if (id != null) {
                        ext = this.registry_.getPropertyGroupUIExtension(id);
                    }
                    ++this.level_;
                    if (ext == null) {
                        if (!peelPropertyGroup && eC == null) {
                            Composite subComp = this.createSubGroupContainer(bpg, main);
                            GridLayout layout = (GridLayout)subComp.getLayout();
                            if (this.uiInfo_.nestedGroupStyle_ != 1) {
                                layout.numColumns = this.calculateMaxRowLength(bpg, type);
                            }
                            subList = this.generateWidgets(subComp, bpg, true, style);
                        } else {
                            --this.level_;
                            subList = this.generateWidgets(main, bpg, true, style);
                            ++this.level_;
                        }
                    } else {
                        subList = ext.generateWidgets(this, main, bpg, true, style);
                    }
                    --this.level_;
                    aList.addAll(subList);
                    propertyGroupComposite = main;
                    isPropertyGroup = true;
                    break block33;
                }
                if (this.isUISupportedProperty(ipd)) {
                    boolean isExpert = PropertyUtil.isExpert(ipd);
                    if (!((style & 2) == 0 && !isExpert || (style & 4) == 0 && isExpert)) {
                        IPropertyUIExtension ext = null;
                        if (id != null) {
                            ext = this.registry_.getPropertyUIExtension(id);
                        }
                        if (isPropertyGroup && this.uiInfo_.needSeparatorForProperty_ && this.uiInfo_.nestedGroupStyle_ == 1 && main == propertyGroupComposite) {
                            this.generatePropertyGroupSeparator(main, colNo);
                        }
                        isPropertyGroup = false;
                        PropertyUIWidget widget = ext == null ? this.baseProperty2Widget(main, ipd, colNo, false) : ext.property2Widget(this, main, ipd, colNo, false);
                        if (widget != null) {
                            aList.add(widget);
                        }
                    }
                } else {
                    isPropertyGroup = false;
                }
            }
            ++i;
        }
        if (numOfAdvancedPG == 1 && expandArea != null) {
            expandArea.setExpanded(true);
        }
        return aList;
    }

    protected void changeWidgetLabelFont1(PropertyUIWidget widget) {
        Control[] controls = widget.getUIControls();
        if (controls != null && controls.length > 0) {
            int i = 0;
            while (i < controls.length) {
                if (controls[i] instanceof Label) {
                    Font font = controls[i].getFont();
                    FontData newFontData = font.getFontData()[0];
                    newFontData.setStyle(2);
                    break;
                }
                ++i;
            }
        }
    }

    public ExpandableComposite createPropertyGroupSection(Composite parent, String label, String pgName, int columnNum, boolean expanded) {
        ExpandableComposite ec = this.createExpandableArea(parent, label, 18, expanded);
        Composite comp = this.getUIFactory().createComposite((Composite)ec, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = columnNum;
        comp.setLayout((Layout)layout);
        this.inheritLayoutData(parent, comp);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setFont(parent.getFont());
        ec.setClient((Control)comp);
        if (pgName != null) {
            ec.setData((Object)pgName);
        }
        return ec;
    }

    protected ExpandableComposite createExpandableArea(Composite parent, String label, int expansionStyle, boolean expanded) {
        Section area = this.getUIFactory().createSection(parent, expansionStyle | 0x100);
        area.setText(label);
        if (expanded) {
            area.setExpanded(expanded);
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        area.setLayoutData((Object)gd);
        if (this.uiInfo_.style_ != 1) {
            area.setToggleColor(Display.getCurrent().getSystemColor(18));
            area.setTitleBarBorderColor(Display.getCurrent().getSystemColor(18));
        }
        area.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PropertyUIFactory.this.relayoutParents((Composite)((ExpandableComposite)e.getSource()));
            }
        });
        return area;
    }

    protected void relayoutParents(Composite comp) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        comp.layout();
        Composite parent = comp.getParent();
        if (parent != null) {
            if (parent instanceof PropertyUIScrollableComposite) {
                ((PropertyUIScrollableComposite)parent).reflow(true);
            } else if (parent instanceof ScrolledComposite) {
                Point p = comp.computeSize(-1, -1);
                comp.setSize(p.x, p.y);
                ((ScrolledComposite)parent).setMinSize(p);
                parent.layout();
            } else {
                this.relayoutParents(parent);
            }
        }
    }

    public Composite createSubGroupContainer(IPropertyGroup properties, Composite parent) {
        Composite subComp;
        int colNo = ((GridLayout)parent.getLayout()).numColumns;
        if (this.uiInfo_.nestedGroupStyle_ == 1) {
            IPropertyUIWidgetFactory uiFactory = this.getUIFactory();
            String displayName = properties.getDisplayName();
            if (displayName != null && displayName.length() > 0 || this.uiInfo_.genSeparatorForNoDNamePG_) {
                Composite composite = uiFactory.createComposite(parent, 0);
                GridLayout layout = new GridLayout();
                if (displayName != null && displayName.length() > 0) {
                    layout.numColumns = 2;
                }
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                composite.setLayout((Layout)layout);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                if (this.uiInfo_.indent_ * (this.level_ - 1) > 0) {
                    gd.horizontalIndent = this.uiInfo_.indent_ * (this.level_ - 1);
                }
                if (colNo <= 2) {
                    gd.grabExcessHorizontalSpace = true;
                }
                gd.horizontalSpan = colNo;
                composite.setLayoutData((Object)gd);
                composite.setData((Object)PROPERTYGROUP_SEPARATOR_WIDGET);
                if (displayName != null && displayName.length() > 0) {
                    uiFactory.createLabel(composite, properties.getDisplayName(), 0);
                }
                Label label = uiFactory.createSeparator(composite, 256);
                gd = new GridData(768);
                label.setLayoutData((Object)gd);
            }
            subComp = parent;
        } else {
            subComp = this.createWidgetContainer(properties, parent, true);
            GridData gd = new GridData(256);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = colNo;
            if (this.uiInfo_.nestedGroupStyle_ == 1 && this.uiInfo_.indent_ > 0) {
                gd.horizontalIndent = this.uiInfo_.indent_;
            } else if (this.uiInfo_.nestedGroupStyle_ == 0) {
                ((Group)subComp).setText(properties.getDisplayName());
            }
            subComp.setLayoutData((Object)gd);
            subComp.setData((Object)PROPERTYUI_NESTED_LAYOUT_WIDGET);
            GridLayout gl = (GridLayout)subComp.getLayout();
            gl.verticalSpacing = ((GridLayout)parent.getLayout()).verticalSpacing;
        }
        return subComp;
    }

    public PropertyUIWidget baseProperty2Widget(Composite parent, IPropertyDescriptor property, int colNo, boolean isSubGroup) {
        Object[] ret = this.createPropertyUIWidgetInstance(property, colNo);
        if (ret[1] == null) {
            return null;
        }
        PropertyUIWidget widget = (PropertyUIWidget)ret[1];
        widget.setListenerType(this.uiInfo_.modificationType_);
        if (this.uiInfo_.shell_ != null && !this.uiInfo_.shell_.isDisposed()) {
            widget.setShell(this.uiInfo_.shell_);
        } else {
            widget.setShell(parent.getShell());
        }
        if (this.uiInfo_.nestedGroupStyle_ == 1 && this.uiInfo_.indent_ > 0 && isSubGroup) {
            widget.setWidgetIndent(this.uiInfo_.indent_ * this.level_);
        }
        widget.createControl(parent);
        PropertyUIHelpRegistry.instance().addF1HelpToWidget(widget, property, this);
        return widget;
    }

    protected Object[] createPropertyUIWidgetInstance(IPropertyDescriptor property, int colNo) {
        int widgetType;
        Object[] ret = new Object[2];
        IPropertyType propertyType = null;
        if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)property)) {
            propertyType = ((ISingleTypedProperty)property).getPropertyType();
        }
        if ((widgetType = this.getPropertyUIWidgetType(property, propertyType)) == -1) {
            return ret;
        }
        IPropertyUIWidgetFactory factory = this.getUIFactory();
        PropertyUIWidget widget = null;
        switch (widgetType) {
            case 3: {
                widget = this.createPropertyUICheckBoxWidget(factory, property, colNo);
                break;
            }
            case 2: {
                widget = this.createPropertyUIComboBoxWidget(factory, property, colNo);
                break;
            }
            case 6: {
                widget = this.createPropertyUILabelWidget(factory, property, colNo);
                break;
            }
            case 4: {
                widget = this.createPropertyUIListWidget(factory, property, colNo);
                break;
            }
            case 5: {
                widget = this.createPropertyUIRadioButtonWidget(factory, property, colNo, propertyType.getValidValues().length, true);
                break;
            }
            case 8: {
                widget = this.createPropertyUITableWidget(factory, property, colNo, this.isOrderSensitiveTable());
                break;
            }
            case 1: {
                widget = this.createPropertyUITextWidget(factory, property, colNo, null, -1, null, -1);
                break;
            }
            case 9: {
                PropertyInputExtensionPointInfo extInfo = this.registry_.getPropertyInputExtension(property.getID());
                widget = this.createPropertyUITextWidget(factory, property, colNo, extInfo.getButtonLabel(), 0, null, -1);
                break;
            }
            case 16: {
                PropertyInputExtensionPointInfo extInfo = this.registry_.getPropertyInputExtension(property.getID());
                widget = this.createPropertyUITextWidget(factory, property, colNo, extInfo.getButtonLabel(0), 0, extInfo.getButtonLabel(1), 0);
                break;
            }
            case 12: {
                widget = this.createPropertyUITextWidget(factory, property, colNo, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_BROWSE, 1, null, -1);
                break;
            }
            case 13: {
                widget = this.createPropertyUITextWidget(factory, property, colNo, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_BROWSE, 2, null, -1);
                break;
            }
            case 11: {
                widget = this.createPropertyUITextWidget(factory, property, colNo, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_BROWSE, 4, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_NEW, 2);
                break;
            }
            case 10: {
                widget = this.createPropertyUITextWidget(factory, property, colNo, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_BROWSE, 3, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_NEW, 1);
                break;
            }
            case 14: {
                widget = this.createPropertyUITextWidget_Select(factory, property, colNo);
                break;
            }
            case 15: {
                widget = this.createPropertyUITextWidget_TypeBrowse(factory, property, colNo);
                break;
            }
            case 7: {
                widget = this.createPropertyUITreeWidget(factory, property, colNo);
            }
        }
        if (widget != null) {
            ret[0] = new Integer(widgetType);
            ret[1] = widget;
        }
        return ret;
    }

    public PropertyUIWidget createPropertyUILabelWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetLabel((IProperty)property, factory, colNo - 1, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUITextWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo, String label1, int type1, String label2, int type2) {
        PropertyUIWidgetText text = new PropertyUIWidgetText((IProperty)property, factory, colNo - 1, this.uiInfo_.widgetInfo_);
        if (label1 != null && label1.length() > 0) {
            text.setButtonLabel(label1);
        }
        if (type1 > 0) {
            text.setButtonType(type1);
        }
        if (label2 != null && label2.length() > 0) {
            text.setButton2Label(label2);
        }
        if (type2 > 0) {
            text.setButton2Type(type2);
        }
        return text;
    }

    public PropertyUIWidget createPropertyUITextWidget_Select(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetText_Select((IProperty)property, factory, colNo - 1, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUITextWidget_TypeBrowse(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetText_BrowseType((IProperty)property, factory, colNo - 1, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUICheckBoxWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetCheckBox((IProperty)property, factory, colNo, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUIRadioButtonWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo, int length, boolean isEqualWidth) {
        return new PropertyUIWidgetRadioButton((IProperty)property, factory, colNo, length, isEqualWidth, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUIComboBoxWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetComboBox((IProperty)property, factory, colNo - 1, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUIListWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetList((IProperty)property, factory, colNo, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUITreeWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo) {
        return new PropertyUIWidgetTree(property, factory, colNo, this.uiInfo_.widgetInfo_);
    }

    public PropertyUIWidget createPropertyUITableWidget(IPropertyUIWidgetFactory factory, IPropertyDescriptor property, int colNo, boolean moveable) {
        PropertyUIWidgetTable table = new PropertyUIWidgetTable(property, factory, colNo, this.uiInfo_.widgetInfo_);
        table.isRowMovable(moveable);
        return table;
    }

    ArrayList<PropertyUIWidget> generatePropertyDescriptorUI(Composite parent, IPropertyDescriptor property, int colNo, boolean isSubGroup, int style, boolean genSeparator) {
        ArrayList<PropertyUIWidget> aList = new ArrayList<PropertyUIWidget>();
        String id = property.getID();
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)property)) {
            ArrayList<PropertyUIWidget> subList;
            int type;
            IPropertyGroup bpg = (IPropertyGroup)property;
            if (bpg.getProperties() == null || bpg.getProperties().length < 1 || PropertyUIHelper.instance().getNumberOfProperties(bpg, true, 0) < 1) {
                return aList;
            }
            int no = 0;
            if ((style & 4) == 0) {
                if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) < 1) {
                    return aList;
                }
                type = 2;
            } else if ((style & 2) == 0) {
                if (PropertyUIHelper.instance().getNumberOfProperties(bpg, false, no) > 0) {
                    return aList;
                }
                type = 4;
            } else {
                type = 6;
            }
            IPropertyGroupUIExtension ext = null;
            if (id != null) {
                ext = this.registry_.getPropertyGroupUIExtension(id);
            }
            ++this.level_;
            if (ext == null) {
                Composite subComp = this.createSubGroupContainer(bpg, parent);
                GridLayout layout = (GridLayout)subComp.getLayout();
                if (this.uiInfo_.nestedGroupStyle_ != 1) {
                    layout.numColumns = this.calculateMaxRowLength(bpg, type);
                }
                subList = this.generateWidgets(subComp, bpg, true, style);
            } else {
                subList = ext.generateWidgets(this, parent, bpg, true, style);
            }
            --this.level_;
            int j = 0;
            while (j < subList.size()) {
                aList.add(subList.get(j));
                ++j;
            }
        } else if (this.isUISupportedProperty(property)) {
            boolean isExpert = PropertyUtil.isExpert(property);
            if (!((style & 2) == 0 && !isExpert || (style & 4) == 0 && isExpert)) {
                PropertyUIWidget widget;
                IPropertyUIExtension ext = null;
                if (id != null) {
                    ext = this.registry_.getPropertyUIExtension(id);
                }
                if (genSeparator && this.uiInfo_.needSeparatorForProperty_ && this.uiInfo_.nestedGroupStyle_ == 1) {
                    this.generatePropertyGroupSeparator(parent, colNo);
                }
                if ((widget = ext == null ? this.baseProperty2Widget(parent, property, colNo, isSubGroup) : ext.property2Widget(this, parent, property, colNo, isSubGroup)) != null) {
                    aList.add(widget);
                }
            }
        }
        return aList;
    }

    public int calculateMaxRowLength(IPropertyGroup properties, int type) {
        int maxLength = 0;
        IPropertyDescriptor[] children = properties.getProperties();
        int i = 0;
        while (i < children.length) {
            block2: {
                int curRowLength;
                block3: {
                    IPropertyDescriptor ipd;
                    block1: {
                        ipd = children[i];
                        curRowLength = 0;
                        if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) break block1;
                        if ((type & 2) == 0 && PropertyUIHelper.instance().getNumberOfProperties((IPropertyGroup)ipd, false, 0) > 0) break block2;
                        curRowLength = "com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(ipd.getID()) ? 1 : (this.uiInfo_.nestedGroupStyle_ == 1 ? this.calculateMaxRowLength((IPropertyGroup)ipd, type) : 1);
                        break block3;
                    }
                    curRowLength = this.calculateMaxRowLength(ipd, type);
                }
                maxLength = Math.max(maxLength, curRowLength);
            }
            ++i;
        }
        return maxLength;
    }

    public int calculateMaxRowLength(IPropertyDescriptor property, int type) {
        if (!this.isUISupportedProperty(property)) {
            return 0;
        }
        if (PropertyUtil.isHidden(property)) {
            return 0;
        }
        boolean isExpert = PropertyUtil.isExpert(property);
        if ((type & 4) == 0 && isExpert || (type & 2) == 0 && !isExpert) {
            return 0;
        }
        String id = property.getID();
        IPropertyUIExtension ext = null;
        if (id != null) {
            ext = this.registry_.getPropertyUIExtension(id);
        }
        if (ext == null) {
            int widgetType = this.getPropertyUIWidgetType(property, null);
            switch (widgetType) {
                case 1: 
                case 2: 
                case 6: {
                    return 2;
                }
                case 3: 
                case 5: 
                case 7: {
                    return 1;
                }
                case 4: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return 3;
                }
                case 10: 
                case 11: {
                    return 4;
                }
                case 16: {
                    PropertyInputExtensionPointInfo extInfo = this.registry_.getPropertyInputExtension(id);
                    return 2 + extInfo.getNumberOfContributor();
                }
            }
        } else {
            return ext.numberOfColumn(property);
        }
        return 0;
    }

    int calculateMaxRowLength(IPropertyGroup properties, int type, boolean checkNoNameGroup, boolean ignorePG) {
        int maxLength = 0;
        IPropertyDescriptor[] children = properties.getProperties();
        int i = 0;
        while (i < children.length) {
            block4: {
                int curRowLength;
                block3: {
                    IPropertyDescriptor ipd;
                    block2: {
                        ipd = children[i];
                        curRowLength = 0;
                        if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) break block2;
                        if (ignorePG) break block3;
                        if ((type & 2) != 0 || PropertyUIHelper.instance().getNumberOfProperties((IPropertyGroup)ipd, false, 0) <= 0) {
                            curRowLength = "com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(ipd.getID()) ? 1 : (this.uiInfo_.nestedGroupStyle_ == 1 ? (this.uiInfo_.rootGroupingStyle_ == 0 ? this.calculateMaxRowLength((IPropertyGroup)ipd, type) : (PropertyUtil.isAdvancedPropertyGroup((IPropertyGroup)ipd) || this.uiInfo_.rootGroupingStyle_ == 2 ? 1 : this.calculateMaxRowLength((IPropertyGroup)ipd, type))) : (checkNoNameGroup && this.needToPeelPropertyGroup(properties) ? this.calculateMaxRowLength((IPropertyGroup)ipd, type) : 1));
                        }
                        break block4;
                        break block3;
                    }
                    curRowLength = this.calculateMaxRowLength(ipd, type);
                }
                maxLength = Math.max(maxLength, curRowLength);
            }
            ++i;
        }
        return maxLength;
    }

    boolean needToPeelPropertyGroup(IPropertyGroup ipg) {
        if (ipg == null) {
            return false;
        }
        IPropertyDescriptor[] properties = ipg.getProperties();
        if (properties.length == 1 && PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[0])) {
            IPropertyGroup group = (IPropertyGroup)properties[0];
            String name = group.getName();
            String dName = group.getDisplayName();
            String desc = group.getDescription();
            if (!(name != null && name.length() >= 1 || dName != null && dName.length() >= 1 || desc != null && desc.length() >= 1)) {
                return true;
            }
        }
        return false;
    }

    public void generatePropertyGroupSeparator(Composite parent, int colNo) {
        Label label = this.getUIFactory().createSeparator(parent, 256);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        if (this.uiInfo_.indent_ * this.level_ > 0) {
            gd.horizontalIndent = this.uiInfo_.indent_ * this.level_;
        }
        if (colNo <= 2) {
            gd.grabExcessHorizontalSpace = true;
        }
        gd.horizontalSpan = colNo;
        label.setLayoutData((Object)gd);
        label.setData((Object)PROPERTYGROUP_SEPARATOR_WIDGET);
    }

    public boolean isUISupportedProperty(IPropertyDescriptor ipd) {
        if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd) || PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) || PropertyHelper.isTreeProperty((IPropertyDescriptor)ipd) || PropertyHelper.isTableProperty((IPropertyDescriptor)ipd)) {
            return true;
        }
        String id = ipd.getID();
        IPropertyUIExtension ext = this.registry_.getPropertyUIExtension(id);
        return ext != null;
    }

    Control[] createShowingAdvancedPropertiesHandler(IPropertyUIWidgetFactory factory, Composite parent) {
        if (this.uiInfo_.showingAdvancedStyle_ == 0) {
            Composite container = factory.createComposite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 2;
            container.setLayout((Layout)gridLayout);
            Button advancedButton = factory.createButton(container, new StringBuffer(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_ADVANCED).append(" ").append(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_SHOW).toString(), 8);
            Label label = factory.createLabel(container, PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_CANNOT_HIDE_PROPERTIES, 0);
            label.setVisible(false);
            return new Control[]{advancedButton, label};
        }
        ExpandableComposite eComposite = factory.createExpandableComposite(parent, 18);
        eComposite.setLayout((Layout)new GridLayout());
        eComposite.setLayoutData((Object)new GridData(768));
        this.inheritLayoutData(null, (Composite)eComposite);
        Label label = factory.createLabel((Composite)eComposite, PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_CANNOT_HIDE_PROPERTIES, 0);
        label.setVisible(false);
        label.setFont(parent.getFont());
        eComposite.setTextClient((Control)label);
        eComposite.setExpanded(false);
        eComposite.setText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_SHOW_ADVANCED);
        return new Control[]{eComposite};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getPropertyUIWidgetType(IPropertyDescriptor property, IPropertyType propertyType) {
        if (propertyType == null && PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)property)) {
            propertyType = ((ISingleTypedProperty)property).getPropertyType();
        }
        if (propertyType != null && propertyType.isHidden()) {
            return -1;
        }
        if (propertyType != null && propertyType.isReadOnly()) {
            return 6;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            String id = property.getID();
            PropertyInputExtensionPointInfo extInfo = null;
            if (id != null) {
                extInfo = this.registry_.getPropertyInputExtension(id);
            }
            if (extInfo == null) {
                if (PropertyHelper.isCustomProperty((IPropertyDescriptor)property)) {
                    ICustomProperty cProperty = (ICustomProperty)property;
                    if (CustomPropertyHelper.isJavaProjectProperty((ICustomProperty)cProperty)) {
                        return 10;
                    }
                    if (CustomPropertyHelper.isJavaPackageNameProperty((ICustomProperty)cProperty)) {
                        return 11;
                    }
                    if (CustomPropertyHelper.isJavaClassNameProperty((ICustomProperty)cProperty)) {
                        return 1;
                    }
                    if (CustomPropertyHelper.isSingleFileProperty((ICustomProperty)cProperty)) {
                        return 12;
                    }
                    if (CustomPropertyHelper.isSingleFolderProperty((ICustomProperty)cProperty)) {
                        return 13;
                    }
                    if (CustomPropertyHelper.isSingleJavaTypeProperty((ICustomProperty)cProperty)) {
                        return 15;
                    }
                    if (!CustomPropertyHelper.isSingleSchemaTypeProperty((ICustomProperty)cProperty)) return 0;
                    return 15;
                }
                if (propertyType.getType().getName().equalsIgnoreCase("java.lang.Boolean")) {
                    return 3;
                }
                Object[] values = propertyType.getValidValues();
                if (values == null || values.length < 1) {
                    return 1;
                }
                if (values.length == 2 && this.uiInfo_.generateRadioButton_) {
                    return 5;
                }
                if (values.length < 20) return 2;
                return 14;
            }
            if (extInfo.getNumberOfContributor() <= 1) return 9;
            return 16;
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            return 4;
        }
        if (PropertyHelper.isTreeProperty((IPropertyDescriptor)property)) {
            return 7;
        }
        if (!PropertyHelper.isTableProperty((IPropertyDescriptor)property)) return 0;
        return 8;
    }

    public PropertyUIComposite getPropertyUIComposite() {
        return this.uiComposite_;
    }

    protected void inheritLayoutData(Composite source, Composite target) {
        if (source == null) {
            source = target.getParent();
        }
        Layout layoutS = source.getLayout();
        Layout layoutT = target.getLayout();
        if (layoutS != null && layoutS instanceof GridLayout && layoutT != null && layoutT instanceof GridLayout) {
            ((GridLayout)layoutT).horizontalSpacing = ((GridLayout)layoutS).horizontalSpacing;
            ((GridLayout)layoutT).verticalSpacing = ((GridLayout)layoutS).verticalSpacing;
        }
    }
}

