/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.controls.NewPatternFilter;
import com.ibm.propertygroup.ui.internal.controls.ToolBarComposite;
import com.ibm.propertygroup.ui.internal.controls.ToolBarFilteredTreeViewer;
import com.ibm.propertygroup.ui.internal.controls.TreePropertyToolBarFilteredCheckboxTreeViewer;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIDecorator;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetDecorator;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIStatusChangedEvent;
import com.ibm.propertygroup.ui.plugin.PropertyUIPlugin;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.WorkbenchJob;

public class PropertyUIWidgetTree
extends PropertyUIWidgetProperty {
    public static int PROPERTIES_AREA_SHOWING_POSITION_RIGHT = 0;
    public static int PROPERTIES_AREA_SHOWING_POSITION_BOTTOM = 1;
    protected SashForm sashForm_;
    protected ToolBarFilteredTreeViewer filteredTree_;
    protected TreeViewer treeViewer_;
    protected ScrolledComposite propertiesArea_;
    protected Label noProperties_;
    protected Button selectAllButton_;
    protected Button deselectAllButton_;
    protected int ColumnNo_ = 1;
    protected int filterWidth_ = 0;
    protected int treeNodeCount_ = 0;
    protected TreeItem selectedItem_;
    protected PropertyUIComposite propertyUIComposite_;
    protected Map<INodeProperty, TreeNodeInfo> treeNodeInfo_ = new HashMap<INodeProperty, TreeNodeInfo>();
    protected PropertyUIChangeListenerImpl propertyUIChangeListener_;
    protected CheckTreeItemJob updateJob_ = null;
    protected Image treeNodeImage_;
    protected Image treeRootImage_ = this.treeNodeImage_ = PropertyUIPlugin.getImageDescriptor("icons/node.gif").createImage();
    protected PropertyUIDecorator decorator_ = new PropertyUIDecorator();
    protected Hashtable<String, Image> allocatedImages_ = new Hashtable();
    protected int propertiesShowingPosition_ = PROPERTIES_AREA_SHOWING_POSITION_RIGHT;
    protected PropertyUIFactory uiFactory_;

    public PropertyUIWidgetTree(IPropertyDescriptor property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetTree(IPropertyDescriptor property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetTree(IPropertyDescriptor property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.ColumnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        this.uiFactory_ = PropertyUIFactory.newInstance(false);
        this.uiFactory_.isShowAll(false);
        this.uiFactory_.setIndent(20);
        this.uiFactory_.setNestedLevel(0);
        this.uiFactory_.getNestedLayoutInfo().clear();
        this.uiFactory_.setModificationType(this.listenerType_);
        this.createContainers(parent);
        this.createTreeViewer((Composite)this.sashForm_.getChildren()[0]);
        this.createPropertyArea((Composite)((Composite)this.sashForm_.getChildren()[1]).getChildren()[0]);
        this.initTreeViewer();
        this.initSashForm();
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void createTitle(Composite parent) {
        String title = this.property_.getDisplayName().trim();
        if (title != null && title.length() > 0) {
            Control label = this.createWidgetLabel(parent);
            GridData gd = new GridData();
            if (this.widgetIndent_ > 0) {
                gd.horizontalIndent = this.widgetIndent_;
            }
            gd.horizontalSpan = this.ColumnNo_;
            label.setLayoutData((Object)gd);
        }
    }

    protected void createContainers(Composite parent) {
        int orientation = 256;
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM) {
            orientation = 512;
        }
        this.sashForm_ = this.factory_.createSashForm(parent, orientation);
        Composite treeComposite = this.factory_.createComposite((Composite)this.sashForm_, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM && ((ITreeProperty)this.property_).isSelectableTree()) {
            layout.numColumns = 2;
        }
        treeComposite.setLayout((Layout)layout);
        treeComposite.setLayoutData((Object)new GridData(1808));
        Composite comp = this.factory_.createComposite((Composite)this.sashForm_, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM && ((ITreeProperty)this.property_).isSelectableTree()) {
            layout.numColumns = 2;
        }
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        Group group = this.factory_.createGroup(comp, 0);
        group.setText(PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_PROPERTIES);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
    }

    protected void createTreeViewer(Composite treeComposite) {
        IContributionItem[] actions = this.createTreeViewerActions();
        ToolBarComposite composite = this.factory_.createToolBarComposite(treeComposite, this.factory_.getBorderStyle());
        composite.setLayoutData(new GridData(1808));
        this.filteredTree_ = ((ITreeProperty)this.property_).isSelectableTree() ? new TreePropertyToolBarFilteredCheckboxTreeViewer(composite, 0, new NewPatternFilter()) : new ToolBarFilteredTreeViewer(composite, 0, new NewPatternFilter());
        this.filteredTree_.setBackground(treeComposite.getDisplay().getSystemColor(25));
        this.treeViewer_ = this.filteredTree_.getViewer();
        GridData gd = new GridData(1808);
        this.treeViewer_.getTree().setLayoutData((Object)gd);
        composite.setControl((Control)this.filteredTree_);
        composite.addContributionItems(actions);
        if (((ITreeProperty)this.property_).isSelectableTree()) {
            this.filteredTree_.getRefreshJob().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    PropertyUIWidgetTree.this.performUpdateTreeItemStatus(PropertyUIWidgetTree.this.treeViewer_.getTree().getItems());
                }
            });
        }
        if (((ITreeProperty)this.property_).isSelectableTree()) {
            this.createSelectButtons(treeComposite);
        }
    }

    protected void performUpdateTreeItemStatus(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            INodeProperty node;
            Object data = items[i].getData();
            if (data instanceof INodeProperty && (node = (INodeProperty)data) != null && node.isSelected() != items[i].getChecked()) {
                items[i].setChecked(node.isSelected());
            }
            this.performUpdateTreeItemStatus(items[i].getItems());
            ++i;
        }
    }

    protected IContributionItem[] createTreeViewerActions() {
        Action filterAction = new Action("FilterAction", 2){

            public void run() {
                PropertyUIWidgetTree.this.performShowFilter((IAction)this);
            }
        };
        filterAction.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_TOOLBAR_ENABLE_FILTER_DESC);
        filterAction.setImageDescriptor(PropertyUIPlugin.getImageDescriptor("icons/filter_obj.gif"));
        return new IContributionItem[]{new ActionContributionItem((IAction)filterAction)};
    }

    protected void createSelectButtons(Composite parent) {
        Composite buttonArea = this.factory_.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        layout.horizontalSpacing = 1;
        buttonArea.setLayout((Layout)layout);
        this.selectAllButton_ = this.factory_.createButton(buttonArea, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_SELECT_ALL, 8);
        GridData gd1 = new GridData();
        gd1.horizontalAlignment = 4;
        this.selectAllButton_.setLayoutData((Object)gd1);
        this.selectAllButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyUIWidgetTree.this.performSelectAll(true);
                    }
                });
            }
        });
        this.deselectAllButton_ = this.factory_.createButton(buttonArea, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_DESELECT_ALL, 8);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        this.deselectAllButton_.setLayoutData((Object)gd2);
        this.deselectAllButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyUIWidgetTree.this.performSelectAll(false);
                    }
                });
            }
        });
        this.filterWidth_ = Math.max(this.selectAllButton_.computeSize((int)-1, (int)-1).x, this.deselectAllButton_.computeSize((int)-1, (int)-1).x);
        this.layoutButtonArea();
    }

    protected void layoutButtonArea() {
        Composite buttonArea = this.selectAllButton_.getParent();
        GridLayout layout = (GridLayout)buttonArea.getLayout();
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM) {
            layout.numColumns = 1;
            GridData gd = new GridData(1040);
            gd.verticalAlignment = 1;
            this.selectAllButton_.getParent().setLayoutData((Object)gd);
        } else {
            layout.numColumns = 2;
            GridData gd = new GridData();
            gd.horizontalAlignment = 3;
            buttonArea.setLayoutData((Object)gd);
            int width1 = this.selectAllButton_.computeSize((int)-1, (int)-1).x;
            int width2 = this.deselectAllButton_.computeSize((int)-1, (int)-1).x;
            if (width1 > width2) {
                ((GridData)this.deselectAllButton_.getLayoutData()).widthHint = width1;
            } else {
                ((GridData)this.selectAllButton_.getLayoutData()).widthHint = width2;
            }
        }
    }

    protected void createPropertyArea(Composite group) {
        this.propertiesArea_ = this.factory_.createScrolledComposite(group, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        this.propertiesArea_.setLayout((Layout)layout);
        this.propertiesArea_.setLayoutData((Object)new GridData(1808));
        this.noProperties_ = this.factory_.createLabel((Composite)this.propertiesArea_, "", 0);
        this.propertiesArea_.setContent((Control)this.noProperties_);
        this.propertiesArea_.setMinSize(this.noProperties_.computeSize(-1, -1));
        if (((ITreeProperty)this.property_).isSelectableTree()) {
            Button filler = this.factory_.createButton(group.getParent(), "", 8);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            filler.setLayoutData((Object)gd);
            filler.setVisible(false);
            if (this.filterWidth_ > 0) {
                gd.widthHint = this.filterWidth_;
            }
        }
    }

    protected void initSashForm() {
        this.sashForm_.setWeights(new int[]{31, 69});
        if (this.treeNodeInfo_.isEmpty()) {
            this.sashForm_.setMaximizedControl(this.sashForm_.getChildren()[0]);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        if (this.ColumnNo_ <= 2) {
            gridData.grabExcessHorizontalSpace = true;
        }
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = 160;
        gridData.minimumWidth = 200;
        if (this.ColumnNo_ > 1) {
            gridData.horizontalSpan = this.ColumnNo_;
        }
        if (this.widgetIndent_ > 0) {
            gridData.horizontalIndent = this.widgetIndent_;
        }
        this.sashForm_.setLayoutData((Object)gridData);
        this.sashForm_.layout(true);
    }

    protected void initTreeViewer() {
        this.treeViewer_.setContentProvider((IContentProvider)new TreeElementContentProvider());
        this.treeViewer_.setLabelProvider((IBaseLabelProvider)new TreeElementLabelProvider());
        if (((ITreeProperty)this.property_).isSelectableTree()) {
            ((CheckboxTreeViewer)this.treeViewer_).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    PropertyUIWidgetTree.this.performCheckTreeItem(event);
                }
            });
        }
        this.treeViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyUIWidgetTree.this.performSelectTreeItem(event);
                    }
                });
            }
        });
        this.buildTreeInfo((ITreeProperty)this.property_);
        this.treeViewer_.setInput((Object)this.property_);
        this.performUpdateTreeItemStatus(this.treeViewer_.getTree().getItems());
        this.addHoverManager((Control)this.treeViewer_.getTree(), this.property_.getDescription());
    }

    protected void performCheckTreeItem(CheckStateChangedEvent event) {
        INodeProperty node = (INodeProperty)event.getElement();
        if (!node.isEnabled()) {
            ((CheckboxTreeViewer)this.treeViewer_).setChecked((Object)node, !event.getChecked());
        } else {
            node.removePropertyChangeListener((IPropertyChangeListener)this);
            node.setSelected(event.getChecked());
            node.addPropertyChangeListener((IPropertyChangeListener)this);
            boolean itemStatus = event.getChecked();
            boolean nodeStatus = node.isSelected();
            if (itemStatus == nodeStatus) {
                if (itemStatus) {
                    this.eventSender_.firePropertyUIChange(null, null, 5);
                } else {
                    this.eventSender_.firePropertyUIChange(null, null, 6);
                }
            } else {
                ((CheckboxTreeViewer)this.treeViewer_).setChecked((Object)node, nodeStatus);
            }
        }
    }

    protected void performSelectTreeItem(SelectionChangedEvent event) {
        TreeItem[] selectedItems = this.treeViewer_.getTree().getSelection();
        final TreeItem selected = selectedItems.length == 1 ? selectedItems[0] : null;
        this.status_ = 0;
        this.errorMessage_ = null;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (selected != null) {
                    if (!selected.equals(PropertyUIWidgetTree.this.selectedItem_)) {
                        INodeProperty node = (INodeProperty)selected.getData();
                        node.setHighLighted();
                        TreeNodeInfo info = PropertyUIWidgetTree.this.treeNodeInfo_.get(node);
                        IPropertyGroup pg = null;
                        if (info != null) {
                            pg = info.getPropertyGroup();
                        }
                        PropertyUIWidgetTree.this.displayProperties(pg, PropertyUIWidgetTree.this.selectedItem_, selected);
                        PropertyUIWidgetTree.this.treeViewer_.expandToLevel((Object)node, 1);
                    }
                } else {
                    PropertyUIWidgetTree.this.displayProperties(null, PropertyUIWidgetTree.this.selectedItem_, selected);
                }
                PropertyUIWidgetTree.this.selectedItem_ = selected;
            }
        });
    }

    @Override
    public void initDefaultValue() {
    }

    @Override
    public String getWidgetValue() {
        return null;
    }

    @Override
    public void setWidgetValue(String newValue) {
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.propertyUIComposite_ != null && this.propertyUIComposite_.getUIWidgets() != null) {
            ArrayList<PropertyUIWidget> widgets = this.propertyUIComposite_.getUIWidgets();
            int i = 0;
            while (i < widgets.size()) {
                PropertyUIWidget widget = widgets.get(i);
                if (enabled) {
                    widget.setEnabled(widget.getProperty().isEnabled());
                } else {
                    widget.setEnabled(enabled);
                }
                ++i;
            }
        }
    }

    public void setColumnNo(int newValue) {
        this.ColumnNo_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        return new Control[]{this.sashForm_, this.treeViewer_.getControl()};
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer_;
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.treeViewer_.getTree();
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber != this.ColumnNo_) {
            this.ColumnNo_ = newNumber;
            GridData gd = (GridData)this.sashForm_.getLayoutData();
            gd.horizontalSpan = this.ColumnNo_;
            if (this.ColumnNo_ > 2) {
                gd.grabExcessHorizontalSpace = false;
            }
        }
    }

    @Override
    public int getStatus() {
        ErrorInfo errorInfo;
        if (!this.isEnabled()) {
            return 0;
        }
        if (this.status_ == 4) {
            return this.status_;
        }
        INodeProperty root = ((ITreeProperty)this.property_).getRoot();
        if (root != null && (errorInfo = this.getErrorInfoWithPath(root)) != null && this.status_ < errorInfo.status_) {
            this.status_ = errorInfo.status_;
            this.errorMessage_ = errorInfo.message_;
        }
        return this.status_;
    }

    public void setTreeNodeImage(Image newImage) {
        if (newImage != null && !newImage.isDisposed()) {
            this.disposeImage(Integer.toHexString(this.hashCode()));
            this.treeNodeImage_ = newImage;
            this.treeViewer_.refresh();
        }
    }

    public void setTreeRootImage(Image newImage) {
        if (newImage != null && !newImage.isDisposed()) {
            this.disposeImage(Integer.toHexString(((ITreeProperty)this.property_).getRoot().hashCode()));
            this.treeRootImage_ = newImage;
            this.treeViewer_.refresh();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.treeNodeImage_ != null && !this.treeNodeImage_.isDisposed()) {
            this.treeNodeImage_.dispose();
        }
        if (this.treeRootImage_ != null && !this.treeRootImage_.isDisposed()) {
            this.treeRootImage_.dispose();
        }
        Enumeration<Image> ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
        if (this.decorator_ != null) {
            this.decorator_.dispose();
        }
        if (this.treeNodeInfo_ != null) {
            for (TreeNodeInfo info : this.treeNodeInfo_.values()) {
                if (info == null) continue;
                info.dispose();
            }
        }
        this.removePropertyChangeListener(((ITreeProperty)this.property_).getRoot());
        if (this.propertyUIComposite_ != null) {
            this.propertyUIComposite_.dispose();
        }
        if (this.uiFactory_ != null) {
            this.uiFactory_.dispose();
        }
    }

    protected void removePropertyChangeListener(INodeProperty node) {
        if (node != null) {
            node.removePropertyChangeListener((IPropertyChangeListener)this);
            INodeProperty[] nodes = node.getChildren();
            if (nodes != null) {
                int i = 0;
                while (i < nodes.length) {
                    this.removePropertyChangeListener(nodes[i]);
                    ++i;
                }
            }
        }
    }

    protected void disposeImage(String id) {
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 1;
        nArray[3] = 2;
        int[] keys = nArray;
        int i = 0;
        while (i < keys.length) {
            String key = new StringBuffer(id).append("__").append(keys[i]).toString();
            Image image = this.allocatedImages_.get(key);
            if (image != null) {
                if (!image.isDisposed()) {
                    image.dispose();
                }
                this.allocatedImages_.remove(key);
            }
            ++i;
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage_;
    }

    public void setPropertiesShowingPosition(int position) {
        this.propertiesShowingPosition_ = position;
        if (position == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM) {
            this.sashForm_.setOrientation(512);
            Control[] children = this.sashForm_.getChildren();
            GridLayout layout = (GridLayout)((Composite)children[0]).getLayout();
            layout.numColumns = 2;
            layout = (GridLayout)((Composite)children[1]).getLayout();
            layout.numColumns = 2;
        } else {
            this.sashForm_.setOrientation(256);
            Control[] children = this.sashForm_.getChildren();
            GridLayout layout = (GridLayout)((Composite)children[0]).getLayout();
            layout.numColumns = 1;
            layout = (GridLayout)((Composite)children[1]).getLayout();
            layout.numColumns = 1;
        }
        this.layoutButtonArea();
    }

    public void setSashFormWeights(int[] weights) {
        this.sashForm_.setWeights(weights);
    }

    protected void buildTreeInfo(ITreeProperty treeProperty) {
        INodeProperty root = treeProperty.getRoot();
        if (root != null) {
            this.buildTreeNodeInfo(root);
        }
    }

    protected TreeNodeInfo buildTreeNodeInfo(INodeProperty node) {
        TreeNodeInfo info = null;
        IPropertyGroup pg = node.createConfigurationProperties();
        if (pg != null) {
            ErrorInfo errorInfo;
            node.applyConfigurationProperties(pg);
            info = new TreeNodeInfo(node);
            this.treeNodeInfo_.put(node, info);
            info.errorInfo_ = errorInfo = new ErrorInfo(0, null);
            errorInfo.message_ = this.checkRequiredForPropertyGroup(pg);
            if (errorInfo.message_ != null) {
                errorInfo.status_ = 4;
            }
            info.setPropertGroup(pg);
        }
        node.addPropertyChangeListener((IPropertyChangeListener)this);
        INodeProperty[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.buildTreeNodeInfo(children[i]);
                ++i;
            }
        }
        return info;
    }

    protected String checkRequiredForPropertyGroup(IPropertyGroup pg) {
        if (pg == null) {
            return null;
        }
        IPropertyDescriptor[] properties = pg.getProperties();
        PropertyUIHelper helper = PropertyUIHelper.instance();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                String msg = this.checkRequiredForPropertyGroup((IPropertyGroup)properties[i]);
                if (msg != null) {
                    return msg;
                }
            } else if (PropertyUtil.isRequired(properties[i]) && !helper.validateRequiredProperty(properties[i])) {
                StringBuffer err = new StringBuffer(this.getDisplayString(this.getWidgetLabel(properties[i], false)));
                err.append(" ");
                err.append(PropertyUIMessages.ERROR_WIZARDS_VALUE_CANNOT_BE_EMPTY);
                return err.toString();
            }
            ++i;
        }
        return null;
    }

    protected void displayProperties(final IPropertyGroup properties, final TreeItem oldItem, final TreeItem newItem) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (PropertyUIWidgetTree.this.propertyUIComposite_ != null) {
                    PropertyUIWidgetTree.this.propertyUIComposite_.dispose();
                    PropertyUIWidgetTree.this.propertyUIComposite_ = null;
                    PropertyUIWidgetTree.this.propertiesArea_.setContent(null);
                }
                if (properties == null) {
                    Control control = PropertyUIWidgetTree.this.propertiesArea_.getContent();
                    if (control != null && !control.equals(PropertyUIWidgetTree.this.noProperties_)) {
                        control.dispose();
                    }
                    PropertyUIWidgetTree.this.propertiesArea_.setContent((Control)PropertyUIWidgetTree.this.noProperties_);
                    PropertyUIWidgetTree.this.propertiesArea_.setMinSize(PropertyUIWidgetTree.this.noProperties_.computeSize(-1, -1));
                } else {
                    PropertyUIWidgetTree.this.propertyUIComposite_ = PropertyUIWidgetTree.this.uiFactory_.generatePropertyUI((Composite)PropertyUIWidgetTree.this.propertiesArea_, properties);
                    if (PropertyUIWidgetTree.this.propertyUIChangeListener_ == null) {
                        PropertyUIWidgetTree.this.propertyUIChangeListener_ = new PropertyUIChangeListenerImpl();
                    }
                    PropertyUIWidgetTree.this.propertyUIChangeListener_.setTreeNode((INodeProperty)newItem.getData());
                    PropertyUIWidgetTree.this.propertyUIComposite_.addPropertyUIChangeListener(PropertyUIWidgetTree.this.propertyUIChangeListener_);
                    Composite main = PropertyUIWidgetTree.this.propertyUIComposite_.getComposite();
                    PropertyUIWidgetTree.this.propertiesArea_.setContent((Control)main);
                    Point p = main.computeSize(-1, -1);
                    main.setSize(p.x, p.y);
                    PropertyUIWidgetTree.this.propertiesArea_.setMinSize(p);
                }
                PropertyUIWidgetTree.this.updateStatus(oldItem, newItem);
            }
        });
    }

    protected void updateStatus(TreeItem oldItem, TreeItem newItem) {
        TreeNodeInfo newInfo;
        TreeNodeInfo oldInfo;
        if (oldItem == null && newItem == null) {
            return;
        }
        boolean previousS = true;
        boolean currentS = true;
        int severity = 0;
        String message = null;
        if (oldItem != null && !oldItem.isDisposed() && (oldInfo = this.treeNodeInfo_.get((INodeProperty)oldItem.getData())) != null) {
            int status = oldInfo.errorInfo_.status_;
            if (status == 4) {
                this.updateTreeItemsIcon(oldItem, oldInfo);
            }
            if (status != 0) {
                previousS = false;
            }
        }
        if (newItem != null && !newItem.isDisposed() && (newInfo = this.treeNodeInfo_.get((INodeProperty)newItem.getData())) != null && newInfo.errorInfo_.status_ != 0) {
            severity = newInfo.errorInfo_.status_;
            message = newInfo.errorInfo_.message_;
            currentS = false;
        }
        this.errorMessage_ = message;
        this.status_ = severity;
        if (!currentS || currentS != previousS) {
            if (severity == 0) {
                this.sendPropertyUIStatusChangedEvent(null);
            } else {
                this.sendPropertyUIStatusChangedEvent((IStatus)new Status(severity, "com.ibm.property.ui", severity, message, null));
            }
        }
    }

    protected void updateTreeItemsIcon(TreeItem item, TreeNodeInfo nodeInfo) {
        if (item != null) {
            IPropertyGroup pg = nodeInfo.getPropertyGroup();
            String msg = this.checkRequiredForPropertyGroup(pg);
            if (msg != null) {
                nodeInfo.errorInfo_.message_ = msg;
            } else {
                if (nodeInfo.warning_ == null || nodeInfo.warning_.isEmpty()) {
                    nodeInfo.errorInfo_.message_ = null;
                    nodeInfo.errorInfo_.status_ = 0;
                } else {
                    nodeInfo.errorInfo_.status_ = 2;
                    nodeInfo.errorInfo_.message_ = this.getFirstWarningMessage(nodeInfo.warning_);
                }
                this.updateTreeItemsIcon(item);
            }
        }
    }

    protected String getFirstWarningMessage(Map<IPropertyDescriptor, WarningInfo> warning) {
        String retMessage = null;
        ArrayList<IPropertyDescriptor> removing = new ArrayList<IPropertyDescriptor>(3);
        for (IPropertyDescriptor ipd : warning.keySet()) {
            WarningInfo info = warning.get(ipd);
            if (info != null) {
                Object pValue = PropertyUtil.getValue(ipd);
                if (pValue != null && !pValue.equals(info.value_) || info.value_ != null && !info.value_.equals(pValue)) {
                    removing.add(ipd);
                    continue;
                }
                retMessage = info.message_;
                break;
            }
            removing.add(ipd);
        }
        int i = 0;
        while (i < removing.size()) {
            warning.remove(removing.get(i));
            ++i;
        }
        return retMessage;
    }

    protected void updateTreeItemsIcon(TreeItem item) {
        TreeItem parentItem = item;
        while (parentItem != null) {
            this.treeViewer_.update(parentItem.getData(), new String[]{"org.eclipse.jface.image"});
            parentItem = parentItem.getParentItem();
        }
    }

    protected void updateTreeItemsIcon(INodeProperty node) {
        INodeProperty parentNode = node;
        while (parentNode != null && parentNode instanceof INodeProperty) {
            this.treeViewer_.update((Object)parentNode, new String[]{"org.eclipse.jface.image"});
            parentNode = parentNode.getParent();
        }
    }

    protected void setStatus(PropertyUIChangeEvent evt, int status, String errorMessage) {
        this.status_ = status;
        this.errorMessage_ = errorMessage;
        this.eventSender_.firePropertyUIChange(evt.getOldValue(), evt.getNewValue());
    }

    protected void checkWidgetsStatus(ArrayList<PropertyUIWidget> widgets, ErrorInfo info) {
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget w = widgets.get(i);
            int s = w.getStatus();
            if (s == 4) {
                info.status_ = s;
                info.message_ = w.getErrorMessage();
                break;
            }
            if (s != 0 && info.status_ == 0) {
                info.status_ = s;
                info.message_ = w.getErrorMessage();
            }
            ++i;
        }
    }

    protected void performShowFilter(IAction action) {
        boolean checked = action.isChecked();
        this.filteredTree_.showFilterTextField(checked);
        if (checked) {
            action.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_TOOLBAR_DISABLE_FILTER_DESC);
        } else {
            action.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_TOOLBAR_ENABLE_FILTER_DESC);
        }
    }

    protected void performSelectAll(boolean selected) {
        if (this.filteredTree_.isFiltered()) {
            ArrayList<TreeItem> items = this.getSelectableTreeItem();
            int i = 0;
            while (i < items.size()) {
                TreeItem item = items.get(i);
                INodeProperty node = (INodeProperty)item.getData();
                if (node != null && node.isSelected() != selected) {
                    node.removePropertyChangeListener((IPropertyChangeListener)this);
                    node.setSelected(selected);
                    node.addPropertyChangeListener((IPropertyChangeListener)this);
                    if (selected == node.isSelected()) {
                        item.setChecked(selected);
                    }
                }
                ++i;
            }
        } else {
            this.selectAllNodes(((ITreeProperty)this.property_).getRoot(), selected, true);
        }
        if (selected) {
            this.eventSender_.firePropertyUIChange(null, null, 7);
        } else {
            this.eventSender_.firePropertyUIChange(null, null, 8);
        }
    }

    protected ArrayList<TreeItem> getSelectableTreeItem() {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] items = this.treeViewer_.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            list.add(items[i]);
            ArrayList<TreeItem> subList = this.getChildCount(items[i]);
            if (!subList.isEmpty()) {
                list.addAll(subList);
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(items[0].getData());
        if (this.treeViewer_.getSelection() != null && !this.treeViewer_.getSelection().isEmpty()) {
            selection = this.treeViewer_.getSelection();
        }
        this.treeViewer_.setSelection((ISelection)selection, true);
        return list;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.disposed_) {
            return;
        }
        Object prop = evt.getSource();
        if (prop instanceof INodeProperty) {
            if (evt.getPropertyChangeType() == 10) {
                this.checkTreeItem((INodeProperty)prop, true);
            } else if (evt.getPropertyChangeType() == 11) {
                this.checkTreeItem((INodeProperty)prop, false);
            } else {
                this.treeViewer_.update(prop, null);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    protected void checkTreeItem(INodeProperty node, boolean checked) {
        if (this.updateJob_ == null) {
            this.updateJob_ = new CheckTreeItemJob("Update Tree Item");
            this.updateJob_.setSystem(true);
        } else {
            this.updateJob_.cancel();
        }
        this.updateJob_.checkTreeItem(node, new Boolean(checked));
        this.updateJob_.schedule(100L);
    }

    protected ArrayList<TreeItem> getChildCount(TreeItem item) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            list.add(children[i]);
            ArrayList<TreeItem> subList = this.getChildCount(children[i]);
            if (!subList.isEmpty()) {
                list.addAll(subList);
            }
            ++i;
        }
        return list;
    }

    protected void selectAllNodes(INodeProperty node, boolean selected, boolean updateAllItems) {
        node.removePropertyChangeListener((IPropertyChangeListener)this);
        node.setSelected(selected);
        node.addPropertyChangeListener((IPropertyChangeListener)this);
        INodeProperty[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.selectAllNodes(children[i], selected, false);
                ++i;
            }
        }
        if (updateAllItems) {
            this.performUpdateTreeItemStatus(this.treeViewer_.getTree().getItems());
        }
    }

    protected ErrorInfo getErrorInfoWithPath(INodeProperty node) {
        INodeProperty[] children;
        ErrorInfo retInfo = null;
        TreeNodeInfo info = this.treeNodeInfo_.get(node);
        if (info != null) {
            ErrorInfo errorInfo = info.errorInfo_;
            retInfo = errorInfo.status_ != 4 && !node.isValid() && node.getValidationMessage() != null ? new ErrorInfo(4, node.getValidationMessage()) : new ErrorInfo(errorInfo.status_, errorInfo.message_);
            if (retInfo.status_ != 0) {
                StringBuffer msg = new StringBuffer(retInfo.message_);
                msg.insert(0, "/");
                msg.insert(0, this.getPath(node));
                retInfo.message_ = msg.toString();
            }
            if (retInfo.status_ == 4) {
                return retInfo;
            }
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                ErrorInfo subInfo = this.getErrorInfoWithPath(children[i]);
                if (retInfo == null) {
                    retInfo = subInfo;
                } else if (subInfo != null && retInfo.status_ < subInfo.status_) {
                    retInfo = subInfo;
                }
                if (retInfo != null && retInfo.status_ == 4) {
                    return retInfo;
                }
                ++i;
            }
        }
        return retInfo;
    }

    protected ErrorInfo getErrorInfo(INodeProperty node) {
        INodeProperty[] children;
        TreeNodeInfo info = this.treeNodeInfo_.get(node);
        ErrorInfo errorInfo = null;
        if (info != null) {
            errorInfo = info.errorInfo_;
            if (errorInfo.status_ == 4) {
                return errorInfo;
            }
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                ErrorInfo subInfo = this.getErrorInfo(children[i]);
                if (errorInfo == null) {
                    errorInfo = subInfo;
                } else if (subInfo != null && errorInfo.status_ < subInfo.status_) {
                    errorInfo = subInfo;
                }
                if (errorInfo != null && errorInfo.status_ == 4) {
                    return errorInfo;
                }
                ++i;
            }
        }
        return errorInfo;
    }

    protected String getPath(INodeProperty node) {
        StringBuffer path = new StringBuffer(node.getDisplayName());
        IPropertyDescriptor parent = node.getParent();
        if (parent != null && parent instanceof INodeProperty) {
            path.insert(0, "/");
            path.insert(0, this.getPath((INodeProperty)parent));
        }
        return path.toString();
    }

    @Override
    public void decorateUIWidget(Image image, int position, String hoverHelp, Runnable action) {
        if (((PropertyUIWidgetProperty)this).decorator_ == null) {
            ((PropertyUIWidgetProperty)this).decorator_ = new PropertyUIWidgetDecorator((Control)this.sashForm_, (Control)this.treeViewer_.getTree());
        }
        ((PropertyUIWidgetProperty)this).decorator_.setOffset(1, 1);
        ((PropertyUIWidgetProperty)this).decorator_.decorateUIWidget(image, position, hoverHelp, true, action);
    }

    protected class CheckTreeItemJob
    extends WorkbenchJob {
        protected Hashtable<INodeProperty, Boolean> itemMap_;

        public CheckTreeItemJob(String name) {
            super(name);
            this.itemMap_ = new Hashtable();
        }

        public void checkTreeItem(INodeProperty node, Boolean value) {
            this.itemMap_.put(node, value);
        }

        public IStatus runInUIThread(final IProgressMonitor monitor) {
            if (PropertyUIWidgetTree.this.treeViewer_.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            final IStatus[] status = new IStatus[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    status[0] = CheckTreeItemJob.this.performCheckTreeItem(monitor, ((CheckTreeItemJob)CheckTreeItemJob.this).PropertyUIWidgetTree.this.treeViewer_.getTree().getItems());
                }
            });
            return status[0];
        }

        protected IStatus performCheckTreeItem(IProgressMonitor monitor, TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                Object data = items[i].getData();
                if (data != null) {
                    Boolean value = this.itemMap_.get(data);
                    if (value != null) {
                        items[i].setChecked(value.booleanValue());
                        this.itemMap_.remove(data);
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IStatus status = this.performCheckTreeItem(monitor, items[i].getItems());
                    if (!status.isOK()) {
                        return status;
                    }
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }

    protected class ErrorInfo {
        protected String message_;
        protected int status_;

        public ErrorInfo(int status, String message) {
            this.message_ = message;
            this.status_ = status;
        }

        public void reset() {
            this.message_ = null;
            this.status_ = 0;
        }
    }

    protected class PropertyUIChangeListenerImpl
    implements IPropertyUIChangeListener,
    IPropertyUIStatusChangedListener {
        protected TreeNodeInfo nodeInfo_;

        public void setTreeNode(INodeProperty node) {
            this.nodeInfo_ = PropertyUIWidgetTree.this.treeNodeInfo_.get(node);
        }

        @Override
        public void propertyUIChange(PropertyUIChangeEvent evt) {
            if (evt.getSource() instanceof PropertyUIWidget) {
                Map<IPropertyDescriptor, WarningInfo> unSolvedPropertyValues = this.nodeInfo_.warning_;
                PropertyUIWidget widget = (PropertyUIWidget)evt.getSource();
                IPropertyDescriptor ipd = widget.getProperty();
                int oldStatus = this.nodeInfo_.errorInfo_.status_;
                int status = widget.getStatus();
                String errMsg = null;
                if (status != 0) {
                    errMsg = widget.getErrorMessage();
                }
                this.nodeInfo_.errorInfo_.status_ = status;
                this.nodeInfo_.errorInfo_.message_ = errMsg;
                if (unSolvedPropertyValues == null) {
                    if (status != 0 && status != 4 && errMsg != null && errMsg.length() > 0) {
                        unSolvedPropertyValues = new HashMap<IPropertyDescriptor, WarningInfo>();
                        WarningInfo warningInfo = new WarningInfo(PropertyUtil.getValue(ipd), errMsg);
                        unSolvedPropertyValues.put(ipd, warningInfo);
                        this.nodeInfo_.warning_ = unSolvedPropertyValues;
                    }
                } else {
                    WarningInfo warningInfo = unSolvedPropertyValues.get(ipd);
                    if (warningInfo == null) {
                        if (status != 0 && status != 4 && errMsg != null && errMsg.length() > 0) {
                            warningInfo = new WarningInfo(PropertyUtil.getValue(ipd), errMsg);
                            unSolvedPropertyValues.put(ipd, warningInfo);
                        }
                    } else if (status != 0 && status != 4) {
                        warningInfo.value_ = PropertyUtil.getValue(ipd);
                        warningInfo.message_ = errMsg;
                    } else if (status != 4) {
                        unSolvedPropertyValues.remove(ipd);
                    }
                }
                if (status == 0 && this.nodeInfo_.warning_ != null && !this.nodeInfo_.warning_.isEmpty()) {
                    this.nodeInfo_.errorInfo_.message_ = errMsg = PropertyUIWidgetTree.this.getFirstWarningMessage(this.nodeInfo_.warning_);
                    if (this.nodeInfo_.errorInfo_.message_ != null) {
                        status = 2;
                        this.nodeInfo_.errorInfo_.status_ = 2;
                    } else {
                        status = 0;
                        this.nodeInfo_.errorInfo_.status_ = 0;
                    }
                }
                if (status != 4) {
                    PropertyUIWidgetTree.this.checkWidgetsStatus(PropertyUIWidgetTree.this.propertyUIComposite_.getUIWidgets(), this.nodeInfo_.errorInfo_);
                    status = this.nodeInfo_.errorInfo_.status_;
                    errMsg = this.nodeInfo_.errorInfo_.message_;
                }
                if (status != oldStatus) {
                    PropertyUIWidgetTree.this.updateTreeItemsIcon(PropertyUIWidgetTree.this.selectedItem_);
                }
                PropertyUIWidgetTree.this.setStatus(evt, status, errMsg);
            }
        }

        @Override
        public void propertyUIStatusChanged(PropertyUIStatusChangedEvent evt) {
            IStatus status = evt.getStatus();
            PropertyUIWidgetTree.this.sendPropertyUIStatusChangedEvent(status);
        }
    }

    protected class TreeElementContentProvider
    implements ITreeContentProvider {
        protected TreeElementContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ITreeProperty tree;
            INodeProperty node;
            if (parentElement instanceof ArrayList) {
                return ((ArrayList)parentElement).toArray();
            }
            if (parentElement instanceof INodeProperty) {
                Object[] nodes = ((INodeProperty)parentElement).getChildren();
                if (nodes != null) {
                    return nodes;
                }
            } else if (parentElement instanceof ITreeProperty && (node = (tree = (ITreeProperty)parentElement).getRoot()) != null) {
                if (tree.showRoot()) {
                    return new Object[]{node};
                }
                Object[] nodes = node.getChildren();
                if (nodes != null) {
                    return nodes;
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class TreeElementLabelProvider
    extends LabelProvider {
        protected TreeElementLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof INodeProperty) {
                return this.getImage((INodeProperty)element);
            }
            return null;
        }

        public Image getImage(INodeProperty node) {
            boolean isRoot;
            int status = 0;
            ErrorInfo errorInfo = PropertyUIWidgetTree.this.getErrorInfo(node);
            if (errorInfo != null) {
                status = PropertyUIWidgetTree.this.getErrorInfo((INodeProperty)node).status_;
            }
            StringBuffer key = (isRoot = node.equals(((ITreeProperty)PropertyUIWidgetTree.this.property_).getRoot())) ? new StringBuffer(Integer.toHexString(node.hashCode())) : new StringBuffer(Integer.toHexString(((Object)((Object)this)).hashCode()));
            key.append("__");
            key.append(status);
            Image im = PropertyUIWidgetTree.this.allocatedImages_.get(key.toString());
            if (im != null) {
                return im;
            }
            im = isRoot ? PropertyUIWidgetTree.this.decorator_.decorateImage(PropertyUIWidgetTree.this.treeRootImage_, new Integer(status)) : PropertyUIWidgetTree.this.decorator_.decorateImage(PropertyUIWidgetTree.this.treeNodeImage_, new Integer(status));
            PropertyUIWidgetTree.this.allocatedImages_.put(key.toString(), im);
            return im;
        }

        public String getText(Object element) {
            if (element instanceof INodeProperty) {
                return ((INodeProperty)element).getDisplayName();
            }
            return "";
        }
    }

    protected class TreeNodeInfo
    implements IPropertyChangeListener {
        protected ErrorInfo errorInfo_;
        protected INodeProperty node_;
        protected Map<IPropertyDescriptor, WarningInfo> warning_;
        protected IPropertyGroup propertygroup_;

        public TreeNodeInfo(INodeProperty node) {
            this.node_ = node;
        }

        public void propertyChange(final PropertyChangeEvent evt) {
            if (evt.getPropertyChangeType() == 0) {
                if (Display.getCurrent() != null) {
                    this.handlePropertyValueChange(evt);
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeNodeInfo.this.handlePropertyValueChange(evt);
                        }
                    });
                }
            }
        }

        protected void handlePropertyValueChange(PropertyChangeEvent evt) {
            int oldStatus = this.errorInfo_.status_;
            String msg = PropertyUIWidgetTree.this.checkRequiredForPropertyGroup(this.propertygroup_);
            if (msg != null) {
                this.errorInfo_.message_ = msg;
                this.errorInfo_.status_ = 4;
            } else if (this.warning_ != null) {
                msg = PropertyUIWidgetTree.this.getFirstWarningMessage(this.warning_);
                if (msg != null) {
                    this.errorInfo_.status_ = 2;
                }
            } else {
                this.errorInfo_.reset();
            }
            if (oldStatus != this.errorInfo_.status_) {
                PropertyUIWidgetTree.this.updateTreeItemsIcon(this.node_);
            }
        }

        public void addPropertyChangeListener(IPropertyGroup pg) {
            IPropertyDescriptor[] properties = pg.getProperties();
            int i = 0;
            while (i < properties.length) {
                if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                    this.addPropertyChangeListener((IPropertyGroup)properties[i]);
                } else {
                    properties[i].addPropertyChangeListener((IPropertyChangeListener)this);
                }
                ++i;
            }
        }

        public void removePropertyChangeListener(IPropertyGroup pg) {
            IPropertyDescriptor[] properties = pg.getProperties();
            int i = 0;
            while (i < properties.length) {
                if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                    this.removePropertyChangeListener((IPropertyGroup)properties[i]);
                } else {
                    properties[i].removePropertyChangeListener((IPropertyChangeListener)this);
                }
                ++i;
            }
        }

        public void dispose() {
            if (this.propertygroup_ != null) {
                this.removePropertyChangeListener(this.propertygroup_);
            }
        }

        public void setPropertGroup(IPropertyGroup pg) {
            if (this.propertygroup_ != null) {
                this.removePropertyChangeListener(this.propertygroup_);
            }
            this.propertygroup_ = pg;
            if (pg != null) {
                this.addPropertyChangeListener(this.propertygroup_);
            }
        }

        public IPropertyGroup getPropertyGroup() {
            return this.propertygroup_;
        }
    }

    protected class WarningInfo {
        protected String message_;
        protected Object value_;

        public WarningInfo(Object value, String message) {
            this.message_ = message;
            this.value_ = value;
        }
    }
}

