/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ITableCellProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.spi.common.JavaTypeProperty;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyInputExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIExtensionRegistry;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import com.ibm.propertygroup.ui.internal.wizards.TablePropertyInputWizard;
import com.ibm.propertygroup.ui.plugin.PropertyUIPlugin;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PropertyUIWidgetTable
extends PropertyUIWidgetProperty {
    protected Image CHECK_IMAGE = PropertyUIPlugin.getImageDescriptor("icons/checked.gif").createImage();
    protected Image UNCHECK_IMAGE = PropertyUIPlugin.getImageDescriptor("icons/unchecked.gif").createImage();
    protected Image ERROR_IMAGE = PropertyUIPlugin.getImageDescriptor("icons/error.gif").createImage();
    protected Image WARNING_IMAGE = PropertyUIPlugin.getImageDescriptor("icons/warning.gif").createImage();
    protected Image UP_IMAGE = PropertyUIPlugin.getImageDescriptor("icons/up_obj.gif").createImage();
    protected Image DOWN_IMAGE = PropertyUIPlugin.getImageDescriptor("icons/down_obj.gif").createImage();
    protected PropertyUITableViewer tableViewer_;
    protected Button addButton_;
    protected Button removeButton_;
    protected Button editButton_;
    protected Button upButton_;
    protected Button downButton_;
    protected Control label_;
    protected Button filler1_;
    protected int ColumnNo_ = 1;
    protected boolean wrappedByComposite_ = false;
    protected Map<IPropertyDescriptor, ErrorInfo> unSolvedValues_;
    protected EditingPropertyInfo editingPropertyInfo_ = new EditingPropertyInfo();
    protected boolean isRowMovable_ = false;

    public PropertyUIWidgetTable(IPropertyDescriptor property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetTable(IPropertyDescriptor property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetTable(IPropertyDescriptor property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.ColumnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        GridData viewerGD;
        Composite container;
        this.label_ = this.createTableLabel(parent);
        if (this.wrappedByComposite_) {
            container = this.factory_.createComposite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 1;
            layout.marginHeight = 1;
            container.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            if (this.ColumnNo_ <= 2) {
                gridData.grabExcessHorizontalSpace = true;
            }
            gridData.grabExcessVerticalSpace = true;
            if (this.ColumnNo_ > 1) {
                gridData.horizontalSpan = this.ColumnNo_;
            }
            if (this.widgetIndent_ > 0) {
                gridData.horizontalIndent = this.widgetIndent_;
            }
            container.setLayoutData((Object)gridData);
            container.setData("com.ibm.propertygroup.ui.inner_composite", (Object)"PropertyUIWidgetTable");
            viewerGD = new GridData(1808);
            viewerGD.verticalSpan = 4;
            viewerGD.widthHint = 200;
        } else {
            container = parent;
            viewerGD = new GridData(768);
            viewerGD.verticalSpan = 4;
            viewerGD.horizontalSpan = 2;
            viewerGD.widthHint = 200;
            viewerGD.verticalAlignment = 4;
            viewerGD.grabExcessVerticalSpace = true;
            if (this.widgetIndent_ > 0) {
                viewerGD.horizontalIndent = this.widgetIndent_;
            }
        }
        this.tableViewer_ = this.createTableViewer(container);
        this.tableViewer_.getTable().setLayoutData((Object)viewerGD);
        this.createTableInput(this.tableViewer_);
        this.addButton_ = this.createButton(container, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_ADD_MORE, null);
        this.addButton_.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_ADD_NEW_ROW);
        this.addButton_.addListener(13, (Listener)this);
        if (!this.wrappedByComposite_ && this.ColumnNo_ - 2 - 1 > 0) {
            this.addFillers(container, this.ColumnNo_ - 2 - 1, 4);
        }
        this.editButton_ = this.createButton(container, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_EDIT_MORE, null);
        this.editButton_.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_EDIT_SELECTED_ROW);
        this.editButton_.addListener(13, (Listener)this);
        this.editButton_.setEnabled(false);
        this.removeButton_ = this.createButton(container, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_REMOVE, null);
        this.removeButton_.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_REMOVE_SELECTED_ROW);
        this.removeButton_.addListener(13, (Listener)this);
        this.removeButton_.setEnabled(false);
        if (this.isRowMovable_) {
            Composite composite = this.factory_.createComposite(container, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(4);
            gd.verticalAlignment = 3;
            composite.setLayoutData((Object)gd);
            composite.setData("com.ibm.propertygroup.ui.inner_composite", (Object)"PropertyUIWidgetTable_MovingArea");
            this.upButton_ = this.createImageButton(composite, this.UP_IMAGE, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_UP, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_UP);
            this.upButton_.addListener(13, (Listener)this);
            this.upButton_.setEnabled(false);
            this.downButton_ = this.createImageButton(composite, this.DOWN_IMAGE, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_DOWN, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_DOWN);
            this.downButton_.addListener(13, (Listener)this);
            this.downButton_.setEnabled(false);
        } else {
            this.filler1_ = this.factory_.createButton(container, "", 8);
            this.filler1_.setLayoutData((Object)new GridData(4));
            this.filler1_.setVisible(false);
        }
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.CHECK_IMAGE.dispose();
        this.UNCHECK_IMAGE.dispose();
        this.ERROR_IMAGE.dispose();
        this.WARNING_IMAGE.dispose();
        this.UP_IMAGE.dispose();
        this.DOWN_IMAGE.dispose();
    }

    @Override
    public void initDefaultValue() {
    }

    @Override
    public String getWidgetValue() {
        return null;
    }

    @Override
    public void setWidgetValue(String newValue) {
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
                break;
            }
            default: {
                this.tableViewer_.refresh();
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.updateButtonsState();
        }
    }

    public void setColumnNo(int newValue) {
        this.ColumnNo_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        if (this.isRowMovable_) {
            if (this.filler_ == null) {
                return new Control[]{this.label_, this.tableViewer_.getTable(), this.addButton_, this.editButton_, this.removeButton_, this.upButton_, this.downButton_};
            }
            return new Control[]{this.label_, this.tableViewer_.getTable(), this.addButton_, this.editButton_, this.removeButton_, this.upButton_, this.downButton_, this.filler_};
        }
        if (this.filler_ == null) {
            return new Control[]{this.label_, this.tableViewer_.getTable(), this.addButton_, this.editButton_, this.removeButton_, this.filler1_};
        }
        return new Control[]{this.label_, this.tableViewer_.getTable(), this.addButton_, this.editButton_, this.removeButton_, this.filler1_, this.filler_};
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.tableViewer_.getTable();
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber != this.ColumnNo_) {
            this.ColumnNo_ = newNumber;
            if (this.wrappedByComposite_) {
                GridData gd = (GridData)this.tableViewer_.getTable().getParent().getLayoutData();
                gd.horizontalSpan = this.ColumnNo_;
                if (this.ColumnNo_ > 2) {
                    gd.grabExcessHorizontalSpace = false;
                }
            } else {
                GridData gd = (GridData)this.label_.getLayoutData();
                gd.horizontalSpan = this.ColumnNo_;
                if (this.ColumnNo_ - 2 - 1 > 0) {
                    if (this.filler_ != null) {
                        gd = (GridData)this.filler_.getLayoutData();
                        gd.horizontalSpan = this.ColumnNo_ - 2 - 1;
                    } else {
                        if (this.isRowMovable_) {
                            this.addFillers(this.tableViewer_.getTable().getParent(), this.ColumnNo_ - 2 - 1, 3);
                        } else {
                            this.addFillers(this.tableViewer_.getTable().getParent(), this.ColumnNo_ - 2 - 1, 2);
                        }
                        this.filler_.moveBelow((Control)this.addButton_);
                    }
                } else if (this.filler_ != null) {
                    this.filler_.dispose();
                    this.filler_ = null;
                }
            }
        }
    }

    public void wrappedByComposite(boolean wrapped) {
        this.wrappedByComposite_ = wrapped;
    }

    public void isRowMovable(boolean moveable) {
        this.isRowMovable_ = moveable;
    }

    public Table getTable() {
        return this.tableViewer_.getTable();
    }

    public void updateButtonsState() {
        Table table = this.tableViewer_.getTable();
        int count = table.getSelectionCount();
        this.removeButton_.setEnabled(count > 0);
        this.editButton_.setEnabled(count == 1);
        if (this.isRowMovable_) {
            int index = table.getSelectionIndex();
            this.upButton_.setEnabled(count == 1 && index > 0);
            this.downButton_.setEnabled(count == 1 && index != table.getItemCount() - 1);
        }
    }

    @Override
    public void handleEvent(final Event event) {
        this.property_.removePropertyChangeListener((IPropertyChangeListener)this);
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.widget == PropertyUIWidgetTable.this.addButton_) {
                    PropertyUIWidgetTable.this.handleAddButton();
                } else if (event.widget == PropertyUIWidgetTable.this.removeButton_) {
                    PropertyUIWidgetTable.this.handleRemoveButton();
                } else if (event.widget == PropertyUIWidgetTable.this.editButton_) {
                    PropertyUIWidgetTable.this.handleEditButton();
                } else if (event.widget.equals(PropertyUIWidgetTable.this.upButton_)) {
                    PropertyUIWidgetTable.this.handleUpButton();
                } else if (event.widget.equals(PropertyUIWidgetTable.this.downButton_)) {
                    PropertyUIWidgetTable.this.handleDownButton();
                }
            }
        });
        this.property_.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void handleAddButton() {
        TableItem[] items = this.tableViewer_.getTable().getSelection();
        ISingleValuedProperty[] properties = null;
        int index = ((ITableProperty)this.property_).rowCount();
        try {
            if (items == null || items.length < 1) {
                properties = ((ITableProperty)this.property_).createNewRow();
            } else {
                index = this.tableViewer_.getTable().getSelectionIndex();
                properties = ((ITableProperty)this.property_).createNewRow(index);
            }
            if (properties != null && properties.length > 0) {
                if (this.editingPropertyInfo_ != null) {
                    this.editingPropertyInfo_.reset();
                }
                if (this.showInputWizard(properties, 1) == 0) {
                    this.tableViewer_.refresh();
                    this.tableViewer_.getTable().setFocus();
                    Object data = this.tableViewer_.getTable().getItem(index).getData();
                    this.tableViewer_.setSelection((ISelection)new StructuredSelection(data), true);
                } else {
                    ((ITableProperty)this.property_).deleteRow(index);
                }
            }
        }
        catch (CoreException ce) {
            String errMsg = ce.getMessage();
            if (errMsg == null) {
                errMsg = ce.toString();
            }
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDisplayString(this.getWidgetLabel(false)), (String)errMsg);
            this.eventSender_.firePropertyUIChange(null, new Integer(index), 1);
        }
    }

    protected void handleRemoveButton() {
        Table table = this.tableViewer_.getTable();
        TableItem[] items = table.getSelection();
        if (items.length > 0) {
            this.eventSender_.firePropertyUIComplexChanged(2, 0);
        }
        int i = 0;
        while (i < items.length) {
            block6: {
                int index = table.indexOf(items[i]);
                try {
                    if (index == -1) break block6;
                    table.remove(index);
                    ITableCellProperty[] properties = ((ITableProperty)this.property_).getRowProperties(index);
                    ((ITableProperty)this.property_).deleteRow(index);
                    this.status_ = 0;
                    this.errorMessage_ = null;
                    this.eventSender_.firePropertyUIChange(new Integer(index), properties, 2);
                }
                catch (CoreException ce) {
                    String errMsg = ce.getMessage();
                    if (errMsg == null) {
                        errMsg = ce.toString();
                    }
                    MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDisplayString(this.getWidgetLabel(false)), (String)errMsg);
                    if (index == -1) break;
                    this.eventSender_.firePropertyUIChange(new Integer(index), null, 2);
                    break;
                }
            }
            ++i;
        }
        if (items.length > 0) {
            this.eventSender_.firePropertyUIComplexChanged(2, 1);
        }
        this.tableViewer_.setSelection(null);
        this.tableViewer_.refresh();
        this.tableViewer_.getTable().setFocus();
    }

    protected void handleEditButton() {
        Object selection = this.tableViewer_.getTable().getSelection()[0].getData();
        if (this.editingPropertyInfo_ != null) {
            this.editingPropertyInfo_.reset();
        }
        if (this.showInputWizard((ISingleValuedProperty[])selection, 0) != 1) {
            this.tableViewer_.refresh(selection);
            this.tableViewer_.getTable().setFocus();
        }
    }

    protected void handleUpButton() {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        try {
            ((ITableProperty)this.property_).moveRow(index - 1, index);
            this.tableViewer_.refresh();
            this.tableViewer_.getTable().setFocus();
            this.updateButtonsState();
            this.eventSender_.firePropertyUIChange(new Integer(index), new Integer(index - 1), 3);
        }
        catch (CoreException ce) {
            String errMsg = ce.getMessage();
            if (errMsg == null) {
                errMsg = ce.toString();
            }
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDisplayString(this.getWidgetLabel(false)), (String)errMsg);
            this.eventSender_.firePropertyUIChange(new Integer(index), new Integer(index - 1), 3);
        }
    }

    protected void handleDownButton() {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        try {
            ((ITableProperty)this.property_).moveRow(index + 1, index);
            this.tableViewer_.refresh();
            this.tableViewer_.getTable().setFocus();
            this.updateButtonsState();
            this.eventSender_.firePropertyUIChange(new Integer(index), new Integer(index + 1), 4);
        }
        catch (CoreException ce) {
            String errMsg = ce.getMessage();
            if (errMsg == null) {
                errMsg = ce.toString();
            }
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDisplayString(this.getWidgetLabel(false)), (String)errMsg);
            this.eventSender_.firePropertyUIChange(new Integer(index), new Integer(index + 1), 4);
        }
    }

    protected String addWidgetLabelPrefix(String error) {
        StringBuffer err = new StringBuffer(this.getDisplayString(this.getWidgetLabel(false)));
        err.append(" ").append(error);
        return err.toString();
    }

    @Override
    public int getStatus() {
        if (!this.isEnabled()) {
            return 0;
        }
        if (this.status_ == 4) {
            return this.status_;
        }
        if (!((ITableProperty)this.property_).isValid() && ((ITableProperty)this.property_).getValidationMessage() != null) {
            return 4;
        }
        if (this.unSolvedValues_ != null && !this.unSolvedValues_.isEmpty() && this.status_ == 0) {
            this.errorMessage_ = this.getFirstErrorMessage();
            if (this.errorMessage_ != null) {
                this.status_ = 2;
            }
        }
        try {
            ITableProperty tableProperty = (ITableProperty)this.property_;
            int rowCount = tableProperty.rowCount();
            ITableProperty.ColumnDescriptor[] columns = ((ITableProperty)this.property_).getColumns();
            PropertyUIHelper helper = PropertyUIHelper.instance();
            int i = 0;
            while (i < rowCount) {
                ITableCellProperty[] properties = tableProperty.getRowProperties(i);
                int j = 0;
                while (j < properties.length) {
                    if (properties[j].getPropertyType().isRequired()) {
                        ITableCellProperty ipd = properties[j];
                        if (properties[j].equals(this.editingPropertyInfo_.property_) && this.editingPropertyInfo_.copy_ != null) {
                            ipd = this.editingPropertyInfo_.copy_;
                        }
                        if (!helper.validateRequiredProperty((IPropertyDescriptor)ipd)) {
                            this.errorMessage_ = this.getErrorMessageWithLocation(columns[j], i + 1, PropertyUIMessages.ERROR_WIZARDS_VALUE_CANNOT_BE_EMPTY);
                            this.status_ = 4;
                            return this.status_;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            this.errorMessage_ = ce.getMessage();
            if (this.errorMessage_ == null) {
                this.errorMessage_ = ce.toString();
            }
            this.status_ = 4;
        }
        return this.status_;
    }

    @Override
    public String getErrorMessage() {
        String errMsg;
        if (this.status_ != 4 && !((ITableProperty)this.property_).isValid() && (errMsg = ((ITableProperty)this.property_).getValidationMessage()) != null && errMsg.length() > 0) {
            return super.getErrorMessage();
        }
        return this.errorMessage_;
    }

    protected String getErrorMessageWithLocation(ISingleValuedProperty property, String message) {
        Table table = this.tableViewer_.getTable();
        TableItem[] items = table.getSelection();
        int row = table.getSelectionIndex();
        int column = -1;
        if (items.length > 0 && items[0].getData() instanceof ISingleValuedProperty[]) {
            ISingleValuedProperty[] properties = (ISingleValuedProperty[])items[0].getData();
            int i = 0;
            while (i < properties.length) {
                if (property.equals(properties[i])) {
                    column = i;
                    break;
                }
                ++i;
            }
        }
        if (row != -1 && column != -1) {
            try {
                ITableProperty.ColumnDescriptor cd = ((ITableProperty)this.property_).getColumns()[column];
                return this.getErrorMessageWithLocation(cd, row + 1, message);
            }
            catch (CoreException coreException) {}
        }
        return message;
    }

    protected String getErrorMessageWithLocation(ITableProperty.ColumnDescriptor column, int row, String message) {
        StringBuffer errmsg = new StringBuffer(column.getDisplayName());
        errmsg.append("[");
        errmsg.append(row);
        errmsg.append("]");
        this.getWidgetLabel(errmsg, false);
        errmsg.append(" ");
        errmsg.append(message);
        return errmsg.toString();
    }

    protected Object[] getPGContext() {
        Object[] context = null;
        IPropertyDescriptor parent = this.getTopMostParent(this.getProperty());
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)parent)) {
            context = ((IPropertyGroup)parent).getPropertyGroupContext();
        }
        return context;
    }

    protected void setPGContext(Object[] context) {
        IPropertyDescriptor parent = this.getTopMostParent(this.getProperty());
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)parent)) {
            ((IPropertyGroup)parent).setPropertyGroupContext(context);
        }
    }

    protected IPropertyDescriptor getTopMostParent(IPropertyDescriptor property) {
        if (property.getParent() == null) {
            return property;
        }
        return this.getTopMostParent(property.getParent());
    }

    protected int showInputWizard(ISingleValuedProperty[] properties, int type) {
        try {
            Object[] pgContext = this.getPGContext();
            TablePropertyInputWizard wizard = new TablePropertyInputWizard(properties, ((ITableProperty)this.property_).getColumns(), type, pgContext);
            wizard.setModificationType(this.listenerType_);
            wizard.setShowingType(type);
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            int returnCode = dialog.open();
            if (returnCode == 0) {
                this.status_ = 0;
                this.errorMessage_ = null;
                TablePropertyInputWizard.PropertyChangedInfo[] info = wizard.getPropertyChangedInfo();
                if (info.length > 0) {
                    this.eventSender_.firePropertyUIComplexChanged(type, 0);
                }
                int i = 0;
                while (i < info.length) {
                    this.updateUnSolvedValueList((ISingleValuedProperty)info[i].ipd_, info[i].status_, info[i].message_, info[i].value_);
                    if (info[i].status_ > this.status_) {
                        this.status_ = info[i].status_;
                        this.errorMessage_ = info[i].message_;
                    }
                    this.eventSender_.firePropertyUIChange(info[i].oldValue_, info[i].ipd_);
                    ++i;
                }
                if (info.length > 0) {
                    this.eventSender_.firePropertyUIComplexChanged(type, 1);
                }
                if (pgContext == null) {
                    this.setPGContext(wizard.getPgContext());
                }
            }
            return returnCode;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.length() < 1) {
                msg = e.toString();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)PropertyUIMessages.ERROR_WIZARDS_NEW_WIZARD, (String)msg);
            return 1;
        }
    }

    protected void setPropertyValue(ISingleValuedProperty property, Object newValue) {
        if (!this.isEnabled()) {
            return;
        }
        if (newValue instanceof String) {
            this.setPropertyValueAsString(property, (String)newValue);
        } else {
            this.property_.removePropertyChangeListener((IPropertyChangeListener)this);
            try {
                property.setValue(newValue);
                this.updateUnSolvedValueList(property, 0, null, newValue);
            }
            catch (CoreException ie) {
                IStatus status = ie.getStatus();
                this.updateUnSolvedValueList(property, status.getSeverity(), status.getMessage(), newValue);
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null || errMsg.length() < 1) {
                    errMsg = e.toString();
                }
                this.updateUnSolvedValueList(property, 4, errMsg, newValue);
            }
            this.property_.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected void setPropertyValueAsString(ISingleValuedProperty property, String newValue) {
        if (!this.isEnabled()) {
            return;
        }
        this.property_.removePropertyChangeListener((IPropertyChangeListener)this);
        try {
            if (newValue == null || newValue.length() < 1) {
                if (property.getValue() != null) {
                    property.setValue(null);
                }
            } else {
                property.setValueAsString(newValue);
            }
            this.updateUnSolvedValueList(property, 0, null, newValue);
        }
        catch (CoreException ie) {
            IStatus status = ie.getStatus();
            this.updateUnSolvedValueList(property, status.getSeverity(), status.getMessage(), newValue);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            if (errMsg == null || errMsg.length() < 1) {
                errMsg = e.toString();
            }
            this.updateUnSolvedValueList(property, 4, errMsg, newValue);
        }
        this.property_.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected String getFirstErrorMessage() {
        if (this.unSolvedValues_ == null || this.unSolvedValues_.isEmpty()) {
            return null;
        }
        String retMessage = null;
        ArrayList<IPropertyDescriptor> removing = new ArrayList<IPropertyDescriptor>(3);
        for (IPropertyDescriptor ipd : this.unSolvedValues_.keySet()) {
            ErrorInfo info = this.unSolvedValues_.get(ipd);
            if (info != null) {
                Object pValue = PropertyUtil.getValue(ipd);
                if (pValue != null && pValue.equals(info.value_) || info.value_ != null && info.value_.equals(pValue) || pValue == null && info.value_ == null) {
                    retMessage = info.message_;
                    break;
                }
                removing.add(ipd);
                continue;
            }
            removing.add(ipd);
        }
        int i = 0;
        while (i < removing.size()) {
            this.unSolvedValues_.remove(removing.get(i));
            ++i;
        }
        return retMessage;
    }

    protected ErrorInfo updateUnSolvedValueList(ISingleValuedProperty isvp, int status, String message, Object value) {
        ISingleValuedProperty property = isvp;
        if (property.equals(this.editingPropertyInfo_.copy_)) {
            property = this.editingPropertyInfo_.property_;
        }
        if (status == 0 && PropertyUtil.isRequired((IPropertyDescriptor)isvp) && !PropertyUIHelper.instance().validateRequiredProperty((IPropertyDescriptor)isvp)) {
            message = PropertyUIMessages.ERROR_WIZARDS_VALUE_CANNOT_BE_EMPTY;
            status = 4;
            if (this.unSolvedValues_ != null) {
                this.unSolvedValues_.remove(property);
            }
        }
        this.editingPropertyInfo_.status_ = status;
        if (status != 0 && message != null && message.length() > 0) {
            message = this.getErrorMessageWithLocation(property, message);
        }
        ErrorInfo info = null;
        if (status == 0) {
            if (this.unSolvedValues_ != null) {
                this.unSolvedValues_.remove(property);
            }
        } else if (status != 4) {
            if (this.unSolvedValues_ != null) {
                info = this.unSolvedValues_.get(property);
                if (info == null) {
                    info = new ErrorInfo(status, message, value);
                    this.unSolvedValues_.put((IPropertyDescriptor)property, info);
                } else {
                    info.status_ = status;
                    info.message_ = message;
                    info.value_ = value;
                }
            } else {
                this.unSolvedValues_ = new HashMap<IPropertyDescriptor, ErrorInfo>();
                info = new ErrorInfo(status, message, value);
                this.unSolvedValues_.put((IPropertyDescriptor)property, info);
            }
        }
        if (info != null) {
            this.status_ = info.status_;
            this.errorMessage_ = info.message_;
        } else {
            this.status_ = status;
            this.errorMessage_ = message;
        }
        return info;
    }

    protected void rollbackStatus() {
        if (this.unSolvedValues_ != null) {
            if (this.editingPropertyInfo_.oldInfo_ == null) {
                this.unSolvedValues_.remove(this.editingPropertyInfo_.property_);
            } else {
                this.unSolvedValues_.put((IPropertyDescriptor)this.editingPropertyInfo_.property_, this.editingPropertyInfo_.oldInfo_);
            }
        }
        try {
            if (this.listenerType_ != 1) {
                this.editingPropertyInfo_.copy_ = (ISingleValuedProperty)this.editingPropertyInfo_.property_.clone();
            }
        }
        catch (Exception exception) {
            this.editingPropertyInfo_.reset();
        }
    }

    protected Control createTableLabel(Composite container) {
        Control label = this.createWidgetLabel(container);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        gd.horizontalSpan = this.ColumnNo_;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected PropertyUITableViewer createTableViewer(Composite container) {
        String[] columnProperties = this.getColumnProperties();
        PropertyUITableViewer tableViewer = this.widgetStyle_ == -1 ? new PropertyUITableViewer(container, this.factory_.getBorderStyle() | 2 | 0x10000) : new PropertyUITableViewer(container, this.factory_.getBorderStyle() | this.widgetStyle_);
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.addHoverManager((Control)table, this.property_.getDescription());
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 16384, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        column.setResizable(false);
        int i = 1;
        while (i < columnProperties.length) {
            column = new TableColumn(table, 16384, i);
            column.setText(columnProperties[i]);
            if (i == columnProperties.length - 1) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 130, true));
            } else {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(130, true));
            }
            ++i;
        }
        table.setLayout((Layout)layout);
        tableViewer.setColumnProperties(columnProperties);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertyUIWidgetTable.this.updateButtonsState();
            }
        });
        return tableViewer;
    }

    protected void createTableInput(PropertyUITableViewer tableViewer) {
        TableViewerProvider tableProvider = new TableViewerProvider();
        tableViewer.setContentProvider((IContentProvider)tableProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)tableProvider);
        tableViewer.setCellModifier(new TableViewerCellModifier());
        tableViewer.setCellEditors(this.getCellEditors(tableViewer));
        tableViewer.setInput(this.property_);
    }

    protected Button createButton(Composite parent, String text, String tooltip) {
        Button button = this.factory_.createButton(parent, text, 0x1000008);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        button.setLayoutData((Object)gd);
        if (tooltip != null && tooltip.length() > 0) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    protected Button createImageButton(Composite parent, Image image, String text, String tooltip) {
        Button button = this.factory_.createButton(parent, 0x1000008);
        GridData gd = new GridData();
        gd.horizontalAlignment = 768;
        gd.verticalAlignment = 3;
        button.setLayoutData((Object)gd);
        button.setImage(image);
        if (tooltip != null && tooltip.length() > 0) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    protected String[] getColumnProperties() {
        try {
            ITableProperty.ColumnDescriptor[] columns = ((ITableProperty)this.property_).getColumns();
            String[] names = new String[columns.length + 1];
            names[0] = "";
            int i = 0;
            while (i < columns.length) {
                names[i + 1] = columns[i].getDisplayName();
                ++i;
            }
            return names;
        }
        catch (CoreException coreException) {
            return new String[0];
        }
    }

    protected CellEditor[] getCellEditors(TableViewer viewer) {
        ITableProperty.ColumnDescriptor[] columns;
        try {
            columns = ((ITableProperty)this.property_).getColumns();
        }
        catch (CoreException coreException) {
            return new CellEditor[0];
        }
        CellEditor[] cellEditors = new CellEditor[columns.length + 1];
        PropertyUIExtensionRegistry registry = PropertyUIExtensionRegistry.instance();
        int i = 0;
        while (i < columns.length) {
            IPropertyType type = columns[i].getType();
            if (type.isReadOnly() || !columns[i].isEnabled()) {
                cellEditors[i + 1] = null;
            } else {
                Object cellEditor;
                block30: {
                    String id = columns[i].getID();
                    cellEditor = null;
                    Table table = viewer.getTable();
                    PropertyInputExtensionPointInfo extInfo = null;
                    if (id != null) {
                        extInfo = registry.getPropertyInputExtension(id);
                    }
                    if (extInfo != null) {
                        cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], true, 0, type);
                    } else {
                        String[] validValues = type.getValidValuesAsStrings();
                        if (type.getType().equals(Boolean.class)) {
                            cellEditor = new PropertyCheckBoxCellEditor((Composite)table);
                        } else if (validValues != null && validValues.length > 0) {
                            cellEditor = new PropertyComboBoxCellEditor((Composite)table, validValues, type);
                        } else {
                            ITableCellProperty property;
                            String className = type.getType().getName();
                            if (className.equalsIgnoreCase("org.eclipse.jdt.core.IJavaProject")) {
                                cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], true, 3, type);
                            } else if (className.equalsIgnoreCase("org.eclipse.jdt.core.IPackageFragment")) {
                                cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], true, 4, type);
                            } else if (className.equalsIgnoreCase("javax.xml.namespace.QName")) {
                                cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], true, 100, type);
                            } else if (className.equalsIgnoreCase("org.eclipse.emf.common.util.URI")) {
                                if (((ITableProperty)this.property_).rowCount() > 0) {
                                    try {
                                        property = ((ITableProperty)this.property_).getCellProperty(0, i);
                                        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)property)) {
                                            cellEditor = CustomPropertyHelper.isSingleFileProperty((ICustomProperty)((ICustomProperty)property)) ? new PropertyTextCellEditor((Composite)table, columns[i], true, 1, type) : (CustomPropertyHelper.isSingleFolderProperty((ICustomProperty)((ICustomProperty)property)) ? new PropertyTextCellEditor((Composite)table, columns[i], true, 2, type) : new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type));
                                            break block30;
                                        }
                                        cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                                    }
                                    catch (CoreException coreException) {
                                        cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                                    }
                                } else {
                                    cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                                }
                            } else if (((ITableProperty)this.property_).rowCount() > 0) {
                                try {
                                    property = ((ITableProperty)this.property_).getCellProperty(0, i);
                                    if (PropertyHelper.isCustomProperty((IPropertyDescriptor)property)) {
                                        cellEditor = CustomPropertyHelper.isJavaTypeProperty((ICustomProperty)((ICustomProperty)property)) ? new PropertyTextCellEditor((Composite)table, columns[i], true, 101, type) : new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                                        break block30;
                                    }
                                    cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                                }
                                catch (CoreException coreException) {
                                    cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                                }
                            } else {
                                cellEditor = new PropertyTextCellEditor((Composite)table, columns[i], false, -1, type);
                            }
                        }
                    }
                }
                cellEditors[i + 1] = cellEditor;
            }
            ++i;
        }
        return cellEditors;
    }

    protected String getDisplayValue(ISingleValuedProperty property, boolean isForDisplay) {
        String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
        if (value == null) {
            Object defaultValue = PropertyUtil.getDefaultValue((IPropertyDescriptor)property);
            String[] validValues = PropertyUtil.getValidValuesAsStrings((IPropertyDescriptor)property);
            if (validValues != null && validValues.length > 0) {
                boolean editable = PropertyUtil.isValidValuesEditable((IPropertyDescriptor)property);
                if (defaultValue == null) {
                    if (!editable) {
                        value = validValues[0];
                    }
                } else if (!editable) {
                    int i = 0;
                    while (i < validValues.length) {
                        if (validValues[i].equals(defaultValue.toString())) {
                            value = validValues[i];
                            break;
                        }
                        ++i;
                    }
                    if (value == null) {
                        value = validValues[0];
                    }
                } else {
                    value = defaultValue.toString();
                }
            } else if (defaultValue != null) {
                value = defaultValue.toString();
            }
        }
        if (value == null && isForDisplay) {
            return "";
        }
        return value;
    }

    protected int validateProperties(ISingleValuedProperty[] properties) {
        int status = 0;
        int i = 0;
        while (i < properties.length) {
            ErrorInfo info;
            if (this.unSolvedValues_ != null && (info = this.unSolvedValues_.get(properties[i])) != null && info.status_ != 0) {
                if (info.status_ == 4) {
                    return info.status_;
                }
                status = info.status_;
            }
            if (PropertyUtil.isRequired((IPropertyDescriptor)properties[i])) {
                ISingleValuedProperty ipd = properties[i];
                if (ipd.equals(this.editingPropertyInfo_.property_) && this.editingPropertyInfo_.copy_ != null) {
                    ipd = this.editingPropertyInfo_.copy_;
                }
                if (!this.validateRequiredProperty((IPropertyDescriptor)ipd)) {
                    return 4;
                }
            }
            ++i;
        }
        return status;
    }

    protected boolean validateRequiredProperty(IPropertyDescriptor ipd) {
        Object[] validValues = PropertyUtil.getValidValues(ipd);
        return PropertyUtil.getValue(ipd) != null || !PropertyUtil.isEnabled(ipd) || PropertyUtil.getDefaultValue(ipd) != null || validValues != null && validValues.length >= 1;
    }

    protected class EditingPropertyInfo {
        ISingleValuedProperty property_;
        ISingleValuedProperty copy_;
        int status_;
        ErrorInfo oldInfo_;

        protected EditingPropertyInfo() {
        }

        protected void reset() {
            this.property_ = null;
            this.copy_ = null;
            this.status_ = 0;
        }
    }

    protected class ErrorInfo {
        String message_;
        int status_;
        Object value_;

        public ErrorInfo(int status, String message, Object value) {
            this.message_ = message;
            this.status_ = status;
            this.value_ = value;
        }
    }

    protected abstract class PropertyCellEditor
    extends CellEditor {
        protected Listener modifyListener_;
        protected DelayedEvent delayedTask_;

        protected PropertyCellEditor() {
        }

        public void activate() {
            ErrorInfo info;
            boolean currentS = true;
            if (PropertyUIWidgetTable.this.status_ == 4) {
                return;
            }
            if (PropertyUIWidgetTable.this.unSolvedValues_ != null && !PropertyUIWidgetTable.this.unSolvedValues_.isEmpty() && (info = PropertyUIWidgetTable.this.unSolvedValues_.get(PropertyUIWidgetTable.this.editingPropertyInfo_.property_)) != null && info.status_ != 0) {
                PropertyUIWidgetTable.this.status_ = info.status_;
                PropertyUIWidgetTable.this.errorMessage_ = info.message_;
                currentS = false;
            }
            if (!currentS) {
                PropertyUIWidgetTable.this.sendPropertyUIStatusChangedEvent((IStatus)new Status(PropertyUIWidgetTable.this.status_, "com.ibm.property.ui", PropertyUIWidgetTable.this.status_, PropertyUIWidgetTable.this.errorMessage_, null));
            }
        }

        public void deactivate() {
            super.deactivate();
            if (PropertyUIWidgetTable.this.editingPropertyInfo_.status_ == 4) {
                ErrorInfo info;
                PropertyUIWidgetTable.this.status_ = 0;
                PropertyUIWidgetTable.this.errorMessage_ = null;
                if (PropertyUIWidgetTable.this.unSolvedValues_ != null && !PropertyUIWidgetTable.this.unSolvedValues_.isEmpty() && (info = PropertyUIWidgetTable.this.unSolvedValues_.get(PropertyUIWidgetTable.this.editingPropertyInfo_.property_)) != null && info.status_ != 0) {
                    PropertyUIWidgetTable.this.status_ = info.status_;
                    PropertyUIWidgetTable.this.errorMessage_ = info.message_;
                }
                if (PropertyUIWidgetTable.this.status_ == 0) {
                    PropertyUIWidgetTable.this.sendPropertyUIStatusChangedEvent(null);
                } else {
                    PropertyUIWidgetTable.this.sendPropertyUIStatusChangedEvent((IStatus)new Status(PropertyUIWidgetTable.this.status_, "com.ibm.property.ui", PropertyUIWidgetTable.this.status_, PropertyUIWidgetTable.this.errorMessage_, null));
                }
            }
        }

        protected void doSetValue(Object value) {
            if (value instanceof ISingleValuedProperty) {
                try {
                    PropertyUIWidgetTable.this.editingPropertyInfo_.property_ = (ISingleValuedProperty)value;
                    PropertyUIWidgetTable.this.editingPropertyInfo_.copy_ = null;
                    if (PropertyUIWidgetTable.this.listenerType_ != 1) {
                        PropertyUIWidgetTable.this.editingPropertyInfo_.copy_ = (ISingleValuedProperty)((ISingleValuedProperty)value).clone();
                    }
                    if (PropertyUIWidgetTable.this.unSolvedValues_ != null) {
                        PropertyUIWidgetTable.this.editingPropertyInfo_.oldInfo_ = PropertyUIWidgetTable.this.unSolvedValues_.get(PropertyUIWidgetTable.this.editingPropertyInfo_.property_);
                    }
                }
                catch (Exception exception) {
                    PropertyUIWidgetTable.this.editingPropertyInfo_.reset();
                }
            }
        }

        protected void fireCancelEditor() {
            PropertyUIWidgetTable.this.rollbackStatus();
            TableItem[] items = PropertyUIWidgetTable.this.tableViewer_.getTable().getSelection();
            if (items.length > 0) {
                PropertyUIWidgetTable.this.tableViewer_.refreshEditingItem(items[0].getData(), false);
            }
            super.fireCancelEditor();
        }

        protected void addModificationListner(Control control, int listenerType) {
            if (PropertyUIWidgetTable.this.listenerType_ != 1) {
                control.addListener(listenerType, this.getListener());
            }
        }

        protected void removeModificationListner(Control control, int listenerType) {
            if (PropertyUIWidgetTable.this.listenerType_ != 1) {
                control.removeListener(listenerType, this.getListener());
            }
        }

        protected Listener getListener() {
            if (this.modifyListener_ == null) {
                this.modifyListener_ = new Listener(){

                    public void handleEvent(Event event) {
                        if (PropertyCellEditor.this.delayedTask_ == null) {
                            PropertyCellEditor.this.delayedTask_ = new DelayedEvent();
                        }
                        Display.getDefault().timerExec(400, (Runnable)PropertyCellEditor.this.delayedTask_);
                    }
                };
            }
            return this.modifyListener_;
        }

        protected void addTraverseListener(Control control) {
            control.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
        }

        protected void addKeyListener(Control control) {
            control.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u001b') {
                        PropertyCellEditor.this.fireCancelEditor();
                        PropertyUIWidgetTable.this.sendPropertyUIStatusChangedEvent(null);
                    } else if (e.character == '\r' || e.character == '\n') {
                        PropertyCellEditor.this.applyEditorValueAndDeactivate();
                    }
                }
            });
        }

        protected void applyEditorValueAndDeactivate() {
            this.fireApplyEditorValue();
            this.deactivate();
        }

        protected void applyEditorValue() {
            if (PropertyUIWidgetTable.this.editingPropertyInfo_.copy_ != null) {
                Object newValue = this.getValue();
                Object oldValue = PropertyUIWidgetTable.this.editingPropertyInfo_.copy_.getValue();
                PropertyUIWidgetTable.this.setPropertyValue(PropertyUIWidgetTable.this.editingPropertyInfo_.copy_, newValue);
                TableItem[] items = PropertyUIWidgetTable.this.tableViewer_.getTable().getSelection();
                if (items.length > 0) {
                    PropertyUIWidgetTable.this.tableViewer_.refreshEditingItem(items[0].getData(), PropertyUIWidgetTable.this.editingPropertyInfo_.status_ == 4);
                }
                PropertyUIWidgetTable.this.eventSender_.firePropertyUIChange(oldValue, newValue);
            }
        }

        protected class DelayedEvent
        implements Runnable {
            boolean cancelEvent = false;

            protected DelayedEvent() {
            }

            @Override
            public void run() {
                if (!this.cancelEvent) {
                    if (PropertyCellEditor.this.delayedTask_ == this) {
                        PropertyCellEditor.this.delayedTask_ = null;
                    }
                    PropertyCellEditor.this.applyEditorValue();
                }
            }

            public void setCancel(boolean flag) {
                this.cancelEvent = flag;
            }
        }
    }

    protected class PropertyCheckBoxCellEditor
    extends CheckboxCellEditor {
        public PropertyCheckBoxCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value instanceof ISingleValuedProperty) {
                Boolean newValue = (Boolean)((ISingleValuedProperty)value).getValue();
                if (newValue == null) {
                    newValue = new Boolean(false);
                }
                super.doSetValue((Object)newValue);
            } else {
                super.doSetValue(value);
            }
        }
    }

    protected class PropertyComboBoxCellEditor
    extends PropertyCellEditor {
        protected String[] items_;
        protected IPropertyType type_;
        protected CCombo comboBox_;

        public PropertyComboBoxCellEditor(Composite parent, String[] items, IPropertyType type) {
            this.type_ = type;
            this.create(parent);
            this.setItems(PropertyUIWidgetTable.this.processText(items));
        }

        public String[] getItems() {
            return this.items_;
        }

        public void setItems(String[] items) {
            Assert.isNotNull((Object)items);
            this.items_ = items;
            this.populateComboBoxItems();
        }

        protected Control createControl(Composite parent) {
            if (!this.type_.isValidValuesEditable()) {
                this.comboBox_ = new CCombo(parent, this.getStyle() | 8);
            } else {
                this.comboBox_ = new CCombo(parent, this.getStyle());
                this.addModificationListner((Control)this.comboBox_, 24);
            }
            this.comboBox_.setFont(parent.getFont());
            this.addKeyListener((Control)this.comboBox_);
            this.addTraverseListener((Control)this.comboBox_);
            return this.comboBox_;
        }

        protected Object doGetValue() {
            return this.comboBox_.getText();
        }

        protected void doSetFocus() {
            this.comboBox_.setFocus();
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(value);
            if (this.type_.isValidValuesEditable()) {
                this.removeModificationListner((Control)this.comboBox_, 24);
            }
            if (value instanceof ISingleValuedProperty) {
                String[] newItems = PropertyUtil.getValidValuesAsStrings((IPropertyDescriptor)((ISingleValuedProperty)value));
                if (newItems != null) {
                    this.setItems(newItems);
                }
                this.comboBox_.setText(PropertyUIWidgetTable.this.processText(this.type_.getType(), PropertyUIWidgetTable.this.getDisplayValue((ISingleValuedProperty)value, true)));
            } else {
                this.comboBox_.setText(PropertyUIWidgetTable.this.processText(this.type_.getType(), value.toString()));
            }
            if (this.type_.isValidValuesEditable()) {
                this.addModificationListner((Control)this.comboBox_, 24);
            }
        }

        protected void populateComboBoxItems() {
            if (this.comboBox_ != null && this.items_ != null) {
                this.comboBox_.removeAll();
                this.comboBox_.setItems(this.items_);
            }
        }
    }

    protected class PropertyTextCellEditor
    extends PropertyCellEditor {
        public static final int BUTTON_BROWSE_SCHEMA_TYPE = 100;
        public static final int BUTTON_BROWSE_JAVA_TYPE = 101;
        protected Text text_;
        protected Button button_;
        protected ITableProperty.ColumnDescriptor column_;
        protected boolean withButton_ = false;
        protected boolean inputWindowIsShowing_;
        protected int buttonType_;
        protected String[] fileExtensions_;
        protected IPropertyType propertyType_;

        public PropertyTextCellEditor(Composite parent, ITableProperty.ColumnDescriptor column, boolean withButton, int type, IPropertyType pType) {
            this.column_ = column;
            this.withButton_ = withButton;
            this.buttonType_ = type;
            this.propertyType_ = pType;
            this.create(parent);
        }

        protected Control createControl(Composite parent) {
            Composite container = parent;
            if (this.withButton_) {
                container = PropertyUIWidgetTable.this.factory_.createComposite(container, 0);
                container.setLayout((Layout)new ComboCellLayout());
                container.setLayoutData((Object)new GridData(1808));
            }
            this.text_ = PropertyUIWidgetTable.this.factory_.createText(container, 0);
            if (this.column_.getType().isSensitive()) {
                this.text_.setEchoChar('*');
            }
            this.text_.setBackground(container.getBackground());
            this.text_.setFont(container.getFont());
            this.text_.setBackground(container.getBackground());
            this.addKeyListener((Control)this.text_);
            this.addTraverseListener((Control)this.text_);
            this.addModificationListner((Control)this.text_, 24);
            if (this.withButton_) {
                this.text_.setEditable(false);
                this.button_ = PropertyUIWidgetTable.this.factory_.createButton(container, "...", 1024);
                this.button_.setBackground(container.getBackground());
                this.button_.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PropertyTextCellEditor.this.inputWindowIsShowing_ = true;
                        switch (PropertyTextCellEditor.this.buttonType_) {
                            case 0: {
                                PropertyTextCellEditor.this.handleCustomizedButton();
                                break;
                            }
                            case 1: {
                                PropertyTextCellEditor.this.handleBrowseFile();
                                break;
                            }
                            case 2: {
                                PropertyTextCellEditor.this.handleBrowseFolder();
                                break;
                            }
                            case 3: {
                                PropertyTextCellEditor.this.handleBrowseProject();
                                break;
                            }
                            case 4: {
                                PropertyTextCellEditor.this.handleBrowsePackage();
                                break;
                            }
                            case 100: {
                                PropertyTextCellEditor.this.handleBrowseSchemaType();
                                break;
                            }
                            case 101: {
                                PropertyTextCellEditor.this.handleBrowseJavaType();
                                break;
                            }
                        }
                        PropertyTextCellEditor.this.inputWindowIsShowing_ = false;
                    }
                });
                return container;
            }
            return this.text_;
        }

        protected Object doGetValue() {
            return this.text_.getText();
        }

        protected void doSetFocus() {
            this.text_.setFocus();
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(value);
            this.removeModificationListner((Control)this.text_, 24);
            if (value instanceof ISingleValuedProperty) {
                this.setStringToSWTControl(PropertyUIWidgetTable.this.getDisplayValue((ISingleValuedProperty)value, true));
                if (PropertyHelper.isCustomProperty((IPropertyDescriptor)PropertyUIWidgetTable.this.editingPropertyInfo_.property_) && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)((ICustomProperty)PropertyUIWidgetTable.this.editingPropertyInfo_.property_))) {
                    this.fileExtensions_ = ((FileProperty)PropertyUIWidgetTable.this.editingPropertyInfo_.property_).getFileExtensions();
                }
            } else {
                this.setStringToSWTControl(value.toString());
            }
            this.addModificationListner((Control)this.text_, 24);
        }

        protected void handleCustomizedButton() {
            PropertyUIHelper helper = PropertyUIHelper.instance();
            PropertyInputExtensionPointInfo piExtInfo = null;
            String id = PropertyUIWidgetTable.this.editingPropertyInfo_.property_.getID();
            if (id != null) {
                piExtInfo = PropertyUIExtensionRegistry.instance().getPropertyInputExtension(id);
            }
            if (piExtInfo == null) {
                id = this.column_.getID();
                piExtInfo = PropertyUIExtensionRegistry.instance().getPropertyInputExtension(id);
            }
            if (piExtInfo != null) {
                Shell shell = PropertyUIWidgetTable.this.getShell();
                try {
                    String value;
                    if (PropertyUIWidgetTable.this.editingPropertyInfo_.copy_ != null) {
                        value = helper.getPropertyInputValue((Control)this.text_, piExtInfo, (IPropertyDescriptor)PropertyUIWidgetTable.this.editingPropertyInfo_.copy_);
                    } else if (PropertyUIWidgetTable.this.editingPropertyInfo_.property_ != null) {
                        IPropertyDescriptor ipd = (IPropertyDescriptor)PropertyUIWidgetTable.this.editingPropertyInfo_.property_.clone();
                        String str = this.text_.getText();
                        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)ipd)) {
                            try {
                                ((ISingleValuedProperty)ipd).setValueAsString(str);
                            }
                            catch (Exception exception) {}
                        }
                        value = helper.getPropertyInputValue((Control)this.text_, piExtInfo, ipd);
                    } else {
                        value = helper.getPropertyInputValue((Control)this.text_, piExtInfo, (IPropertyDescriptor)this.column_.clone());
                    }
                    if (value != null) {
                        this.setStringToSWTControl(value);
                        this.text_.setFocus();
                    }
                }
                catch (Exception exception) {
                    String msg = exception.getMessage();
                    if (msg == null || msg.length() < 1) {
                        msg = exception.toString();
                    }
                    MessageDialog.openError((Shell)shell, (String)PropertyUIMessages.ERROR_WIZARDS_NEW_WIZARD, (String)msg);
                    this.button_.setEnabled(false);
                }
            } else {
                this.button_.setEnabled(false);
            }
        }

        protected void handleBrowseFile() {
            PropertyUIHelper helper = PropertyUIHelper.instance();
            ISingleValuedProperty isvp = PropertyUIWidgetTable.this.editingPropertyInfo_.property_;
            if (isvp != null && PropertyHelper.isCustomProperty((IPropertyDescriptor)isvp) && CustomPropertyHelper.isSingleFolderProperty((ICustomProperty)((ICustomProperty)isvp))) {
                String value = helper.browseFolder(PropertyUIWidgetTable.this.shell_, helper.getDefaultFolderLocation(), "");
                if (value != null && value.length() > 0) {
                    helper.setDefaultFolderLocation(value);
                    this.setStringToSWTControl(value);
                }
            } else {
                String value;
                boolean mustExist = true;
                if (PropertyHelper.isCustomProperty((IPropertyDescriptor)isvp) && CustomPropertyHelper.isSingleFileProperty((ICustomProperty)((ICustomProperty)isvp))) {
                    mustExist = ((FileProperty)PropertyUIWidgetTable.this.property_).isMustExist();
                }
                if ((value = helper.browseFile(PropertyUIWidgetTable.this.shell_, this.fileExtensions_, mustExist)) != null && value.length() > 0) {
                    this.setStringToSWTControl(value);
                }
            }
        }

        protected void handleBrowseFolder() {
            PropertyUIHelper helper = PropertyUIHelper.instance();
            String value = helper.browseFolder(PropertyUIWidgetTable.this.shell_, helper.getDefaultFolderLocation(), "");
            if (value != null && value.length() > 0) {
                helper.setDefaultFolderLocation(value);
                this.setStringToSWTControl(value);
            }
        }

        protected void handleBrowseProject() {
            String value = PropertyUIHelper.instance().browseProject(PropertyUIWidgetTable.this.getShell());
            if (value != null && value.length() > 0) {
                this.setStringToSWTControl(value);
            }
        }

        protected void handleBrowsePackage() {
            String value = PropertyUIHelper.instance().browsePackage(PropertyUIWidgetTable.this.getShell(), "");
            if (value != null && value.length() > 0) {
                this.setStringToSWTControl(value);
            }
        }

        protected void handleBrowseSchemaType() {
            String[] results = PropertyUIHelper.instance().browseSchemaTypeAsString(PropertyUIWidgetTable.this.shell_, false);
            if (results != null && results.length > 0) {
                this.setStringToSWTControl(results[0]);
            }
        }

        protected void handleBrowseJavaType() {
            String[] results;
            ISingleValuedProperty isvp = PropertyUIWidgetTable.this.editingPropertyInfo_.property_;
            if (isvp != null && (results = PropertyUIHelper.instance().browseJavaTypeAsString(((JavaTypeProperty)isvp).getImplementationTypes(), PropertyUIWidgetTable.this.shell_, PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_OPEN_TYPE, PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_OPEN_TYPE_DESC, false)) != null && results.length > 0) {
                this.setStringToSWTControl(results[0]);
            }
        }

        protected void setStringToSWTControl(String str) {
            this.text_.setText(PropertyUIWidgetTable.this.processText(str));
        }

        protected class ComboCellLayout
        extends Layout {
            protected ComboCellLayout() {
            }

            public void layout(Composite parent, boolean force) {
                Rectangle bounds = parent.getClientArea();
                Point size = PropertyTextCellEditor.this.button_.computeSize(-1, bounds.height, force);
                PropertyTextCellEditor.this.text_.setBounds(0, 0, bounds.width - size.x, bounds.height);
                PropertyTextCellEditor.this.button_.setBounds(bounds.width - size.x, 0, size.x, size.y);
            }

            public Point computeSize(Composite parent, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point size = PropertyTextCellEditor.this.text_.computeSize(-1, -1, force);
                return size;
            }
        }
    }

    protected class PropertyUITableViewer
    extends TableViewer {
        boolean refreshingItem_;

        public PropertyUITableViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void refreshEditingItem(Object rowElement, boolean refreshingItem) {
            Widget w;
            if (rowElement != null && (w = this.findItem(rowElement)) != null) {
                this.refreshingItem_ = refreshingItem;
                this.updateItem(w, rowElement);
                this.refreshingItem_ = false;
            }
        }
    }

    protected class TableViewerCellModifier
    implements ICellModifier {
        ITableProperty.ColumnDescriptor[] columns_;

        public TableViewerCellModifier() {
            try {
                this.columns_ = ((ITableProperty)PropertyUIWidgetTable.this.property_).getColumns();
            }
            catch (CoreException coreException) {
                this.columns_ = new ITableProperty.ColumnDescriptor[0];
            }
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ISingleValuedProperty[]) {
                ISingleValuedProperty[] properties = (ISingleValuedProperty[])element;
                int index = this.getColumnIndex(property);
                if (index != -1) {
                    return properties[index];
                }
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object data;
            if (element instanceof TableItem && (data = ((TableItem)element).getData()) instanceof ISingleValuedProperty[]) {
                ISingleValuedProperty[] properties = (ISingleValuedProperty[])data;
                int index = this.getColumnIndex(property);
                if (index != -1) {
                    Object oldValue = properties[index].getValue();
                    if (this.checkNewValue(properties[index], value)) {
                        PropertyUIWidgetTable.this.setPropertyValue(properties[index], value);
                        if (PropertyUIWidgetTable.this.status_ == 4) {
                            PropertyUIWidgetTable.this.rollbackStatus();
                        }
                        PropertyUIWidgetTable.this.eventSender_.firePropertyUIChange(oldValue, properties[index]);
                        PropertyUIWidgetTable.this.tableViewer_.refreshEditingItem(data, false);
                    }
                }
            }
        }

        protected int getColumnIndex(String colName) {
            int i = 0;
            while (i < this.columns_.length) {
                if (colName.equals(this.columns_[i].getDisplayName())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected boolean checkNewValue(ISingleValuedProperty isvp, Object nValue) {
            Object oValue = nValue instanceof String ? isvp.getValueAsString() : isvp.getValue();
            if (nValue == null && oValue == null || nValue != null && nValue.equals(oValue) || oValue != null && oValue.equals(nValue)) {
                return false;
            }
            return nValue == null || !(nValue instanceof String) || ((String)nValue).length() >= 1 || oValue != null;
        }
    }

    protected class TableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        protected TableViewerProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ISingleValuedProperty[]) {
                if (columnIndex != 0) {
                    ISingleValuedProperty data = ((ISingleValuedProperty[])element)[columnIndex - 1];
                    if (data.getPropertyType().getType().getName().equalsIgnoreCase("java.lang.Boolean")) {
                        Boolean value = (Boolean)data.getValue();
                        boolean bValue = false;
                        if (value != null) {
                            bValue = value;
                        } else {
                            Object defaultValue = data.getPropertyType().getDefaultValue();
                            if (defaultValue != null) {
                                if (defaultValue instanceof String) {
                                    bValue = new Boolean((String)defaultValue);
                                } else if (defaultValue instanceof Boolean) {
                                    bValue = (Boolean)defaultValue;
                                }
                            }
                        }
                        return bValue ? PropertyUIWidgetTable.this.CHECK_IMAGE : PropertyUIWidgetTable.this.UNCHECK_IMAGE;
                    }
                } else {
                    int status = PropertyUIWidgetTable.this.tableViewer_.refreshingItem_ ? PropertyUIWidgetTable.this.status_ : PropertyUIWidgetTable.this.validateProperties((ISingleValuedProperty[])element);
                    if (status == 4) {
                        return PropertyUIWidgetTable.this.ERROR_IMAGE;
                    }
                    if (status != 0) {
                        return PropertyUIWidgetTable.this.WARNING_IMAGE;
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object o, int columnIndex) {
            if (columnIndex == 0) {
                return "";
            }
            if (o instanceof ISingleValuedProperty[]) {
                ISingleValuedProperty data = ((ISingleValuedProperty[])o)[columnIndex - 1];
                String value = PropertyUIWidgetTable.this.getDisplayValue(data, false);
                if (value != null && data.getValue() == null && data.isEnabled()) {
                    boolean setValue = false;
                    if (PropertyUtil.isRequired((IPropertyDescriptor)data)) {
                        setValue = true;
                    } else {
                        Object[] validValues = PropertyUtil.getValidValues((IPropertyDescriptor)data);
                        if (validValues != null && validValues.length > 0) {
                            boolean bl = setValue = !PropertyUtil.isValidValuesEditable((IPropertyDescriptor)data);
                        }
                    }
                    if (setValue) {
                        try {
                            data.setValueAsString(value);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!data.getPropertyType().getType().getName().equalsIgnoreCase("java.lang.Boolean")) {
                    return PropertyUIWidgetTable.this.getDisplayValue(data, true);
                }
            }
            return "";
        }

        public Object[] getElements(Object o) {
            if (o instanceof ITableProperty) {
                ArrayList<ITableCellProperty[]> elements = new ArrayList<ITableCellProperty[]>();
                ITableProperty tp = (ITableProperty)o;
                int rowNo = tp.rowCount();
                int i = 0;
                while (i < rowNo) {
                    try {
                        ITableCellProperty[] svps = tp.getRowProperties(i);
                        elements.add(svps);
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
                return elements.toArray();
            }
            return new Object[0];
        }
    }
}

