/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.common.CustomPropertyHelper;
import com.ibm.propertygroup.spi.common.MultiFileProperty;
import com.ibm.propertygroup.spi.common.MultiJavaTypeProperty;
import com.ibm.propertygroup.ui.api.IPropertyValueContributor;
import com.ibm.propertygroup.ui.dialogs.PropertyUIValueSelectionDialog;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyInputExtensionPointInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIExtensionRegistry;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class PropertyUIWidgetList
extends PropertyUIWidgetProperty {
    protected Control label_;
    protected Button addButton_;
    protected Button removeButton_;
    protected TableViewer tableViewer_;
    protected int columnNo_ = 1;
    protected int buttonType_ = -1;
    protected ArrayList<String> inputList_;
    protected String lastSelection_ = null;
    protected PropertyInputExtensionPointInfo piExtInfo_;

    public PropertyUIWidgetList(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetList(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetList(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.columnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        this.createLabel(parent);
        this.createList(parent);
        this.initListViewer();
        this.createAddButton(parent);
        if (this.columnNo_ - 2 - 1 > 0) {
            this.addFillers(parent, this.columnNo_ - 2 - 1, 2);
        }
        this.createRemoveButton(parent);
        this.initUIControls(parent);
    }

    protected void initUIControls(Composite parent) {
        this.populateValues();
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
        String id = this.property_.getID();
        this.piExtInfo_ = null;
        if (id != null) {
            this.piExtInfo_ = PropertyUIExtensionRegistry.instance().getPropertyInputExtension(id);
        }
        if (this.piExtInfo_ != null) {
            this.buttonType_ = 0;
            this.addButton_.setText(this.piExtInfo_.getButtonLabel());
            this.addHoverManager((Control)this.addButton_, this.piExtInfo_.getButtonToolTip());
        } else if (PropertyHelper.isCustomProperty((IPropertyDescriptor)this.property_)) {
            ICustomProperty cProperty = (ICustomProperty)this.property_;
            if (CustomPropertyHelper.isMultiFolderProperty((ICustomProperty)cProperty)) {
                this.buttonType_ = 2;
            } else if (CustomPropertyHelper.isMultiFileProperty((ICustomProperty)cProperty)) {
                this.buttonType_ = 1;
            } else if (CustomPropertyHelper.isMultiJavaTypeProperty((ICustomProperty)cProperty)) {
                this.buttonType_ = 3;
            } else if (CustomPropertyHelper.isMultiSchemaTypeProperty((ICustomProperty)cProperty)) {
                this.buttonType_ = 4;
            }
        }
    }

    protected void createLabel(Composite parent) {
        this.label_ = this.createWidgetLabel(parent, true);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        gd.horizontalSpan = this.columnNo_;
        this.label_.setLayoutData((Object)gd);
    }

    protected void createList(Composite parent) {
        if (this.widgetStyle_ == -1) {
            int style = this.factory_.getBorderStyle() | 2;
            if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_) && ((IMultiValuedProperty)this.property_).getSelectionStyle() == 0) {
                style = this.factory_.getBorderStyle() | 4;
            }
            this.tableViewer_ = this.factory_.createTableViewer(parent, style);
        } else {
            this.tableViewer_ = this.factory_.createTableViewer(parent, this.factory_.getBorderStyle() | this.widgetStyle_);
        }
        Table table = this.tableViewer_.getTable();
        TableLayout tlayout = new TableLayout();
        ColumnWeightData cLayout = new ColumnWeightData(100, false);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        table.setLayout((Layout)tlayout);
        GridData gd = new GridData(768);
        gd.verticalSpan = 2;
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        table.setLayoutData((Object)gd);
        this.addHoverManager((Control)table, this.property_.getDescription());
    }

    protected void initListViewer() {
        ListViewerProvider listProvider = new ListViewerProvider();
        this.tableViewer_.setContentProvider((IContentProvider)listProvider);
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)listProvider);
        this.tableViewer_.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyUIWidgetList.this.updateRemoveButtonState();
                PropertyUIWidgetList.this.updateSelection();
            }
        });
    }

    protected void updateSelection() {
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)this.property_)) {
            int[] selectionIndicies = this.tableViewer_.getTable().getSelectionIndices();
            ((IMultiValuedProperty)this.property_).setSelection(selectionIndicies);
        }
    }

    protected void createAddButton(Composite parent) {
        this.addButton_ = this.factory_.createButton(parent, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_ADD_MORE, 0x1000008);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        this.addButton_.setLayoutData((Object)gd);
        this.addButton_.addListener(13, (Listener)this);
    }

    protected void createRemoveButton(Composite parent) {
        this.removeButton_ = this.factory_.createButton(parent, PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_REMOVE, 0x1000008);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        this.removeButton_.setLayoutData((Object)gd);
        this.removeButton_.addListener(13, (Listener)this);
        this.removeButton_.setEnabled(false);
    }

    @Override
    public void initDefaultValue() {
        this.populateValues();
    }

    @Override
    public void handleEvent(final Event event) {
        final PropertyUIWidgetList currWidget = this;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList<Integer> newValuesIndex = null;
                PropertyUIWidgetList.this.property_.removePropertyChangeListener((IPropertyChangeListener)currWidget);
                if (event.widget == PropertyUIWidgetList.this.addButton_) {
                    switch (PropertyUIWidgetList.this.buttonType_) {
                        case 0: {
                            newValuesIndex = PropertyUIWidgetList.this.performCustomizedBrowseValue();
                            break;
                        }
                        case 1: {
                            newValuesIndex = PropertyUIWidgetList.this.performBrowseFile();
                            break;
                        }
                        case 2: {
                            newValuesIndex = PropertyUIWidgetList.this.performBrowseFolder();
                            break;
                        }
                        case 3: {
                            newValuesIndex = PropertyUIWidgetList.this.performBrowseJavaType();
                            break;
                        }
                        case 4: {
                            newValuesIndex = PropertyUIWidgetList.this.performBrowseSchemaType();
                            break;
                        }
                        default: {
                            newValuesIndex = PropertyUIWidgetList.this.performBrowseValue();
                            break;
                        }
                    }
                } else if (event.widget == PropertyUIWidgetList.this.removeButton_ && PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)PropertyUIWidgetList.this.property_)) {
                    newValuesIndex = PropertyUIWidgetList.this.performRemoveValue();
                }
                PropertyUIWidgetList.this.property_.addPropertyChangeListener((IPropertyChangeListener)currWidget);
                if (newValuesIndex != null) {
                    PropertyUIWidgetList.this.update(0);
                    int[] indexes = new int[newValuesIndex.size()];
                    int i = 0;
                    while (i < newValuesIndex.size()) {
                        indexes[i] = newValuesIndex.get(i);
                        ++i;
                    }
                    Table table = PropertyUIWidgetList.this.tableViewer_.getTable();
                    table.setFocus();
                    table.setSelection(indexes);
                    table.showSelection();
                    PropertyUIWidgetList.this.updateRemoveButtonState();
                    ((IMultiValuedProperty)PropertyUIWidgetList.this.property_).setSelection(indexes);
                }
            }
        });
    }

    protected ArrayList<Integer> performBrowseFile() {
        String res;
        ArrayList<Integer> newValuesIndex = null;
        FileDialog fDialog = new FileDialog(this.shell_, 2);
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)this.property_) && CustomPropertyHelper.isMultiFileProperty((ICustomProperty)((ICustomProperty)this.property_))) {
            String[] exts = ((MultiFileProperty)this.property_).getFileExtensions();
            fDialog.setFilterExtensions(PropertyUIHelper.instance().getFileExtensions(exts));
        }
        if ((res = fDialog.open()) != null && res.length() > 0) {
            String path = fDialog.getFilterPath();
            String[] files = fDialog.getFileNames();
            if (files != null && files.length > 0) {
                newValuesIndex = new ArrayList<Integer>(files.length);
                if (files.length > 0) {
                    this.eventSender_.firePropertyUIComplexChanged(1, 0);
                }
                Table table = this.tableViewer_.getTable();
                int[] selectionIndices = table.getSelectionIndices();
                int index = table.getItemCount();
                if (selectionIndices != null && selectionIndices.length > 0) {
                    index = selectionIndices[0];
                }
                int i = 0;
                while (i < files.length) {
                    StringBuffer file = new StringBuffer(path);
                    file.append(File.separator);
                    file.append(files[i]);
                    if (this.addStringValue(file.toString(), index)) {
                        newValuesIndex.add(new Integer(index++));
                    }
                    this.eventSender_.firePropertyUIChange(null, res, 1);
                    ++i;
                }
                if (files.length > 0) {
                    this.eventSender_.firePropertyUIComplexChanged(1, 1);
                }
            }
        }
        return newValuesIndex;
    }

    protected ArrayList<Integer> performBrowseFolder() {
        String res;
        ArrayList<Integer> newValuesIndex = null;
        DirectoryDialog dialog = new DirectoryDialog(this.shell_);
        dialog.setMessage(this.property_.getDescription());
        if (this.lastSelection_ != null && this.lastSelection_.length() > 0) {
            dialog.setFilterPath(this.lastSelection_);
        }
        if ((res = dialog.open()) != null && res.length() > 0) {
            Table table = this.tableViewer_.getTable();
            int[] selectionIndices = table.getSelectionIndices();
            int index = table.getItemCount();
            if (selectionIndices != null && selectionIndices.length > 0) {
                index = selectionIndices[0];
            }
            if (this.addStringValue(res, index)) {
                newValuesIndex = new ArrayList<Integer>(1);
                newValuesIndex.add(new Integer(index));
            }
            this.eventSender_.firePropertyUIChange(null, res, 1);
        }
        return newValuesIndex;
    }

    protected ArrayList<Integer> performBrowseValue() {
        String[] validValues = ((IMultiValuedProperty)this.property_).allowDuplicateValues() ? this.propertyType_.getValidValuesAsStrings() : this.getFilteredValidValuesAsStrings();
        String label = validValues != null && validValues.length > 0 ? PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_SELECT_VALUES : PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_VALUE;
        PropertyUIValueSelectionDialog dialog = new PropertyUIValueSelectionDialog(this.shell_, validValues, label);
        dialog.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_WIN_TITLE_ADD);
        dialog.setValidValuesEditable(this.propertyType_.isValidValuesEditable());
        if (dialog.open() == 0) {
            return this.performSetValue(dialog.getResultsAsStrings());
        }
        return null;
    }

    protected ArrayList<Integer> performCustomizedBrowseValue() {
        try {
            Object ee = this.piExtInfo_.getExecutableExtension();
            if (ee instanceof IPropertyValueContributor) {
                IPropertyValueContributor ipvc = (IPropertyValueContributor)ee;
                ipvc.initialize((Control)this.getList(), this.property_);
                return this.performSetValue(ipvc.performAddValue());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected ArrayList<Integer> performBrowseJavaType() {
        return this.performSetValue(PropertyUIHelper.instance().browseJavaTypeAsString(((MultiJavaTypeProperty)this.property_).getImplementationTypes(), this.shell_, PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_OPEN_TYPE, PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_OPEN_TYPE_DESC, true));
    }

    protected ArrayList<Integer> performBrowseSchemaType() {
        return this.performSetValue(PropertyUIHelper.instance().browseSchemaTypeAsString(this.shell_, true));
    }

    protected ArrayList<Integer> performSetValue(String[] results) {
        ArrayList<Integer> newValuesIndex = null;
        if (results != null && results.length > 0) {
            Table table = this.tableViewer_.getTable();
            newValuesIndex = new ArrayList<Integer>(results.length);
            if (results.length > 0) {
                this.eventSender_.firePropertyUIComplexChanged(1, 0);
            }
            int[] selectionIndices = table.getSelectionIndices();
            int index = table.getItemCount();
            if (selectionIndices != null && selectionIndices.length > 0) {
                index = selectionIndices[0] + 1;
            }
            int i = 0;
            while (i < results.length) {
                if (results[i] != null) {
                    if (this.addStringValue(results[i], index)) {
                        newValuesIndex.add(new Integer(index++));
                    }
                    this.eventSender_.firePropertyUIChange(null, results[i], 1);
                }
                ++i;
            }
            if (results.length > 0) {
                this.eventSender_.firePropertyUIComplexChanged(1, 1);
            }
        }
        return newValuesIndex;
    }

    @Deprecated
    public void setValue(String newValue, int index) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ((IMultiValuedProperty)this.property_).addValueAsString(newValue, index);
            this.errorMessage_ = null;
            this.status_ = 0;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            this.errorMessage_ = status.getMessage();
            this.status_ = status.getSeverity();
        }
    }

    protected boolean addStringValue(String newValue, int index) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            ((IMultiValuedProperty)this.property_).addValueAsString(newValue, index);
            this.errorMessage_ = null;
            this.status_ = 0;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDisplayString(this.getWidgetLabel(false)), (String)status.getMessage());
            return status.getSeverity() != 4;
        }
        return true;
    }

    protected ArrayList<Integer> performRemoveValue() {
        ArrayList<Integer> newValuesString = null;
        IMultiValuedProperty property = (IMultiValuedProperty)this.property_;
        int[] indexes = this.tableViewer_.getTable().getSelectionIndices();
        Object[] removingItems = new Object[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            removingItems[i] = property.get(indexes[i]);
            ++i;
        }
        if (removingItems.length > 0) {
            this.eventSender_.firePropertyUIComplexChanged(2, 0);
        }
        i = 0;
        while (i < removingItems.length) {
            try {
                if (property.removeValue(removingItems[i])) {
                    this.errorMessage_ = null;
                    this.status_ = 0;
                }
                this.eventSender_.firePropertyUIChange(removingItems[i], null, 2);
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = e.toString();
                }
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getDisplayString(this.getWidgetLabel(false)), (String)errMsg);
                break;
            }
            ++i;
        }
        if (removingItems.length > 0) {
            newValuesString = new ArrayList<Integer>();
            this.eventSender_.firePropertyUIComplexChanged(2, 1);
        }
        this.updateRemoveButtonState();
        return newValuesString;
    }

    public void updateRemoveButtonState() {
        if (this.isEnabled() && this.tableViewer_.getTable().getSelectionCount() > 0) {
            this.removeButton_.setEnabled(true);
        } else {
            this.removeButton_.setEnabled(false);
        }
    }

    @Override
    public String getWidgetValue() {
        Table table = this.tableViewer_.getTable();
        if (table.getItemCount() < 1) {
            return null;
        }
        if (table.getSelectionCount() < 1) {
            return table.getItem(0).getText();
        }
        return table.getItem(table.getSelectionIndex()).getText();
    }

    @Override
    public void setWidgetValue(String newValue) {
        this.setWidgetValue(newValue, true);
    }

    @Override
    public void setWidgetValue(String newValue, boolean applyToProperty) {
        if (newValue == null) {
            return;
        }
        if (this.inputList_.indexOf(newValue) == -1) {
            this.inputList_.add(this.processText(newValue));
            if (applyToProperty) {
                this.setValue(newValue);
            }
        }
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                this.populateValues();
                break;
            }
            case 3: {
                this.updateButtonStatus();
                break;
            }
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.updateRemoveButtonState();
        }
    }

    protected void populateValues() {
        String[] values = ((IMultiValuedProperty)this.property_).getValuesAsStrings();
        if (values != null) {
            this.inputList_ = new ArrayList(values.length);
            int i = 0;
            while (i < values.length) {
                this.inputList_.add(values[i]);
                ++i;
            }
        }
        this.tableViewer_.setInput(this.inputList_);
        this.tableViewer_.setSelection(null);
        this.updateButtonStatus();
    }

    public void setColumnNo(int newValue) {
        this.columnNo_ = newValue;
    }

    public void setButtonType(int newValue) {
        this.buttonType_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        if (this.filler_ == null) {
            return new Control[]{this.label_, this.tableViewer_.getTable(), this.addButton_, this.removeButton_};
        }
        return new Control[]{this.label_, this.tableViewer_.getTable(), this.addButton_, this.removeButton_, this.filler_};
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.addButton_;
    }

    public Table getList() {
        return this.tableViewer_.getTable();
    }

    @Override
    public Control[] getHelpControls() {
        return new Control[]{this.tableViewer_.getTable()};
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber != this.columnNo_) {
            this.columnNo_ = newNumber;
            GridData gd = (GridData)this.label_.getLayoutData();
            gd.horizontalSpan = this.columnNo_;
            if (this.columnNo_ - 2 - 1 > 0) {
                if (this.filler_ != null) {
                    gd = (GridData)this.filler_.getLayoutData();
                    gd.horizontalSpan = this.columnNo_ - 2 - 1;
                } else {
                    this.addFillers(this.tableViewer_.getTable().getParent(), this.columnNo_ - 2 - 1);
                    this.filler_.moveBelow((Control)this.addButton_);
                }
            } else if (this.filler_ != null) {
                this.filler_.dispose();
                this.filler_ = null;
            }
        }
    }

    protected void updateButtonStatus() {
        if (this.isEnabled()) {
            if (((IMultiValuedProperty)this.property_).allowDuplicateValues()) {
                this.addButton_.setEnabled(true);
            } else {
                Object[] values = ((IMultiValuedProperty)this.property_).getValues();
                Object[] validValues = this.propertyType_.getValidValues();
                if (validValues == null || validValues.length < 1) {
                    this.addButton_.setEnabled(true);
                } else if (values == null || values.length < 1) {
                    this.addButton_.setEnabled(true);
                } else if (values.length < validValues.length) {
                    this.addButton_.setEnabled(true);
                } else {
                    String[] filteredValidValues = this.getFilteredValidValuesAsStrings();
                    if (filteredValidValues != null && filteredValidValues.length > 0) {
                        this.addButton_.setEnabled(true);
                    } else {
                        this.addButton_.setEnabled(false);
                    }
                }
            }
        } else {
            this.addButton_.setEnabled(false);
        }
        this.updateRemoveButtonState();
    }

    protected String[] getFilteredValidValuesAsStrings() {
        ArrayList<String> filteredValues = new ArrayList<String>();
        String[] validValues = this.propertyType_.getValidValuesAsStrings();
        if (validValues != null && validValues.length > 0) {
            int i = 0;
            while (i < validValues.length) {
                filteredValues.add(validValues[i]);
                ++i;
            }
            String[] values = ((IMultiValuedProperty)this.property_).getValuesAsStrings();
            if (values != null) {
                int i2 = 0;
                while (i2 < values.length) {
                    filteredValues.remove(values[i2]);
                    ++i2;
                }
            }
        }
        if (filteredValues.isEmpty()) {
            return null;
        }
        String[] strs = new String[filteredValues.size()];
        filteredValues.toArray(strs);
        return strs;
    }

    protected class ListViewerProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        protected ListViewerProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object o, int columnIndex) {
            if (o instanceof String) {
                return (String)o;
            }
            return "";
        }

        public Object[] getElements(Object o) {
            if (o instanceof Collection) {
                return ((Collection)o).toArray();
            }
            return new Object[0];
        }
    }
}

