/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetDecorator;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import java.util.ArrayList;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class PropertyUIWidgetComboBox
extends PropertyUIWidgetProperty
implements PaintListener {
    protected Control label_;
    protected Composite combo_;
    protected int columnNo_ = 1;
    protected ArrayList<Object> mnemonics_;
    protected ArrayList<Object> values_;

    public PropertyUIWidgetComboBox(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetComboBox(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetComboBox(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.columnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        this.createLabel(parent);
        this.createCombobox(parent);
        if (this.isValidValuesEditable() && this.isRequired()) {
            this.addPaintListener(this);
        }
        if (this.columnNo_ > 1) {
            this.addFillers(parent, this.columnNo_ - 1);
        }
        this.initDefaultValue();
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void createLabel(Composite parent) {
        this.label_ = this.createWidgetLabel(parent);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        this.label_.setLayoutData((Object)gd);
        if (this.isValidValuesEditable() && this.isRequired()) {
            GC gc = new GC((Drawable)this.label_);
            gd.widthHint = this.label_ instanceof Label ? gc.stringExtent((String)((Label)this.label_).getText()).x + gc.stringExtent((String)"*").x : gc.stringExtent((String)((Hyperlink)this.label_).getText()).x + gc.stringExtent((String)"*").x;
            gc.dispose();
        }
    }

    protected void createCombobox(Composite parent) {
        int style = 8;
        if (this.isValidValuesEditable()) {
            style = 0;
        }
        this.combo_ = this.widgetStyle_ == -1 ? this.factory_.createCombo(parent, this.factory_.getBorderStyle() | style) : this.factory_.createCombo(parent, this.widgetStyle_);
        this.addHoverManager((Control)this.combo_, this.property_.getDescription());
        this.combo_.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 10;
        this.combo_.setLayoutData((Object)gd);
    }

    @Override
    public void initDefaultValue() {
        this.combo_.removeListener(24, (Listener)this);
        this.populateValues();
        Object defaultValue = this.getDefaultValue();
        Object value = this.getValue();
        String widgetDefaultValue = null;
        if (this.combo_ instanceof Combo) {
            Combo combo = (Combo)this.combo_;
            if (value != null && (widgetDefaultValue = this.getMnemonicsValue(value).toString()) != null) {
                if (this.isValidValuesEditable()) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
                if (combo.indexOf(widgetDefaultValue) != -1) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
            }
            if (defaultValue != null && (widgetDefaultValue = this.getMnemonicsValue(defaultValue).toString()) != null) {
                if (this.isValidValuesEditable()) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.setValue(defaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
                if (combo.indexOf(widgetDefaultValue) != -1) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.setValue(defaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
            }
            if (!this.isValidValuesEditable()) {
                if (combo.getItemCount() > 0) {
                    widgetDefaultValue = combo.getItem(0);
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.setValue(this.getPropertyValue(widgetDefaultValue));
                }
                if (!this.combo_.isDisposed()) {
                    this.combo_.addListener(24, (Listener)this);
                }
                return;
            }
        } else if (this.combo_ instanceof CCombo) {
            CCombo combo = (CCombo)this.combo_;
            if (value != null && (widgetDefaultValue = this.getMnemonicsValue(value).toString()) != null) {
                if (this.isValidValuesEditable()) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
                if (combo.indexOf(widgetDefaultValue) != -1) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
            }
            if (defaultValue != null && (widgetDefaultValue = this.getMnemonicsValue(defaultValue).toString()) != null) {
                if (this.isValidValuesEditable()) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.setValue(defaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
                if (combo.indexOf(widgetDefaultValue) != -1) {
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.setValue(defaultValue);
                    this.combo_.addListener(24, (Listener)this);
                    return;
                }
            }
            if (!this.isValidValuesEditable()) {
                if (combo.getItemCount() > 0) {
                    widgetDefaultValue = combo.getItem(0);
                    this.setStringToSWTControl(widgetDefaultValue);
                    this.setValue(this.getPropertyValue(widgetDefaultValue));
                }
                if (!this.combo_.isDisposed()) {
                    this.combo_.addListener(24, (Listener)this);
                }
                return;
            }
        }
        this.combo_.addListener(24, (Listener)this);
    }

    @Override
    public String getWidgetValue() {
        if (this.combo_ instanceof Combo) {
            return ((Combo)this.combo_).getText();
        }
        if (this.combo_ instanceof CCombo) {
            return ((CCombo)this.combo_).getText();
        }
        return null;
    }

    @Override
    public void setWidgetValue(String newValue) {
        this.setStringToSWTControl(newValue);
    }

    @Override
    public void setWidgetValue(String newValue, boolean applyToProperty) {
        if (!applyToProperty) {
            this.combo_.removeListener(24, (Listener)this);
        }
        this.setStringToSWTControl(newValue);
        if (!applyToProperty) {
            this.combo_.addListener(24, (Listener)this);
        }
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                if (this.isValueSyn()) break;
                this.handlePropertyValueChanged();
                break;
            }
            case 3: {
                this.initDefaultValue();
                break;
            }
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label_.getParent().redraw();
    }

    protected void handlePropertyValueChanged() {
        Object value = this.getMnemonicsValue(this.getValue());
        String newValue = null;
        if (value != null) {
            newValue = value.toString();
        }
        this.combo_.removeListener(24, (Listener)this);
        if (newValue != null) {
            if (this.combo_ instanceof Combo) {
                Combo combo = (Combo)this.combo_;
                boolean editable = this.isValidValuesEditable();
                if (combo.indexOf(newValue) == -1 && !editable) {
                    combo.add(newValue);
                }
                this.setStringToSWTControl(newValue);
                if (editable && this.combo_.isFocusControl()) {
                    int stringLength = combo.getText().length();
                    ((Combo)this.combo_).setSelection(new Point(stringLength, stringLength));
                }
            } else if (this.combo_ instanceof CCombo) {
                CCombo combo = (CCombo)this.combo_;
                boolean editable = this.isValidValuesEditable();
                if (combo.indexOf(newValue) == -1 && !editable) {
                    combo.add(newValue);
                }
                this.setStringToSWTControl(newValue);
                if (editable && this.combo_.isFocusControl()) {
                    int stringLength = combo.getText().length();
                    ((CCombo)this.combo_).setSelection(new Point(stringLength, stringLength));
                }
            }
        } else if (this.combo_ instanceof Combo) {
            ((Combo)this.combo_).clearSelection();
            if (this.isValidValuesEditable()) {
                ((Combo)this.combo_).setText("");
            }
        } else if (this.combo_ instanceof CCombo) {
            ((CCombo)this.combo_).clearSelection();
            if (this.isValidValuesEditable()) {
                ((CCombo)this.combo_).setText("");
            }
        }
        this.combo_.addListener(24, (Listener)this);
    }

    public Composite getComboBox() {
        return this.combo_;
    }

    public void setColumnNo(int newValue) {
        this.columnNo_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        if (this.filler_ != null) {
            return new Control[]{this.label_, this.combo_, this.filler_};
        }
        return new Control[]{this.label_, this.combo_};
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.combo_;
    }

    @Override
    public void setValue(Object newValue) {
        if (newValue == null) {
            this.setNullValue(null);
        } else {
            super.setValue(newValue);
        }
    }

    @Override
    public void setValue(String newValue) {
        if (newValue == null || newValue.length() < 1) {
            this.setNullValue(newValue);
        } else {
            super.setValue(newValue);
        }
    }

    protected void setNullValue(Object newValue) {
        if (!this.isValidValuesEditable()) {
            Object[] validValues = this.propertyType_.getValidValues();
            boolean nullable = false;
            if (newValue != null) {
                int i = 0;
                while (i < validValues.length) {
                    if (newValue.equals(validValues[i])) {
                        newValue = validValues[i];
                        nullable = true;
                        break;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < validValues.length) {
                    if (validValues[i] == null) {
                        nullable = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!nullable) {
                return;
            }
        } else if (newValue != null && newValue instanceof String && ((String)newValue).length() < 1) {
            boolean foundValidValue = false;
            Object[] validValues = this.propertyType_.getValidValues();
            int i = 0;
            while (i < validValues.length) {
                if (newValue.equals(validValues[i])) {
                    newValue = validValues[i];
                    foundValidValue = true;
                    break;
                }
                ++i;
            }
            if (!foundValidValue) {
                newValue = null;
            }
        }
        if (newValue instanceof String) {
            super.setValue((String)newValue);
        } else {
            super.setValue(newValue);
        }
    }

    @Override
    public void handleEvent(Event event) {
        Object oldValue;
        Object newValue = this.getPropertyValue(this.getWidgetValue());
        if (newValue.equals(oldValue = this.getValue()) && this.status_ != 4) {
            return;
        }
        this.setValue(newValue);
        this.eventSender_.firePropertyUIChange(oldValue, newValue);
    }

    public void setMnemonics(ArrayList<Object> newList) {
        this.mnemonics_ = newList;
    }

    public void setPropertyValues(ArrayList<Object> newValues) {
        this.values_ = newValues;
    }

    protected void populateValues() {
        String[] popItems;
        if (this.combo_ instanceof Combo) {
            ((Combo)this.combo_).removeAll();
        } else if (this.combo_ instanceof CCombo) {
            ((CCombo)this.combo_).removeAll();
        }
        if (this.mnemonics_ != null && !this.mnemonics_.isEmpty() || this.getValidValuesAsStrings() == null) {
            Object[] items = this.getValidValues();
            popItems = new String[items.length];
            int i = 0;
            while (i < items.length) {
                Object value = this.getMnemonicsValue(items[i]);
                popItems[i] = value != null ? value.toString() : "";
                ++i;
            }
        } else {
            String[] items = this.getValidValuesAsStrings();
            popItems = new String[items.length];
            int i = 0;
            while (i < items.length) {
                popItems[i] = items[i];
                ++i;
            }
        }
        if (this.combo_ instanceof Combo) {
            ((Combo)this.combo_).setItems(this.processText(popItems));
        } else if (this.combo_ instanceof CCombo) {
            ((CCombo)this.combo_).setItems(this.processText(popItems));
        }
    }

    protected Object getMnemonicsValue(Object value) {
        int index = -1;
        if (this.values_ != null) {
            index = this.values_.indexOf(value);
        }
        if (this.mnemonics_ != null && index != -1 && index < this.mnemonics_.size()) {
            return this.mnemonics_.get(index);
        }
        return value;
    }

    protected Object getPropertyValue(String value) {
        int index = -1;
        if (this.mnemonics_ != null) {
            index = this.mnemonics_.indexOf(value);
        }
        if (this.values_ != null && index != -1 && index < this.values_.size()) {
            return this.values_.get(index);
        }
        return value;
    }

    @Override
    protected boolean isValueSyn() {
        Object currValue = this.getValue();
        Object value = this.getMnemonicsValue(currValue);
        String newValue = this.getValueAsString();
        if (currValue != null && !currValue.equals(value)) {
            newValue = value.toString();
        }
        String widgetValue = this.getWidgetValue();
        if (newValue == null && widgetValue == null) {
            return true;
        }
        if (widgetValue.length() < 1 && newValue == null) {
            return true;
        }
        return newValue != null && newValue.equals(widgetValue) || widgetValue != null && widgetValue.equals(newValue);
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber - 1 != this.columnNo_) {
            this.columnNo_ = newNumber - 1;
            if (this.filler_ != null) {
                if (this.columnNo_ > 1) {
                    GridData gd = (GridData)this.filler_.getLayoutData();
                    gd.horizontalSpan = this.columnNo_ - 1;
                } else {
                    this.filler_.dispose();
                    this.filler_ = null;
                }
            } else if (this.columnNo_ > 1) {
                this.addFillers(this.combo_.getParent(), this.columnNo_ - 1);
                this.filler_.moveBelow((Control)this.combo_);
            }
        }
    }

    public void addPaintListener(PaintListener listener) {
        this.label_.addPaintListener((PaintListener)this);
        this.label_.getParent().addPaintListener((PaintListener)this);
    }

    public void paintControl(PaintEvent e) {
        if (this.isRequired() && this.isEnabled() && this.label_ != null && !this.label_.isDisposed() && !e.widget.isDisposed()) {
            String requiredLabel = "*";
            Rectangle lBounds = this.label_.getBounds();
            Point tLoc = this.combo_.getLocation();
            GridLayout layout = (GridLayout)this.label_.getParent().getLayout();
            int hSpace = 5;
            if (layout != null) {
                hSpace = layout.horizontalSpacing;
            }
            Point global = this.label_.toDisplay(tLoc.x - lBounds.x - hSpace - e.gc.stringExtent((String)requiredLabel).x, 2);
            Point local = ((Control)e.widget).toControl(global);
            e.gc.drawString(requiredLabel, local.x, local.y, true);
        }
    }

    protected void setStringToSWTControl(String str) {
        if (this.combo_ instanceof Combo) {
            ((Combo)this.combo_).setText(this.processText(str));
        } else if (this.combo_ instanceof CCombo) {
            ((CCombo)this.combo_).setText(this.processText(str));
        }
    }

    @Override
    public void decorateUIWidget(Image image, int position, String hoverHelp, Runnable action) {
        if (this.decorator_ == null) {
            this.decorator_ = new PropertyUIWidgetDecorator((Control)this.combo_);
        }
        this.decorator_.setOffset(2, 0);
        this.decorator_.decorateUIWidget(image, position, hoverHelp, true, action);
    }
}

