/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class PropertyUIJavaDataTypeHierarchyScope
implements IJavaSearchScope {
    private IType[] searchTypes_;
    private WorkingCopyOwner owner_;
    private boolean needsRefresh_;
    private IPath[] enclosingProjectsAndJars_;
    private IResource[] enclosingProjects_;
    private HashSet resourcePaths_;
    protected HashSet elements_;

    public PropertyUIJavaDataTypeHierarchyScope(IType[] types, WorkingCopyOwner owner, IResource[] resources) throws JavaModelException {
        this.searchTypes_ = types;
        this.needsRefresh_ = true;
        this.owner_ = owner;
        this.enclosingProjects_ = resources;
        this.enclosingProjectsAndJars_ = this.computeProjectsAndJars(types);
    }

    protected IPath[] computeProjectsAndJars(IType[] types) throws JavaModelException {
        ArrayList<IPath> returnPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < types.length) {
            IPath[] paths = this.computeProjectsAndJars(types[i]);
            int j = 0;
            while (j < paths.length) {
                if (returnPaths.indexOf(paths[j]) == -1) {
                    returnPaths.add(paths[j]);
                }
                ++j;
            }
            ++i;
        }
        IPath[] result = new IPath[returnPaths.size()];
        returnPaths.toArray(result);
        return result;
    }

    protected IPath[] computeProjectsAndJars(IType type) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            IPath rootPath = root.getPath();
            HashSet visited = new HashSet();
            int i = 0;
            while (i < this.enclosingProjects_.length) {
                IJavaProject project = (IJavaProject)JavaCore.create((IResource)this.enclosingProjects_[i]);
                IClasspathEntry[] classpath = project.getResolvedClasspath(true);
                int j = 0;
                while (j < classpath.length) {
                    if (rootPath.equals((Object)classpath[j].getPath())) {
                        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                        set.add(project.getPath());
                        int k = 0;
                        while (k < roots.length) {
                            IPackageFragmentRoot pkgFragmentRoot = roots[k];
                            if (pkgFragmentRoot.getKind() == 2) {
                                set.add(pkgFragmentRoot.getPath());
                            }
                            ++k;
                        }
                        if (visited.contains(project)) break;
                        this.computeDependents(project, set, visited);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            IJavaProject project = (IJavaProject)root.getParent();
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot pkgFragmentRoot = roots[i];
                if (pkgFragmentRoot.getKind() == 2) {
                    set.add(pkgFragmentRoot.getParent().getPath());
                } else {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++i;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    protected void computeDependents(IJavaProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject currentProject = project.getProject();
        IProject[] dependents = currentProject.getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            if (!currentProject.equals((Object)dependents[i])) {
                try {
                    IJavaProject dependent = JavaCore.create((IProject)dependents[i]);
                    IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                    set.add(dependent.getPath());
                    int j = 0;
                    while (j < roots.length) {
                        IPackageFragmentRoot pkgFragmentRoot = roots[j];
                        if (pkgFragmentRoot.isArchive()) {
                            set.add(pkgFragmentRoot.getPath());
                        }
                        ++j;
                    }
                    this.computeDependents(dependent, set, visited);
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i;
        }
    }

    protected void initialize() {
        if (this.searchTypes_ == null || !this.needsRefresh_) {
            return;
        }
        this.resourcePaths_ = new HashSet();
        this.needsRefresh_ = false;
        this.elements_ = new HashSet();
        this.reComputeTypesProjectsAndJars();
    }

    protected void reComputeTypesProjectsAndJars() {
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            int k = 0;
            while (k < this.searchTypes_.length) {
                IType[] subTypes = this.searchTypes_[k].newTypeHierarchy(this.owner_, null).getAllTypes();
                int i = 0;
                while (i < subTypes.length) {
                    block8: {
                        block9: {
                            String fileName;
                            IPath path;
                            block11: {
                                block10: {
                                    IPackageFragmentRoot root;
                                    IResource resource = subTypes[i].getResource();
                                    if (resource != null && !this.checkProject(resource.getProject()) || "java.lang.Object".equals(subTypes[i].getFullyQualifiedName())) break block8;
                                    if (resource != null && resources.get(resource) == null) {
                                        resources.put(resource, resource);
                                        this.elements_.add(resource.getFullPath().toString());
                                    }
                                    if (!((root = (IPackageFragmentRoot)subTypes[i].getPackageFragment().getParent()) instanceof IPackageFragmentRoot)) break block9;
                                    path = root.getPath();
                                    IResource rootResource = workspaceRoot.findMember(path);
                                    fileName = null;
                                    if (rootResource == null) break block10;
                                    fileName = path.toString();
                                    break block11;
                                }
                                if (!path.isAbsolute()) break block8;
                                fileName = path.toFile().getPath();
                            }
                            StringBuffer resourcePath = new StringBuffer(fileName);
                            resourcePath.append("|").append(subTypes[i].getFullyQualifiedName().replace('.', '/')).append(".class");
                            this.resourcePaths_.add(resourcePath.toString());
                            paths.put(path, subTypes[i]);
                            break block8;
                        }
                        paths.put(subTypes[i].getJavaProject().getProject().getFullPath(), subTypes[i]);
                    }
                    ++i;
                }
                ++k;
            }
            this.enclosingProjectsAndJars_ = new IPath[paths.size()];
            int i = 0;
            Iterator iter = paths.keySet().iterator();
            while (iter.hasNext()) {
                this.enclosingProjectsAndJars_[i++] = (IPath)iter.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.needsRefresh_) {
            this.initialize();
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.resourcePaths_.contains(resourcePath);
        }
        return this.elements_.contains(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars_;
    }

    protected void refresh() {
        this.initialize();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    protected boolean checkProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (this.enclosingProjects_ == null) {
            return true;
        }
        int i = 0;
        while (i < this.enclosingProjects_.length) {
            if (project.equals((Object)this.enclosingProjects_[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

