/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.jobs;

import com.ibm.propertygroup.ui.internal.jobs.FetchTypesFromXSDJob;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FetchTypesFromXSDRunnable
implements IRunnableWithProgress {
    private FetchTypesFromXSDJob job;

    public FetchTypesFromXSDRunnable(String fullPath) {
        this.job = new FetchTypesFromXSDJob(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_PROGRESS_GETTING_NAMES, fullPath);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        boolean loop = true;
        int interval = 1000;
        int totalTime = 0;
        int units = 60;
        progressMonitor.beginTask(PropertyUIMessages.PROPERTY_UI_DIALOG_XSD_TYPE_PROGRESS_RETRIEVE, units);
        JobCompletionListener listen = new JobCompletionListener();
        this.job.addJobChangeListener(listen);
        this.job.schedule();
        try {
            try {
                while (loop) {
                    if (listen.done) {
                        loop = false;
                    } else {
                        Thread.sleep(interval);
                        totalTime += interval;
                    }
                    progressMonitor.worked(1);
                    if (!progressMonitor.isCanceled()) continue;
                    this.job.cancel();
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception exception) {
                progressMonitor.worked(units);
            }
        }
        finally {
            progressMonitor.worked(units);
        }
    }

    public Object[] getXSDTypes() {
        if (this.job != null) {
            return this.job.getXSDTypes();
        }
        return null;
    }

    private class JobCompletionListener
    extends JobChangeAdapter
    implements IJobChangeListener {
        public boolean done = false;

        public void done(IJobChangeEvent event) {
            this.done = true;
        }
    }
}

