/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.datastores;

import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.datastores.PStore;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetText_Base;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DynamicPropStore
extends PStore {
    protected AbstractUIPlugin plugin_ = null;
    protected ArrayList addedProperties_ = new ArrayList();

    private DynamicPropStore() {
    }

    public DynamicPropStore(AbstractUIPlugin plugin) {
        this.plugin_ = plugin;
    }

    public void storePropertyGroups(String rootName, String customPropertyName, String customName, IPropertyGroup properties) {
        ArrayList propertyList;
        if (properties == null) {
            return;
        }
        IDialogSettings J2CSection = DynamicPropStore.getDialogSettings(this.plugin_);
        if (J2CSection == null) {
            return;
        }
        IDialogSettings myRootSection = DynamicPropStore.getDialogSettings(J2CSection, rootName);
        if (myRootSection == null) {
            myRootSection = DynamicPropStore.setDialogSettings(J2CSection, rootName);
        }
        if (customPropertyName != null && customPropertyName.length() > 0 && customName != null && customName.length() > 0) {
            this.persistForSuggestion(myRootSection, customPropertyName, customName);
        }
        if ((propertyList = this.getAllLeafProperties(properties)).isEmpty()) {
            return;
        }
        for (ISingleTypedProperty prop : propertyList) {
            if (prop == null || !prop.isEnabled() || !prop.isSet() || prop.getPropertyType().isSensitive() || prop.getPropertyType().isReadOnly()) continue;
            String propPath = PropertyUtil.getPropertyPath((IPropertyDescriptor)prop).toPortableString();
            propPath = propPath.replace('/', ':');
            this.storeBaseProperty(myRootSection, customName, propPath, prop);
        }
    }

    public void restorePropertyGroups(String rootName, String customName, IPropertyGroup properties) {
        if (properties == null) {
            return;
        }
        IDialogSettings J2CSection = DynamicPropStore.getDialogSettings(this.plugin_);
        if (J2CSection == null) {
            return;
        }
        IDialogSettings rootSection = DynamicPropStore.getDialogSettings(J2CSection, rootName);
        if (rootSection == null) {
            return;
        }
        IDialogSettings mySection = DynamicPropStore.getDialogSettings(rootSection, customName);
        if (mySection == null) {
            return;
        }
        ArrayList propertyList = this.getAllLeafProperties(properties);
        if (propertyList.isEmpty()) {
            return;
        }
        ArrayList propertyGroupList = this.getAllPropertyGroups(properties);
        PropChangeListener listener = new PropChangeListener();
        this.addedProperties_.clear();
        for (IPropertyGroup element : propertyGroupList) {
            element.addPropertyChangeListener((IPropertyChangeListener)listener);
        }
        this.setPropertyValues(rootSection, mySection, propertyList);
        if (!this.addedProperties_.isEmpty()) {
            this.setPropertyValues(rootSection, mySection, this.addedProperties_);
        }
        for (IPropertyGroup element : propertyGroupList) {
            element.removePropertyChangeListener((IPropertyChangeListener)listener);
        }
    }

    private void setPropertyValues(IDialogSettings rootSection, IDialogSettings mySection, ArrayList propertyList) {
        for (ISingleTypedProperty prop : propertyList) {
            if (prop == null || !prop.isEnabled() || prop.getPropertyType().isReadOnly() || prop.getPropertyType().isSensitive()) continue;
            try {
                String key = PropertyUtil.getPropertyPath((IPropertyDescriptor)prop).toPortableString();
                key = key.replace('/', ':');
                if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)prop)) {
                    String value = DynamicPropStore.get(mySection, key);
                    if (value == null || value.length() <= 0 || value.equals("CoreUInull")) continue;
                    PropertyUtil.setValueAsString((IPropertyDescriptor)prop, value);
                    continue;
                }
                if (!PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)prop)) continue;
                String[] values = DynamicPropStore.getArray(rootSection, key);
                if (values == null) {
                    values = DynamicPropStore.getArray(mySection, key);
                }
                if (values == null || values.length <= 0) continue;
                PropertyUtil.setValuesAsStrings((IPropertyDescriptor)prop, values);
            }
            catch (CoreException coreException) {}
        }
    }

    public void storePropertyGroups(IDialogSettings rootSection, IDialogSettings parentSection, String ancestorName, IPropertyGroup properties, boolean isChildren) {
        if (properties == null) {
            return;
        }
        String myGpName = properties.getName();
        String mylongName = String.valueOf(ancestorName) + ":" + myGpName;
        IPropertyDescriptor[] propList = properties.getProperties();
        if (propList == null) {
            return;
        }
        int i = 0;
        while (i < propList.length) {
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                this.storeBaseProperty(rootSection, parentSection, mylongName, (ISingleTypedProperty)ipd, isChildren);
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                IPropertyGroup bpg = (IPropertyGroup)ipd;
                IDialogSettings newParentSection = DynamicPropStore.getDialogSettings(parentSection, myGpName);
                if (newParentSection == null) {
                    newParentSection = DynamicPropStore.setDialogSettings(parentSection, myGpName);
                }
                this.storePropertyGroups(rootSection, newParentSection, mylongName, bpg, isChildren);
            }
            ++i;
        }
    }

    public void storeBaseProperty(IDialogSettings rootSection, IDialogSettings parentSection, String ancestorName, ISingleTypedProperty property, boolean isChildren) {
        String myPropName = property.getName();
        String myLongPropName = String.valueOf(ancestorName) + ":" + myPropName;
        if (PropertyUtil.isSensitive((IPropertyDescriptor)property)) {
            return;
        }
        if (PropertyHelper.isCustomProperty((IPropertyDescriptor)property)) {
            String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
            this.persistForSuggestion(parentSection, myPropName, value);
            this.persistLastSetting(rootSection, "", myLongPropName, value);
        } else if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            if (((ISingleValuedProperty)property).getValue() != null) {
                String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
                this.persistForSuggestion(parentSection, myPropName, value);
                this.persistLastSetting(rootSection, "", myLongPropName, value);
            } else {
                String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
                if (value == null) {
                    this.persistLastSetting(rootSection, "", myLongPropName, value);
                }
            }
        }
    }

    public void restorePropertyGroups(IDialogSettings rootSection, IDialogSettings parentSection, String ancestorName, IPropertyGroup properties, boolean isChildren) {
        if (properties == null) {
            return;
        }
        String myGpName = properties.getName();
        String mylongName = String.valueOf(ancestorName) + ":" + myGpName;
        IPropertyDescriptor[] propList = properties.getProperties();
        if (propList == null) {
            return;
        }
        int i = 0;
        while (i < propList.length) {
            IPropertyGroup bpg;
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                this.restoreBaseProperty(rootSection, parentSection, mylongName, (ISingleTypedProperty)ipd, isChildren);
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) && (bpg = (IPropertyGroup)ipd).getProperties() != null && bpg.getProperties().length >= 1) {
                String myGpName1 = bpg.getName();
                IDialogSettings newParentSection = DynamicPropStore.getDialogSettings(parentSection, myGpName1);
                if (newParentSection != null) {
                    this.restorePropertyGroups(rootSection, newParentSection, mylongName, bpg, isChildren);
                } else {
                    this.restorePropertyGroups(rootSection, parentSection, mylongName, bpg, isChildren);
                }
            }
            ++i;
        }
    }

    public void restoreBaseProperty(IDialogSettings rootSection, IDialogSettings parentSection, String ancestorName, ISingleTypedProperty property, boolean isChildren) {
        String myPropName = property.getName();
        String myLongPropName = String.valueOf(ancestorName) + ":" + myPropName;
        if (PropertyUtil.isSensitive((IPropertyDescriptor)property)) {
            return;
        }
        if (PropertyUtil.isReadOnly((IPropertyDescriptor)property)) {
            return;
        }
        if (!PropertyUtil.isEnabled((IPropertyDescriptor)property)) {
            return;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            this.restoreLastSetting(parentSection, myLongPropName, (ISingleValuedProperty)property);
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            this.restoreLastSetting(rootSection, myLongPropName, (IMultiValuedProperty)property);
        }
    }

    public void restoreLastSetting(IDialogSettings parentSection, String myLongPropName, ISingleValuedProperty property) {
        String value = null;
        try {
            value = DynamicPropStore.get(parentSection, myLongPropName);
            if (value != null && value.length() > 0 && !value.equals("CoreUInull")) {
                PropertyUtil.setValueAsString((IPropertyDescriptor)property, value);
            }
        }
        catch (Exception exception) {}
    }

    public void restoreLastSetting(IDialogSettings rootSection, String myLongPropName, IMultiValuedProperty property) {
        try {
            String[] values = DynamicPropStore.getArray(rootSection, myLongPropName);
            if (values != null && values.length > 0) {
                ArrayList aList = this.convertToArrayList(values);
                PropertyUtil.setValues((IPropertyDescriptor)property, aList);
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList restoreSuggestions(String rootName, IPropertyGroup properties, String propertyName) {
        ArrayList suggestions = new ArrayList();
        IDialogSettings mySection = null;
        IDialogSettings rootSection = null;
        IDialogSettings J2CSection = DynamicPropStore.getDialogSettings(this.plugin_);
        if (J2CSection == null) {
            return suggestions;
        }
        rootSection = DynamicPropStore.getDialogSettings(J2CSection, rootName);
        if (rootSection == null) {
            return suggestions;
        }
        String parentSectionName = properties.getName();
        mySection = DynamicPropStore.getDialogSettings(rootSection, parentSectionName);
        if (mySection == null) {
            return suggestions;
        }
        IPropertyDescriptor[] propList = properties.getProperties();
        if (propList == null) {
            return suggestions;
        }
        int i = 0;
        while (i < propList.length) {
            IPropertyGroup bpg;
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                String myGroupName = ipd.getName();
                if (myGroupName.equals(propertyName)) {
                    return this.restoreSuggestions(mySection, myGroupName);
                }
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) && (bpg = (IPropertyGroup)ipd).getProperties() != null && bpg.getProperties().length >= 1) {
                ArrayList list;
                String myGroupName = bpg.getName();
                IDialogSettings mySection1 = DynamicPropStore.getDialogSettings(mySection, myGroupName);
                if (mySection1 != null) {
                    list = this.restorePropertyGroups(mySection1, bpg, propertyName);
                    if (list.size() != 0) return list;
                    list = this.restoreSuggestions(mySection, propertyName);
                    if (list.size() != 0) {
                        return list;
                    }
                } else {
                    list = this.restorePropertyGroups(mySection, bpg, propertyName);
                    if (list.size() > 0) {
                        return list;
                    }
                }
            }
            ++i;
        }
        return suggestions;
    }

    public ArrayList restorePropertyGroups(IDialogSettings mySection, IPropertyGroup properties, String propertyName) {
        ArrayList suggestions = new ArrayList();
        IPropertyDescriptor[] propList = properties.getProperties();
        if (propList == null) {
            return suggestions;
        }
        int i = 0;
        while (i < propList.length) {
            ArrayList list;
            String myGroupName;
            IPropertyGroup bpg;
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)ipd)) {
                String myGroupName2 = ipd.getName();
                if (myGroupName2.equals(propertyName)) {
                    return this.restoreSuggestions(mySection, myGroupName2);
                }
            } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) && (bpg = (IPropertyGroup)ipd).getProperties() != null && bpg.getProperties().length >= 1 && ((mySection = DynamicPropStore.getDialogSettings(mySection, myGroupName = bpg.getName())) != null ? (list = this.restorePropertyGroups(mySection, bpg, propertyName)).size() != 0 : (list = this.restoreSuggestions(mySection, propertyName)).size() != 0)) {
                return list;
            }
            ++i;
        }
        return suggestions;
    }

    public ArrayList restoreCustomProperties(String rootName, String customPropertyName) {
        ArrayList customs = new ArrayList();
        IDialogSettings J2CSection = this.getDialogSettings();
        if (J2CSection == null) {
            return customs;
        }
        IDialogSettings rootSection = PStore.getDialogSettings(J2CSection, rootName);
        if (rootSection == null) {
            return customs;
        }
        String[] customProperties = DynamicPropStore.getArray(rootSection, customPropertyName);
        if (customProperties != null && customProperties.length > 0) {
            customs = this.convertToArrayList(customProperties);
        }
        return customs;
    }

    public void storeCustomProperties(String rootName, String sectionName, String customPropertyName, String customPropertyValue) {
        ArrayList customs = new ArrayList();
        if (customPropertyName == null || customPropertyName.length() == 0) {
            return;
        }
        IDialogSettings rootSection = DynamicPropStore.getDialogSettings(this.plugin_, rootName);
        if (rootSection == null) {
            rootSection = DynamicPropStore.setDialogSettings(this.plugin_, rootName);
        }
        IDialogSettings customSection = null;
        if (sectionName != null) {
            customSection = DynamicPropStore.getDialogSettings(rootSection, sectionName);
            if (customSection == null) {
                customSection = DynamicPropStore.setDialogSettings(rootSection, sectionName);
            }
        } else {
            customSection = rootSection;
        }
        String[] customProperties = DynamicPropStore.getArray(customSection, customPropertyName);
        String[] aList = null;
        if (customProperties != null && customProperties.length > 0) {
            customs = this.convertToArrayList(customProperties);
            if (!customs.contains(customPropertyValue)) {
                aList = new String[customProperties.length + 1];
                int i = 0;
                while (i < customProperties.length) {
                    aList[i] = customProperties[i];
                    ++i;
                }
                aList[customProperties.length] = customPropertyValue;
                DynamicPropStore.put(customSection, customPropertyName, aList);
            }
        } else {
            aList = new String[]{customPropertyValue};
            DynamicPropStore.put(customSection, customPropertyName, aList);
        }
        if (sectionName != null) {
            DynamicPropStore.put(customSection, String.valueOf(sectionName) + ":" + customPropertyName, customPropertyValue);
        } else {
            DynamicPropStore.put(customSection, customPropertyName, customPropertyValue);
        }
    }

    public ArrayList restoreCustomPropertiesSuggestions(String rootName, String sectionName, String customPropertyName) {
        ArrayList customs = new ArrayList();
        IDialogSettings rootSection = DynamicPropStore.getDialogSettings(this.plugin_, rootName);
        if (rootSection == null) {
            return customs;
        }
        if (sectionName == null) {
            return this.restoreCustomProperties(rootName, customPropertyName);
        }
        IDialogSettings custSection = DynamicPropStore.getDialogSettings(rootSection, sectionName);
        if (custSection == null) {
            return customs;
        }
        String[] customProperties = DynamicPropStore.getArray(custSection, customPropertyName);
        if (customProperties != null && customProperties.length > 0) {
            customs = this.convertToArrayList(customProperties);
        }
        return customs;
    }

    public String restoreCustomPropertiesValue(String rootName, String sectionName, String customPropertyName) {
        IDialogSettings rootSection = DynamicPropStore.getDialogSettings(this.plugin_, rootName);
        if (rootSection == null) {
            return null;
        }
        IDialogSettings custSection = null;
        if (sectionName == null) {
            custSection = rootSection;
            try {
                String customPropertyValue = DynamicPropStore.get(custSection, customPropertyName);
                return customPropertyValue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        custSection = DynamicPropStore.getDialogSettings(rootSection, sectionName);
        if (custSection == null) {
            return null;
        }
        try {
            String customPropertyValue = DynamicPropStore.get(custSection, String.valueOf(sectionName) + ":" + customPropertyName);
            return customPropertyValue;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void persistForSuggestion(String sectionName, String myPropName, String myValue) {
        IDialogSettings pstore = DynamicPropStore.getDialogSettings(this.plugin_, sectionName);
        if (pstore == null) {
            pstore = DynamicPropStore.setDialogSettings(this.plugin_, sectionName);
        }
        this.persistForSuggestion(pstore, myPropName, myValue);
    }

    public IDialogSettings getDialogSettings() {
        try {
            return this.plugin_.getDialogSettings();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ArrayList restoreSuggestions(IDialogSettings ancestorSection, String propertyName) {
        ArrayList suggestions = new ArrayList();
        String[] lists = DynamicPropStore.getArray(ancestorSection, propertyName);
        if (lists != null && lists.length > 0) {
            suggestions = this.convertToArrayList(lists);
        }
        return suggestions;
    }

    public void restoreSuggestionsOnWidgets(String rootSectionName, ArrayList widgets) {
        if (widgets == null || widgets.isEmpty()) {
            return;
        }
        IDialogSettings J2CSection = this.getDialogSettings();
        if (J2CSection == null) {
            return;
        }
        IDialogSettings rootSection = PStore.getDialogSettings(J2CSection, rootSectionName);
        if (rootSection == null) {
            return;
        }
        int i = 0;
        while (i < widgets.size()) {
            IPropertyDescriptor prop;
            PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
            if (widget instanceof PropertyUIWidgetText_Base && (prop = widget.getProperty()) != null && prop instanceof ISingleTypedProperty && !((ISingleTypedProperty)prop).getPropertyType().isSensitive()) {
                String propPath = PropertyUtil.getPropertyPath(prop).toPortableString();
                ArrayList values = this.restoreSuggestions(rootSection, propPath = propPath.replace('/', ':'));
                if (values != null && values.size() > 0) {
                    ((PropertyUIWidgetText_Base)widget).setSuggestions(values);
                }
            }
            ++i;
        }
    }

    public void storePropertyValues(String rootSectionName, IPropertyGroup properties) {
        if (properties == null) {
            return;
        }
        IDialogSettings J2CSection = this.getDialogSettings();
        if (J2CSection == null) {
            return;
        }
        IDialogSettings rootSection = PStore.getDialogSettings(J2CSection, rootSectionName);
        if (rootSection == null) {
            rootSection = DynamicPropStore.setDialogSettings(J2CSection, rootSectionName);
        }
        ArrayList propertyList = this.getAllLeafProperties(properties);
        for (ISingleTypedProperty prop : propertyList) {
            if (prop == null || !prop.isEnabled() || !prop.isSet() || prop.getPropertyType().isSensitive()) continue;
            IPath path = PropertyUtil.getPropertyPath((IPropertyDescriptor)prop);
            String propPath = path.toPortableString();
            propPath = propPath.replace('/', ':');
            this.storeBaseProperty(rootSection, "", propPath, prop);
        }
    }

    private ArrayList getAllLeafProperties(IPropertyGroup properties) {
        ArrayList<IPropertyDescriptor> props = new ArrayList<IPropertyDescriptor>();
        IPropertyDescriptor[] desc = properties.getProperties();
        int i = 0;
        while (i < desc.length) {
            if (desc[i] instanceof IPropertyGroup) {
                props.addAll(this.getAllLeafProperties((IPropertyGroup)desc[i]));
            } else if (desc[i] instanceof ISingleTypedProperty) {
                props.add(desc[i]);
            } else if (desc[i] instanceof ITreeProperty) {
                props.addAll(this.getAllLeafProperties((ITreeProperty)desc[i]));
            }
            ++i;
        }
        return props;
    }

    private ArrayList getAllPropertyGroups(IPropertyGroup properties) {
        ArrayList<IPropertyGroup> props = new ArrayList<IPropertyGroup>();
        props.add(properties);
        IPropertyDescriptor[] desc = properties.getProperties();
        int i = 0;
        while (i < desc.length) {
            if (desc[i] instanceof IPropertyGroup) {
                props.addAll(this.getAllPropertyGroups((IPropertyGroup)desc[i]));
            }
            ++i;
        }
        return props;
    }

    public void storeBaseProperty(IDialogSettings rootSection, String persistSectionName, String propertyKey, ISingleTypedProperty property) {
        block5: {
            block3: {
                block4: {
                    if (PropertyUtil.isSensitive((IPropertyDescriptor)property)) {
                        return;
                    }
                    if (!PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) break block3;
                    if (((ISingleValuedProperty)property).getValue() == null) break block4;
                    String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
                    this.persistForSuggestion(rootSection, propertyKey, value);
                    this.persistLastSetting(rootSection, persistSectionName, propertyKey, value);
                    break block5;
                }
                String value = PropertyUtil.getValueAsString((IPropertyDescriptor)property);
                if (value != null) break block5;
                this.persistLastSetting(rootSection, persistSectionName, propertyKey, value);
                break block5;
            }
            if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
                ((IMultiValuedProperty)property).getValues();
                String[] Lvalues = ((IMultiValuedProperty)property).getValuesAsStrings();
                int i = 0;
                while (i < Lvalues.length) {
                    this.persistLastSettings(rootSection, persistSectionName, propertyKey, Lvalues[i]);
                    ++i;
                }
            }
        }
    }

    protected void persistForSuggestion(IDialogSettings parentSection, String myPropName, String myValue) {
        if (myValue == null) {
            return;
        }
        String[] valueList = DynamicPropStore.getArray(parentSection, myPropName);
        if (valueList == null || valueList.length == 0) {
            valueList = new String[]{myValue};
            DynamicPropStore.put(parentSection, myPropName, valueList);
        } else {
            String[] newValueList = new String[valueList.length + 1];
            boolean exist = false;
            int i = 0;
            while (i < valueList.length) {
                newValueList[i] = valueList[i];
                if (valueList[i].equals(myValue)) {
                    exist = true;
                }
                ++i;
            }
            if (!exist) {
                newValueList[valueList.length] = myValue;
                DynamicPropStore.put(parentSection, myPropName, newValueList);
            }
        }
    }

    protected void persistLastSetting(IDialogSettings rootSection, String persistSectionName, String propertyKey, String myValue) {
        IDialogSettings persistSection = DynamicPropStore.getDialogSettings(rootSection, persistSectionName);
        if (persistSection == null) {
            persistSection = DynamicPropStore.setDialogSettings(rootSection, persistSectionName);
        }
        if (myValue == null) {
            String previousValue = DynamicPropStore.get(persistSection, propertyKey);
            if (previousValue != null && !previousValue.equals("CoreUInull")) {
                DynamicPropStore.put(persistSection, propertyKey, "CoreUInull");
            }
        } else {
            DynamicPropStore.put(persistSection, propertyKey, myValue);
        }
    }

    protected void persistLastSettings(IDialogSettings rootSection, String persistSectionName, String propertyKey, String myValue) {
        String[] valueList;
        IDialogSettings persistSection = DynamicPropStore.getDialogSettings(rootSection, persistSectionName);
        if (persistSection == null) {
            persistSection = DynamicPropStore.setDialogSettings(rootSection, persistSectionName);
        }
        if ((valueList = DynamicPropStore.getArray(persistSection, propertyKey)) == null || valueList.length == 0) {
            valueList = new String[]{myValue};
            DynamicPropStore.put(persistSection, propertyKey, valueList);
        } else {
            String[] newValueList = new String[valueList.length + 1];
            boolean exist = false;
            int i = 0;
            while (i < valueList.length) {
                newValueList[i] = valueList[i];
                if (valueList[i].equals(myValue)) {
                    exist = true;
                }
                ++i;
            }
            if (!exist) {
                newValueList[valueList.length] = myValue;
                DynamicPropStore.put(persistSection, propertyKey, newValueList);
            }
        }
    }

    private ArrayList getAllLeafProperties(ITreeProperty property) {
        INodeProperty[] children;
        ArrayList props = new ArrayList();
        INodeProperty root = property.getRoot();
        if (property.showRoot()) {
            IPropertyGroup pg = root.getActiveConfigurationProperties();
            boolean created = false;
            if (pg == null) {
                pg = root.createConfigurationProperties();
                created = true;
            }
            if (pg != null) {
                if (created) {
                    root.applyConfigurationProperties(pg);
                }
                props.addAll(this.getAllLeafProperties(pg));
            }
        }
        if ((children = root.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                props.addAll(this.getAllLeafProperties(children[i]));
                ++i;
            }
        }
        return props;
    }

    private ArrayList getAllLeafProperties(INodeProperty node) {
        ArrayList props = new ArrayList();
        IPropertyGroup pg = node.getActiveConfigurationProperties();
        boolean created = false;
        if (pg == null) {
            pg = node.createConfigurationProperties();
            created = true;
        }
        if (pg != null) {
            if (created) {
                node.applyConfigurationProperties(pg);
            }
            props.addAll(this.getAllLeafProperties(pg));
        }
        INodeProperty[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            props.addAll(this.getAllLeafProperties(children[i]));
            ++i;
        }
        return props;
    }

    class PropChangeListener
    implements IPropertyChangeListener {
        PropChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyChangeType() == 6) {
                IPropertyDescriptor pd = (IPropertyDescriptor)evt.getNewValue();
                if (pd instanceof ISingleTypedProperty) {
                    DynamicPropStore.this.addedProperties_.add(pd);
                }
            } else if (evt.getPropertyChangeType() == 8) {
                IPropertyDescriptor[] pds = (IPropertyDescriptor[])evt.getNewValue();
                int i = 0;
                while (i < pds.length) {
                    if (pds[i] instanceof ISingleTypedProperty) {
                        DynamicPropStore.this.addedProperties_.add(pds[i]);
                    }
                    ++i;
                }
            }
        }
    }
}

