/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsdt.dojo.ui.wizards;

import com.ibm.jsdt.dojo.ui.wizards.NewTypeWizardPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class NewClassWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final String SETTINGS_CREATEMAIN = "create_main";
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;

    public NewClassWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle("Dojo Class");
        this.setDescription("Create a new Dojo Class");
        String[] buttonNames3 = new String[]{"initializer", "statics"};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames3, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
    }

    public void init(IStructuredSelection selection) {
        IDialogSettings section;
        this.getInitialJavaElement(selection);
        this.initContainerPage(selection);
        this.initTypePage(selection);
        this.doStatusUpdate();
        boolean createMain = false;
        boolean createConstructors = false;
        boolean createUnimplemented = true;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(PAGE_NAME)) != null) {
            createMain = section.getBoolean(SETTINGS_CREATEMAIN);
            createConstructors = section.getBoolean(SETTINGS_CREATECONSTR);
            createUnimplemented = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
        }
        this.setMethodStubSelection(createMain, createConstructors, createUnimplemented, true);
    }

    @Override
    protected void doStatusUpdate() {
        String newFileName = this.getNewFileName();
        String existingFileName = this.getExistingFileName();
        this.getFolderName();
        String className = this.getTypeName();
        this.getJavaProject();
        this.getExtends();
        boolean shouldUseExisting = this.shouldUseExisting();
        this.isCreateInit();
        this.isCreateStatic();
        if (className == null || className.equals("")) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.jsdt.dojo.core", "Missing Class Name"));
        } else if (!shouldUseExisting && (newFileName == null || newFileName.equals(""))) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.jsdt.dojo.core", "No File Specified for new Class"));
        } else if (shouldUseExisting && (existingFileName == null || existingFileName.equals(""))) {
            this.updateStatus((IStatus)new Status(4, "com.ibm.jsdt.dojo.core", "No File Specified for new Class"));
        } else {
            this.updateStatus((IStatus)new Status(0, "com.ibm.jsdt.dojo.core", ""));
        }
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.new_class_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        } else {
            IDialogSettings dialogSettings = this.getDialogSettings();
            if (dialogSettings != null) {
                IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
                if (section == null) {
                    section = dialogSettings.addNewSection(PAGE_NAME);
                }
                section.put(SETTINGS_CREATEMAIN, this.isCreateInit());
                section.put(SETTINGS_CREATECONSTR, this.isCreateStatic());
            }
        }
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
    }

    public boolean isCreateStatic() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateInit() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public void setMethodStubSelection(boolean createMain, boolean createConstructors, boolean createInherited, boolean canBeModified) {
        this.fMethodStubsButtons.setSelection(0, createMain);
        this.fMethodStubsButtons.setSelection(1, createConstructors);
        this.fMethodStubsButtons.setSelection(2, createInherited);
        this.fMethodStubsButtons.setEnabled(canBeModified);
    }

    @Override
    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Create Dojo Class...", 8);
        String newFileName = this.getNewFileName();
        String existingFileName = this.getExistingFileName();
        String newPath = this.getFolderName();
        String className = this.getTypeName();
        IJavaScriptProject project = this.getJavaProject();
        String[] extendedClasses = this.getExtends();
        boolean shouldUseExisting = this.shouldUseExisting();
        boolean shouldCreateInit = this.isCreateInit();
        boolean shouldCreateStatic = this.isCreateStatic();
        String typeText1 = "";
        String typeText2 = "";
        String typeText3 = "";
        String typeText4 = "";
        String typeText5 = "";
        typeText1 = "dojo.declare(\"" + className + "\",";
        if (extendedClasses != null && extendedClasses.length > 1) {
            typeText2 = String.valueOf(typeText2) + "[";
        }
        int i = 0;
        while (extendedClasses != null && i < extendedClasses.length) {
            typeText2 = String.valueOf(typeText2) + extendedClasses[i];
            if (i < extendedClasses.length - 1) {
                typeText2 = String.valueOf(typeText2) + ",";
            }
            ++i;
        }
        if (extendedClasses != null && extendedClasses.length > 1) {
            typeText2 = String.valueOf(typeText2) + "]";
        }
        if (extendedClasses != null && extendedClasses.length == 0) {
            typeText2 = String.valueOf(typeText2) + "null";
        }
        typeText3 = String.valueOf(typeText3) + ",{\n\t/* Class Body */\n\n";
        if (shouldCreateInit) {
            typeText4 = String.valueOf(typeText4) + "\tinitializer: function() {\n\t/* Class Initializer */\n\n\t}";
        }
        if (shouldCreateInit && shouldCreateStatic) {
            typeText4 = String.valueOf(typeText4) + ",";
        }
        if (shouldCreateStatic) {
            typeText4 = String.valueOf(typeText4) + "\n\tstatics: {\n\t\t /* declare static variables and functions here */\n\n\t}\n";
        }
        typeText5 = String.valueOf(typeText5) + "});";
        String typeText = String.valueOf(typeText1) + typeText2 + typeText3 + typeText4 + typeText5;
        if (shouldUseExisting) {
            String fileExtension = new Path(existingFileName).getFileExtension();
            if (fileExtension != null && fileExtension.equalsIgnoreCase("js")) {
                IResource theFile;
                IJavaScriptUnit jElm;
                if (existingFileName.length() > 0 && existingFileName.charAt(0) == '/' || existingFileName.charAt(0) == '\\') {
                    existingFileName = existingFileName.substring(1);
                }
                if ((jElm = (IJavaScriptUnit)JavaScriptCore.create((IResource)(theFile = project.getProject().findMember((IPath)new Path(existingFileName))))) == null) {
                    return;
                }
                jElm.becomeWorkingCopy(monitor);
                jElm.getBuffer().append("\n" + typeText);
                jElm.commitWorkingCopy(true, monitor);
                jElm.discardWorkingCopy();
            } else if (fileExtension != null && (fileExtension.equalsIgnoreCase("html") || fileExtension.equalsIgnoreCase("htm") || fileExtension.equalsIgnoreCase("jsp"))) {
                IFile toHtml = project.getProject().getFile(existingFileName);
                this.insertInThml(toHtml, typeText);
            }
        } else {
            Path newFilePath = new Path(String.valueOf(newPath) + "/" + newFileName);
            IFile theFile = project.getProject().getFile((IPath)newFilePath);
            String fileExtension = theFile.getFileExtension();
            if (fileExtension != null && (fileExtension.equalsIgnoreCase("html") || fileExtension.equalsIgnoreCase("htm") || fileExtension.equalsIgnoreCase("jsp"))) {
                typeText = "<html>\n<head>\n<script>\n" + typeText + "\n</script>\n</head>\n</html>";
            }
            ByteArrayInputStream str = new ByteArrayInputStream(typeText.getBytes());
            theFile.create((InputStream)str, true, monitor);
        }
    }

    private void insertInThml(IFile htmlFile, String text) {
        boolean existing = true;
        IDOMModel xmlModel = null;
        try {
            IDOMDocument xmlDoc;
            JsTranslationAdapter fTranslationAdapter;
            xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForEdit(htmlFile);
            if (xmlModel == null) {
                try {
                    existing = false;
                    xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(htmlFile);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
            if (!existing) {
                JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)xmlModel);
            }
            if ((fTranslationAdapter = (JsTranslationAdapter)(xmlDoc = xmlModel.getDocument()).getAdapterFor(IJsTranslation.class)) != null) {
                IJsTranslation translation = fTranslationAdapter.getJSPTranslation(false);
                translation.insertInFirstScriptRegion(text);
            }
            if (!existing) {
                this.removeAdapterFactory((IStructuredModel)xmlModel);
            }
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromEdit();
            }
        }
    }

    private void removeAdapterFactory(IStructuredModel sm) {
        if (sm.getFactoryRegistry().getFactoryFor(IJsTranslation.class) != null) {
            sm.getFactoryRegistry().removeFactoriesFor(IJsTranslation.class);
        }
    }
}

