/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsdt.dojo.ui.text.doc;

import com.ibm.jsdt.dojo.ui.text.util.SingleCharReader;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;

public class DojoDocCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public DojoDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 2;
        this.fEndPos = end;
        this.reset();
    }

    @Override
    public int read() {
        if (this.fCurrPos < this.fEndPos) {
            int ch;
            if (this.fWasNewLine) {
                do {
                    ch = this.fBuffer.getChar(this.fCurrPos++);
                } while (this.fCurrPos < this.fEndPos && Character.isWhitespace((char)ch));
                if (ch == 47) {
                    if (this.fCurrPos < this.fEndPos) {
                        while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == 47) {
                        }
                    } else {
                        return -1;
                    }
                    --this.fCurrPos;
                    ch = 32;
                }
            } else {
                ch = this.fBuffer.getChar(this.fCurrPos++);
            }
            this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)ch);
            return ch;
        }
        return -1;
    }

    @Override
    public void close() {
        this.fBuffer = null;
    }

    @Override
    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

