/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsdt.dojo.ui.text.doc;

import com.ibm.jsdt.dojo.ui.text.doc.DojoDocMessages;
import com.ibm.jsdt.dojo.ui.text.util.HTMLPrinter;
import com.ibm.jsdt.dojo.ui.text.util.SubstitutionTextReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class DojoDoc2HTMLTextReader
extends SubstitutionTextReader {
    static final String TAG_SUMMARY = "summary:";
    static final String TAG_DESCRIPTION = "description:";
    static final String TAG_RETURNS = "returns:";
    static final int CHAR1_SUMMARY = 115;
    static final int CHAR1_DESCRIPTION = 100;
    static final int CHAR1_RETURNS = 114;
    private List fParameters;
    private String fReturn;
    private String fDescription = "";
    private String fSummary = "";

    public DojoDoc2HTMLTextReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    private String getTag(int first) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)first);
        int c = this.nextChar();
        while (c != -1 && Character.isLetter((char)c)) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        buffer.append((char)c);
        return buffer.toString();
    }

    private String substituteQualification(String qualification) {
        String result = qualification.replace('#', '.');
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        return result;
    }

    private void printDefinitions(StringBuffer buffer, List list, boolean firstword) {
        for (String s : list) {
            buffer.append("<dd>");
            if (!firstword) {
                buffer.append(s);
            } else {
                buffer.append("<b>");
                int i = this.getParamEndOffset(s);
                if (i <= s.length()) {
                    buffer.append(HTMLPrinter.convertToHTMLContent(s.substring(0, i)));
                    buffer.append("</b>");
                    buffer.append(s.substring(i));
                } else {
                    buffer.append("</b>");
                }
            }
            buffer.append("</dd>");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getParamEndOffset(String s) {
        block5: {
            i = 0;
            length = s.length();
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i >= length || s.charAt(i) != '<') ** GOTO lbl18
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            while (i < length && Character.isJavaIdentifierPart(s.charAt(i))) {
                ++i;
            }
            while (i < length && s.charAt(i) != '>') {
                ++i;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl18:
                // 2 sources

                ** while (i < length && Character.isJavaIdentifierPart((char)s.charAt((int)i)))
            }
        }
        return i;
    }

    private void print(StringBuffer buffer, String tag, List elements, boolean firstword) {
        if (!elements.isEmpty()) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            this.printDefinitions(buffer, elements, firstword);
        }
    }

    private void print(StringBuffer buffer, String tag, String content) {
        if (content != null) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            buffer.append("<dd>");
            buffer.append(content);
            buffer.append("</dd>");
        }
    }

    private String printSimpleTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fSummary);
        buffer.append("<br/>  <br/>");
        buffer.append(this.fDescription);
        buffer.append("<dl>");
        this.print(buffer, DojoDocMessages.DojoDoc2HTMLTextReader_parameters_section, this.fParameters, true);
        this.print(buffer, DojoDocMessages.DojoDoc2HTMLTextReader_returns_section, this.fReturn);
        buffer.append("</dl>");
        return buffer.toString();
    }

    private void handleTag(String tag, String tagContent) {
        tagContent = tagContent.trim();
        if (TAG_RETURNS.equals(tag)) {
            this.fReturn = tagContent;
        } else if (TAG_DESCRIPTION.equals(tag)) {
            this.fDescription = tagContent;
        } else if (TAG_SUMMARY.equals(tag)) {
            this.fSummary = tagContent;
        } else {
            this.fParameters.add(String.valueOf(tag.replace(':', ' ')) + tagContent);
        }
    }

    private String processSimpleTag(String tag) throws IOException {
        this.fParameters = new ArrayList();
        StringBuffer buffer = new StringBuffer();
        StringBuffer tagBuffer = new StringBuffer();
        int c = 32;
        while (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            while (true) {
                if (c != 10 && c != 13 && c != -1) {
                    buffer.append((char)c);
                    c = this.nextChar();
                    continue;
                }
                while (c != -1 && Character.isWhitespace((char)c)) {
                    tagBuffer.append((char)c);
                    c = this.nextChar();
                }
                while (c != -1 && Character.isLetter((char)c)) {
                    tagBuffer.append((char)c);
                    c = this.nextChar();
                }
                if (c == -1) break;
                if (c == 58) {
                    tagBuffer.append(':');
                    c = 32;
                    break;
                }
                buffer.append(tagBuffer);
                tagBuffer.setLength(0);
            }
            this.handleTag(tag, buffer.toString());
            tag = tagBuffer.toString().trim();
            tagBuffer.setLength(0);
        }
        return this.printSimpleTag();
    }

    @Override
    protected String computeSubstitution(int c) throws IOException {
        String returnString = null;
        if (this.fWasWhiteSpace) {
            switch (c) {
                case 100: {
                    returnString = this.getTag(100);
                    if (!TAG_DESCRIPTION.equals(returnString)) break;
                    returnString = this.processSimpleTag(TAG_DESCRIPTION);
                    break;
                }
                case 115: {
                    returnString = this.getTag(115);
                    if (!TAG_SUMMARY.equals(returnString)) break;
                    returnString = this.processSimpleTag(TAG_SUMMARY);
                    break;
                }
                case 114: {
                    returnString = this.getTag(114);
                    if (!TAG_RETURNS.equals(returnString)) break;
                    returnString = this.processSimpleTag(TAG_RETURNS);
                }
            }
        }
        return returnString;
    }
}

