/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsdt.dojo.refactor;

import com.ibm.jsdt.dojo.refactor.OverideDojoMethodDialog;
import com.ibm.jsdt.dojo.refactor.SelectionDispatchAction;
import com.ibm.jsdt.dojo.refactor.Util;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class ImplementDojoMethodAction
extends SelectionDispatchAction
implements IEditorActionDelegate,
IViewActionDelegate {
    protected ISelection selection;
    protected static final String DOJO_DECLARE = "dojo.declare";
    private static final String DIALOG_TITLE = ActionMessages.OverrideMethodsAction_error_title;
    private ISelection fSelection;
    private IViewPart fView;
    private CompilationUnitEditor fEditor;

    public ImplementDojoMethodAction() {
        super(null);
    }

    public ImplementDojoMethodAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public ImplementDojoMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OverrideMethodsAction_label);
        this.setDescription(ActionMessages.OverrideMethodsAction_description);
        this.setToolTipText(ActionMessages.OverrideMethodsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_unimplemented_methods_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getJavaScriptUnit() != null && !type.isInterface();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof IJavaScriptUnit;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn((JavaEditor)this.fEditor);
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaScriptModelException {
        IType type;
        Object[] elements = selection.toArray();
        if (elements == null) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getJavaScriptUnit() != null && !type2.isInterface()) {
                return type2;
            }
        } else if (elements[0] instanceof IJavaScriptUnit && (type = ((IJavaScriptUnit)elements[0]).findPrimaryType()) != null && !type.isInterface()) {
            return type;
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IType type = null;
        try {
            type = this.getSelectedType(selection);
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (type == null) {
            try {
                type = SelectionConverter.getTypeAtOffset((JavaEditor)this.fEditor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (type == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            if (!ElementValidator.check((IJavaScriptElement)type, (Shell)this.getShell(), (String)this.getDialogTitle(), (boolean)false) || !ActionUtil.isEditable((Shell)this.getShell(), (IJavaScriptElement)type)) {
                this.notifyResult(false);
                return;
            }
            this.run(this.getShell(), type);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle((CoreException)exception, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IType type = SelectionConverter.getTypeAtOffset((JavaEditor)this.fEditor);
            if (type != null) {
                if (!ElementValidator.check((IJavaScriptElement)type, (Shell)this.getShell(), (String)this.getDialogTitle(), (boolean)false) || !ActionUtil.isEditable((JavaEditor)this.fEditor, (Shell)this.getShell(), (IJavaScriptElement)type)) {
                    this.notifyResult(false);
                    return;
                }
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(this.getShell(), type);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (Shell)this.getShell(), (String)this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    private void run(Shell shell, IType type) throws CoreException {
        block19: {
            IRewriteTarget target;
            OverideDojoMethodDialog dialog = new OverideDojoMethodDialog(shell, this.fEditor, type, false);
            if (!dialog.hasMethodsToOverride()) {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_nothing_found);
                this.notifyResult(false);
                return;
            }
            if (dialog.open() != 0) {
                this.notifyResult(false);
                return;
            }
            Object[] selected = dialog.getResult();
            if (selected == null) {
                this.notifyResult(false);
                return;
            }
            ArrayList<Object> methods = new ArrayList<Object>();
            String methodText = new String();
            boolean needsComma = false;
            if (dialog.overRideNull()) {
                methodText = "{";
            }
            int i = 0;
            while (i < selected.length) {
                Object elem = selected[i];
                if (elem instanceof IFunction) {
                    IFunction method = (IFunction)elem;
                    methods.add(elem);
                    methodText = String.valueOf(methodText) + (needsComma ? ",\n\t" : "\n\t") + method.getElementName() + " : function(){\n\n\n\t}";
                    needsComma = true;
                }
                ++i;
            }
            if (dialog.overRideNull()) {
                methodText = String.valueOf(methodText) + "}";
            }
            methods.toArray(new IFunction[methods.size()]);
            IEditorPart editor = JavaScriptUI.openInEditor((IJavaScriptElement)type.getJavaScriptUnit());
            IRewriteTarget iRewriteTarget = target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                int insertPos = dialog.getInsertOffset();
                if (dialog.overRideNull()) {
                    ReplaceEdit edit = new ReplaceEdit(insertPos, 4, methodText);
                    edit.apply(target.getDocument());
                } else {
                    InsertEdit edit = new InsertEdit(insertPos, methodText);
                    edit.apply(target.getDocument());
                }
            }
            catch (MalformedTreeException e) {
                e.printStackTrace();
                if (target != null) {
                    target.endCompoundChange();
                }
                break block19;
            }
            catch (BadLocationException e) {
                try {
                    e.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
            }
            if (target == null) break block19;
            target.endCompoundChange();
        }
        this.notifyResult(true);
    }

    public static IWorkspaceRunnable createRunnable(CompilationUnit astRoot, IType type, IFunction[] methodToOverride, int insertPos, boolean createComments) {
        return null;
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaScriptModelException exception) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaScriptPlugin.log((Throwable)exception);
            }
            this.setEnabled(false);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor == null) {
            return;
        }
        this.fEditor = (CompilationUnitEditor)targetEditor;
        super.setSite((IWorkbenchSite)targetEditor.getSite());
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)this.fSelection);
        }
        if (this.fSelection instanceof ITextSelection) {
            this.run((ITextSelection)this.fSelection);
        }
    }

    public void run(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (this.fSelection instanceof ITextSelection) {
            ITextSelection textSelect = (ITextSelection)this.fSelection;
            int offset = textSelect.getOffset();
            IJavaScriptUnit cu = null;
            if (this.fEditor != null) {
                cu = Util.getCompilationUnit((JavaEditor)this.fEditor);
            }
            IJavaScriptElement element = null;
            if (cu != null) {
                try {
                    element = cu.getElementAt(offset);
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            if (element != null && element instanceof SourceType) {
                SourceType type = (SourceType)element;
                String typeSource = null;
                try {
                    typeSource = type.getSource();
                    if (typeSource == null || typeSource.indexOf(DOJO_DECLARE) < 0) {
                        action.setEnabled(false);
                    } else {
                        action.setEnabled(true);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
        }
    }

    public void init(IViewPart view) {
        this.fView = view;
        super.setSite((IWorkbenchSite)view.getSite());
    }
}

