/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.racustomization.internal.utilities;

import com.ibm.adapter.emd.extension.discovery.spi.MetadataEdit;
import com.ibm.adapter.emd.extension.discovery.spi.ServiceDiscoveryFactory;
import com.ibm.adapter.emd.extension.properties.JavaBeanPropertyGroup;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.text.StringCharacterIterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jca.ConnectionDefinition;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;

public class RACustomizationHelper {
    private static RACustomizationHelper Helper_;
    private MetadataEdit metadataEdit_;

    public static RACustomizationHelper instance() {
        if (Helper_ == null) {
            Helper_ = new RACustomizationHelper();
        }
        return Helper_;
    }

    public Connector getConnector(String dName, String vendor, String version) {
        IProject[] connectorProjects = ConnectorProjectHelper.getAllConnectorProjects();
        int i = 0;
        while (i < connectorProjects.length) {
            boolean sameResourceAdapter;
            Connector connector = ConnectorProjectHelper.getConnector((IProject)connectorProjects[i]);
            boolean bl = sameResourceAdapter = dName.equals(connector.getDisplayName()) && vendor.equals(connector.getVendorName());
            if (sameResourceAdapter) {
                Integer connectorVersion = this.parseVersion(connector.getVersion());
                Integer versionNumber = this.parseVersion(version);
                if (versionNumber.compareTo(connectorVersion) == 0) {
                    return connector;
                }
            }
            ++i;
        }
        return null;
    }

    public Integer parseVersion(String version) {
        StringCharacterIterator iterator = new StringCharacterIterator(version);
        char[] digits = new char[version.length()];
        int i = 0;
        char c = iterator.first();
        while (c != '\uffff') {
            if (Character.isDigit(c)) {
                digits[i++] = c;
            }
            c = iterator.next();
        }
        return new Integer(new String(digits).trim());
    }

    public MetadataEdit getMetadataEdit(IResourceAdapterDescriptor irad) {
        if (this.metadataEdit_ == null) {
            this.metadataEdit_ = ServiceDiscoveryFactory.getFactory().createMetadataEdit(irad);
        } else if (irad != null && !irad.equals(this.metadataEdit_.getResourceAdapterDescriptor())) {
            this.metadataEdit_.setResourceAdapterDescriptor(irad);
        }
        return this.metadataEdit_;
    }

    public PropertyGroup getMCFProperties(IResourceAdapterDescriptor irad, String className) throws MetadataException, CoreException {
        EList connectionDefinitions;
        OutboundResourceAdapter outboundAdapter;
        Connector connector = irad.getConnector();
        if ("1.0".equals(irad.getSpecVersion())) {
            return EMDUtil.createPropertyGroupFromConfigElements((String)className, (List)connector.getResourceAdapter().getConfigProperties(), (ClassLoader)irad.getClassLoader());
        }
        if ("1.5".equals(irad.getSpecVersion()) && (outboundAdapter = connector.getResourceAdapter().getOutboundResourceAdapter()) != null && (connectionDefinitions = outboundAdapter.getConnectionDefinitions()) != null) {
            for (ConnectionDefinition def : connectionDefinitions) {
                if (!def.getManagedConnectionFactoryClass().equals(className)) continue;
                return EMDUtil.createPropertyGroupFromConfigElements((String)className, (List)def.getConfigProperties(), (ClassLoader)irad.getClassLoader());
            }
        }
        return null;
    }

    public PropertyGroup getInteractionSpecProperties(IResourceAdapterDescriptor irad, String className) throws MetadataException, CoreException {
        return new JavaBeanPropertyGroup(irad.getInteractionSpecClass(className), className);
    }

    public PropertyGroup getConnectionSpecProperties(IResourceAdapterDescriptor irad, String className) throws MetadataException, CoreException {
        return new JavaBeanPropertyGroup(irad.getConnectionSpecClass(className), className);
    }
}

