/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.webservice;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.model.IDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.properties.CommonDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.properties.J2EEProjectProperty;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebServiceDeploymentPropertyGroup
extends CommonDeploymentPropertyGroup
implements IDeploymentPropertyGroup {
    protected J2EEProjectProperty webProject_;
    private String webProjectName_ = "WebProject";

    public WebServiceDeploymentPropertyGroup(Object param) throws CoreException {
        super("WebServiceDeploymentPropertyGroup", "Web Service deployment properties", "");
        this.initialize();
        this.def = (J2CServiceDescription)param;
        super.initializeAdvanced();
    }

    public J2EEProjectProperty getWebProjectProperty() {
        return this.webProject_;
    }

    public String getWebProjectName() {
        return this.webProject_.getValueAsString();
    }

    public void setWebProjectName(String newName) {
        try {
            this.webProject_.setValueAsString(newName);
        }
        catch (Exception exception) {}
    }

    private void initialize() throws CoreException {
        this.webProject_ = new J2EEProjectProperty(this.webProjectName_, J2CUIMessages.J2C_UI_WIZARDS_LABEL_WEB, J2CUIMessages.J2C_UI_WIZARDS_LABEL_WEB_TOOLTIP, String.class, (BasePropertyGroup)this);
        this.webProject_.setRequired(true);
        this.webProject_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        this.webProject_.addPropertyChangeListener((IPropertyChangeListener)this);
        this.webProject_.setProjectType(ResourceUtils.DYNAMIC_WEB);
        this.webProject_.assignID("com.ibm.j2c.ui.propertyextension.newj2eewizard");
    }

    public Object clone() throws CloneNotSupportedException {
        WebServiceDeploymentPropertyGroup group = (WebServiceDeploymentPropertyGroup)((Object)super.clone());
        J2EEProjectProperty webProjectProperty = (J2EEProjectProperty)group.getProperty(this.webProjectName_);
        webProjectProperty.addPropertyChangeListener((IPropertyChangeListener)group);
        webProjectProperty.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
        return group;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyChangeType()) {
            case 0: {
                Object source = evt.getSource();
                if (source != this.webProject_) break;
                String wName = this.webProject_.getValueAsString();
                DeploymentUtils.initializeCommonDeploymentPropretyGroupValues((String)wName, (BasePropertyGroup)this);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object source = evt.getSource();
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            return;
        }
        if (source == this.webProject_) {
            IProject project = ResourceUtils.getWorkspace().getRoot().getProject((String)evt.getNewValue());
            if (project != null && !project.exists()) {
                throw new PropertyVetoException(J2CUIMessages.J2C_UI_WIZARDS_LABEL_INVALID_WEB, (java.beans.PropertyChangeEvent)evt);
            }
            if (source == this.webProject_ && !ResourceUtils.isProjectOfKind((IProject)project, (String)ResourceUtils.DYNAMIC_WEB)) {
                throw new PropertyVetoException(J2CUIMessages.J2C_UI_WIZARDS_LABEL_INVALID_WEB, (java.beans.PropertyChangeEvent)evt);
            }
        }
    }

    public IVirtualComponent getDeployableComponent() {
        String webName = this.webProject_.getValueAsString();
        if (webName != null) {
            IProject pr = ResourceUtils.getWorkspace().getRoot().getProject(webName);
            IVirtualComponent comp = ComponentCore.createComponent((IProject)pr);
            return comp;
        }
        return null;
    }

    public String getResourceRefName() {
        return this.resourceReference_.getValueAsString();
    }

    public String getJndiLookupName() {
        return this.jndiLookupName_.getValueAsString();
    }

    public Vector getEarComponents() {
        return DeploymentUtils.hasEARSforJ2EEProj((IProject)this.getDeployableComponent().getProject());
    }
}

