/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.deployment.ejb;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.spi.Environment;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2c.edit.J2CJavaBeanEdit;
import com.ibm.adapter.j2ca.spi.util.ProjectUtils;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.j2c.ui.core.internal.utilities.J2CUIPropertyUtil;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.deployment.ejb.EJBDeploymentUtils;
import com.ibm.j2c.ui.internal.deployment.ejb.EjbDeploymentMessages;
import com.ibm.j2c.ui.internal.deployment.ejb.EjbDeploymentPlugin;
import com.ibm.j2c.ui.internal.deployment.ejb.EjbDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.model.AbstractDeploymentMethod;
import com.ibm.j2c.ui.internal.model.BindingOperationInfo;
import com.ibm.j2c.ui.internal.model.IDeploymentMethod;
import com.ibm.j2c.ui.internal.model.IWasCommonUtils;
import com.ibm.j2c.ui.internal.model.J2CUIInfo;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.utilities.EJB30Utils;
import com.ibm.jee.was.descriptors.ejb.EjbBindingsDescriptor;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import com.ibm.ws.ast.st.core.WASRuntimeLocator;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import commonj.connector.metadata.description.FunctionDescription;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class EjbDeployment
extends AbstractDeploymentMethod
implements IDeploymentMethod {
    private boolean earExistsForEjbProj = false;
    private EjbDeploymentPropertyGroup propGroup;
    private IFile initFile = null;
    private Hashtable newTypeNames = null;
    private ArrayList _extraAdapterJarURIs = null;

    public IPropertyGroup getPropertyGroup() {
        if (this.propGroup == null) {
            try {
                IProject origProj;
                this.propGroup = new EjbDeploymentPropertyGroup(this.initialOutboundServiceDescription);
                if (this.ivc != null && (ResourceUtils.isEJBProject((IProject)this.ivc.getProject()) || EJB30Utils.isEJB30FacetExists((IProject)this.ivc.getProject(), (IProject)this.initialOutboundServiceDescription.getResourceAdapterDescriptor().getConnectorProject())) && (origProj = this.ivc.getProject()) != null) {
                    this.propGroup.getEjbProjectProperty().setEnabled(true);
                    this.propGroup.setEJBProjectName(origProj.getName());
                    if (ResourceUtils.isEJBProject((IProject)this.ivc.getProject())) {
                        this.propGroup.getEjbProjectProperty().setEnabled(false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.propGroup;
    }

    public void performOnFinish(J2CUIInfo uiInfo) {
        IProject project = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
        this.performOnFinish(uiInfo.JavaInterface_, this.getGeneratedFile(uiInfo));
        this.copyDependentTypesToEJBClient(project, uiInfo);
    }

    public void performOnFinish(J2CServiceDescription oid, IFile file) {
        if (this.initFile != null) {
            file = this.initFile;
        }
        IProject project = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
        IVirtualComponent ejbMod = ComponentCore.createComponent((IProject)project);
        EJBDeploymentUtils.installEJB3FacetOnUtilityJavaProject(project, this.monitor);
        String earPrName = this.propGroup.getEarProjectName();
        IVirtualComponent earMod = null;
        if (earPrName != null) {
            IProject earProj = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEarProjectName());
            earMod = ComponentCore.createComponent((IProject)earProj);
        }
        try {
            Hashtable typeNames;
            Vector associatedEARs = DeploymentUtils.hasEARSforJ2EEProj((IProject)this.propGroup.getDeployableComponent().getProject());
            if (associatedEARs != null) {
                int t = 0;
                while (t < associatedEARs.size()) {
                    IVirtualComponent aComp = (IVirtualComponent)associatedEARs.get(t);
                    if (aComp.getProject().getName().equals(this.propGroup.getEarProjectName())) {
                        this.earExistsForEjbProj = true;
                        break;
                    }
                    ++t;
                }
            }
            if (!this.earExistsForEjbProj && earMod != null) {
                DeploymentUtils.addUtilityProjectToModule((String)project.getName(), (String)project.getName(), (IVirtualComponent)earMod);
            }
            IProject ejbClientProject1 = null;
            if (ResourceUtils.isEJBProject((IProject)project)) {
                EJBArtifactEdit editEJB = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)ejbMod);
                try {
                    ejbClientProject1 = editEJB.getEJBClientJarModule().getProject();
                }
                catch (Exception exception) {}
                editEJB.dispose();
            }
            IFacetedProject fProj = null;
            IFacetedProject clientFProject = null;
            try {
                fProj = ProjectFacetsManager.create((IProject)ejbMod.getProject());
                if (ejbClientProject1 != null) {
                    clientFProject = ProjectFacetsManager.create((IProject)ejbClientProject1);
                }
            }
            catch (Exception exception) {}
            if ((typeNames = this.newTypeNames) == null) {
                FunctionDescription[] methodsList = null;
                if (oid != null) {
                    methodsList = oid.getServiceDescription().getFunctionDescriptions();
                }
                typeNames = DeploymentUtils.getAllDataTypeProjectNames((FunctionDescription[])methodsList, (boolean)false);
            }
            if (this.propGroup.isEJB30Enabled) {
                DeploymentUtils.waitForBuildJobs((int)5);
                this.handleEJB30AnnotationsScenario(file, oid);
            } else {
                if (ProjectFacetsManager.isProjectFacetDefined((String)"com.ibm.etools.wrd.j2ee.annotations")) {
                    IProjectFacet anFacet = ProjectFacetsManager.getProjectFacet((String)"com.ibm.etools.wrd.j2ee.annotations");
                    if (clientFProject != null && !clientFProject.hasProjectFacet(anFacet)) {
                        clientFProject.installProjectFacet(anFacet.getLatestVersion(), null, this.monitor);
                    }
                    if (fProj != null) {
                        if (!fProj.hasProjectFacet(anFacet)) {
                            fProj.installProjectFacet(anFacet.getLatestVersion(), null, this.monitor);
                        }
                        DeploymentUtils.waitForBuildJobs((int)3);
                    }
                }
                this.handleXDocletsScenario(file);
                this.handleDependentTypes(project, typeNames, earMod);
            }
            project.build(10, this.monitor);
            DeploymentUtils.waitForBuildJobs((int)5);
            DeploymentUtils.waitForBuildJobs((int)3);
            project.build(10, this.monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateEJBProjectClassPathWithAdapterJarIfRequired(oid);
    }

    public void setData(Object data) {
    }

    public String getDeploymentPageTitle() {
        return EjbDeploymentMessages.J2C_UI_DEPLOYMENT_EJB_PROPERTIES;
    }

    public String getDeploymentPageDescription() {
        return EjbDeploymentMessages.J2C_UI_DEPLOYMENT_EJB_PROPERTIES_DESC;
    }

    public ImageDescriptor getDeploymentPageImageDescriptor() {
        return EjbDeploymentPlugin.getImageDescriptor("icons/J2C_wiz.gif");
    }

    public void copyDependentTypesToEJBClient(IProject project, J2CUIInfo info) {
        try {
            if (project != null && ResourceUtils.isEJBProject((IProject)project)) {
                DeploymentUtils.waitForBuildJobs((int)4);
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                EJBArtifactEdit editEJB = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                IProject ejbClientProject = project;
                if (editEJB.getEJBClientJarModule() != null) {
                    ejbClientProject = editEJB.getEJBClientJarModule().getProject();
                }
                editEJB.dispose();
                IPropertyDescriptor bindDesc = PropertyUtil.getProperty((IPropertyGroup)info.writerInfo_.getWriteProperties(), (String)"BindingName");
                IPropertyDescriptor packDesc = PropertyUtil.getProperty((IPropertyGroup)info.writerInfo_.getWriteProperties(), (String)"PackageName");
                String sFileName = PropertyUtil.getValueAsString((IPropertyDescriptor)bindDesc);
                String packageName = PropertyUtil.getValueAsString((IPropertyDescriptor)packDesc);
                packageName = packageName.replace('.', '/');
                IPath clientSourceFolder = ResourceUtils.getAllJavaSourceLocations((IProject)project)[0];
                if (!sFileName.endsWith(".java")) {
                    sFileName = String.valueOf(sFileName) + ".java";
                }
                IPath newFpath = clientSourceFolder.append(packageName);
                newFpath = newFpath.append("/" + sFileName);
                IWorkspace workspace = ResourceUtils.getWorkspace();
                IFile file = workspace.getRoot().getFile(newFpath);
                if (file.exists()) {
                    ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
                    IType type = cu.getTypes()[0];
                    IJavaProject parentPr = type.getJavaProject();
                    Hashtable allTypesToCopy = DeploymentUtils.getAllDependentProjects((IType)type);
                    Enumeration e1 = allTypesToCopy.keys();
                    while (e1.hasMoreElements()) {
                        String typeNameToCopy = (String)e1.nextElement();
                        IType typeToCopy = DeploymentUtils.getType((String)typeNameToCopy, (IJavaProject)parentPr);
                        IResource resourceToCopy = typeToCopy.getResource();
                        if (resourceToCopy == null) continue;
                        IPath pathToCopy = resourceToCopy.getFullPath();
                        String sPath = pathToCopy.toString();
                        if (sPath.startsWith("/")) {
                            sPath = sPath.substring(1);
                        }
                        String sURI = "platform:/resource/" + sPath;
                        ResourceUtils.copyFile((IProject)project, (IProject)ejbClientProject, (String)sURI, (boolean)false);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performBeforeFinish(J2CUIInfo uiInfo) {
        IProject ejbProj2 = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
        if (this.propGroup.isEJB30Enabled && ResourceUtils.isTrueJavaProject((IProject)ejbProj2)) {
            return;
        }
        if (this.originatingWizardType == 0) {
            IPropertyGroup ip1;
            IProject project = this.ivc.getProject();
            IProject genProj = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
            if (uiInfo != null && uiInfo.writerInfo_ != null && (ip1 = uiInfo.writerInfo_.getWriteProperties()) != null) {
                IPropertyDescriptor pDesc = PropertyUtil.getProperty((IPropertyGroup)uiInfo.writerInfo_.getWriteProperties(), (String)"Project");
                try {
                    PropertyUtil.setValueAsString((IPropertyDescriptor)pDesc, (String)this.propGroup.getEJBProjectName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Vector vecOps = this.bindingOperations;
            Iterator iter = vecOps.iterator();
            IVirtualComponent component = ComponentCore.createComponent((IProject)genProj);
            EJBArtifactEdit editEJB = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
            IProject ejbClientProject = null;
            try {
                ejbClientProject = editEJB.getEJBClientJarModule().getProject();
            }
            catch (Exception exception) {}
            editEJB.dispose();
            if (ejbClientProject != null && !ejbClientProject.getName().equals(project.getName())) {
                while (iter.hasNext()) {
                    List<IPropertyDescriptor> lst2;
                    IPropertyGroup pG_Out;
                    List<IPropertyDescriptor> lst1;
                    IPropertyGroup pG;
                    BindingOperationInfo info = (BindingOperationInfo)iter.next();
                    if (info.getInputMessage() != null && (pG = info.getInputMessage().getWriteProperties()) != null && (lst1 = Arrays.asList(pG.getProperties())) != null) {
                        Iterator<IPropertyDescriptor> propIter = lst1.iterator();
                        J2CUIPropertyUtil.modifyJavaProjectNameProperty(propIter, (String)project.getName(), (String)ejbClientProject.getName());
                    }
                    if (info.getOutputMessage() == null || (pG_Out = info.getOutputMessage().getWriteProperties()) == null || (lst2 = Arrays.asList(pG_Out.getProperties())) == null) continue;
                    Iterator<IPropertyDescriptor> propIterOut = lst2.iterator();
                    J2CUIPropertyUtil.modifyJavaProjectNameProperty(propIterOut, (String)project.getName(), (String)ejbClientProject.getName());
                }
            }
        }
    }

    public void performBeforeFinish(J2CServiceDescription oid, IFile ejbFile) {
        IProject ejbProj2 = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
        if (this.propGroup.isEJB30Enabled && ResourceUtils.isTrueJavaProject((IProject)ejbProj2)) {
            return;
        }
        if (this.originatingWizardType == 0) {
            IProject project;
            boolean areSameProjects;
            IWorkspace workspace = ResourceUtils.getWorkspace();
            IProject genProj = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
            IVirtualComponent component = ComponentCore.createComponent((IProject)genProj);
            EJBArtifactEdit editEJB = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
            IProject ejbClientProject = null;
            if (editEJB != null) {
                try {
                    ejbClientProject = editEJB.getEJBClientJarModule().getProject();
                }
                catch (Exception exception) {}
                editEJB.dispose();
            }
            boolean bl = areSameProjects = (project = this.ivc.getProject()) == genProj;
            if (!areSameProjects) {
                Object[] args = new Object[]{project.getName(), genProj.getName()};
                MessageDialog.openInformation((Shell)new Shell(), (String)J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_INFO_DIALOG_TITLE, (String)NLS.bind((String)J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_INFO_DIALOG_MSG, (Object[])args));
            }
            IClasspathEntry[] cpEntries = ResourceUtils.getJavaClasspath((IProject)project);
            int i = 0;
            while (i < cpEntries.length) {
                Path projP = new Path(project.getName());
                if (!projP.isPrefixOf(cpEntries[i].getPath())) {
                    ResourceUtils.addToClassPath((IClasspathEntry)cpEntries[i], (IProject)genProj);
                    if (ejbClientProject != null) {
                        ResourceUtils.addToClassPath((IClasspathEntry)cpEntries[i], (IProject)ejbClientProject);
                    }
                }
                ++i;
            }
            IPath newFpath = null;
            IJavaProject parentPr = null;
            Hashtable allTypesToCopy = null;
            try {
                ICompilationUnit cu2 = JavaCore.createCompilationUnitFrom((IFile)ejbFile);
                IType[] allTypes2 = cu2.getAllTypes();
                IType type1 = allTypes2[0];
                parentPr = type1.getJavaProject();
                allTypesToCopy = DeploymentUtils.getAllDependentProjects((IType)type1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String interName = oid.getServiceDescription().getName();
            int indx = interName.lastIndexOf(46);
            String packName = "";
            if (indx >= 0) {
                packName = interName.substring(0, indx);
            }
            QName implName = QNameHelper.createQName((String)packName, (String)ejbFile.getName());
            QName interQName = QNameHelper.createQName((String)packName, (String)interName.substring(indx + 1, interName.length()));
            if (!areSameProjects) {
                ResourceUtils.copyFile((IProject)project, (IProject)genProj, (QName)interQName, (boolean)true);
                ResourceUtils.copyFile((IProject)project, (IProject)genProj, (QName)implName, (boolean)true);
            }
            try {
                String packageDecl = implName.getNamespaceURI();
                packageDecl = packageDecl.replace('.', '/');
                IPath clientSourceFolder = ResourceUtils.getAllJavaSourceLocations((IProject)genProj)[0];
                newFpath = clientSourceFolder.append(packageDecl);
                newFpath = newFpath.append("/" + ejbFile.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Enumeration enum1 = allTypesToCopy.keys();
            Hashtable<String, IPath> subFoldersToCopy = new Hashtable<String, IPath>();
            while (enum1.hasMoreElements()) {
                String typeNameToCopy = (String)enum1.nextElement();
                IType typeToCopy = DeploymentUtils.getType((String)typeNameToCopy, (IJavaProject)parentPr);
                IResource resourceToCopy = typeToCopy.getResource();
                if (resourceToCopy == null) continue;
                IPath pathToCopy = resourceToCopy.getFullPath();
                String sPath = pathToCopy.toString();
                if (sPath.startsWith("/")) {
                    sPath = sPath.substring(1);
                }
                String sURI = "platform:/resource/" + sPath;
                if (ejbClientProject != null) {
                    ResourceUtils.copyFile((IProject)project, (IProject)ejbClientProject, (String)sURI, (!areSameProjects ? 1 : 0) != 0);
                }
                IPath folderPath = pathToCopy.removeLastSegments(1);
                subFoldersToCopy.put(folderPath.toString(), folderPath);
            }
            try {
                IFile file = workspace.getRoot().getFile(newFpath);
                IProject proj = file.getProject();
                ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
                IType[] allTypes = cu.getAllTypes();
                IType type = allTypes[0];
                this.initFile = file;
                J2CJavaBeanEdit ide = new J2CJavaBeanEdit();
                ide.initialize(type, (IEnvironment)new Environment((IProgressMonitor)new NullProgressMonitor(), null));
                J2CServiceDescription newoid = ide.getOutboundServiceDescriptionModel();
                if (newoid == null) {
                    String className;
                    String jndiName = ide.getJNDILookupName();
                    String referencedJNDIName = null;
                    IWasCommonUtils utils = DeploymentHelper.instance().getWASCommonUtils();
                    if (utils != null) {
                        referencedJNDIName = utils.getBindingForResReference(project, project.getName(), jndiName);
                    }
                    if (referencedJNDIName != null) {
                        jndiName = referencedJNDIName;
                    }
                    if ((className = DeploymentHelper.instance().getMCFClassName(genProj)) != null) {
                        ide.setManagedConnectionFactoryName(className);
                        newoid = ide.getOutboundServiceDescriptionModel();
                    }
                }
                this.updateJNDINameTag(newoid, file, this.propGroup.getResourceReference());
                this.ivc = proj;
                oid = newoid;
                FunctionDescription[] methodsList = null;
                if (oid != null) {
                    methodsList = oid.getServiceDescription().getFunctionDescriptions();
                }
                this.newTypeNames = DeploymentUtils.getAllDataTypeProjectNames((FunctionDescription[])methodsList, (boolean)false);
                proj.build(10, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ImageDescriptor getDeploymentOptionImageDescriptor(int imageCode) {
        if (imageCode == 1) {
            return EjbDeploymentPlugin.getImageDescriptor("icons/EjbDeploy.gif");
        }
        if (imageCode == 2) {
            return EjbDeploymentPlugin.getImageDescriptor("icons/EjbDeployFalse.gif");
        }
        if (imageCode == 3) {
            return EjbDeploymentPlugin.getImageDescriptor("icons/ejb_hov.gif");
        }
        return null;
    }

    public IFile[] getDeploymentFiles() {
        return null;
    }

    private void modifyEJBModuleJarDependency(IProject ejbProj, List dependentJars, IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProj);
        IVirtualFile vf = ejbComponent.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)ejbProj.getName());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)dependentJars);
        try {
            updateManifestDataModel.getDefaultOperation().execute(aMonitor, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleXDocletsScenario(IFile file) {
        try {
            String source;
            ICompilationUnit cu;
            Vector<String> ejbTags = new Vector<String>();
            String remoteHome = this.propGroup.getRemoteHomeInterface();
            String remoteIntf = this.propGroup.getRemoteInterface();
            String sViewType = "";
            String sEjbHome = "";
            String sEJBIntf = "";
            if (this.propGroup.isRemoteInterfaceEnabled() && !this.propGroup.isLocalInterfaceEnabled()) {
                sViewType = "remote";
                sEjbHome = " remote-class=\"" + remoteHome + "\"";
                sEJBIntf = " remote-class=\"" + remoteIntf + "\"";
            } else if (this.propGroup.isLocalInterfaceEnabled() && !this.propGroup.isRemoteInterfaceEnabled()) {
                sViewType = "local";
                sEjbHome = " local-class=\"" + this.propGroup.getLocalHomeInterface() + "\"";
                sEJBIntf = " local-class=\"" + this.propGroup.getLocalInterface() + "\"";
            } else if (this.propGroup.isRemoteInterfaceEnabled() && this.propGroup.isLocalInterfaceEnabled()) {
                sViewType = "both";
                sEjbHome = " remote-class=\"" + remoteHome + "\"" + " local-class=\"" + this.propGroup.getLocalHomeInterface() + "\"";
                sEJBIntf = " remote-class=\"" + remoteIntf + "\"" + " local-class=\"" + this.propGroup.getLocalInterface() + "\"";
            }
            String fullName = String.valueOf(this.propGroup.getSessionBeanPackage()) + "." + this.propGroup.getSessionBeanName() + "ImplBean";
            String ejbTags1 = "@ejb.bean \tname=\"" + this.propGroup.getSessionBeanName() + "\"  " + "\ttype=\"" + this.propGroup.getSessionType() + "\"" + "\tjndi-name=\"" + this.propGroup.getJNDIName() + "\"" + "\tview-type=\"" + sViewType + "\" " + "\ttransaction-type=\"" + this.propGroup.getTransactionType() + "\"" + "   impl-class-name=\"" + fullName + "\"";
            ejbTags.add(ejbTags1);
            String ejbTags2 = "@ejb.home" + sEjbHome;
            ejbTags.add(ejbTags2);
            String ejbTags3 = "@ejb.interface" + sEJBIntf;
            ejbTags.add(ejbTags3);
            String resRefName = this.propGroup.getResourceReference();
            if (resRefName != null && resRefName.length() > 0) {
                String ejbTags7 = "@ejb.resource-ref res-ref-name=\"" + resRefName + "\"" + " res-type=\"javax.resource.cci.ConnectionFactory\" res-auth=\"Application\" ";
                String jndiName = this.propGroup.getJNDILookupName();
                if (jndiName != null) {
                    ejbTags7 = String.valueOf(ejbTags7) + "jndi-name=\"" + jndiName + "\"";
                }
                ejbTags.add(ejbTags7);
            }
            if (!(cu = JavaCore.createCompilationUnitFrom((IFile)file)).isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            if ((source = cu.getSource()).indexOf("@ejb.bean") >= 0) {
                Object[] args = new Object[]{file.getFullPath().toString()};
                MessageDialog.openError((Shell)new Shell(), (String)J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_SESSION_BEAN_TAG_ALREADY_DEFINED_TITLE, (String)NLS.bind((String)J2CUIMessages.J2C_UI_DEPLOYMENT_EJB_SESSION_BEAN_TAG_ALREADY_DEFINED_DESCR, (Object[])args));
                return;
            }
            if (source.indexOf("@j2c.") > 0 && source.indexOf("@generated") > 0) {
                Hashtable<String, String> newMethods = new Hashtable<String, String>();
                int i = 0;
                while (i < this.methodNames.size()) {
                    String meth = (String)this.methodNames.get(i);
                    newMethods.put(meth, meth);
                    ++i;
                }
                Document doc = new Document(source);
                ASTParser parser1 = ASTParser.newParser((int)3);
                parser1.setSource(doc.get().toCharArray());
                CompilationUnit astCU1 = (CompilationUnit)parser1.createAST(null);
                List l1 = astCU1.types();
                TypeDeclaration td1 = (TypeDeclaration)l1.get(0);
                Javadoc jd1 = td1.getJavadoc();
                ASTRewrite rewrite1 = ASTRewrite.create((AST)jd1.getAST());
                AST ast1 = jd1.getAST();
                ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)jd1, Javadoc.TAGS_PROPERTY);
                int j = 0;
                while (j < ejbTags.size()) {
                    TagElement te1 = ast1.newTagElement();
                    te1.setTagName((String)ejbTags.get(j));
                    int size = lrw1.getRewrittenList().size();
                    lrw1.insertAt((ASTNode)te1, size - 1, null);
                    ++j;
                }
                TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                edits1.apply((IDocument)doc);
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(doc.get().toCharArray());
                CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
                List l = astCU.types();
                TypeDeclaration td = (TypeDeclaration)l.get(0);
                MethodDeclaration[] msA = td.getMethods();
                boolean methodAnnotationsChanged = false;
                int i2 = 0;
                while (i2 < msA.length) {
                    ASTParser tempParser = ASTParser.newParser((int)3);
                    tempParser.setSource(doc.get().toCharArray());
                    CompilationUnit astCUTemp = (CompilationUnit)tempParser.createAST(null);
                    List lTemp = astCUTemp.types();
                    TypeDeclaration tdTemp = (TypeDeclaration)lTemp.get(0);
                    MethodDeclaration[] msATemp = tdTemp.getMethods();
                    MethodDeclaration methodDecl = msATemp[i2];
                    String sN = methodDecl.getName().getIdentifier();
                    if (newMethods.get(sN) != null) {
                        methodAnnotationsChanged = true;
                        Javadoc jd = methodDecl.getJavadoc();
                        if (jd != null) {
                            ASTRewrite rewrite = ASTRewrite.create((AST)jd.getAST());
                            AST ast = jd.getAST();
                            TagElement te = ast.newTagElement();
                            te.setTagName("@ejb.interface-method  view-type=\"" + sViewType + "\" ");
                            ListRewrite lrw = rewrite.getListRewrite((ASTNode)jd, Javadoc.TAGS_PROPERTY);
                            int numberOfTags = lrw.getRewrittenList().size();
                            lrw.insertAt((ASTNode)te, numberOfTags - 1, null);
                            if (this.propGroup.isEjbTransactionDisabled()) {
                                TagElement te1 = ast.newTagElement();
                                te1.setTagName("@ejb.transaction type=\"NotSupported\"");
                                int numberOfTags1 = lrw.getRewrittenList().size();
                                lrw.insertAt((ASTNode)te1, numberOfTags1 - 1, null);
                            }
                            TextEdit edits = rewrite.rewriteAST((IDocument)doc, null);
                            edits.apply((IDocument)doc);
                        }
                    }
                    ++i2;
                }
                cu.getBuffer().setContents(doc.get());
                cu.commitWorkingCopy(true, this.monitor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleEJB30AnnotationsScenario(IFile file, J2CServiceDescription oid) {
        try {
            String tag;
            ArrayList<String> annotationsList = new ArrayList<String>();
            ArrayList<String> importsList = new ArrayList<String>();
            String jndiName = null;
            String jndiNameTemp = this.propGroup.getJNDIName();
            if (jndiNameTemp != null && jndiNameTemp.trim().length() > 0) {
                jndiName = jndiNameTemp;
            }
            String string = this.propGroup.getSessionType();
            ((Object)((Object)this.propGroup)).getClass();
            if (string.equals("Stateless")) {
                tag = "@Stateless";
                if (jndiName != null) {
                    tag = String.valueOf(tag) + "(mappedName=\"" + jndiName + "\")";
                }
                annotationsList.add(tag);
                importsList.add("javax.ejb");
            } else {
                tag = "@Stateful";
                if (jndiName != null) {
                    tag = String.valueOf(tag) + "(mappedName=\"" + jndiName + "\")";
                }
                annotationsList.add(tag);
                importsList.add("javax.ejb");
            }
            String transactionTag = "@TransactionManagement(value=javax.ejb.TransactionManagementType.BEAN)";
            String string2 = this.propGroup.getTransactionType();
            ((Object)((Object)this.propGroup)).getClass();
            if (string2.equals("Bean")) {
                annotationsList.add(transactionTag);
                importsList.add("javax.ejb");
            }
            if (this.propGroup.isEjbTransactionDisabled()) {
                String tempS = "@TransactionAttribute(value=javax.ejb.TransactionAttributeType.NOT_SUPPORTED)";
                annotationsList.add(tempS);
                importsList.add("javax.ejb");
            }
            EJBDeploymentUtils.addAnnotationsToCU(file, annotationsList, importsList);
            if (this.propGroup.getResourceRefName() != null) {
                this.createEJB30JarResourceReference(oid, file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean createEJB30JarResourceReference(J2CServiceDescription oid, final IFile file) {
        final IProject ejbProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)ejbProject);
        final EObject xmlObject = (EObject)provider.getModelObject(IJEE5ModelProvider.EJB_DD_MODEL_XML_NODEVICE);
        final boolean[] returnValue = new boolean[]{false};
        provider.modify(new Runnable(){

            @Override
            public void run() {
                if (xmlObject instanceof EJBJar) {
                    Resource res = xmlObject.eResource();
                    EJBJar ejbJar = (EJBJar)xmlObject;
                    EnterpriseBeans eBeans = ejbJar.getEnterpriseBeans();
                    if (eBeans == null) {
                        eBeans = EjbFactory.eINSTANCE.createEnterpriseBeans();
                        ejbJar.setEnterpriseBeans(eBeans);
                    }
                    if (eBeans != null) {
                        List sessionBeans = eBeans.getSessionBeans();
                        Object j2cSession = null;
                        String j2cSessionName = file.getName().replace("." + file.getFileExtension(), "");
                        for (Object obj : sessionBeans) {
                            SessionBean sessBean = (SessionBean)obj;
                            if (!sessBean.getEjbName().equals(j2cSessionName)) continue;
                            j2cSession = sessBean;
                            break;
                        }
                        if (j2cSession == null) {
                            j2cSession = EjbFactory.eINSTANCE.createSessionBean();
                            j2cSession.setEjbName(j2cSessionName);
                            eBeans.getSessionBeans().add(j2cSession);
                        }
                        List resRefs = j2cSession.getResourceRefs();
                        for (Object obj : resRefs) {
                            ResourceRef resRef = (ResourceRef)obj;
                            if (!resRef.getResRefName().equals(EjbDeployment.this.propGroup.getResourceRefName())) continue;
                            return;
                        }
                        ResourceRef resRef = JavaeeFactory.eINSTANCE.createResourceRef();
                        resRef.setResRefName(EjbDeployment.this.propGroup.getResourceRefName());
                        resRef.setResType("javax.resource.cci.ConnectionFactory");
                        resRefs.add(resRef);
                        if (res != null) {
                            EjbBindingsDescriptor descriptor = new EjbBindingsDescriptor(ejbProject);
                            try {
                                descriptor.setSessionResourceRefBinding(j2cSessionName, EjbDeployment.this.propGroup.getResourceRefName(), EjbDeployment.this.propGroup.getJNDILookupName());
                            }
                            catch (CoreException coreException) {}
                            returnValue[0] = true;
                            return;
                        }
                        return;
                    }
                }
            }
        }, IModelProvider.FORCESAVE);
        return returnValue[0];
    }

    private void handleDependentTypes(IProject project, Hashtable typeNames, IVirtualComponent earMod) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        EJBArtifactEdit edit = null;
        edit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
        IVirtualComponent clientJarM = edit.getEJBClientJarModule();
        IProject ejbClientProject = project;
        if (clientJarM != null) {
            ejbClientProject = clientJarM.getProject();
        }
        Enumeration keys = typeNames.keys();
        ArrayList<String> projList = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String typeProjectName = (String)keys.nextElement();
            if (typeProjectName.equals(project.getName()) || typeProjectName.equals(ejbClientProject.getName())) continue;
            DeploymentUtils.addUtilityProjectToModule((String)typeProjectName, (String)typeProjectName, (IVirtualComponent)earMod);
            ResourceUtils.updateClassPath((String)typeProjectName, (IProject)ejbClientProject);
            ResourceUtils.updateClassPath((String)typeProjectName, (IProject)project);
            typeProjectName = String.valueOf(typeProjectName) + ".jar";
            projList.add(typeProjectName);
        }
        if (!projList.isEmpty()) {
            try {
                this.modifyEJBModuleJarDependency(project, projList, this.monitor);
            }
            catch (Exception exception) {}
        }
    }

    private void updateEJBProjectClassPathWithAdapterJarIfRequired(J2CServiceDescription oid) {
        block16: {
            IProject ejbProj = ResourceUtils.getWorkspace().getRoot().getProject(this.propGroup.getEJBProjectName());
            if (EJB30Utils.isEJB30Project((IProject)ejbProj)) {
                return;
            }
            if (oid != null) {
                String sVendorName = oid.getResourceAdapterDescriptor().getConnector().getVendorName();
                String sEisType = oid.getResourceAdapterDescriptor().getConnector().getEisType();
                if ((!sVendorName.equalsIgnoreCase("ibm") || sEisType.trim().indexOf("SAP") < 0 && sEisType.trim().indexOf("JD Edwards") < 0 && sEisType.trim().indexOf("JDBC") < 0 && sEisType.trim().indexOf("PeopleSoft") < 0 && sEisType.trim().indexOf("Siebel") < 0) && sEisType.trim().indexOf("Oracle") < 0) {
                    return;
                }
                IProject connProj = oid.getResourceAdapterDescriptor().getConnectorProject();
                try {
                    IRuntime serverRuntime;
                    IFacetedProject facetProj = ProjectFacetsManager.create((IProject)connProj);
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = facetProj.getPrimaryRuntime();
                    if (facetRuntime == null || !WASRuntimeUtil.isWASv61OrLaterRuntime((IRuntime)(serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetRuntime)))) break block16;
                    if (this._extraAdapterJarURIs == null) {
                        File[] jarsToAdd;
                        IPath runtimeStubPath = null;
                        runtimeStubPath = serverRuntime.isStub() ? serverRuntime.getLocation() : (WASRuntimeUtil.isWASv70Runtime((IRuntime)serverRuntime) ? WASRuntimeLocator.getRuntimeStubLocation((byte)37) : WASRuntimeLocator.getRuntimeStubLocation((byte)33));
                        if (runtimeStubPath == null) {
                            return;
                        }
                        IPath jarPath = runtimeStubPath.append("adapterJars");
                        File jarDir = new File(jarPath.toOSString());
                        if (jarDir.exists() && (jarsToAdd = jarDir.listFiles()).length != 0) {
                            ArrayList<String> newJarList = new ArrayList<String>();
                            int i = 0;
                            while (i < jarsToAdd.length) {
                                try {
                                    newJarList.add(jarsToAdd[i].getCanonicalPath());
                                }
                                catch (Exception exception) {}
                                ++i;
                            }
                            if (!newJarList.isEmpty()) {
                                this._extraAdapterJarURIs = newJarList;
                            }
                        }
                    }
                    if (this._extraAdapterJarURIs != null && !this._extraAdapterJarURIs.isEmpty()) {
                        IJavaProject ijp = JavaCore.create((IProject)ejbProj);
                        ArrayList<IClasspathEntry> jarsToAdd = new ArrayList<IClasspathEntry>();
                        int c = 0;
                        while (c < this._extraAdapterJarURIs.size()) {
                            String sPath = (String)this._extraAdapterJarURIs.get(c);
                            Path newPath = new Path(sPath);
                            IClasspathEntry ice = JavaCore.newLibraryEntry((IPath)newPath, (IPath)newPath, null);
                            jarsToAdd.add(ice);
                            ++c;
                        }
                        try {
                            ProjectUtils.addClasspathEntriesToClassPath((IJavaProject)ijp, jarsToAdd, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

