/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.snippets.internal.snippets;

import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.utilities.J2CDeltaUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;
import org.eclipse.wst.common.snippets.ui.ISnippetInsertion;

public abstract class J2CSnippetHandler
extends DefaultSnippetInsertion
implements ISnippetInsertion {
    IEditorPart part;

    protected void doInsert(IEditorPart part, ITextEditor textEditor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        IEditorInput iedInput = part.getEditorInput();
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(iedInput);
        try {
            String sSource = cu.getSource();
            if (sSource.indexOf("@j2c.") <= 0 || sSource.indexOf("@generated") <= 0) {
                MessageDialog.openWarning((Shell)new Shell(), (String)J2CUIMessages.WARNING_WIZARDS_SNIPPETS_NOT_ANNOTATED_BEAN, (String)J2CUIMessages.WARNING_WIZARDS_SNIPPETS_NOT_ANNOTATED_BEAN_MESSAGE);
                return;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.makeInsertion(part, textEditor, document, textSelection, cu);
    }

    public void makeInsertion(IEditorPart part, ITextEditor textEditor, IDocument document, ITextSelection textSelection, ICompilationUnit cu) throws BadLocationException {
        block5: {
            try {
                this.part = part;
                boolean bRes = this.displayWizard(cu);
                if (!bRes) break block5;
                DeploymentUtils.waitForBuildJobs((int)3);
                J2CDeltaUtil.transferDeltaAnnotationsForAll((ICompilationUnit)cu);
                IWorkbench workbench = PlatformUI.getWorkbench();
                part = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                try {
                    part = JavaUI.openInEditor((IJavaElement)cu);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Integer sourceOffset = this.getMethodOffSet(cu);
                if (sourceOffset != null) {
                    this.positionCursor(sourceOffset, cu);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public abstract boolean displayWizard(ICompilationUnit var1);

    public abstract Integer getMethodOffSet(ICompilationUnit var1);

    protected void positionCursor(int sourceOffset, ICompilationUnit cu) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorPart part2 = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        try {
            if (part2 != null) {
                AbstractTextEditor textEditor = (AbstractTextEditor)part2;
                textEditor.selectAndReveal(sourceOffset, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

