/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.snippets.internal.snippets;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.internal.build.j2c.J2CBuildAgent;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.spi.Environment;
import com.ibm.adapter.j2c.edit.J2CJavaBeanEdit;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.j2c.javabean.ui.internal.messages.J2CJavaBeanUIMessages;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.snippets.internal.messages.J2CSnippetsMessages;
import com.ibm.j2c.snippets.internal.snippets.J2CSnippetHandler;
import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.model.BindingOperationInfo;
import com.ibm.j2c.ui.internal.model.J2CUIInfo;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.j2c.ui.internal.wizards.NewOperationWizard;
import commonj.connector.metadata.MetadataConfigurationType;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BindingOperationSnippet
extends J2CSnippetHandler {
    private NewOperationWizard wiz;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean displayWizard(ICompilationUnit cu) {
        boolean sRes = false;
        try {
            IResourceAdapterDescriptor desc;
            IJavaElement[] jeArray = cu.getChildren();
            IType typeElement = null;
            int length = jeArray.length;
            int i = 0;
            while (i < length) {
                IJavaElement javaEl = jeArray[i];
                if (javaEl.getElementType() == 7) {
                    typeElement = (IType)javaEl;
                    break;
                }
                ++i;
            }
            if (typeElement == null) return sRes;
            if (typeElement.isInterface()) return sRes;
            J2CUIInfo uiInfo = new J2CUIInfo();
            uiInfo.Environment_ = new Environment((IProgressMonitor)new NullProgressMonitor(), Logger.getLogger("com.ibm.j2c.snippets"));
            J2CJavaBeanEdit edit = new J2CJavaBeanEdit();
            edit.initialize(typeElement, uiInfo.Environment_);
            Vector vec = null;
            boolean setAdditionalParameters = false;
            J2CServiceDescription oid = edit.getOutboundServiceDescriptionModel();
            if (oid == null && (oid = DeploymentUtils.getOSDfromServer((J2CJavaBeanEdit)edit, (IProject)cu.getJavaProject().getProject())) == null) {
                vec = DeploymentHelper.instance().getMCFRarInfosForProject(cu.getJavaProject().getProject());
                if (vec != null && vec.size() == 1) {
                    MCF_RAR_Indentifier mcfRar = (MCF_RAR_Indentifier)vec.get(0);
                    oid = DeploymentUtils.getOSDfromRARInfo((J2CJavaBeanEdit)edit, (MCF_RAR_Indentifier)mcfRar);
                } else if (vec != null && vec.size() > 1) {
                    setAdditionalParameters = true;
                } else {
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)J2CSnippetsMessages.error_label, (String)J2CSnippetsMessages.CANNOT_FIND_JNDI_NAME, (IStatus)new Status(4, "com.ibm.j2c.snippets", 4, J2CSnippetsMessages.CANNOT_FIND_JNDI_NAME_LONG, null));
                    return false;
                }
            }
            if (oid != null && (desc = oid.getResourceAdapterDescriptor()) != null && desc.getConnector() != null) {
                IBuildAgent agent;
                String targetEIS = desc.getConnector().getEisType();
                String targetVendor = desc.getConnector().getVendorName();
                String targetVersion = desc.getConnector().getSpecVersion();
                if (targetEIS != null && targetVendor != null && targetVersion != null) {
                    IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
                    try {
                        IResourceAdapterDescriptor[] adapters = raRegistry.getAllImportEnabledAdapters();
                        if (adapters != null) {
                            int h = 0;
                            while (h < adapters.length) {
                                IResourceAdapterDescriptor adp = adapters[h];
                                if (adp != null && adp.getConnector() != null) {
                                    String eis = adp.getConnector().getEisType();
                                    String vendor = adp.getConnector().getVendorName();
                                    String vers = adp.getConnector().getSpecVersion();
                                    if (!"IMS TM".equalsIgnoreCase(targetEIS) && !targetEIS.equalsIgnoreCase("IMS") && eis.toLowerCase().equals(targetEIS.toLowerCase()) && vendor.toLowerCase().equals(targetVendor.toLowerCase()) && vers.toLowerCase().equals(targetVersion.toLowerCase())) {
                                        return false;
                                    }
                                }
                                ++h;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (targetEIS != null && (targetEIS.equals("IMS") || targetEIS.equals("IMS TM")) && (agent = desc.getBuildAgent()) != null && agent instanceof J2CBuildAgent && !J2CUIHelper.instance().isOutboundScenario(agent)) {
                    this.removeAgentInboundCapability(agent);
                }
            }
            uiInfo.JavaInterface_ = oid;
            uiInfo.InterfaceImplName_ = typeElement.getElementName();
            uiInfo.ProjectName_ = typeElement.getJavaProject().getProject().getName();
            uiInfo.usedForSnippets = true;
            uiInfo.classifications_ = J2CUIHelper.instance().RAD_PATH;
            this.wiz = new NewOperationWizard(uiInfo, new J2CUIMessageBundle(J2CJavaBeanUIMessages.class), cu);
            if (setAdditionalParameters) {
                this.wiz.setMultipleRAsOnClassPath(vec);
                this.wiz.setEdit(edit);
            }
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)this.wiz);
            dialog.setBlockOnOpen(true);
            int result = dialog.open();
            if (result != 0) return sRes;
            return true;
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)J2CSnippetsMessages.error_label, (String)e.toString(), (IStatus)new Status(4, "com.ibm.j2c.snippets", 4, "", (Throwable)e));
        }
        return sRes;
    }

    protected void removeAgentInboundCapability(IBuildAgent agent) {
        String[] configurations = agent.getConfiguration();
        if (configurations != null && configurations.length > 0) {
            ArrayList<String> newConfiguration = new ArrayList<String>(6);
            String[] stringArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                String config = stringArray[n2];
                if (!MetadataConfigurationType.INBOUND_SERVICE.toString().equals(config)) {
                    newConfiguration.add(config);
                }
                ++n2;
            }
            try {
                agent.setConfiguration(newConfiguration.toArray(new String[newConfiguration.size()]));
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Integer getMethodOffSet(ICompilationUnit cu) {
        int size;
        int result = 0;
        if (cu == null) {
            return new Integer(0);
        }
        String sSource = "";
        try {
            sSource = cu.getSource();
        }
        catch (Exception exception) {}
        if (this.wiz != null && (size = this.wiz.getOperationsPage().getBindingOperations().size()) > 0) {
            BindingOperationInfo info = (BindingOperationInfo)this.wiz.getOperationsPage().getBindingOperations().get(size - 1);
            String methodName = info.getOperation().getName();
            int temp = sSource.indexOf(String.valueOf(methodName) + "(");
            if (temp < 0) {
                int temp2 = sSource.indexOf(String.valueOf(methodName) + " ");
                if (temp2 >= 0) {
                    result = temp2;
                }
            } else {
                result = temp;
            }
        }
        return new Integer(result);
    }
}

