/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.snippets.internal.actions;

import com.ibm.j2c.snippets.internal.messages.J2CSnippetsMessages;
import com.ibm.j2c.snippets.internal.snippets.BindingOperationSnippet;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class BindingOperationObjectAction
implements IObjectActionDelegate {
    private ICompilationUnit javaFile = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            if (action.isEnabled()) {
                IEditorPart targetEditor = JavaUI.openInEditor((IJavaElement)this.javaFile);
                BindingOperationSnippet snip = new BindingOperationSnippet();
                ITextEditor textEd = (ITextEditor)targetEditor;
                ITextSelection ts = (ITextSelection)textEd.getSelectionProvider().getSelection();
                IDocument document = textEd.getDocumentProvider().getDocument((Object)targetEditor.getEditorInput());
                snip.makeInsertion(targetEditor, textEd, document, ts, this.javaFile);
            } else {
                MessageDialog dialog = new MessageDialog(new Shell(), J2CSnippetsMessages.warning_label, null, J2CSnippetsMessages.NO_J2C_CONTEXT, 0, null, 1);
                dialog.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object obj = iss.toList().get(0);
            action.setEnabled(false);
            if (obj instanceof ICompilationUnit) {
                this.javaFile = (ICompilationUnit)obj;
                try {
                    String sSource = this.javaFile.getSource();
                    if (sSource.indexOf("@j2c.") > 0 && sSource.indexOf("@generated") > 0) {
                        action.setEnabled(true);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else if (obj instanceof IType) {
                IType type = (IType)obj;
                this.javaFile = type.getCompilationUnit();
                try {
                    String sSource = this.javaFile.getSource();
                    if (sSource.indexOf("@j2c.") > 0 && sSource.indexOf("@generated") > 0) {
                        action.setEnabled(true);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else if (obj instanceof IMethod) {
                IMethod type = (IMethod)obj;
                this.javaFile = type.getCompilationUnit();
                try {
                    String sSource = this.javaFile.getSource();
                    if (sSource.indexOf("@j2c.") > 0 && sSource.indexOf("@generated") > 0) {
                        action.setEnabled(true);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

