/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.lang.ui.internal.properties;

import com.ibm.j2c.lang.ui.internal.messages.LangUIMessages;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.FileProperty;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

public class PlatformFileProperty
extends FileProperty {
    public PlatformFileProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validFileExtensions) throws CoreException {
        super(propertyName, displayName, propertyDescription, parentGroup, validFileExtensions, false);
    }

    public void setValueAsString(String newValue) throws CoreException {
        if (newValue.startsWith("platform:/resource")) {
            this.setValue(URI.createURI((String)newValue));
        } else {
            this.setValue(URI.createPlatformResourceURI((String)newValue));
        }
    }

    public String getValueAsString() {
        if (this.value != null) {
            String scheme = "platform:/resource";
            String str = ((URI)this.value).toString();
            if (str.startsWith(scheme)) {
                str = str.substring(scheme.length());
            }
            return str;
        }
        return "";
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        try {
            URI uri;
            if (evt.getSource() == this && (uri = (URI)evt.getNewValue()) != null) {
                String fullPath = uri.toString();
                String lastSegment = uri.lastSegment();
                int index = 0;
                String prefix = "platform:/resource";
                if (fullPath.startsWith(prefix)) {
                    index = prefix.length();
                }
                Path path = new Path(fullPath.substring(index, fullPath.lastIndexOf(lastSegment)));
                int count = path.segmentCount();
                String errMsg = null;
                if (count == 1) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.toString());
                    if (project == null || !project.exists()) {
                        errMsg = NLS.bind((String)LangUIMessages.ERROR_PATH_DOES_NOT_EXIST, (Object[])PropertyUIHelper.instance().getDisplayString(path.toString()));
                    }
                } else if (count > 1) {
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                    if (folder == null || !folder.exists()) {
                        errMsg = NLS.bind((String)LangUIMessages.ERROR_PATH_DOES_NOT_EXIST, (Object[])PropertyUIHelper.instance().getDisplayString(path.toString()));
                    }
                } else {
                    errMsg = LangUIMessages.ERROR_PATH_NO_PROJECT_OR_FILE_NAME;
                }
                if (errMsg != null && errMsg.length() > 0) {
                    throw new PropertyVetoException(errMsg, (java.beans.PropertyChangeEvent)evt);
                }
            }
        }
        catch (Throwable e) {
            throw new PropertyVetoException(e.getLocalizedMessage(), (java.beans.PropertyChangeEvent)evt);
        }
        super.vetoableChange(evt);
    }
}

