/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.jsf.ui.internal.utilities;

import com.ibm.adapter.emd.extension.description.J2CParameterDescription;
import com.ibm.adapter.emd.extension.description.ParameterDescription;
import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2c.edit.J2CJavaBeanEdit;
import com.ibm.etools.webtools.pagedatamodel.nls.ResourceHandler;
import com.ibm.j2c.javabean.ui.internal.messages.J2CJavaBeanUIMessages;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.j2c.ui.internal.wizards.NewOperationWizard;
import commonj.connector.metadata.description.DataDescription;
import commonj.connector.metadata.description.FunctionDescription;
import commonj.connector.metadata.description.OutboundFunctionDescription;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class J2CJSFUIHelper {
    private static J2CJSFUIHelper uiHelper_;

    public static J2CJSFUIHelper instance() {
        if (uiHelper_ == null) {
            uiHelper_ = new J2CJSFUIHelper();
        }
        return uiHelper_;
    }

    public J2CServiceDescription createOutboundModel(IType type, IEnvironment env, Shell shell) {
        IProject project;
        J2CJavaBeanEdit edit = new J2CJavaBeanEdit();
        edit.initialize(type, env);
        Vector vec = null;
        J2CServiceDescription osd = edit.getOutboundServiceDescriptionModel();
        if (osd == null && (osd = DeploymentUtils.getOSDfromServer((J2CJavaBeanEdit)edit, (IProject)(project = type.getJavaProject().getProject()))) == null) {
            vec = DeploymentHelper.instance().getMCFRarInfosForProject(project);
            if (vec != null && vec.size() == 1) {
                MCF_RAR_Indentifier mcfRar = (MCF_RAR_Indentifier)vec.get(0);
                osd = DeploymentUtils.getOSDfromRARInfo((J2CJavaBeanEdit)edit, (MCF_RAR_Indentifier)mcfRar);
            } else if (vec != null && vec.size() > 1) {
                MCF_RAR_Indentifier mcfRar = (MCF_RAR_Indentifier)vec.get(0);
                if (shell != null) {
                    NewOperationWizard wiz = new NewOperationWizard(null, new J2CUIMessageBundle(J2CJavaBeanUIMessages.class), type.getCompilationUnit());
                    wiz.setDisplayRaSelectionOnly(true);
                    wiz.setEdit(edit);
                    wiz.setMultipleRAsOnClassPath(vec);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wiz);
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0) {
                        Cursor cursor = null;
                        if (shell != null) {
                            Display d = shell.getDisplay();
                            cursor = new Cursor((Device)d, 1);
                            shell.setCursor(cursor);
                        }
                        mcfRar = wiz.getRASelectionPage().getSelectedRAR();
                        if (cursor != null) {
                            cursor.dispose();
                        }
                    }
                }
                osd = DeploymentUtils.getOSDfromRARInfo((J2CJavaBeanEdit)edit, (MCF_RAR_Indentifier)mcfRar);
            }
        }
        return osd;
    }

    public ArrayList<Method> getJ2CMethods(JavaClass beanClass, IEnvironment env) {
        try {
            J2CServiceDescription oid = this.createOutboundModel((IType)beanClass.getReflectionType(), env, null);
            return this.getJ2CMethods(beanClass, oid);
        }
        catch (Throwable throwable) {
            return new ArrayList<Method>(0);
        }
    }

    public ArrayList<Method> getJ2CMethods(JavaClass beanClass, J2CServiceDescription oid) {
        ArrayList<Method> methods = new ArrayList<Method>(6);
        if (oid != null) {
            FunctionDescription[] omds = oid.getServiceDescription().getFunctionDescriptions();
            ArrayList<String> paras = new ArrayList<String>(3);
            int i = 0;
            while (i < omds.length) {
                Method method;
                DataDescription dd;
                com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription omd;
                paras.clear();
                String name = omds[i].getName();
                int paraCount = 0;
                if (omds[i] instanceof com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription) {
                    omd = (com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription)omds[i];
                    ParameterDescription[] pds = omd.getParameterDescriptions();
                    if (pds != null) {
                        paraCount = pds.length;
                        int j = 0;
                        while (j < pds.length) {
                            if (pds[j].getStyle() != 2) {
                                String para = null;
                                if (pds[j] instanceof com.ibm.adapter.emd.extension.description.DataDescription) {
                                    para = this.convertURIToFullyQualifiedName(((com.ibm.adapter.emd.extension.description.DataDescription)pds[j]).getDataFiles()[0].getLocation());
                                } else if (pds[j] instanceof J2CParameterDescription) {
                                    para = ((J2CParameterDescription)pds[j]).getPropertyType().getName();
                                }
                                if (name != null && para != null && para.length() > 0) {
                                    paras.add(para);
                                }
                            }
                            ++j;
                        }
                    }
                } else if (omds[i] instanceof OutboundFunctionDescription && (dd = (omd = (OutboundFunctionDescription)omds[i]).getInputDataDescription()) != null && dd.getName() != null) {
                    paraCount = 1;
                    try {
                        String para = QNameHelper.getQualifiedClassName((QName)dd.getName());
                        if (name != null && para != null && para.length() > 0) {
                            paras.add(para);
                        }
                    }
                    catch (Exception exception) {}
                }
                if ((method = beanClass.getMethod(name, paras)) != null) {
                    if (methods.indexOf(method) == -1) {
                        methods.add(method);
                    }
                } else {
                    EList methodList = beanClass.getMethods();
                    int j = 0;
                    while (j < methodList.size()) {
                        Method m = (Method)methodList.get(j);
                        if (m.getName().equals(name) && m.getParameters().size() == paraCount && methods.indexOf(m) == -1) {
                            methods.add(m);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return methods;
    }

    protected String convertURIToFullyQualifiedName(java.net.URI uri) {
        URL resolvedURL = null;
        try {
            resolvedURL = FileLocator.resolve((URL)new URL(URLDecoder.decode(uri.toString(), "UTF-8")));
        }
        catch (Exception exception) {
            return null;
        }
        Path path = new Path(resolvedURL.getFile());
        IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (javaFile.exists()) {
            IJavaElement javaElement = JavaCore.create((IFile)javaFile);
            switch (javaElement.getElementType()) {
                case 5: {
                    return ((ICompilationUnit)javaElement).findPrimaryType().getFullyQualifiedName();
                }
                case 6: {
                    try {
                        return ((IClassFile)javaElement).getType().getFullyQualifiedName();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    public JavaHelpers introspect(String rtType, IProject project) throws CoreException, ClassNotFoundException {
        JavaHelpers[] jclass = new JavaHelpers[1];
        this.internalLoadJavaClass(rtType, jclass, project, (IProgressMonitor)new NullProgressMonitor());
        JavaHelpers javaClass = jclass[0];
        if (javaClass != null && javaClass instanceof JavaClass && !((JavaClass)javaClass).isExistingType()) {
            throw new ClassNotFoundException(NLS.bind((String)ResourceHandler._EXC_classNotFound, (Object[])new String[]{rtType}));
        }
        return javaClass;
    }

    void internalLoadJavaClass(String rtType, JavaHelpers[] javaClass, IProject project, IProgressMonitor monitor) throws CoreException {
        if (rtType == null || rtType.length() == 0) {
            return;
        }
        monitor.beginTask(NLS.bind((String)ResourceHandler.UI_Introspecting, (Object[])new String[]{rtType}), 10);
        monitor.worked(1);
        BeaninfoNature nature = BeaninfoNature.getRuntime((IProject)project);
        ResourceSet rset = nature.getResourceSet();
        monitor.worked(3);
        String partialURI = null;
        int i = rtType.lastIndexOf(46);
        if (i > -1) {
            char[] chars = rtType.toCharArray();
            chars[i] = 35;
            partialURI = new String(chars);
        } else {
            partialURI = "#" + rtType;
        }
        monitor.worked(1);
        URI uri = URI.createURI((String)("java:/" + partialURI));
        javaClass[0] = (JavaHelpers)rset.getEObject(uri, true);
        monitor.done();
    }
}

