/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PIHandler2_TopLevelSchemaDetector
extends DefaultHandler {
    private SAXParser saxParser;
    private boolean appInfoEncountered = false;
    private boolean stopParsing = false;
    private boolean isTopLevelSchema = false;
    private boolean isBOSchema = false;
    private StringBuffer chars = new StringBuffer();

    public PIHandler2_TopLevelSchemaDetector() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(false);
            this.saxParser = saxParserFactory.newSAXParser();
        }
        catch (SAXException exception) {
            exception.printStackTrace();
        }
        catch (ParserConfigurationException exception) {
            exception.printStackTrace();
        }
    }

    public void parse(InputSource inputSource) {
        try {
            this.resetValues();
            this.saxParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    public void parse(InputStream inputStream) {
        try {
            this.resetValues();
            this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.stopParsing && localName.equals("appinfo") && attributes.getValue(0).equals("com.ibm.j2c.core")) {
            this.appInfoEncountered = true;
            this.isBOSchema = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.appInfoEncountered) {
            this.appInfoEncountered = false;
            String st = this.chars.toString().trim();
            this.chars = new StringBuffer();
            if (st.length() == 0) {
                this.isTopLevelSchema = true;
            }
        }
        if (localName.equals("annotation") && this.isTopLevelSchema) {
            this.stopParsing = true;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int length) throws SAXException {
        if (this.appInfoEncountered) {
            this.chars.append(buf, offset, length);
        }
    }

    private void resetValues() {
        this.isBOSchema = false;
        this.chars = new StringBuffer();
        this.isTopLevelSchema = false;
        this.stopParsing = false;
    }

    public boolean isTopLevelSchema() {
        return this.isTopLevelSchema;
    }

    public boolean isBOSchema() {
        return this.isBOSchema;
    }
}

