/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PIHandler
extends DefaultHandler {
    private SAXParser saxParser;
    private String sGenName = null;
    private boolean appInfoEncountered = false;
    private boolean stopParsing = false;
    private boolean isBOSchema = false;
    private StringBuffer chars = new StringBuffer();

    public PIHandler() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(false);
            this.saxParser = saxParserFactory.newSAXParser();
        }
        catch (SAXException exception) {
            exception.printStackTrace();
        }
        catch (ParserConfigurationException exception) {
            exception.printStackTrace();
        }
    }

    public void parse(InputSource inputSource) {
        try {
            this.resetValues();
            this.saxParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    public void parse(InputStream inputStream) {
        try {
            this.resetValues();
            this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.stopParsing && localName.equals("appinfo") && attributes.getValue(0).equals("com.ibm.j2c.core")) {
            this.isBOSchema = true;
            this.appInfoEncountered = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.appInfoEncountered) {
            String st;
            this.appInfoEncountered = false;
            this.sGenName = st = this.chars.toString().trim();
        }
        if (localName.equals("annotation")) {
            this.stopParsing = true;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int length) throws SAXException {
        if (this.appInfoEncountered) {
            this.chars.append(buf, offset, length);
        }
    }

    public String getGeneratorName() {
        return this.sGenName;
    }

    private void resetValues() {
        this.sGenName = null;
        this.chars = new StringBuffer();
        this.isBOSchema = false;
        this.stopParsing = false;
    }

    public boolean isBOSchema() {
        return this.isBOSchema;
    }
}

