/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.validation;

import com.ibm.j2c.emd.internal.utils.J2CEmdUtils;
import commonj.connector.metadata.description.DataBindingGenerator;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class BOXSDValidator
implements IValidator {
    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) {
        String[] sUrs = helper.getURIs();
        ResourceSetImpl resourceSet = null;
        int i = 0;
        while (i < sUrs.length) {
            String sUr = sUrs[i];
            IFile xsdFile = J2CEmdUtils.getIFileFromWorkspaceRelativePath(sUr);
            if (J2CEmdUtils.getEMDHelper().isBOXSD(xsdFile)) {
                IPath p3;
                URI uri;
                Resource resource;
                try {
                    IMarker[] marks = xsdFile.findMarkers("com.ibm.j2c.emd.problem", false, 2);
                    if (marks.length > 0) {
                        return;
                    }
                }
                catch (Exception exception) {}
                if (resourceSet == null) {
                    resourceSet = new ResourceSetImpl();
                }
                if ((resource = resourceSet.createResource(uri = URI.createFileURI((String)(p3 = xsdFile.getRawLocation()).toString()))) != null) {
                    XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
                    try {
                        IProject pr = J2CEmdUtils.getProjectFromWorkspaceRelativePath(sUr);
                        if (pr == null) {
                            return;
                        }
                        xsdResource.load(resourceSet.getLoadOptions());
                        XSDSchema schema = xsdResource.getSchema();
                        XSDTypeDefinition xsdTYpe = J2CEmdUtils.getNativeTypeDefinition(schema);
                        if (xsdTYpe == null) {
                            return;
                        }
                        QName qn = new QName(xsdTYpe.getTargetNamespace(), xsdTYpe.getName());
                        DataBindingGenerator generator = J2CEmdUtils.getEMDHelper().getDataBindingGenerator(schema, pr);
                        String[] javaRecordNames = null;
                        if (generator != null) {
                            javaRecordNames = generator.getDataBindingClassNames(qn, null);
                        }
                        if (javaRecordNames != null && javaRecordNames.length > 0) {
                            String javaRecordName = javaRecordNames[0];
                            IFile javaFile = J2CEmdUtils.getIFileFromFullJavaRecordName(javaRecordName, pr);
                            if (javaFile != null) {
                                long lTimeStamp = javaFile.getLocalTimeStamp();
                                long lXsdFileTimeStamp = xsdFile.getLocalTimeStamp();
                                if (lXsdFileTimeStamp > lTimeStamp) {
                                    this.addWarningMessage(xsdFile, reporter);
                                }
                            } else {
                                this.addWarningMessage(xsdFile, reporter);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    private void addWarningMessage(IFile xsdFile, IReporter reporter) {
        try {
            Message mes = new Message();
            mes.setSeverity(2);
            mes.setBundleName("plugin");
            mes.setId("message");
            mes.setTargetObject((Object)xsdFile);
            reporter.addMessage((IValidator)this, (IMessage)mes);
        }
        catch (Exception exception) {}
    }
}

