/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.utils;

import com.ibm.adapter.j2ca.internal.ResourceAdapterDescriptorImpl;
import com.ibm.j2c.emd.internal.action.CodeGenerationJob;
import com.ibm.j2c.emd.internal.action.DependencyCalculationJob;
import com.ibm.j2c.emd.internal.action.JobCompletionListener;
import com.ibm.j2c.emd.internal.action.RegenRunnable;
import com.ibm.j2c.emd.internal.action.RemoveWarningMarkersJob;
import com.ibm.j2c.emd.internal.ui.RegenDialog2;
import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.ui.model.XSDContainementModel;
import com.ibm.j2c.emd.internal.utils.J2CEmdHelper;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;

public class J2CEmdUtils {
    private static J2CEmdHelper helper;
    public static final String J2C_CORE_APP_INFO_SOURCE_MARKER = "com.ibm.j2c.core";
    public static final String J2C_EMD_MARKER_ID = "com.ibm.j2c.emd.problem";

    public static List getContainmentModels(Hashtable topSchemas) {
        ArrayList<XSDContainementModel> res = new ArrayList<XSDContainementModel>();
        Enumeration en = topSchemas.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            XSDSchema sc = (XSDSchema)topSchemas.get(key);
            XSDContainementModel model = J2CEmdUtils.getXSDContainmentModel(sc);
            res.add(model);
        }
        return res;
    }

    private static XSDContainementModel getXSDContainmentModel(XSDSchema sc) {
        XSDContainementModel mod = new XSDContainementModel(sc.eResource().getURI().toFileString());
        for (XSDSchemaContent xsdSchemaContent : sc.getContents()) {
            XSDImport xsdImport;
            XSDSchema importedSchema;
            if (!(xsdSchemaContent instanceof XSDSchemaDirective) || !(xsdSchemaContent instanceof XSDImport) || (importedSchema = ((XSDImportImpl)(xsdImport = (XSDImport)xsdSchemaContent)).importSchema()) == null) continue;
            XSDContainementModel child = J2CEmdUtils.getXSDContainmentModel(importedSchema);
            mod.addChild(child);
        }
        return mod;
    }

    public static ClassLoader getClassLoader(IProject xsdProj) {
        ClassLoader classLoader = null;
        try {
            Vector connProjects = new DeploymentHelper().getConnectorProjectsOnClassPath(xsdProj);
            IProject pr = (IProject)connProjects.get(0);
            ResourceAdapterDescriptorImpl raDesc = new ResourceAdapterDescriptorImpl(null, pr);
            if (raDesc != null) {
                return raDesc.getClassLoader();
            }
        }
        catch (Exception exception) {}
        return classLoader;
    }

    public static J2CEmdHelper getEMDHelper() {
        if (helper == null) {
            helper = new J2CEmdHelper();
        }
        return helper;
    }

    public static IFile getIFileFromWorkspaceRelativePath(String sWrPath) {
        IFile res = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String tempS = new String(sWrPath);
        if (tempS.startsWith("/")) {
            tempS = tempS.substring(1);
        }
        String sPrName = null;
        int indx = tempS.indexOf("/");
        if (indx > 0) {
            IFile fi;
            IResource resource;
            sPrName = tempS.substring(0, indx);
            String sFilePath = tempS.substring(indx + 1, tempS.length());
            IProject pr = root.getProject(sPrName);
            if (pr.exists() && (resource = pr.findMember((IPath)new Path(sFilePath))) instanceof IFile && (fi = (IFile)resource).exists()) {
                return fi;
            }
        }
        return res;
    }

    public static IProject getProjectFromWorkspaceRelativePath(String sWrPath) {
        IProject pr;
        String tempS = new String(sWrPath);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (tempS.startsWith("/")) {
            tempS = tempS.substring(1);
        }
        String sPrName = null;
        int indx = tempS.indexOf("/");
        if (indx > 0 && (pr = root.getProject(sPrName = tempS.substring(0, indx))).exists()) {
            return pr;
        }
        return null;
    }

    public static String getProjectRelativePathFromAbsolutePath(String projectName, String absolutePath) {
        String sTemp = "/" + projectName + "/";
        int indx = absolutePath.indexOf(sTemp);
        if (indx < 0) {
            sTemp = "\\" + projectName + "\\";
            indx = absolutePath.indexOf(sTemp);
        }
        if (indx >= 0) {
            String res = absolutePath.substring(indx + sTemp.length());
            return res;
        }
        return null;
    }

    public static void triggerRegeneration(IFile[] xsdFiles, String sGenName, Shell shell) throws Exception {
        IFile xsdFile;
        RegenRunnable rr = new RegenRunnable(sGenName, xsdFiles);
        if (shell == null) {
            shell = new Shell(16);
        }
        ProgressMonitorDialog dia = new ProgressMonitorDialog(shell);
        try {
            dia.run(true, true, (IRunnableWithProgress)rr);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        List lst = rr.getModelObs();
        List cMs = rr.getContainmentModels();
        Hashtable names = J2CEmdUtils.sortByPackageName(rr.getJavaRecordNames());
        RegenDialog2 d2 = new RegenDialog2(shell, cMs, names, xsdFiles);
        int r = d2.open();
        if (r == 0 && xsdFiles.length > 0 && (xsdFile = xsdFiles[0]) != null) {
            IProject po = xsdFile.getProject();
            CodeGenerationJob job = new CodeGenerationJob(J2CEMDUIMessages.JAVA_RECORDS_GENERATION_JOB_NAME, lst, po, sGenName);
            job.setUser(true);
            job.schedule();
            RemoveWarningMarkersJob rMJ = new RemoveWarningMarkersJob(po, cMs);
            rMJ.schedule();
        }
    }

    public static void triggerStealthRegeneration(IFile[] xsdFiles, String sGenName, IProgressMonitor monitor) throws Exception {
        DependencyCalculationJob depjob;
        block9: {
            depjob = new DependencyCalculationJob(sGenName, xsdFiles);
            JobCompletionListener listen = new JobCompletionListener();
            depjob.addJobChangeListener(listen);
            depjob.schedule();
            boolean loop = true;
            int interval = 1000;
            int totalTime = 0;
            int units = 60;
            try {
                try {
                    while (loop) {
                        if (listen.done) {
                            loop = false;
                        } else {
                            Thread.sleep(interval);
                            totalTime += interval;
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        depjob.cancel();
                        throw new InterruptedException();
                    }
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (Exception exception) {
                    monitor.worked(units);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                monitor.worked(units);
                throw throwable;
            }
            monitor.worked(units);
        }
        List lst = depjob.getResolvedStructures();
        List cMs = J2CEmdUtils.getContainmentModels(depjob.getTopSchemas());
        IProject po = xsdFiles[0].getProject();
        CodeGenerationJob job = new CodeGenerationJob(J2CEMDUIMessages.JAVA_RECORDS_GENERATION_JOB_NAME, lst, po, sGenName);
        job.setUser(true);
        job.schedule();
        RemoveWarningMarkersJob rMJ = new RemoveWarningMarkersJob(po, cMs);
        rMJ.schedule();
    }

    private static Hashtable sortByPackageName(String[] fullNames) {
        Hashtable<String, List> res = new Hashtable<String, List>();
        if (fullNames != null) {
            int h = 0;
            while (h < fullNames.length) {
                String sFullName = fullNames[h];
                int ind = sFullName.lastIndexOf(".");
                if (ind > 0) {
                    String sPack = sFullName.substring(0, ind);
                    String sName = sFullName.substring(ind + 1);
                    List lst = (List)res.get(sPack);
                    if (lst == null) {
                        ArrayList<String> aL = new ArrayList<String>();
                        aL.add(sName);
                        res.put(sPack, aL);
                    } else if (!lst.contains(sName)) {
                        lst.add(sName);
                        res.put(sPack, lst);
                    }
                }
                ++h;
            }
        }
        return res;
    }

    public static XSDTypeDefinition getNativeTypeDefinition(XSDSchema schema) {
        String schemaNS = schema.getTargetNamespace();
        EList lst = schema.getTypeDefinitions();
        int j = 0;
        while (j < lst.size()) {
            XSDTypeDefinition td = (XSDTypeDefinition)lst.get(j);
            if (td.getTargetNamespace().equals(schemaNS)) {
                return td;
            }
            ++j;
        }
        return null;
    }

    public static IFile getIFileFromFullJavaRecordName(String javaRecordName, IProject pr) {
        int indx = javaRecordName.lastIndexOf(".");
        String sPackName = javaRecordName.substring(0, indx);
        String sClassName = javaRecordName.substring(indx + 1, javaRecordName.length());
        sPackName = sPackName.replace('.', '/');
        Path filePath = new Path(sPackName);
        IPath finalPath = filePath.append(sClassName).addFileExtension("java");
        IPath[] sourceLocs = ResourceUtils.getAllJavaSourceLocations((IProject)pr);
        IFile javaFile = null;
        int n = 0;
        while (n < sourceLocs.length) {
            IPath sourceLoc = sourceLocs[n];
            sourceLoc = sourceLoc.append(finalPath);
            IFile file = pr.getFile(sourceLoc = sourceLoc.removeFirstSegments(1));
            if (file.exists()) {
                javaFile = file;
                return javaFile;
            }
            ++n;
        }
        return null;
    }
}

