/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.utils;

import com.ibm.j2c.emd.internal.utils.J2CEmdUtils;
import com.ibm.j2c.emd.internal.xml.PIHandler;
import commonj.connector.metadata.description.DataBindingGenerator;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class J2CEmdHelper {
    private Hashtable recordGenerators = new Hashtable();
    private PIHandler parser;
    private final String PLATFORM_RES = "platform:/resource/";
    private String genName = null;

    public String getGeneratorName() {
        return this.genName;
    }

    public DataBindingGenerator getDataBindingGenerator(XSDSchema schema, IProject proj) {
        DataBindingGenerator res = null;
        EList lst = schema.getAnnotations();
        int b = 0;
        while (b < lst.size()) {
            XSDAnnotation an = (XSDAnnotation)lst.get(b);
            EList appInfos = an.getApplicationInformation();
            int v = 0;
            while (v < appInfos.size()) {
                NodeList childNodes;
                Node n;
                Element el;
                String genTag;
                Object o1 = appInfos.get(v);
                if (o1 instanceof Element && (genTag = (el = (Element)o1).getAttribute("source")).equals("com.ibm.j2c.core") && (n = (childNodes = el.getChildNodes()).item(0)) instanceof Text) {
                    this.genName = ((Text)n).getData();
                }
                ++v;
            }
            ++b;
        }
        if (this.genName != null && res == null) {
            String sLoc = schema.getSchemaLocation();
            if (proj == null) {
                proj = this.getProjectFromXSDFileString(sLoc);
            }
            if (proj != null) {
                ClassLoader cl = J2CEmdUtils.getClassLoader(proj);
                try {
                    if (cl != null) {
                        Class<?> cla = cl.loadClass(this.genName);
                        DataBindingGenerator recordGenerator = (DataBindingGenerator)cla.newInstance();
                        this.recordGenerators.put(this.genName, recordGenerator);
                        return recordGenerator;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    private IProject getProjectFromXSDFileString(String fileString) {
        IProject proj;
        String sT;
        int indx;
        IProject res = null;
        String projName = null;
        if (fileString.startsWith("platform:/resource/") && (indx = (sT = fileString.substring("platform:/resource/".length(), fileString.length())).indexOf("/")) > 0) {
            projName = sT.substring(0, indx);
        }
        if (projName != null && (proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName)).exists()) {
            return proj;
        }
        return res;
    }

    public boolean isBOXSD(IFile file) {
        if (file.getFileExtension().equalsIgnoreCase("xsd")) {
            if (this.parser == null) {
                this.parser = new PIHandler();
            }
            try {
                this.parser.parse(file.getContents());
                return this.parser.isBOSchema();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isBOXSD(InputStream in) {
        if (this.parser == null) {
            this.parser = new PIHandler();
        }
        try {
            this.parser.parse(in);
            return this.parser.isBOSchema();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

