/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.ui.model;

import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class BusinessTypeJavaRecordInfo {
    private String xsdLocation;
    private String globalTypeQN;
    private IFile javaRecord;
    private String javaRecordPackageName;
    private String javaRecordName;

    public BusinessTypeJavaRecordInfo(String xsdLocation, String globalType, IFile javaFile) {
        this.xsdLocation = xsdLocation;
        this.globalTypeQN = globalType;
        this.javaRecord = javaFile;
    }

    public String getGlobalTypeQN() {
        return this.globalTypeQN;
    }

    public IFile getJavaRecord() {
        return this.javaRecord;
    }

    public String getXsdLocation() {
        return this.xsdLocation;
    }

    public String getJavaRecordName() {
        if (this.javaRecordName != null) {
            return this.javaRecordName;
        }
        this.javaRecordName = this.javaRecord.getName();
        return this.javaRecordName;
    }

    public void setJavaRecordName(String javaRecordName) {
        this.javaRecordName = javaRecordName;
    }

    public String getJavaRecordPackageName(IProject pr) {
        if (this.javaRecordPackageName != null) {
            return this.javaRecordPackageName;
        }
        if (pr != null) {
            IPath[] sourceLocs = ResourceUtils.getAllJavaSourceLocations((IProject)pr);
            IPath recordPath = this.javaRecord.getProjectRelativePath();
            int m = 0;
            while (m < sourceLocs.length) {
                IPath sourceLoc = sourceLocs[m];
                int sourcePathCount = sourceLoc.segmentCount();
                if (sourcePathCount > 1) {
                    sourceLoc = sourceLoc.removeFirstSegments(1);
                    if (sourcePathCount != 0 && recordPath.matchingFirstSegments(sourceLoc) == sourceLoc.segmentCount()) {
                        recordPath = recordPath.removeFirstSegments(sourceLoc.segmentCount());
                        break;
                    }
                }
                ++m;
            }
            recordPath = recordPath.removeLastSegments(1);
            this.javaRecordPackageName = recordPath.toString().replace('/', '.');
            return this.javaRecordPackageName;
        }
        return null;
    }

    public void setJavaRecordPackageName(String javaRecordPackageName) {
        this.javaRecordPackageName = javaRecordPackageName;
    }
}

