/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.emd.internal.action;

import com.ibm.j2c.emd.internal.action.DependencyCalculationJob;
import com.ibm.j2c.emd.internal.action.JobCompletionListener;
import com.ibm.j2c.emd.internal.ui.messages.J2CEMDUIMessages;
import com.ibm.j2c.emd.internal.utils.J2CEmdUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class RegenRunnable
implements IRunnableWithProgress {
    private DependencyCalculationJob job;
    private IFile[] xsdFiles;
    private List cMs = new ArrayList();

    public RegenRunnable(String sGenName1, IFile[] xsdFiles) {
        this.xsdFiles = xsdFiles;
        this.job = new DependencyCalculationJob(J2CEMDUIMessages.RETRIEVING_INFORMATION, xsdFiles);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        boolean loop = true;
        int interval = 1000;
        int totalTime = 0;
        int units = 60;
        progressMonitor.beginTask(J2CEMDUIMessages.RETRIEVING_INFORMATION, units);
        JobCompletionListener listen = new JobCompletionListener();
        this.job.addJobChangeListener(listen);
        this.job.schedule();
        try {
            try {
                while (loop) {
                    if (listen.done) {
                        loop = false;
                        this.cMs = J2CEmdUtils.getContainmentModels(this.getTopSchemas());
                    } else {
                        Thread.sleep(interval);
                        totalTime += interval;
                    }
                    progressMonitor.worked(1);
                    if (!progressMonitor.isCanceled()) continue;
                    this.job.cancel();
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception exception) {
                progressMonitor.worked(units);
            }
        }
        finally {
            progressMonitor.worked(units);
        }
    }

    public List getModelObs() {
        if (this.job != null) {
            return this.job.getResolvedStructures();
        }
        return null;
    }

    public IFile[] getXSDFiles() {
        return this.xsdFiles;
    }

    private Hashtable getTopSchemas() {
        if (this.job != null) {
            return this.job.getTopSchemas();
        }
        return null;
    }

    public String[] getJavaRecordNames() {
        if (this.job != null) {
            return this.job.getJavaRecordNames();
        }
        return null;
    }

    public List getContainmentModels() {
        return this.cMs;
    }
}

